/*
 * Decompiled with CFR 0.152.
 */
package com.genexus;

import com.genexus.Application;
import com.genexus.ModelContext;
import com.genexus.ProcessInterruptedException;
import com.genexus.db.UserInformation;
import com.genexus.internet.HttpContext;
import com.genexus.reports.GXReportMetadata;
import com.genexus.reports.GXReportPDFCommons;
import com.genexus.reports.IReportHandler;
import com.genexus.reports.PDFReportItext2;
import com.genexus.reports.PDFReportItext8;
import com.genexus.reports.PDFReportPDFBox;
import com.genexus.webpanels.GXWebProcedure;
import java.io.OutputStream;

public abstract class GXWebReport
extends GXWebProcedure {
    public static final int OUTPUT_RVIEWER = 1;
    public static final int OUTPUT_PDF = 2;
    protected GXReportMetadata reportMetadata;
    protected IReportHandler reportHandler;
    protected int lineHeight;
    protected int Gx_line;
    protected int P_lines;
    protected int gxXPage;
    protected int gxYPage;
    protected int Gx_page;
    protected String Gx_out = "";
    protected String filename;
    protected String filetype;

    public GXWebReport(HttpContext httpContext) {
        super(httpContext);
    }

    @Override
    protected void initState(ModelContext context, UserInformation ui) {
        super.initState(context, ui);
        this.httpContext.setBuffered(true);
        this.httpContext.setBinary(true);
        String implementation = Application.getClientContext().getClientPreferences().getPDF_RPT_LIBRARY();
        this.reportHandler = implementation.equals("ITEXT") ? new PDFReportItext2(context) : (implementation.equals("ITEXT8") ? new PDFReportItext8(context) : new PDFReportPDFBox(context));
        this.initValues();
    }

    @Override
    protected void preExecute() {
        this.httpContext.setContentType("application/pdf");
        this.httpContext.setStream();
        ((GXReportPDFCommons)this.reportHandler).setOutputStream(this.httpContext.getOutputStream());
    }

    protected void setOutputFileName(String outputFileName) {
        this.filename = outputFileName;
    }

    protected void setOutputType(String outputType) {
        this.filetype = outputType.toLowerCase();
    }

    private void initValues() {
        this.Gx_line = 0;
        this.P_lines = 0;
        this.gxXPage = 0;
        this.gxYPage = 0;
        this.Gx_page = 0;
        this.Gx_out = "";
        this.lineHeight = 0;
    }

    public void setPrinter(IReportHandler reportHandler) {
        this.reportHandler = reportHandler;
    }

    public IReportHandler getPrinter() {
        return this.reportHandler;
    }

    protected void GxEndPage() throws ProcessInterruptedException {
        if (this.reportHandler != null) {
            this.reportHandler.GxEndPage();
        }
    }

    protected boolean initTextPrinter(String output, int gxXPage, int gxYPage, String iniFile, String form, String printer, int mode, int nPaperLength, int nPaperWidth, int nGridX, int nGridY, int nPageLines) {
        int[] x = new int[]{gxXPage};
        int[] y = new int[]{gxYPage};
        this.getPrinter().GxRVSetLanguage(this.localUtil._language);
        boolean ret = this.getPrinter().GxPrTextInit(output, x, y, iniFile, form, printer, mode, nPaperLength, nPaperWidth, nGridX, nGridY, nPageLines);
        this.gxXPage = x[0];
        this.gxYPage = y[0];
        return ret;
    }

    protected boolean initPrinter(String output, int gxXPage, int gxYPage, String iniFile, String form, String printer, int mode, int orientation, int pageSize, int pageLength, int pageWidth, int scale, int copies, int defSrc, int quality, int color, int duplex) {
        int[] x = new int[]{gxXPage};
        int[] y = new int[]{gxYPage};
        this.setResponseOuputFileName();
        this.getPrinter().GxRVSetLanguage(this.localUtil._language);
        boolean ret = this.getPrinter().GxPrintInit(output, x, y, iniFile, form, printer, mode, orientation, pageSize, pageLength, pageWidth, scale, copies, defSrc, quality, color, duplex);
        this.gxXPage = x[0];
        this.gxYPage = y[0];
        return ret;
    }

    private void setResponseOuputFileName() {
        String outputFileName = this.filename != null ? this.filename : ((Object)((Object)this)).getClass().getSimpleName();
        String outputFileType = this.filetype != null ? "." + this.filetype.toLowerCase() : ".pdf";
        this.httpContext.getResponse().addHeader("content-disposition", "inline; filename=" + outputFileName + outputFileType);
    }

    protected void endPrinter() {
        this.getPrinter().GxEndPrinter();
    }

    protected int getOutputType() {
        return 1;
    }

    protected OutputStream getOutputStream() {
        throw new RuntimeException("Output stream not set");
    }

    protected void loadReportMetadata(String name) {
        this.reportMetadata = new GXReportMetadata(name, this.reportHandler);
        this.reportMetadata.load();
    }

    protected int GxDrawDynamicGetPrintBlockHeight(int printBlock) {
        return this.reportMetadata.GxDrawGetPrintBlockHeight(printBlock);
    }

    protected void GxDrawDynamicText(int printBlock, int controlId, int Gx_line) {
        this.reportMetadata.GxDrawText(printBlock, controlId, Gx_line);
    }

    protected void GxDrawDynamicText(int printBlock, int controlId, String value, int Gx_line) {
        this.reportMetadata.GxDrawText(printBlock, controlId, Gx_line, value);
    }

    protected void GxDrawDynamicLine(int printBlock, int controlId, int Gx_line) {
        this.reportMetadata.GxDrawLine(printBlock, controlId, Gx_line);
    }

    protected void GxDrawDynamicRect(int printBlock, int controlId, int Gx_line) {
        this.reportMetadata.GxDrawRect(printBlock, controlId, Gx_line);
    }

    protected void GxDrawDynamicBitMap(int printBlock, int controlId, String value, int Gx_line) {
        this.reportMetadata.GxDrawBitMap(printBlock, controlId, Gx_line, value, 0);
    }

    protected void GxDrawDynamicBitMap(int printBlock, int controlId, String value, int aspectRatio, int Gx_line) {
        this.reportMetadata.GxDrawBitMap(printBlock, controlId, Gx_line, value, aspectRatio);
    }

    @Override
    protected void cleanup() {
        super.cleanup();
    }
}

