/*
 * Decompiled with CFR 0.152.
 */
package com.genexus;

import com.genexus.CommonUtil;
import com.genexus.GXDbFile;
import com.genexus.GXutil;
import com.genexus.IHttpContext;
import com.genexus.ModelContext;
import com.genexus.PrivateUtilities;
import com.genexus.db.driver.ResourceAccessControlList;
import com.genexus.util.GXFile;
import com.genexus.util.GxFileInfoSourceType;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GxImageUtil {
    private static Logger log = LogManager.getLogger(GxImageUtil.class);
    private static int INVALID_CODE = -1;

    private static InputStream getInputStream(String filePathOrUrl) throws IOException {
        return GxImageUtil.getGXFile(filePathOrUrl).getStream();
    }

    private static BufferedImage createBufferedImageFromURI(String filePathOrUrl) throws IOException {
        IHttpContext httpContext = ModelContext.getModelContext().getHttpContext();
        try (InputStream is = null;){
            is = filePathOrUrl.toLowerCase().startsWith("http://") || filePathOrUrl.toLowerCase().startsWith("https://") || httpContext.isHttpContextWeb() && filePathOrUrl.startsWith(httpContext.getContextPath()) ? new URL(GXDbFile.pathToUrl(filePathOrUrl, httpContext)).openStream() : GxImageUtil.getGXFile(filePathOrUrl).getStream();
            BufferedImage bufferedImage = ImageIO.read(is);
            return bufferedImage;
        }
    }

    private static GXFile getGXFile(String filePathOrUrl) {
        String basePath = ModelContext.getModelContext() != null ? ModelContext.getModelContext().getHttpContext().getDefaultPath() : "";
        return new GXFile(basePath, filePathOrUrl, ResourceAccessControlList.Default, GxFileInfoSourceType.Unknown);
    }

    public static long getFileSize(String imageFile) {
        if (!GxImageUtil.isValidInput(imageFile)) {
            return INVALID_CODE;
        }
        IHttpContext httpContext = ModelContext.getModelContext().getHttpContext();
        if (imageFile.toLowerCase().startsWith("http://") || imageFile.toLowerCase().startsWith("https://") || httpContext.isHttpContextWeb() && imageFile.startsWith(httpContext.getContextPath())) {
            try {
                URL url = new URL(GXDbFile.pathToUrl(imageFile, httpContext));
                URLConnection connection = url.openConnection();
                return Long.parseLong(connection.getHeaderField("Content-Length"));
            }
            catch (Exception e) {
                log.error("getFileSize " + imageFile + " failed", (Throwable)e);
            }
        } else {
            return GxImageUtil.getGXFile(imageFile).getLength();
        }
        return INVALID_CODE;
    }

    public static int getImageHeight(String imageFile) {
        if (!GxImageUtil.isValidInput(imageFile)) {
            return INVALID_CODE;
        }
        try {
            return GxImageUtil.createBufferedImageFromURI(imageFile).getHeight();
        }
        catch (Exception e) {
            log.error("getImageHeight " + imageFile + " failed", (Throwable)e);
            return INVALID_CODE;
        }
    }

    private static boolean isValidInput(String imageFile) {
        boolean isValid;
        boolean bl = isValid = imageFile != null && imageFile.length() > 0;
        if (!isValid) {
            log.debug("Image Api - FileName cannot be empty");
        }
        return isValid;
    }

    public static int getImageWidth(String imageFile) {
        if (!GxImageUtil.isValidInput(imageFile)) {
            return INVALID_CODE;
        }
        try {
            return GxImageUtil.createBufferedImageFromURI(imageFile).getWidth();
        }
        catch (Exception e) {
            log.error("getImageWidth " + imageFile + " failed", (Throwable)e);
            return INVALID_CODE;
        }
    }

    public static String crop(String imageFile, int x, int y, int width, int height) {
        if (!GxImageUtil.isValidInput(imageFile)) {
            return "";
        }
        try {
            BufferedImage image = GxImageUtil.createBufferedImageFromURI(imageFile);
            BufferedImage croppedImage = image.getSubimage(x, y, width, height);
            return GxImageUtil.writeImage(croppedImage, imageFile);
        }
        catch (Exception e) {
            log.error("crop " + imageFile + " failed", (Throwable)e);
            return "";
        }
    }

    private static String writeImage(BufferedImage croppedImage, String destinationFilePathOrUrl) throws IOException {
        byte[] imageInByte;
        String newFileName = PrivateUtilities.getTempFileName(CommonUtil.getFileType((String)destinationFilePathOrUrl));
        IHttpContext httpContext = ModelContext.getModelContext().getHttpContext();
        try (ByteArrayOutputStream outStream = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)croppedImage, CommonUtil.getFileType((String)newFileName), outStream);
            if (destinationFilePathOrUrl.toLowerCase().startsWith("http://") || destinationFilePathOrUrl.toLowerCase().startsWith("https://") || httpContext.isHttpContextWeb() && destinationFilePathOrUrl.startsWith(httpContext.getContextPath())) {
                String string;
                ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
                Throwable throwable = null;
                try {
                    GXFile file = GxImageUtil.getGXFile(newFileName);
                    file.create(inStream, true);
                    file.close();
                    string = file.getURI();
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        GxImageUtil.$closeResource(throwable, inStream);
                        throw throwable3;
                    }
                }
                GxImageUtil.$closeResource(throwable, inStream);
                return string;
            }
            outStream.flush();
            imageInByte = outStream.toByteArray();
        }
        String string = GXutil.blobFromBytes(imageInByte, CommonUtil.getFileType((String)newFileName));
        return string;
    }

    public static String flipHorizontally(String imageFile) {
        if (!GxImageUtil.isValidInput(imageFile)) {
            return "";
        }
        try {
            BufferedImage image = GxImageUtil.createBufferedImageFromURI(imageFile);
            AffineTransform tx = AffineTransform.getScaleInstance(-1.0, 1.0);
            tx.translate(-image.getWidth(null), 0.0);
            AffineTransformOp op = new AffineTransformOp(tx, 1);
            BufferedImage flippedImage = op.filter(image, null);
            return GxImageUtil.writeImage(flippedImage, imageFile);
        }
        catch (Exception e) {
            log.error("flip horizontal " + imageFile + " failed", (Throwable)e);
            return "";
        }
    }

    public static String flipVertically(String imageFile) {
        if (!GxImageUtil.isValidInput(imageFile)) {
            return "";
        }
        try {
            BufferedImage image = GxImageUtil.createBufferedImageFromURI(imageFile);
            AffineTransform tx = AffineTransform.getScaleInstance(1.0, -1.0);
            tx.translate(0.0, -image.getHeight(null));
            AffineTransformOp op = new AffineTransformOp(tx, 1);
            BufferedImage flippedImage = op.filter(image, null);
            return GxImageUtil.writeImage(flippedImage, imageFile);
        }
        catch (Exception e) {
            log.error("flip vertical " + imageFile + " failed", (Throwable)e);
            return "";
        }
    }

    public static String roundBorders(String imageFile, int topLeftRadius, int topRightRadius, int bottomLeftRadius, int bottomRightRadius) {
        if (!GxImageUtil.isValidInput(imageFile)) {
            return "";
        }
        try {
            BufferedImage originalImage = GxImageUtil.createBufferedImageFromURI(imageFile);
            if (imageFile.indexOf(".jpg") > 0 || imageFile.indexOf(".jpeg") > 0) {
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    ImageIO.write((RenderedImage)originalImage, "png", baos);
                    byte[] bytes = baos.toByteArray();
                    try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);){
                        originalImage = ImageIO.read(is);
                    }
                    imageFile = imageFile.replace(".jpg", ".png").replace(".jpeg", ".png");
                }
            }
            int w = originalImage.getWidth();
            int h = originalImage.getHeight();
            BufferedImage roundedImage = new BufferedImage(w, h, 2);
            Graphics2D g2 = roundedImage.createGraphics();
            g2.setComposite(AlphaComposite.Src);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(Color.WHITE);
            GeneralPath path = new GeneralPath();
            path.moveTo(0.0f, topLeftRadius);
            path.quadTo(0.0f, 0.0f, topLeftRadius, 0.0f);
            path.lineTo(w - topRightRadius, 0.0f);
            path.quadTo(w, 0.0f, w, topRightRadius);
            path.lineTo(w, h - bottomRightRadius);
            path.quadTo(w, h, w - bottomRightRadius, h);
            path.lineTo(bottomLeftRadius, h);
            path.quadTo(0.0f, h, 0.0f, h - bottomLeftRadius);
            path.closePath();
            g2.fill(path);
            g2.setComposite(AlphaComposite.SrcIn);
            g2.drawImage((Image)originalImage, 0, 0, null);
            g2.dispose();
            return GxImageUtil.writeImage(roundedImage, imageFile);
        }
        catch (Exception e) {
            log.error("round borders for " + imageFile + " failed", (Throwable)e);
            return "";
        }
    }

    public static String resize(String imageFile, int width, int height, boolean keepAspectRatio) {
        if (!GxImageUtil.isValidInput(imageFile)) {
            return "";
        }
        try {
            BufferedImage image = GxImageUtil.createBufferedImageFromURI(imageFile);
            if (keepAspectRatio) {
                double imageWidth;
                double imageHeight = image.getHeight();
                if (imageHeight / (double)height > (imageWidth = (double)image.getWidth()) / (double)width) {
                    width = (int)((double)height * imageWidth / imageHeight);
                } else {
                    height = (int)((double)width * imageHeight / imageWidth);
                }
            }
            BufferedImage resizedImage = new BufferedImage(width, height, image.getType());
            Graphics2D g2d = resizedImage.createGraphics();
            g2d.drawImage(image, 0, 0, width, height, null);
            g2d.dispose();
            return GxImageUtil.writeImage(resizedImage, imageFile);
        }
        catch (Exception e) {
            log.error("resize " + imageFile + " failed", (Throwable)e);
            return "";
        }
    }

    public static String scale(String imageFile, short percent) {
        if (!GxImageUtil.isValidInput(imageFile)) {
            return "";
        }
        try {
            BufferedImage image = GxImageUtil.createBufferedImageFromURI(imageFile);
            imageFile = GxImageUtil.resize(imageFile, image.getWidth() * percent / 100, image.getHeight() * percent / 100, true);
        }
        catch (Exception e) {
            log.error("scale " + imageFile + " failed", (Throwable)e);
        }
        return imageFile;
    }

    public static String rotate(String imageFile, short angle) {
        if (!GxImageUtil.isValidInput(imageFile)) {
            return "";
        }
        try {
            BufferedImage image = GxImageUtil.createBufferedImageFromURI(imageFile);
            BufferedImage rotatedImage = GxImageUtil.rotateImage(image, angle);
            return GxImageUtil.writeImage(rotatedImage, imageFile);
        }
        catch (Exception e) {
            log.error("rotate " + imageFile + " failed", (Throwable)e);
            return "";
        }
    }

    private static BufferedImage rotateImage(BufferedImage buffImage, double angle) {
        double radian = Math.toRadians(angle);
        double sin = Math.abs(Math.sin(radian));
        double cos = Math.abs(Math.cos(radian));
        int width = buffImage.getWidth();
        int height = buffImage.getHeight();
        int nWidth = (int)Math.floor((double)width * cos + (double)height * sin);
        int nHeight = (int)Math.floor((double)height * cos + (double)width * sin);
        BufferedImage rotatedImage = new BufferedImage(nWidth, nHeight, 2);
        Graphics2D graphics = rotatedImage.createGraphics();
        AffineTransform at = new AffineTransform();
        at.translate((nWidth - width) / 2, (nHeight - height) / 2);
        at.rotate(radian, width / 2, height / 2);
        graphics.setTransform(at);
        graphics.drawImage((Image)buffImage, 0, 0, null);
        graphics.drawRect(0, 0, nWidth - 1, nHeight - 1);
        graphics.dispose();
        return rotatedImage;
    }
}

