/*
 * Decompiled with CFR 0.152.
 */
package com.genexus;

import com.genexus.Application;
import com.genexus.ApplicationContext;
import com.genexus.GXObjectBase;
import com.genexus.GXSmartCacheProvider;
import com.genexus.GXutil;
import com.genexus.IGxSilentTrn;
import com.genexus.IHttpContext;
import com.genexus.ModelContext;
import com.genexus.WrapperUtils;
import com.genexus.diagnostics.core.ILogger;
import com.genexus.internet.MsgList;
import com.genexus.security.GXResult;
import com.genexus.security.GXSecurityProvider;
import com.genexus.servlet.IServletContext;
import com.genexus.servlet.http.IHttpServletRequest;
import com.genexus.servlet.http.IHttpServletResponse;
import com.genexus.specific.java.LogManager;
import com.genexus.webpanels.HttpContextWeb;
import com.genexus.ws.rs.core.IResponseBuilder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import json.org.json.JSONException;
import json.org.json.JSONObject;

public abstract class GxRestService
extends GXObjectBase {
    private static ILogger logger = null;
    protected JSONObject errorJson;
    protected boolean error = false;
    protected String gamError;
    protected boolean forbidden = false;
    protected String permissionPrefix;
    protected String permissionMethod;
    protected static final int SECURITY_LOW = 1;
    protected static final String POST = "POST";
    protected HttpContextWeb restHttpContext;
    protected IResponseBuilder builder;

    protected abstract boolean IntegratedSecurityEnabled();

    protected abstract int IntegratedSecurityLevel();

    protected String ExecutePermissionPrefix() {
        return "";
    }

    protected boolean IsSynchronizer() {
        return false;
    }

    protected void init(String requestMethod) {
        this.initWrappedVars();
        this.init(requestMethod, this.myServletRequestWrapper, this.myServletResponseWrapper, this.myContextWrapper);
        ApplicationContext.getInstance().setServletEngineDefaultPath(this.myContextWrapper.getRealPath("/"));
    }

    public void init(String requestMethod, IHttpServletRequest myServletRequest, IHttpServletResponse myServletResponse, IServletContext myContext) {
        this.initLogger(myContext);
        try {
            String gxcfg = myContext.getInitParameter("gxcfg");
            Class<?> gxcfgClass = ((Object)((Object)this)).getClass();
            if (gxcfg != null) {
                gxcfgClass = Class.forName(gxcfg);
                ApplicationContext appContext = ApplicationContext.getInstance();
                appContext.setServletEngine(true);
                Application.init(gxcfgClass);
            }
            this.restHttpContext = new HttpContextWeb(requestMethod, myServletRequest, myServletResponse, myContext);
            this.restHttpContext.doNotCompress(true);
            this.restHttpContext.setRestService();
            ModelContext.deleteThreadContext();
            super.init(this.restHttpContext, gxcfgClass);
            ModelContext modelContext = ModelContext.getModelContext(((Object)((Object)this)).getClass());
            modelContext.setHttpContext((IHttpContext)this.restHttpContext);
        }
        catch (Throwable e) {
            logger.error("Could not initialize Rest Service", e);
        }
    }

    private void initLogger(IServletContext myContext) {
        if (logger == null) {
            logger = LogManager.initialize((String)myContext.getRealPath("/"), GxRestService.class);
        }
    }

    @Override
    public void webExecute() {
    }

    @Override
    protected void cleanup() {
        GXutil.setThreadTimeZone(ModelContext.getModelContext().getClientTimeZone());
        super.cleanup();
        super.finallyCleanup();
        WrapperUtils.requestBodyThreadLocal.remove();
    }

    public void ErrorCheck(IGxSilentTrn trn) {
        if (trn.Errors() == 1) {
            this.error = true;
            MsgList msg = trn.GetMessages();
            if (msg.getItemCount() > 0) {
                this.SetError("404", msg.getItemText(1));
            }
        }
    }

    protected void webException(Throwable th) {
        logger.error("Failed to complete execution of Rest Service:", th);
    }

    public void SetError(String code, String message) {
        try {
            JSONObject obj = new JSONObject();
            obj.put("code", (Object)code);
            obj.put("message", (Object)message);
            this.errorJson = new JSONObject();
            this.errorJson.put("error", (Object)obj);
        }
        catch (JSONException e) {
            logger.error("Invalid JSON", (Throwable)e);
        }
    }

    private boolean isAuthenticated(IHttpServletRequest myServletRequest, int integratedSecurityLevel, boolean useAuthentication, String objPermissionPrefix) {
        if (!useAuthentication) {
            return true;
        }
        String token = myServletRequest.getHeader("Authorization");
        if (token == null) {
            this.gamError = "0";
            this.SetError(this.gamError, "This service needs an Authorization Header");
            return false;
        }
        token = myServletRequest.getHeader("Authorization").replace("OAuth ", "");
        boolean[] flag = new boolean[]{false};
        boolean[] permissionFlag = new boolean[]{false};
        ModelContext modelContext = ModelContext.getModelContext(((Object)((Object)this)).getClass());
        modelContext.setHttpContext((IHttpContext)this.restHttpContext);
        if (integratedSecurityLevel == 1) {
            GXResult result = GXSecurityProvider.getInstance().checkaccesstoken(this.remoteHandle, modelContext, token, flag);
            if (!flag[0]) {
                this.gamError = result.getCode();
                String message = result.getDescription();
                this.SetError(this.gamError, message);
                return false;
            }
            return true;
        }
        GXResult result = GXSecurityProvider.getInstance().checkaccesstokenprm(this.remoteHandle, modelContext, token, objPermissionPrefix, permissionFlag, flag);
        if (flag[0]) {
            return true;
        }
        this.gamError = result.getCode();
        String messagePermission = result.getDescription();
        this.SetError(this.gamError, messagePermission);
        if (permissionFlag[0]) {
            this.forbidden = true;
        }
        return false;
    }

    public boolean isAuthenticated(IHttpServletRequest myServletRequest) {
        return this.isAuthenticated(myServletRequest, this.IntegratedSecurityLevel(), this.IntegratedSecurityEnabled(), this.permissionPrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAuthenticated(IHttpServletRequest myServletRequest, String synchronizer) {
        boolean validSynchronizer = false;
        try {
            if (synchronizer != null && !synchronizer.equals("")) {
                Class<?> synchronizerClass;
                GxRestService synchronizerRestService;
                synchronizer = synchronizer.toLowerCase() + "_services_rest";
                String packageName = Application.getClientContext().getClientPreferences().getPACKAGE();
                if (!packageName.equals("")) {
                    packageName = packageName + ".";
                }
                if ((synchronizerRestService = (GxRestService)((Object)(synchronizerClass = Class.forName(packageName + synchronizer)).getConstructor(new Class[0]).newInstance(new Object[0]))) != null && synchronizerRestService.IsSynchronizer()) {
                    validSynchronizer = true;
                    boolean bl = this.isAuthenticated(myServletRequest, synchronizerRestService.IntegratedSecurityLevel(), synchronizerRestService.IntegratedSecurityEnabled(), synchronizerRestService.ExecutePermissionPrefix());
                    return bl;
                }
            }
            boolean packageName = false;
            return packageName;
        }
        catch (Exception e) {
            logger.error("Could not check user authenticated", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (!validSynchronizer) {
                this.SetError("0", "Invalid Synchronizer " + synchronizer);
            }
        }
    }

    public void setWWWAuthHeader(IHttpServletRequest myServletRequest, IHttpServletResponse myServletResponse) {
        String OauthRealm = "OAuth realm=\"" + myServletRequest.getServerName() + "\"";
        myServletResponse.addHeader("WWW-Authenticate", OauthRealm);
    }

    public boolean processHeaders(String queryId, IHttpServletRequest myServletRequest, IHttpServletResponse myServletResponse) {
        GXSmartCacheProvider.DataUpdateStatus status;
        String theme;
        String language = myServletRequest.getHeader("GeneXus-Language");
        if (language != null) {
            this.setLanguage(language);
        }
        if ((theme = myServletRequest.getHeader("GeneXus-Theme")) != null) {
            this.setTheme(theme);
        }
        String etag = myServletRequest.getMethod().equalsIgnoreCase(POST) ? null : myServletRequest.getHeader("If-Modified-Since");
        Date dt = Application.getStartDateTime();
        Date newDt = new Date();
        Date[] newDt_arr = new Date[]{newDt};
        if (etag == null) {
            status = GXSmartCacheProvider.DataUpdateStatus.Invalid;
            GXSmartCacheProvider.CheckDataStatus((String)queryId, (Date)dt, (Date[])newDt_arr);
        } else {
            dt = this.HTMLDateToDatetime(etag);
            status = GXSmartCacheProvider.CheckDataStatus((String)queryId, (Date)dt, (Date[])newDt_arr);
        }
        newDt = newDt_arr[0];
        if (myServletResponse != null) {
            myServletResponse.addHeader("Last-Modified", this.DateTimeToHTMLDate(newDt));
        }
        return status != GXSmartCacheProvider.DataUpdateStatus.UpToDate;
    }

    Date HTMLDateToDatetime(String s) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            TimeZone tz = TimeZone.getTimeZone("GMT");
            sdf.setTimeZone(tz);
            return sdf.parse(s);
        }
        catch (ParseException p) {
            logger.warn("Could not parse RFC Date", (Throwable)p);
            return new Date();
        }
    }

    String DateTimeToHTMLDate(Date dt) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        TimeZone tz = TimeZone.getTimeZone("GMT");
        sdf.setTimeZone(tz);
        return sdf.format(dt);
    }
}

