/*
 * Decompiled with CFR 0.152.
 */
package com.genexus;

import com.genexus.Application;
import com.genexus.ApplicationContext;
import com.genexus.CommonUtil;
import com.genexus.ConfigFileFinder;
import com.genexus.Filter;
import com.genexus.GXDbFile;
import com.genexus.PrivateUtilities;
import com.genexus.common.interfaces.IPreferences;
import com.genexus.util.IniFile;
import java.io.File;
import java.util.Hashtable;

public class Preferences
implements IPreferences {
    public static final byte ORB_NEVER = 0;
    public static final byte ORB_SUN_RMI = 1;
    public static final byte ORB_CORBA = 2;
    public static final byte ORB_DCOM = 3;
    public static final byte ORB_EJB = 4;
    public static final byte ORB_BEST = 5;
    public static final byte ORB_WL_RMI = 6;
    public static final byte ORB_WL_EJB = 7;
    public static final byte ORB_VBROKER = 8;
    public static final byte ORB_HTTP_STATELESS = 9;
    public static final byte ORB_HTTP_STATEFUL = 10;
    public Byte REMOTE_CALLS;
    protected IniFile iniFile;
    protected String defaultSection;
    public static final int CHANGE_PRETTY_OFTEN = 0;
    public static final int CHANGE_TIME_TO_TIME = 1;
    public static final int CHANGE_HARDLY_EVER = 2;
    public static final int CHANGE_ALMOST_NEVER = 3;
    public static final int CANT_CATS = 4;
    public static final int TTL_NO_CACHE = -1;
    public static final int TTL_NO_EXPIRY = 0;
    public static int[] TTL = new int[4];
    public static int[] HTL = new int[4];
    public static final int SECONDS_IN_ONE_MINUTE = 60;
    public static Class defaultResourceClass;
    private Boolean cookie_httponly_default = null;
    private Object objLock = new Object();
    private String BLOB_PATH = null;
    private String PRIVATE_PATH = null;
    private Boolean LDAP_USERID;
    public static final int LDAP_USERID_OS = 0;
    public static final int LDAP_USERID_LDAP = 1;
    public static final int LDAP_USERID_LDAP_ONLY_SERVER = 2;
    private Integer LDAP_USERID_TYPE = null;
    private Boolean LOGIN_AS_USERID;
    private Boolean EXPOSE_METADATA;
    private static int modelNum;
    private Boolean CACHING;
    private Boolean SMART_CACHING;
    private Hashtable<String, String> eventTable = new Hashtable();

    public Preferences(IniFile iniFile, String defaultSection) {
        this.iniFile = iniFile;
        this.defaultSection = defaultSection;
    }

    public Preferences(Class resourceClass, String fileName, String defaultSection) {
        this.defaultSection = defaultSection;
        this.iniFile = ConfigFileFinder.getConfigFile(resourceClass, fileName, defaultResourceClass);
    }

    public void setAutomaticReloading(boolean autoReloading) {
        this.iniFile.setAutomaticReloading(autoReloading);
    }

    public String getNAME_SPACE() {
        if (ApplicationContext.getInstance().isGXUtility()) {
            return this.getProperty("NAME_SPACE", "");
        }
        return this.getProperty("NAME_SPACE");
    }

    public IniFile getIniFile() {
        return this.iniFile;
    }

    public String getServerKey() {
        return this.iniFile.getServerKey();
    }

    public String getSiteKey() {
        return this.iniFile.getSiteKey();
    }

    public String getORQ_SERVER_DIR() {
        return PrivateUtilities.addLastPathSeparator(this.getProperty("ORQ_SERVER_DIR", ""));
    }

    public String getORQ_CLIENT_URL() {
        return PrivateUtilities.addLastChar(this.getProperty("ORQ_CLIENT_URL", ""), "/");
    }

    public String getSMTP_HOST() {
        return this.getProperty("SMTP_HOST", "");
    }

    public String getHTTP_BACKEND_URL() {
        return this.getProperty("HTTP_BACKEND_URL", "");
    }

    public String getNAME_HOST() {
        return this.getProperty("NAME_HOST", "");
    }

    public int getCONN_TIMEOUT() {
        return (int)CommonUtil.val((String)this.getProperty("CONN_TIMEOUT", "300"));
    }

    public boolean getcookie_httponly_default() {
        if (this.cookie_httponly_default == null) {
            this.cookie_httponly_default = new Boolean(true);
            String cookie_httponly_defaultS = "";
            cookie_httponly_defaultS = this.getProperty("cookie_httponly_default", "").trim();
            if (cookie_httponly_defaultS.equals("false")) {
                this.cookie_httponly_default = new Boolean(false);
            }
        }
        return this.cookie_httponly_default;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBLOB_PATH() {
        Object object = this.objLock;
        synchronized (object) {
            if (this.BLOB_PATH == null) {
                this.BLOB_PATH = this.getProperty_PATH(this.getProperty("CS_BLOB_PATH", "").trim(), "");
            }
        }
        return this.BLOB_PATH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPRIVATE_PATH() {
        Object object = this.objLock;
        synchronized (object) {
            if (this.PRIVATE_PATH == null) {
                this.PRIVATE_PATH = this.getProperty_PATH(this.getProperty("TMPMEDIA_DIR", "").trim(), "WEB-INF");
            }
        }
        return this.PRIVATE_PATH;
    }

    public String getProperty_PATH(String propertyPath, String extraFolder) {
        String file = "";
        if (!propertyPath.equals("") && !propertyPath.endsWith(File.separator)) {
            propertyPath = propertyPath + File.separator;
        }
        if (Application.getGXServices().get("Storage") == null) {
            if (ApplicationContext.getInstance().isServletEngine() && !new File(propertyPath).isAbsolute()) {
                file = ApplicationContext.getInstance().getServletEngineDefaultPath();
                if (!file.equals("") && !file.endsWith(File.separator)) {
                    file = file + File.separator;
                }
                file = extraFolder.isEmpty() ? file : file + extraFolder + File.separator;
            }
            new File(file + propertyPath).mkdirs();
            propertyPath = file + propertyPath;
        } else {
            propertyPath = propertyPath.replace(File.separator, "/");
        }
        return propertyPath;
    }

    public String getMultimediaPath() {
        File blobDir = new File(this.getBLOB_PATH());
        File multimediaDir = new File(blobDir, GXDbFile.getMultimediaDirectory());
        if (!multimediaDir.exists()) {
            multimediaDir.mkdirs();
        }
        return multimediaDir.getPath();
    }

    public String getLUCENE_INDEX_DIRECTORY() {
        return this.getProperty("LUCENE_INDEX_DIRECTORY", "");
    }

    public String getINDEX_QUEUE_MAX_SIZE() {
        return this.getProperty("INDEX_QUEUE_MAX_SIZE", "");
    }

    public String getLUCENE_ANALYZER() {
        return this.getProperty("LUCENE_ANALYZER", "");
    }

    public int getSUBMIT_POOL_SIZE() {
        return (int)CommonUtil.val((String)this.getProperty("SUBMIT_POOL_SIZE", "3"));
    }

    public static Preferences getDefaultPreferences() {
        return Application.getClientPreferences();
    }

    public boolean propertyExists(String key) {
        return this.iniFile.propertyExists(this.defaultSection, key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.iniFile.getProperty(this.defaultSection, key, defaultValue);
    }

    public String getProperty(String section, String key, String defaultValue) {
        return this.iniFile.getProperty(section, key, defaultValue);
    }

    public int getRemoteAdminPort() {
        return (int)CommonUtil.val((String)this.iniFile.getProperty(this.defaultSection, "RemoteAdminPort", "1999"));
    }

    protected String getProperty(String key) {
        String out = this.iniFile.getProperty(this.defaultSection, key);
        if (out == null) {
            System.err.println("Can't find key " + key);
            new Throwable().printStackTrace();
        }
        return out;
    }

    public String getPropertyDefault(String key, String defaultValue) {
        String out = this.iniFile.getProperty(this.defaultSection, key);
        if (out == null) {
            return defaultValue;
        }
        return out;
    }

    public String getCORBA_SERVER_NAME() {
        return this.iniFile.getProperty(this.defaultSection, "CORBA_SERVER_NAME", "");
    }

    public String getDCOM_GUID() {
        return this.iniFile.getProperty(this.defaultSection, "DCOM_GUID", "");
    }

    protected byte mapRemoteProtocol(String aux) {
        if (aux.equals("CORBA")) {
            return 2;
        }
        if (aux.equals("SUN_RMI")) {
            return 1;
        }
        if (aux.equals("DCOM")) {
            return 3;
        }
        if (aux.equals("VBROKER")) {
            return 8;
        }
        if (aux.equals("HTTP_STATELESS")) {
            return 9;
        }
        if (aux.equals("HTTP_STATEFUL")) {
            return 10;
        }
        if (aux.equals("BEST")) {
            return 5;
        }
        return 0;
    }

    public byte getREMOTE_CALLS() {
        if (this.REMOTE_CALLS == null) {
            String aux = ApplicationContext.getInstance().isGXUtility() ? this.getProperty("REMOTE_CALLS", "NEVER").toUpperCase() : this.getProperty("REMOTE_CALLS").toUpperCase();
            this.REMOTE_CALLS = new Byte(this.mapRemoteProtocol(aux));
        }
        return this.REMOTE_CALLS;
    }

    public boolean getLDAP_USERID() {
        return this.getLDAP_USERID_TYPE() != 0;
    }

    public int getLDAP_USERID_TYPE() {
        if (this.LDAP_USERID_TYPE == null) {
            try {
                String userIdType = this.getProperty("LDAP_USERID_TYPE", "OS");
                this.LDAP_USERID_TYPE = userIdType.equalsIgnoreCase("LDAP") ? new Integer(1) : (userIdType.equalsIgnoreCase("LDAP_SERVER") ? new Integer(2) : new Integer(0));
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.LDAP_USERID_TYPE = new Integer(0);
            }
        }
        return this.LDAP_USERID_TYPE;
    }

    public boolean getLOGIN_AS_USERID() {
        try {
            return this.booleanPreference(this.LOGIN_AS_USERID, "LOGIN_AS_USERID");
        }
        catch (Throwable e) {
            return false;
        }
    }

    public boolean getEXPOSE_METADATA() {
        try {
            return this.booleanPreference(this.EXPOSE_METADATA, "EXPOSE_METADATA");
        }
        catch (Throwable e) {
            return false;
        }
    }

    protected boolean booleanPreference(Boolean value, String key, String defValue) {
        if (value == null) {
            value = new Boolean(!this.getProperty(key, defValue).equals("0"));
        }
        return value;
    }

    protected boolean booleanPreference(Boolean value, String key) {
        if (value == null) {
            value = new Boolean(!this.getProperty(key).equals("0"));
        }
        return value;
    }

    protected byte bytePreference(Byte value, String key, String defValue) {
        if (value == null) {
            try {
                value = new Byte(this.getProperty(key, defValue));
            }
            catch (NumberFormatException e) {
                throw new InternalError("Illegal format in model.properties - " + key);
            }
        }
        return value;
    }

    protected byte bytePreference(Byte value, String key) {
        if (value == null) {
            try {
                value = new Byte(this.getProperty(key));
            }
            catch (NumberFormatException e) {
                throw new InternalError("Illegal format in model.properties - " + key);
            }
        }
        return value;
    }

    protected short shortPreference(Short value, String key) {
        if (value == null) {
            try {
                value = new Short(this.getProperty(key));
            }
            catch (NumberFormatException e) {
                throw new InternalError("Illegal format in model.properties - " + key);
            }
        }
        return value;
    }

    protected int intPreference(Integer value, String key) {
        if (value == null) {
            try {
                value = new Integer(this.getProperty(key));
            }
            catch (NumberFormatException e) {
                throw new InternalError("Illegal format in model.properties - " + key);
            }
        }
        return value;
    }

    public static int getGXModelNum() {
        String[] list;
        if (modelNum == -1 && (list = new File(".").list(new Filter())).length > 0) {
            modelNum = (int)CommonUtil.val((String)list[0].substring(list[0].lastIndexOf(46) + 1));
        }
        return modelNum;
    }

    public int getCACHE_TTL(int category, int defaultTTL) {
        try {
            return Integer.parseInt(this.getProperty("CACHE_TTL_" + category, "" + defaultTTL));
        }
        catch (Exception e) {
            return defaultTTL;
        }
    }

    public int getCACHE_HTL(int category, int defaultTTL) {
        try {
            return Integer.parseInt(this.getProperty("CACHE_HTL_" + category, "" + defaultTTL));
        }
        catch (Exception e) {
            return defaultTTL;
        }
    }

    public long getCACHE_STORAGE_SIZE() {
        try {
            return Long.parseLong(this.getProperty("CACHE_STORAGE_SIZE", "0"));
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public boolean getCACHING() {
        return this.booleanPreference(this.CACHING, "CACHING", "0");
    }

    public boolean getSMART_CACHING() {
        return this.booleanPreference(this.SMART_CACHING, "SMART_CACHING", "1");
    }

    public String getEvent(String eventName) {
        String proc = this.eventTable.get(eventName = eventName.toUpperCase());
        if (proc == null) {
            proc = this.getProperty("EVENT_" + eventName, "").trim().toLowerCase();
            proc = proc.replace('\\', '.');
            this.eventTable.put(eventName, proc);
        }
        return proc;
    }

    public String getDefaultTheme() {
        return this.getProperty("Theme", "").trim();
    }

    static {
        modelNum = -1;
    }
}

