/*
 * Decompiled with CFR 0.152.
 */
package com.genexus;

import com.genexus.CommonUtil;
import com.genexus.Preferences;
import com.genexus.util.IniFile;
import java.util.Hashtable;

public final class ServerPreferences
extends Preferences {
    public static String fileName = "server.cfg";
    private static ServerPreferences instance;
    private static Hashtable<String, ServerPreferences> preferences;

    public static void setFileName(String iFileName) {
        fileName = iFileName;
    }

    public ServerPreferences(IniFile iniFile) {
        super(iniFile, "Server");
    }

    private ServerPreferences(Class resourceClass) {
        super(resourceClass, fileName, "Server");
    }

    public static ServerPreferences getInstance(Class resourceClass) {
        String packageName = CommonUtil.getPackageName((Class)resourceClass);
        ServerPreferences ret = preferences.get(packageName);
        if (ret == null) {
            ret = new ServerPreferences(resourceClass);
            preferences.put(packageName, ret);
        }
        return ret;
    }

    public String getLocation() {
        return this.iniFile.getProperty(this.defaultSection, "Location", "");
    }

    public boolean getLogToConsole() {
        return !this.iniFile.getProperty(this.defaultSection, "LogConsole").equals("0");
    }

    public boolean getLogEnabled() {
        return !this.iniFile.getProperty(this.defaultSection, "LogEnabled").equals("0");
    }

    public boolean getRemoteAdminEnabled() {
        return !this.iniFile.getProperty(this.defaultSection, "RemoteAdmin", "1").equals("0");
    }

    public boolean getIsNameServer() {
        return this.iniFile.getProperty(this.defaultSection, "IsNameServer", "1").equals("1");
    }

    public int getRMI_SERVER_PORT() {
        return (int)CommonUtil.val((String)this.iniFile.getProperty(this.defaultSection, "RMI_SERVER_PORT", "0"));
    }

    public String getORB_LOG() {
        return this.iniFile.getProperty(this.defaultSection, "ORB_LOG");
    }

    public int getServerProtocol() {
        return this.mapRemoteProtocol(this.iniFile.getProperty(this.defaultSection, "ServerProtocol", "NEVER"));
    }

    public String getOnDisconnectProcName() {
        return this.iniFile.getProperty(this.defaultSection, "OnDisconnect", null);
    }

    static {
        preferences = new Hashtable();
    }
}

