/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.configuration;

import com.genexus.Preferences;
import com.genexus.util.GXService;
import com.genexus.util.GXServices;
import com.genexus.util.IniFile;

public class ConfigurationManager {
    public static boolean hasValue(String propName, String fileName) {
        String value = ConfigurationManager.getValue(propName, fileName);
        if (value == null) {
            return false;
        }
        return !value.isEmpty();
    }

    public static boolean hasValue(String propName) {
        return ConfigurationManager.hasValue(propName, "");
    }

    public static String getValue(String propName, String fileName) {
        GXServices services = null;
        if (fileName.isEmpty()) {
            String propValue;
            IniFile iniFile = Preferences.getDefaultPreferences().getIniFile();
            String section = "Client";
            String key = propName;
            if (propName.indexOf(":") > 0) {
                section = propName.substring(0, propName.indexOf(":"));
                key = propName.substring(propName.indexOf(":") + 1);
            }
            if ((propValue = iniFile.getProperty(section, key)) != null && !propValue.isEmpty()) {
                return propValue;
            }
            services = GXServices.getInstance();
        } else {
            services = new GXServices();
            GXServices.loadFromFile("", fileName, services);
        }
        if (services == null) {
            return "";
        }
        return ConfigurationManager.getValueFromGXServices(services, propName);
    }

    public static String getValue(String propName) {
        return ConfigurationManager.getValue(propName, "");
    }

    private static String getValueFromGXServices(GXServices services, String propName) {
        GXService service;
        String[] tokens = propName.split(":");
        if (tokens.length < 2 || tokens.length > 3) {
            return null;
        }
        String key = tokens[0];
        String property = tokens[1];
        if (tokens.length == 3) {
            key = String.format("%s:%s", tokens[0], tokens[1]);
            property = tokens[2];
        }
        if ((service = services.get(key)) == null) {
            return null;
        }
        return service.getProperties().get(property);
    }
}

