/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.configuration;

import com.genexus.Application;
import com.genexus.GXBaseCollection;
import com.genexus.GXutil;
import com.genexus.SdtMessages_Message;
import com.genexus.common.interfaces.SpecificImplementation;
import com.genexus.db.driver.ExternalProvider;
import com.genexus.diagnostics.core.ILogger;
import com.genexus.diagnostics.core.LogManager;
import com.genexus.util.Encryption;
import com.genexus.util.GXProperties;
import com.genexus.util.GXProperty;
import com.genexus.util.GXService;
import com.genexus.util.GXStorageProvider;

public class ExternalStorage
extends GXStorageProvider {
    private GXService providerService = Application.getGXServices().get("StorageAPI");
    public static ILogger logger = LogManager.getLogger(Application.class);
    private static String key = SpecificImplementation.Application.getModelContext().getServerKey();

    public ExternalStorage() {
        if (this.providerService == null) {
            this.providerService = Application.getGXServices().get("Storage");
        }
    }

    public boolean create(String name, GXProperties properties, GXStorageProvider[] storageProvider, GXBaseCollection<SdtMessages_Message>[] messages) {
        storageProvider[0] = null;
        if (this.isNullOrEmpty(name)) {
            GXutil.ErrorToMessages("Unsupported", "Provider name cannot be empty", messages[0]);
            return false;
        }
        try {
            if (this.providerService == null || !this.providerService.getName().equals(name)) {
                this.providerService = new GXService();
                this.providerService.setType("Storage");
                this.providerService.setName(name);
                this.providerService.setAllowMultiple(false);
                this.providerService.setAllowOverrideWithEnvVarSettings(false);
                this.providerService.setProperties(new GXProperties());
            }
            this.preprocess(name, properties);
            GXProperty prop = properties.first();
            while (!properties.eof()) {
                this.providerService.getProperties().set(prop.name, prop.value);
                prop = properties.next();
            }
            String classFullName = this.providerService.getClassName();
            logger.debug("Loading storage provider: " + classFullName);
            Class<?> providerClass = Class.forName(classFullName);
            this.provider = (ExternalProvider)providerClass.getConstructor(GXService.class).newInstance(this.providerService);
        }
        catch (Exception ex) {
            logger.error("Couldn't connect to external storage provider. ", ex.getMessage(), (Throwable)ex);
            this.storageMessages(ex, messages[0]);
            return false;
        }
        storageProvider[0] = this;
        return true;
    }

    public boolean connect(String profileName, GXProperties properties, GXStorageProvider[] storageProvider, GXBaseCollection<SdtMessages_Message>[] messages) {
        if (this.providerService != null) {
            if (profileName.trim().equalsIgnoreCase("default")) {
                profileName = this.providerService.getName();
            }
            return this.create(profileName, properties, storageProvider, messages);
        }
        this.storageMessages(new RuntimeException("Provider cannot be local"), messages[0]);
        return false;
    }

    private void preprocess(String name, GXProperties properties) {
        String className = null;
        switch (name) {
            case "AMAZONS3": {
                className = "com.genexus.db.driver.ExternalProviderS3";
                this.setDefaultProperty(properties, "STORAGE_PROVIDER_REGION", "us-east-1");
                this.setDefaultProperty(properties, "STORAGE_ENDPOINT", "s3.amazonaws.com");
                this.setEncryptProperty(properties, "STORAGE_PROVIDER_ACCESSKEYID");
                this.setEncryptProperty(properties, "STORAGE_PROVIDER_SECRETACCESSKEY");
                this.setEncryptProperty(properties, "BUCKET_NAME");
                break;
            }
            case "AZURESTORAGE": {
                className = "com.genexus.db.driver.ExternalProviderAzureStorage";
                this.setEncryptProperty(properties, "PUBLIC_CONTAINER_NAME");
                this.setEncryptProperty(properties, "PRIVATE_CONTAINER_NAME");
                this.setEncryptProperty(properties, "ACCOUNT_NAME");
                this.setEncryptProperty(properties, "ACCESS_KEY");
                break;
            }
            case "BLUEMIXSTORAGE": {
                className = "com.genexus.db.driver.ExternalProviderBluemix";
                this.setDefaultProperty(properties, "SERVER_URL", "https://identity.open.softlayer.com");
                this.setDefaultProperty(properties, "STORAGE_PROVIDER_REGION", "dallas");
                this.setEncryptProperty(properties, "PUBLIC_BUCKET_NAME");
                this.setEncryptProperty(properties, "PRIVATE_BUCKET_NAME");
                this.setEncryptProperty(properties, "STORAGE_PROVIDER_USER");
                this.setEncryptProperty(properties, "STORAGE_PROVIDER_PASSWORD");
                break;
            }
            case "BOX": {
                className = "com.genexus.db.driver.ExternalProviderBox";
                break;
            }
            case "GOOGLE": {
                className = "com.genexus.db.driver.ExternalProviderGoogle";
                this.setEncryptProperty(properties, "KEY");
                this.setEncryptProperty(properties, "BUCKET_NAME");
                break;
            }
            case "IBMCOS": {
                className = "com.genexus.db.driver.ExternalProviderIBM";
                this.setEncryptProperty(properties, "STORAGE_PROVIDER_ACCESS_KEY");
                this.setEncryptProperty(properties, "STORAGE_PROVIDER_SECRET_KEY");
                this.setEncryptProperty(properties, "BUCKET_NAME");
                break;
            }
            case "OPENSTACKSTORAGE": {
                className = "com.genexus.db.driver.ExternalProviderOpenStack";
                this.setEncryptProperty(properties, "BUCKET_NAME");
                this.setEncryptProperty(properties, "STORAGE_PROVIDER_USER");
                this.setEncryptProperty(properties, "STORAGE_PROVIDER_PASSWORD");
                break;
            }
            default: {
                throw new RuntimeException(String.format("Provider %s is not supported", name));
            }
        }
        if (this.isNullOrEmpty(this.providerService.getClassName()) || !this.providerService.getClassName().equals(className)) {
            this.providerService.setClassName(className);
        }
    }

    private void setDefaultProperty(GXProperties properties, String prop, String value) {
        if (!properties.containsKey(prop)) {
            properties.set(prop, value);
        }
    }

    private void setEncryptProperty(GXProperties properties, String prop) {
        String value = properties.get(prop);
        if (this.isNullOrEmpty(value)) {
            value = "";
        }
        value = Encryption.addchecksum((String)value, (int)Encryption.getCheckSumLength());
        value = Encryption.encrypt64((String)value, (String)key);
        properties.set(prop, value);
    }

    private boolean isNullOrEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }
}

