/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.cryptography;

import com.genexus.cryptography.GXCertificate;
import com.genexus.cryptography.Utils;
import com.genexus.cryptography.encryption.asymmetric.CipherAsymProvider;
import com.genexus.cryptography.encryption.asymmetric.IGXAsymEncryption;
import com.genexus.cryptography.exception.AlgorithmNotSupportedException;
import com.genexus.cryptography.exception.EncryptionException;
import com.genexus.cryptography.exception.PrivateKeyNotFoundException;
import com.genexus.cryptography.exception.PublicKeyNotFoundException;

public class GXAsymEncryption {
    private static final String DEFAULT_SYM_ALGORITHM = "RSA";
    private static final String DEFAULT_SYM_PADDING = "PKCS1Padding";
    private static final String DEFAULT_SYM_MODE = "ECB";
    private int _lastError;
    private String _lastErrorDescription;
    private String _algorithm = String.format("%s/%s/%s", "RSA", "ECB", "PKCS1Padding");
    private GXCertificate _cert;
    private IGXAsymEncryption _asymAlg;
    private boolean _isDirty = true;

    public GXAsymEncryption() {
        this.initialize();
    }

    private void initialize() {
        if (this._isDirty) {
            this.setError(0);
            if (this._cert != null && this._cert.certLoaded()) {
                try {
                    this._asymAlg = new CipherAsymProvider(this._algorithm, this._cert.getPublicKey(), this._cert.getPrivateKey());
                    this._isDirty = false;
                }
                catch (AlgorithmNotSupportedException e) {
                    this.setError(2);
                }
            } else {
                this.setError(4);
            }
        }
    }

    public String encrypt(String text) {
        this.initialize();
        String encrypted = "";
        if (!this.anyError()) {
            try {
                encrypted = this._asymAlg.encrypt(text);
            }
            catch (PublicKeyNotFoundException e) {
                this.setError(4);
            }
            catch (EncryptionException e) {
                this.setError(3);
                Utils.logError((Exception)((Object)e));
            }
        }
        return encrypted;
    }

    public String decrypt(String text) {
        this.initialize();
        String decrypted = "";
        if (!this.anyError()) {
            try {
                decrypted = this._asymAlg.decrypt(text);
            }
            catch (PrivateKeyNotFoundException e) {
                this.setError(5);
            }
            catch (EncryptionException e) {
                this.setError(3);
                Utils.logError((Exception)((Object)e));
            }
        }
        return decrypted;
    }

    private void setError(int errorCode) {
        this.setError(errorCode, "");
    }

    private void setError(int errorCode, String errDsc) {
        this._lastError = errorCode;
        switch (errorCode) {
            case 0: {
                this._lastErrorDescription = "";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this._lastErrorDescription = "Algorithm not supported";
                break;
            }
            case 3: {
                this._lastErrorDescription = "Unknown encryption exception";
                break;
            }
            case 4: {
                this._lastErrorDescription = "";
                break;
            }
            case 5: {
                this._lastErrorDescription = "Certificate does not contain private key";
                break;
            }
        }
        if (!errDsc.equals("")) {
            this._lastErrorDescription = errDsc;
        }
    }

    public String getAlgorithm() {
        return this._algorithm;
    }

    public void setAlgorithm(String value) {
        value = String.format("%s/%s/%s", value, DEFAULT_SYM_MODE, DEFAULT_SYM_PADDING);
        this._isDirty = this._isDirty || !value.equals(this._algorithm);
        this._algorithm = value;
    }

    public GXCertificate getCertificate() {
        return this._cert;
    }

    public void setCertificate(GXCertificate cert) {
        this._isDirty = this._isDirty || cert != this._cert;
        this._cert = cert;
    }

    private boolean anyError() {
        if (this._cert == null || !this._cert.certLoaded()) {
            this.setError(4);
        }
        return this._lastError != 0;
    }

    public int getErrCode() {
        return this._lastError;
    }

    public String getErrDescription() {
        return this._lastErrorDescription;
    }
}

