/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.cryptography;

import com.genexus.cryptography.encryption.symmetric.CipherSymProvider;
import com.genexus.cryptography.encryption.symmetric.IGXSymEncryption;
import com.genexus.cryptography.exception.AlgorithmNotSupportedException;
import com.genexus.cryptography.exception.EncryptionException;
import com.genexus.cryptography.exception.InvalidKeyLengthException;
import com.genexus.diagnostics.Log;
import java.security.NoSuchAlgorithmException;
import javax.crypto.NoSuchPaddingException;

public class GXSymEncryption {
    private int _lastError;
    private String _lastErrorDescription;
    private IGXSymEncryption _symAlg;
    private String _algorithm = String.format("%s/%s/%s", "DES", "CBC", "PKCS5Padding");
    private String _key = "";
    private String _iv = "";
    private boolean isDirty = true;
    private int _keySize;
    private int _blockSize;

    private void Initialize() {
        if (this.isDirty) {
            this.setError(0);
            try {
                this._symAlg = new CipherSymProvider(this._algorithm);
                if (this.validPropertyValue(this._key)) {
                    this._symAlg.setKey(this._key);
                }
                if (this.validPropertyValue(this._iv)) {
                    this._symAlg.setIV(this._iv);
                }
                if (this._blockSize > 0) {
                    this._symAlg.setBlockSize(this._blockSize);
                }
                if (this._keySize > 0) {
                    this._symAlg.setKeySize(this._keySize);
                }
                this.isDirty = false;
            }
            catch (NoSuchAlgorithmException e) {
                this.setError(2);
                GXSymEncryption.logError(e);
            }
            catch (NoSuchPaddingException e) {
                this.setError(3);
                GXSymEncryption.logError(e);
            }
            catch (InvalidKeyLengthException e) {
                this.setError(4, e.getMessage());
                GXSymEncryption.logError(e);
            }
            catch (AlgorithmNotSupportedException e) {
                this.setError(2);
                GXSymEncryption.logError(e);
            }
        }
    }

    private boolean validPropertyValue(String value) {
        return value != null && !value.equals("");
    }

    public String encrypt(String text) {
        this.Initialize();
        String encrypted = "";
        if (!this.anyError()) {
            try {
                encrypted = this._symAlg.encrypt(text);
            }
            catch (EncryptionException e) {
                this.setError(1);
                Log.error((String)e.getMessage(), (String)"GXSymEncryption", (Throwable)e);
            }
        }
        return encrypted;
    }

    public String decrypt(String text) {
        this.Initialize();
        String decrypted = "";
        if (!this.anyError()) {
            try {
                if (this.getIV().equals("")) {
                    this.setError(5);
                    return "";
                }
                decrypted = this._symAlg.decrypt(text);
            }
            catch (EncryptionException e) {
                this.setError(1);
                GXSymEncryption.logError(e);
            }
        }
        return decrypted;
    }

    public String getAlgorithm() {
        return this._algorithm;
    }

    public void setAlgorithm(String algorithm) {
        algorithm = String.format("%s/%s/%s", algorithm, "CBC", "PKCS5Padding");
        this.isDirty = this.isDirty || !this._algorithm.equals(algorithm);
        this._algorithm = algorithm;
    }

    public String getKey() {
        if (!this.anyError() && this._symAlg != null) {
            return this._symAlg.getKey();
        }
        return this._key;
    }

    public void setKey(String key) {
        this.isDirty = this.isDirty || !this._key.equals(key);
        this._key = key;
    }

    public String getIV() {
        if (!this.anyError() && this._symAlg != null) {
            return this._symAlg.getIV();
        }
        return this._iv;
    }

    public void setIV(String iv) {
        this.isDirty = this.isDirty || !this._iv.equals(iv);
        this._iv = iv;
    }

    public int getKeySize() {
        if (!this.anyError() && this._symAlg != null) {
            return this._symAlg.getKeySize();
        }
        return this._keySize;
    }

    public void setKeySize(int keySize) {
        this.isDirty = this.isDirty || this._keySize != keySize;
        this._keySize = keySize;
    }

    public int getBlockSize() {
        if (!this.anyError() && this._symAlg != null) {
            return this._symAlg.getBlockSize();
        }
        return this._blockSize;
    }

    public void setBlockSize(int blockSize) {
        this.isDirty = this.isDirty || this._blockSize != blockSize;
        this._blockSize = blockSize;
    }

    private void setError(int errorCode) {
        this.setError(errorCode, "");
    }

    private void setError(int errorCode, String errDsc) {
        this._lastError = errorCode;
        switch (errorCode) {
            case 0: {
                this._lastErrorDescription = "";
                break;
            }
            case 1: {
                this._lastErrorDescription = "Unknown encryption exception";
                break;
            }
            case 2: {
                this._lastErrorDescription = "Algorithm not supported";
                break;
            }
            case 3: {
                this._lastErrorDescription = "Unknown encryption exception";
                break;
            }
            case 4: {
                this._lastErrorDescription = "Not valid Key";
                break;
            }
            case 5: {
                this._lastErrorDescription = "IV must be set for Decryption";
                break;
            }
        }
        if (!errDsc.equals("")) {
            this._lastErrorDescription = errDsc;
        }
    }

    private boolean anyError() {
        return this._lastError != 0;
    }

    public int getErrCode() {
        return this._lastError;
    }

    public String getErrDescription() {
        return this._lastErrorDescription;
    }

    private static void logError(Throwable e) {
        Log.error((String)e.getMessage(), (String)"GXSymEncryption", (Throwable)e);
    }
}

