/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db;

import com.genexus.db.CacheKey;
import com.genexus.db.CachedIFieldGetter;
import com.genexus.db.DynamicExecute;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Date;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.Vector;

public class CacheValue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int hits;
    private Vector<CachedIFieldGetter> items;
    private long timestamp;
    private Date timeCreated;
    protected boolean isRemote = false;
    private TimeZone mTimeZone;
    private CacheKey key;
    private int expiryTime = 0;
    private int expiryHits = 0;
    private long cachedSize = 0L;
    private int[] resultSetTypes;

    public CacheValue() {
    }

    public CacheValue(String sentence, Object[] parms) {
        if (parms == null) {
            this.key = new CacheKey(sentence, null);
        } else {
            Object[] keyParms = new Object[parms.length];
            System.arraycopy(parms, 0, keyParms, 0, parms.length);
            this.key = new CacheKey(sentence, keyParms);
        }
        this.items = new Vector();
        this.cachedSize = sentence.length();
    }

    public CacheKey getKey() {
        return this.key;
    }

    public void setExpiryTime(int expiryTimeSeconds) {
        this.expiryTime = expiryTimeSeconds;
    }

    public long getExpiryTimeMilliseconds() {
        return this.expiryTime * 1000;
    }

    public int getExpiryTimeSeconds() {
        return this.expiryTime;
    }

    public void setExpiryHits(int expiryHits) {
        this.expiryHits = expiryHits;
    }

    public int getExpiryHits() {
        return this.expiryHits;
    }

    public boolean hasExpired() {
        return this.expiryHits > 0 && this.hits >= this.expiryHits || this.expiryTime > 0 && this.timestamp + this.getExpiryTimeMilliseconds() < System.currentTimeMillis();
    }

    private void getResultSetTypes(Object[] resultSet) {
        this.resultSetTypes = new int[resultSet.length];
        for (int i = 0; i < resultSet.length; ++i) {
            Class<?> componentType = resultSet[i].getClass().getComponentType();
            this.resultSetTypes[i] = DynamicExecute.getPrimitiveType(componentType);
        }
    }

    public void setTimeZone(TimeZone cachedValueTimeZone) {
        this.mTimeZone = cachedValueTimeZone;
    }

    protected void setIsRemote(boolean isRemote) {
        this.isRemote = isRemote;
    }

    public <T> void addItem(T value) {
        if (value instanceof String) {
            this.cachedSize += (long)value.toString().length();
        }
        if (value instanceof CachedIFieldGetter) {
            CachedIFieldGetter cValue = (CachedIFieldGetter)value;
            cValue.setTimeZone(this.mTimeZone);
            this.items.addElement(cValue);
        } else {
            Object[] arr = (Object[])Array.newInstance(value.getClass(), 1);
            arr[0] = value;
            Object[][] values = (Object[][])Array.newInstance(arr.getClass(), 1);
            values[0] = arr;
            this.items.addElement(new CachedIFieldGetter((Object[])values));
        }
    }

    public void addItem(Object[] resultSet, long thisSize) {
        this.cachedSize += thisSize + (long)(8 * resultSet.length);
        if (this.resultSetTypes == null) {
            this.getResultSetTypes(resultSet);
        }
        Object[] copy = (Object[])resultSet.clone();
        block10: for (int i = 0; i < resultSet.length; ++i) {
            switch (this.resultSetTypes[i]) {
                case 1: {
                    copy[i] = ((byte[])resultSet[i]).clone();
                    continue block10;
                }
                case 2: {
                    copy[i] = ((char[])resultSet[i]).clone();
                    continue block10;
                }
                case 3: {
                    copy[i] = ((short[])resultSet[i]).clone();
                    continue block10;
                }
                case 4: {
                    copy[i] = ((int[])resultSet[i]).clone();
                    continue block10;
                }
                case 5: {
                    copy[i] = ((long[])resultSet[i]).clone();
                    continue block10;
                }
                case 6: {
                    copy[i] = ((float[])resultSet[i]).clone();
                    continue block10;
                }
                case 7: {
                    copy[i] = ((double[])resultSet[i]).clone();
                    continue block10;
                }
                case 8: {
                    copy[i] = ((boolean[])resultSet[i]).clone();
                    continue block10;
                }
                default: {
                    copy[i] = ((Object[])resultSet[i]).clone();
                    System.arraycopy(resultSet[i], 0, copy[i], 0, 1);
                }
            }
        }
        CachedIFieldGetter cValue = new CachedIFieldGetter(copy);
        cValue.setTimeZone(this.mTimeZone);
        this.items.addElement(cValue);
    }

    public void setTimestamp() {
        this.timestamp = System.currentTimeMillis();
        this.setTimeCreated(new Date());
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Enumeration getIterator() {
        return this.items.elements();
    }

    protected void incHits() {
        ++this.hits;
    }

    public int getHitCount() {
        return this.hits;
    }

    protected int getCantItems() {
        return this.items.size();
    }

    public long getSize() {
        return this.cachedSize;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public void setTimeCreated(Date timeCreated) {
        this.timeCreated = timeCreated;
    }
}

