/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db;

import com.genexus.Application;
import com.genexus.ApplicationContext;
import com.genexus.db.DBConnectionManager;
import com.genexus.db.LocalUserInformation;
import com.genexus.db.ServerUserInformation;
import com.genexus.db.UserInformation;
import com.genexus.db.driver.DataSource;
import com.genexus.util.ReorgSubmitThreadPool;
import java.sql.SQLException;

public class DBConnection {
    protected DataSource dataSource;
    private int handle;
    private String errMsg = "";
    private int errCode = 0;
    private short showPrompt = (short)3;

    public static DBConnection getDataStore(String dataSourceName, int handle) {
        return new DBConnection(DBConnectionManager.getInstance().getDataSource(handle, dataSourceName), handle);
    }

    public DBConnection() {
        this.errMsg = "Invalid DBConnection instance";
        this.errCode = 1;
    }

    public DBConnection(DataSource dataSource, int handle) {
        if (dataSource == null) {
            this.errMsg = "Invalid DBConnection instance";
            this.errCode = 1;
        } else {
            this.dataSource = dataSource;
            this.handle = handle;
        }
    }

    public String getJdbcdrivername() {
        this.clearErr();
        return this.dataSource.jdbcDriver;
    }

    public String getSchema() {
        return this.dataSource.schema;
    }

    public String getDatabasename() {
        return this.dataSource.jdbcDBName;
    }

    public void setDatabasename(String dbName) {
        String url = this.getJdbcdriverurl();
        if (url != null) {
            int index = 0;
            index = this.dataSource.dbms.getId() == 4 && this.getDatabasename().equals("") ? url.lastIndexOf(":") : url.lastIndexOf(this.dataSource.jdbcDBName);
            if (index >= 0) {
                url = this.dataSource.dbms.getId() == 4 && dbName.equals("") ? url.substring(0, index - 1) + url.substring(index + this.dataSource.jdbcDBName.length()) : (this.dataSource.dbms.getId() == 4 && this.getDatabasename().equals("") ? url.substring(0, index) + "/" + dbName + url.substring(index + this.dataSource.jdbcDBName.length()) : url.substring(0, index) + dbName + url.substring(index + this.dataSource.jdbcDBName.length()));
                this.setJdbcdriverurl(url);
            }
        }
        this.dataSource.jdbcDBName = dbName;
        this.dataSource.dbms.setDatabaseName(dbName);
    }

    public void setJdbcdrivername(String driverName) {
        this.dataSource.jdbcDriver = driverName;
    }

    public String getJdbcdriverurl() {
        this.clearErr();
        return this.dataSource.jdbcUrl;
    }

    public void setJdbcdriverurl(String url) {
        this.dataSource.jdbcUrl = url;
    }

    public boolean getUseexternaldatasource() {
        return this.dataSource.usesJdbcDataSource();
    }

    public void setUseexternaldatasource(int value) {
        this.dataSource.useJdbcDataSource = value == 1;
    }

    public String getExternaldatasourcename() {
        return this.dataSource.jdbcDataSource;
    }

    public void setExternaldatasourcename(String value) {
        this.dataSource.jdbcDataSource = value;
    }

    public String getDatastorename() {
        this.clearErr();
        return this.dataSource.name;
    }

    private void clearErr() {
        this.errMsg = "";
        this.errCode = 0;
    }

    public void setUserName(String userName) {
        this.clearErr();
        this.dataSource.defaultUser = userName;
    }

    public String getUserName() {
        this.clearErr();
        return this.dataSource.defaultUser;
    }

    public void setUserpassword(String userPassword) {
        this.clearErr();
        this.dataSource.defaultPassword = userPassword;
    }

    public String getUserpassword() {
        this.clearErr();
        return this.dataSource.defaultPassword;
    }

    public void setShowprompt(short showPrompt) {
        this.clearErr();
        this.showPrompt = showPrompt;
        this.dataSource.loginInServer = showPrompt == 2;
    }

    public short getShowprompt() {
        return this.showPrompt;
    }

    public String getErrDescription() {
        return this.errMsg;
    }

    public short getErrCode() {
        return (short)this.errCode;
    }

    public short disconnect() {
        this.clearErr();
        try {
            DBConnectionManager.getInstance().getUserInformation(this.handle).disconnect();
        }
        catch (SQLException e) {
            this.errMsg = e.getMessage();
            this.errCode = e.getErrorCode();
        }
        return (short)this.errCode;
    }

    public short connectDontShowErrors() {
        Application.setShowConnectError(false);
        short errCode = this.connect();
        Application.setShowConnectError(true);
        return errCode;
    }

    public short connect() {
        if (ReorgSubmitThreadPool.hasAnyError()) {
            this.errCode = 3;
            return (short)this.errCode;
        }
        this.clearErr();
        try {
            UserInformation info = DBConnectionManager.getInstance().getUserInformation(this.handle);
            if (info instanceof LocalUserInformation || info instanceof ServerUserInformation && ApplicationContext.getInstance().getReorganization()) {
                info.createConnectionBatch(null, this);
            } else {
                info.testConnectionBatch(null, this.handle, this);
            }
        }
        catch (SQLException e) {
            this.errMsg = e.getMessage() + " - code:" + e.getErrorCode();
            this.errCode = 3;
        }
        catch (RuntimeException e) {
            this.errMsg = e.getMessage();
            this.errCode = 3;
        }
        if (this.errCode != 0 && Application.getShowConnectError() && ApplicationContext.getInstance().getReorganization()) {
            ReorgSubmitThreadPool.setAnError();
        }
        return (short)this.errCode;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setConnectiondata(String asLibName) {
        this.clearErr();
        this.dataSource.jdbcDBName = asLibName;
        this.dataSource.dbms.setDatabaseName(asLibName);
    }

    public String getConnectiondata() {
        return this.dataSource.jdbcDBName;
    }

    public void setConnectionmethod(short method) {
    }

    public short getConnectionmethod() {
        return 0;
    }

    public void setOdbcdatasourcename(String ds) {
    }

    public String getOdbcdatasourcename() {
        return "";
    }

    public void setOdbcdrivername(String dn) {
    }

    public String getOdbcdrivername() {
        return "";
    }

    public void setOdbcfiledatasourcename(String ds) {
    }

    public String getOdbcfiledatasourcename() {
        return "";
    }
}

