/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db;

import com.genexus.Application;
import com.genexus.ApplicationContext;
import com.genexus.ClientContext;
import com.genexus.LocalUtil;
import com.genexus.ModelContext;
import com.genexus.db.LocalDBConnectionManager;
import com.genexus.db.LocalUserInformation;
import com.genexus.db.Namespace;
import com.genexus.db.ServerDBConnectionManager;
import com.genexus.db.ServerUserInformation;
import com.genexus.db.UserInformation;
import com.genexus.db.UtilConnectionManager;
import com.genexus.db.driver.DataSource;
import com.genexus.db.driver.GXConnection;
import com.genexus.diagnostics.core.ILogger;
import com.genexus.diagnostics.core.LogManager;
import com.genexus.management.LocalUserInformationJMX;
import com.genexus.management.ServerUserInformationJMX;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class DBConnectionManager {
    public static final ILogger logger = LogManager.getLogger(DBConnectionManager.class);
    private static volatile DBConnectionManager connectionManager;
    protected ConcurrentHashMap<Integer, UserInformation> userConnections = new ConcurrentHashMap();
    private static AtomicInteger mLastHandle;
    private Object handleLock = new Object();
    private static Object staticHandleLock;
    private static boolean finishCreateDataBase;

    public abstract GXConnection getConnection(ModelContext var1, int var2, String var3, boolean var4, boolean var5) throws SQLException;

    public abstract void dropAllCursors(int var1);

    public abstract boolean isConnected(int var1, String var2);

    protected abstract UserInformation getNewUserInformation(Namespace var1);

    DBConnectionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBConnectionManager getInstance() {
        DBConnectionManager manager = connectionManager;
        if (manager == null) {
            Object object = staticHandleLock;
            synchronized (object) {
                manager = connectionManager == null ? (ApplicationContext.getInstance().isGXUtility() ? (connectionManager = new UtilConnectionManager()) : (ApplicationContext.getInstance().getPoolConnections() || ApplicationContext.getInstance().getReorganization() ? (connectionManager = new ServerDBConnectionManager()) : (connectionManager = new LocalDBConnectionManager()))) : connectionManager;
            }
        }
        return manager;
    }

    public static void StartCreateDataBase() {
    }

    public static void EndCreateDataBase() {
        finishCreateDataBase = true;
    }

    public static void endDBConnectionManager() {
        connectionManager = null;
    }

    public Enumeration<UserInformation> getServerConnections() {
        return this.userConnections.elements();
    }

    public static DBConnectionManager getInstance(ModelContext context) {
        return DBConnectionManager.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserInformation createUserInformation(Namespace namespace) {
        UserInformation userInfo = this.getNewUserInformation(namespace);
        int handle = this.createNewHandle();
        Object object = this.handleLock;
        synchronized (object) {
            userInfo.setHandle(handle);
            this.userConnections.put(new Integer(handle), userInfo);
            ClientContext.setLocalUtil((LocalUtil)userInfo.getLocalUtil());
            if (ClientContext.getHandle() == -1) {
                ClientContext.setHandle((int)handle);
            }
        }
        this.connectJMX(userInfo);
        if (Namespace.getConnectAtStartup()) {
            Namespace.connectAll(userInfo.getHandle());
        }
        return userInfo;
    }

    private void connectJMX(UserInformation userInfo) {
        if (Application.isJMXEnabled()) {
            if (userInfo instanceof ServerUserInformation) {
                ((ServerUserInformation)userInfo).setIP(ModelContext.getModelContext().getWorkstationId(userInfo.getHandle()));
                ServerUserInformationJMX.CreateServerUserInformationJMX((ServerUserInformation)userInfo, ModelContext.getModelContext());
            } else if (userInfo instanceof LocalUserInformation) {
                LocalUserInformationJMX.CreateLocalUserInformationJMX((LocalUserInformation)userInfo);
            }
        }
    }

    public String getUserName(ModelContext context, int handle, String dataSource) throws SQLException {
        return this.getConnection(context, handle, dataSource, true, false).getUserName();
    }

    public Date getServerDateTime(ModelContext context, int handle, String dataSource) throws SQLException {
        return this.getConnection(context, handle, dataSource, true, false).getDateTime();
    }

    public String getDBMSVersion(ModelContext context, int handle, String dataSource) throws SQLException {
        return this.getConnection(context, handle, dataSource, true, false).getDBMSVersion();
    }

    public String getDatabaseName(ModelContext context, int handle, String dataSource) throws SQLException {
        return this.getConnection(context, handle, dataSource, true, false).getDatabaseName();
    }

    public void commit(ModelContext context, int handle, String dataSource) throws SQLException {
        if (this.isConnected(handle, dataSource)) {
            this.getConnection(context, handle, dataSource, false, true).commit();
        }
    }

    public void rollback(ModelContext context, int handle, String dataSource) throws SQLException {
        if (this.isConnected(handle, dataSource)) {
            this.getConnection(context, handle, dataSource, false, true).rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeStatement(ModelContext context, int handle, String dataSource, String sqlSentence) throws SQLException {
        GXConnection con = this.getConnection(context, handle, dataSource, false, true);
        Object object = staticHandleLock;
        synchronized (object) {
            if (finishCreateDataBase) {
                finishCreateDataBase = false;
                con.disconnect();
                con = this.getConnection(context, handle, dataSource, false, true);
            }
        }
        con.setUncommitedChanges();
        con.getPoolState().setInAssignment(false);
        Statement stmt = con.createStatement();
        if (ApplicationContext.getInstance().getReorganization() && con.getDataSource().dbms.getSupportsAutocommit() && !con.getAutoCommit()) {
            con.setAutoCommit(true);
        }
        try {
            stmt.executeUpdate(sqlSentence);
        }
        catch (SQLException e) {
            try {
                stmt.close();
            }
            catch (SQLException e1) {
                logger.fatal("Could not complete SQL Statement", (Throwable)e1);
            }
            throw e;
        }
        stmt.close();
    }

    public UserInformation getUserInformation(int handle) {
        UserInformation ui = this.userConnections.get(new Integer(handle));
        if (ui == null) {
            throw new IllegalArgumentException("Can't find user information for handle " + handle);
        }
        return ui;
    }

    public UserInformation getUserInformationNoException(int handle) {
        return this.userConnections.get(new Integer(handle));
    }

    public void disconnectOnException(int handle) throws SQLException, NullPointerException {
        UserInformation ui = this.getUserInformation(handle);
        if (ui != null) {
            ui.disconnectOnException();
        }
        this.removeHandle(handle);
        this.unsuscribeJMX(ui);
    }

    private void unsuscribeJMX(UserInformation ui) {
        if (Application.isJMXEnabled()) {
            if (ui instanceof ServerUserInformation) {
                ServerUserInformationJMX.DestroyServerUserInformationJMX((ServerUserInformation)ui);
            } else if (ui instanceof LocalUserInformation) {
                LocalUserInformationJMX.DestroyLocalUserInformationJMX((LocalUserInformation)ui);
            }
        }
    }

    public void flushBuffers(int handle, Object o) throws SQLException, NullPointerException {
        UserInformation ui = this.getUserInformation(handle);
        if (ui != null) {
            ui.flushBuffers(o);
        }
    }

    public void disconnect(int handle) throws SQLException, NullPointerException {
        UserInformation ui = this.getUserInformation(handle);
        try {
            if (ui != null) {
                ui.disconnect();
            }
        }
        finally {
            this.removeHandle(handle);
            this.unsuscribeJMX(ui);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeHandle(int handle) {
        Object object = this.handleLock;
        synchronized (object) {
            this.userConnections.remove(new Integer(handle));
        }
    }

    protected int createNewHandle() {
        return mLastHandle.incrementAndGet();
    }

    public int getFirstHandle() {
        Enumeration<Integer> en = this.userConnections.keys();
        if (en.hasMoreElements()) {
            return en.nextElement();
        }
        throw new InternalError("There arent any registered handles");
    }

    public int getClientHandle(int remoteHandle) {
        Enumeration<UserInformation> en = this.userConnections.elements();
        while (en.hasMoreElements()) {
            UserInformation ui = en.nextElement();
            if (!ui.hasRemoteHandle(remoteHandle)) continue;
            return ui.getHandle();
        }
        throw new InternalError("Can't find client handle for remote handle " + remoteHandle);
    }

    public DataSource getDataSource(int handle, String dataSourceName) {
        return this.getUserInformation(handle).getNamespace().getDataSource(dataSourceName);
    }

    public DataSource getDataSourceNoException(int handle, String dataSourceName) {
        UserInformation ui = this.getUserInformationNoException(handle);
        if (ui != null) {
            return ui.getNamespace().getDataSource(dataSourceName);
        }
        return null;
    }

    public void disconnectAll() {
        Vector<Integer> handles = new Vector<Integer>();
        Enumeration<Integer> enum1 = this.userConnections.keys();
        while (enum1.hasMoreElements()) {
            handles.addElement(enum1.nextElement());
        }
        enum1 = handles.elements();
        while (enum1.hasMoreElements()) {
            try {
                this.disconnect(enum1.nextElement());
            }
            catch (Throwable e) {
                logger.warn("DBConnectionManager.disconnectAll: ", e);
            }
        }
    }

    static {
        mLastHandle = new AtomicInteger(0);
        staticHandleLock = new Object();
        finishCreateDataBase = false;
    }
}

