/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db;

import com.genexus.Application;
import com.genexus.ApplicationContext;
import com.genexus.CacheFactory;
import com.genexus.CommonUtil;
import com.genexus.GXReorganization;
import com.genexus.GXutil;
import com.genexus.ModelContext;
import com.genexus.common.classes.AbstractDataSource;
import com.genexus.common.classes.AbstractDataStoreProviderBase;
import com.genexus.db.BatchUpdateCursor;
import com.genexus.db.BufferIFieldGetter;
import com.genexus.db.CallCursor;
import com.genexus.db.Cursor;
import com.genexus.db.DBConnectionManager;
import com.genexus.db.DataStoreProviderBase;
import com.genexus.db.DefaultExceptionErrorHandler;
import com.genexus.db.DirectStatement;
import com.genexus.db.ForEachCursor;
import com.genexus.db.IDataStoreHelper;
import com.genexus.db.IDataStoreProvider;
import com.genexus.db.IFieldGetter;
import com.genexus.db.IFieldSetter;
import com.genexus.db.IForEachCursor;
import com.genexus.db.ILocalDataStoreHelper;
import com.genexus.db.SentenceProvider;
import com.genexus.db.UpdateCursor;
import com.genexus.db.driver.DataSource;
import com.genexus.db.driver.GXCallableStatement;
import com.genexus.db.driver.GXConnection;
import com.genexus.db.driver.GXResultSet;
import com.genexus.performance.DataStoreProviderInfo;
import com.genexus.performance.DataStoreProviderJMX;
import com.genexus.performance.DataStoreProvidersJMX;
import com.genexus.performance.SentenceInfo;
import com.genexus.xml.XMLWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class DataStoreProvider
extends DataStoreProviderBase
implements IDataStoreProvider {
    protected ILocalDataStoreHelper helper;
    private static AtomicLong sentenceCount = new AtomicLong(0L);
    private static AtomicLong sentenceSelectCount = new AtomicLong(0L);
    private static AtomicLong sentenceUpdateCount = new AtomicLong(0L);
    private static AtomicLong sentenceDeleteCount = new AtomicLong(0L);
    private static AtomicLong sentenceInsertCount = new AtomicLong(0L);
    private static AtomicLong sentenceCallCount = new AtomicLong(0L);
    private static AtomicLong sentenceDirectSQLCount = new AtomicLong(0L);
    private static ConcurrentHashMap<String, DataStoreProviderInfo> dataStoreProviders = new ConcurrentHashMap();
    private static AtomicBoolean firstTime = new AtomicBoolean(true);
    static Object lock = new Object();

    public DataStoreProvider(ModelContext context, int remoteHandle) {
        super(context, remoteHandle);
    }

    public DataStoreProvider(ModelContext context, int remoteHandle, ILocalDataStoreHelper helper, Object[] buffers) {
        super(context, remoteHandle);
        if (Application.isJMXEnabled() && firstTime.get()) {
            DataStoreProvidersJMX.CreateDataStoreProvidersJMX();
            firstTime.set(false);
        }
        this.helper = helper;
        this.cursors = helper.getCursors();
        this.setOutputBuffers(buffers);
        DataStoreProvider.addDataStoreProviderInfo(helper.getClass().getName());
    }

    public void setErrorBuffers(int cursorIdx, Object[] buffers) {
        ((BatchUpdateCursor)this.cursors[cursorIdx]).errorRecords = buffers;
    }

    private void setOutputBuffers(Object[] buffers) {
        for (int i = 0; i < this.cursors.length; ++i) {
            if (this.cursors[i] instanceof IForEachCursor) {
                ((IForEachCursor)this.cursors[i]).setOutputBuffers((Object[])buffers[i]);
                continue;
            }
            if (!(this.cursors[i] instanceof CallCursor)) continue;
            ((CallCursor)this.cursors[i]).setOutputBuffers((Object[])buffers[i]);
        }
    }

    public int getStatus(int cursorIdx) {
        Cursor cursor = this.cursors[cursorIdx];
        if (ApplicationContext.getInstance().getReorganization() && cursor instanceof ForEachCursor && GXReorganization.executedBefore(cursor.mCursorId)) {
            return 101;
        }
        return cursor.status;
    }

    public void addRecord(int cursorIdx, Object[] parms) {
        BatchUpdateCursor cursor = (BatchUpdateCursor)this.cursors[cursorIdx];
        if (parms != null && (this.cacheIterator == null || this.cacheIterator[cursorIdx] == null)) {
            do {
                this.context.globals.Gx_eop = (byte)3;
                try {
                    this.helper.setParameters(cursorIdx, (IFieldSetter)cursor.mPreparedStatement, parms);
                }
                catch (SQLException e) {
                    DefaultExceptionErrorHandler.handleSQLError(this.errorHandler, e, this.context, this.remoteHandle, (IDataStoreHelper)this.helper, this.cursors[cursorIdx]);
                }
            } while (this.context.globals.Gx_eop == 1);
        }
        do {
            this.context.globals.Gx_eop = (byte)3;
            try {
                if (cursor.getBatchSize() <= 0) continue;
                cursor.addBatch(parms);
            }
            catch (SQLException e) {
                DefaultExceptionErrorHandler.handleSQLError(this.errorHandler, e, this.context, this.remoteHandle, (IDataStoreHelper)this.helper, this.cursors[cursorIdx]);
            }
        } while (this.context.globals.Gx_eop == 1);
    }

    public void initializeBatch(int cursorIdx, int batchSize, Object instance, String method) {
        BatchUpdateCursor cursor = (BatchUpdateCursor)this.cursors[cursorIdx];
        if (cursor.getBatchSize() == 0) {
            do {
                this.context.globals.Gx_eop = (byte)3;
                try {
                    cursor.preExecute(cursorIdx, (AbstractDataStoreProviderBase)this, (AbstractDataSource)this.getDataSource(), null);
                }
                catch (SQLException e) {
                    DefaultExceptionErrorHandler.handleSQLError(this.errorHandler, e, this.context, this.remoteHandle, (IDataStoreHelper)this.helper, this.cursors[cursorIdx]);
                }
            } while (this.context.globals.Gx_eop == 1);
            cursor.setBatchSize(batchSize);
            cursor.onCommitEvent(instance, method);
            cursor.notInUse();
            try {
                Application.getConnectionManager(this.context).getConnection(this.context, this.remoteHandle, this.helper.getDataStoreName(), false, true).addBatchUpdate((Cursor)cursor);
            }
            catch (SQLException e) {
                DefaultExceptionErrorHandler.handleSQLError(this.errorHandler, e, this.context, this.remoteHandle, (IDataStoreHelper)this.helper, this.cursors[cursorIdx]);
            }
        }
    }

    public int getBatchSize(int cursorIdx) {
        BatchUpdateCursor cursor = (BatchUpdateCursor)this.cursors[cursorIdx];
        return cursor.getBatchSize();
    }

    public int readNextErrorRecord(int cursorIdx) {
        BatchUpdateCursor cursor = (BatchUpdateCursor)this.cursors[cursorIdx];
        int res = cursor.readNextErrorRecord();
        if (res == 1) {
            do {
                this.context.globals.Gx_eop = (byte)3;
                try {
                    this.helper.getErrorResults(cursorIdx, (IFieldGetter)new BufferIFieldGetter((Object[])cursor.getBlockRecords()[cursor.errorRecordIndex]), cursor.errorRecords);
                }
                catch (SQLException e) {
                    DefaultExceptionErrorHandler.handleSQLError(this.errorHandler, e, this.context, this.remoteHandle, (IDataStoreHelper)this.helper, this.cursors[cursorIdx]);
                }
            } while (this.context.globals.Gx_eop == 1);
        }
        return res;
    }

    public int recordCount(int cursorIdx) {
        BatchUpdateCursor cursor = (BatchUpdateCursor)this.cursors[cursorIdx];
        return cursor.getRecordCount();
    }

    public void execute(int cursorIdx) {
        this.execute(cursorIdx, null);
    }

    public void executeBatch(int cursorIdx) {
        this.execute(cursorIdx, null, false);
    }

    public synchronized void execute(int cursorIdx, Object[] parms) {
        this.execute(cursorIdx, parms, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(int cursorIdx, Object[] parms, boolean preExecute) {
        boolean retryExecute;
        int maxRetryCount;
        Cursor cursor = this.cursors[cursorIdx];
        byte[] hasValues = null;
        if (ApplicationContext.getInstance().getReorganization() && (cursor instanceof ForEachCursor || cursor instanceof UpdateCursor) && GXReorganization.executedBefore(cursor.mCursorId)) {
            return;
        }
        if (Application.isJMXEnabled()) {
            this.beginExecute = new Date();
            this.incSentencesCount(this.helper.getClass().getName(), cursor);
        }
        int retryCount = 0;
        DataSource ds = this.getDataSourceNoException();
        int n = maxRetryCount = ds == null ? 1 : ds.lockRetryCount;
        if (preExecute) {
            do {
                this.context.globals.Gx_eop = (byte)3;
                try {
                    hasValues = cursor.preExecute(cursorIdx, (AbstractDataStoreProviderBase)this, (AbstractDataSource)this.getDataSource(), parms);
                }
                catch (SQLException e) {
                    DefaultExceptionErrorHandler.handleSQLError(this.errorHandler, e, this.context, this.remoteHandle, (IDataStoreHelper)this.helper, this.cursors[cursorIdx]);
                }
                ++retryCount;
            } while (this.context.globals.Gx_eop == 1);
        }
        if (Application.isJMXEnabled()) {
            this.beginExecute();
        }
        if (this.context.globals.Gx_eop == 0) {
            this.dynConstraints = null;
            return;
        }
        int retries = 0;
        do {
            retryExecute = false;
            if (parms != null && (this.cacheIterator == null || this.cacheIterator[cursorIdx] == null)) {
                retryCount = 0;
                do {
                    this.setParameters(cursorIdx, parms, cursor, hasValues);
                    ++retryCount;
                } while (this.context.globals.Gx_eop == 1);
            }
            if (this.context.globals.Gx_eop == 0) {
                this.dynConstraints = null;
                return;
            }
            retryCount = 0;
            do {
                this.context.globals.Gx_eop = (byte)3;
                cursor.status = 0;
                try {
                    this.executeSavePointOperation("SAVEPOINT gxselectforupdate", cursor);
                    cursor.postExecute((AbstractDataStoreProviderBase)this, (AbstractDataSource)this.getDataSource());
                    this.executeSavePointOperation("RELEASE SAVEPOINT gxselectforupdate", cursor);
                }
                catch (SQLException e) {
                    if (this.getDataSource().dbms.connectionClosed(e)) {
                        try {
                            if (!this.getConnection().getUncommitedChanges()) {
                                this.getConnection().setError();
                                this.execute(cursorIdx, parms);
                                return;
                            }
                        }
                        catch (SQLException exc) {
                            DefaultExceptionErrorHandler.handleSQLError(this.errorHandler, exc, this.context, this.remoteHandle, (IDataStoreHelper)this.helper, this.cursors[cursorIdx]);
                        }
                    }
                    if (this.getDataSource().dbms.rePrepareStatement(e)) {
                        try {
                            this.getConnection().rePrepareStatement(cursor);
                            this.execute(cursorIdx, parms);
                            return;
                        }
                        catch (SQLException exc) {
                            DefaultExceptionErrorHandler.handleSQLError(this.errorHandler, exc, this.context, this.remoteHandle, (IDataStoreHelper)this.helper, this.cursors[cursorIdx]);
                        }
                    }
                    if (retries < 2 && cursor instanceof UpdateCursor && ((UpdateCursor)cursor).getRetryExecute()) {
                        retryExecute = true;
                        try {
                            cursor.mPreparedStatement.clearParameters();
                        }
                        catch (SQLException e1) {
                            DefaultExceptionErrorHandler.handleSQLError(this.errorHandler, e1, this.context, this.remoteHandle, (IDataStoreHelper)this.helper, this.cursors[cursorIdx]);
                        }
                    } else {
                        DefaultExceptionErrorHandler.handleSQLError(this.errorHandler, e, this.context, this.remoteHandle, (IDataStoreHelper)this.helper, this.cursors[cursorIdx]);
                    }
                    if (maxRetryCount != 0 && retryCount == maxRetryCount - 1) {
                        cursor.mPreparedStatement.notInUse();
                        this.context.globals.Gx_eop = (byte)2;
                        DefaultExceptionErrorHandler.handleSQLError(this.errorHandler, e, this.context, this.remoteHandle, (IDataStoreHelper)this.helper, this.cursors[cursorIdx]);
                        continue;
                    }
                    if (ds.waitRecord > 0 && this.context.globals.Gx_eop == 1) {
                        try {
                            Thread.sleep(ds.waitRecord * 1000);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    this.executeSavePointOperation("ROLLBACK TO SAVEPOINT gxselectforupdate", cursor);
                }
            } while (this.context.globals.Gx_eop == 1 && (maxRetryCount == 0 || ++retryCount < maxRetryCount));
            ++retries;
        } while (retryExecute);
        if (this.context.globals.Gx_eop == 0) {
            cursor.mPreparedStatement.notInUse();
            this.dynConstraints = null;
            return;
        }
        if (cursor instanceof IForEachCursor) {
            if (cursor.status != 103) {
                this.readNext(cursorIdx);
                if (cursor.status == 101) {
                    ((IForEachCursor)cursor).clearBuffers();
                }
            }
        } else if (cursor instanceof CallCursor) {
            retryCount = 0;
            do {
                this.context.globals.Gx_eop = (byte)3;
                try {
                    this.helper.getResults(cursorIdx, (IFieldGetter)((GXCallableStatement)cursor.mPreparedStatement), ((CallCursor)cursor).buffers);
                }
                catch (SQLException e) {
                    DefaultExceptionErrorHandler.handleSQLError(this.errorHandler, e, this.context, this.remoteHandle, (IDataStoreHelper)this.helper, this.cursors[cursorIdx]);
                }
                finally {
                    ((GXCallableStatement)cursor.mPreparedStatement).setNotInUse();
                }
            } while (this.context.globals.Gx_eop == 1 && (maxRetryCount == 0 || ++retryCount < maxRetryCount));
        }
        this.dynConstraints = null;
        if (Application.isJMXEnabled()) {
            this.endExecute(this.helper.getClass().getName(), cursor);
        }
    }

    private void setParameters(int cursorIdx, Object[] parms, Cursor cursor, byte[] hasValues) {
        this.context.globals.Gx_eop = (byte)3;
        try {
            if (hasValues != null) {
                Object[] parmsNew = new Object[parms.length + hasValues.length];
                for (int i = 0; i < hasValues.length; ++i) {
                    parmsNew[i] = new Byte(hasValues[i]);
                }
                System.arraycopy(parms, 0, parmsNew, hasValues.length, parms.length);
                try {
                    this.helper.setParameters(cursorIdx, (IFieldSetter)cursor.mPreparedStatement, parmsNew);
                }
                catch (Exception e) {
                    System.err.println("Set dynamic parameters warning " + e.getMessage());
                }
            } else {
                this.helper.setParameters(cursorIdx, (IFieldSetter)cursor.mPreparedStatement, parms);
            }
        }
        catch (SQLException e) {
            DefaultExceptionErrorHandler.handleSQLError(this.errorHandler, e, this.context, this.remoteHandle, (IDataStoreHelper)this.helper, this.cursors[cursorIdx]);
        }
    }

    private void executeSavePointOperation(String operation, Cursor cursor) {
        if (this.getDataSource().dbms.getId() == 7 && GXutil.dbmsVersion(this.context, this.remoteHandle, this.getDataSource().name) > 7 && cursor instanceof ForEachCursor && cursor.isCurrentOf()) {
            try {
                SentenceProvider.executeStatement((AbstractDataStoreProviderBase)this, (String)operation);
            }
            catch (Exception ex) {
                System.err.println(operation + " error " + ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readNext(int cursorIdx) {
        IForEachCursor cursor = (IForEachCursor)this.cursors[cursorIdx];
        if (this.cacheIterator != null && this.cacheIterator[cursorIdx] != null) {
            if (!this.cacheIterator[cursorIdx].hasMoreElements()) {
                cursor.setStatus(101);
                return;
            }
            try {
                Object object = lock;
                synchronized (object) {
                    IFieldGetter cacheIter = (IFieldGetter)this.cacheIterator[cursorIdx].nextElement();
                    cacheIter.resetWasNullHits();
                    this.helper.getResults(cursorIdx, cacheIter, cursor.getBuffers());
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return;
        }
        int retryCount = 0;
        DataSource ds = this.getDataSourceNoException();
        int maxRetryCount = ds == null ? 1 : ds.lockRetryCount;
        do {
            this.context.globals.Gx_eop = (byte)3;
            try {
                GXResultSet result = null;
                if (cursor.hasResult()) {
                    result = (GXResultSet)cursor.getResultSet();
                }
                if (result != null && cursor.next((AbstractDataSource)this.dataSource)) {
                    if (cursor.getStatus() != 0) continue;
                    this.helper.getResults(cursorIdx, (IFieldGetter)result, cursor.getBuffers());
                    if (this.cacheValue == null || this.cacheValue[cursorIdx] == null) continue;
                    TimeZone cachedValueTimeZone = this.context.getClientTimeZone();
                    if (cachedValueTimeZone != null) {
                        this.cacheValue[cursorIdx].setTimeZone(cachedValueTimeZone);
                    }
                    this.cacheValue[cursorIdx].addItem(cursor.getBuffers(), result.getResultRegBytes());
                    continue;
                }
                cursor.setStatus(101);
                if (this.cacheValue == null || this.cacheValue[cursorIdx] == null) continue;
                CacheFactory.getInstance().set(CacheFactory.CACHE_DB, this.cacheValue[cursorIdx].getKey().toString(), (Object)this.cacheValue[cursorIdx]);
            }
            catch (SQLException e) {
                DefaultExceptionErrorHandler.handleSQLError(this.errorHandler, e, this.context, this.remoteHandle, (IDataStoreHelper)this.helper, this.cursors[cursorIdx]);
                if (this.context.globals.Gx_eop == 1) continue;
                cursor.setStatus(101);
            }
        } while (this.context.globals.Gx_eop == 1 && (maxRetryCount == 0 || ++retryCount < maxRetryCount));
    }

    public void close(int cursorIdx) {
        int maxRetryCount;
        Cursor cursor = this.cursors[cursorIdx];
        if (ApplicationContext.getInstance().getReorganization() && cursor instanceof ForEachCursor && GXReorganization.executedBefore(cursor.mCursorId)) {
            return;
        }
        int retryCount = 0;
        DataSource ds = this.getDataSourceNoException();
        int n = maxRetryCount = ds == null ? 1 : ds.lockRetryCount;
        do {
            if (!this.context.inErrorHandler) {
                this.context.globals.Gx_eop = (byte)3;
            }
            try {
                cursor.close();
                if (!cursor.isForFirst() || cursor.status == 101 || this.cacheValue == null || this.cacheValue[cursorIdx] == null) continue;
                CacheFactory.getInstance().set(CacheFactory.CACHE_DB, this.cacheValue[cursorIdx].getKey().toString(), (Object)this.cacheValue[cursorIdx], this.cacheValue[cursorIdx].getExpiryTimeSeconds());
                this.cacheValue[cursorIdx] = null;
            }
            catch (SQLException e) {
                DefaultExceptionErrorHandler.handleSQLError(this.errorHandler, e, this.context, this.remoteHandle, (IDataStoreHelper)this.helper, this.cursors[cursorIdx]);
            }
        } while (this.context.globals.Gx_eop == 1 && (maxRetryCount == 0 || retryCount < maxRetryCount));
        if (ApplicationContext.getInstance().getReorganization() && cursor instanceof ForEachCursor) {
            GXReorganization.addExecutedStatement(cursor.mCursorId);
        }
    }

    public void rollback(String dataSourceName) {
        if (Application.getConnectionManager(this.context).isConnected(this.remoteHandle, dataSourceName)) {
            do {
                this.context.globals.Gx_eop = (byte)3;
                try {
                    try {
                        DBConnectionManager connection = Application.getConnectionManager(this.context);
                        if (connection == null) continue;
                        connection.rollback(this.context, this.remoteHandle, dataSourceName);
                    }
                    catch (RuntimeException ex) {
                        System.err.println("rollback: " + ex.getMessage());
                    }
                }
                catch (SQLException e) {
                    ForEachCursor dummyCursor = new ForEachCursor("rollback", "rollback", false, 16, false, this.getHelper(), 1, 0, true);
                    dummyCursor.status = 999;
                    DefaultExceptionErrorHandler.handleSQLError(this.errorHandler, e, this.context, this.remoteHandle, (IDataStoreHelper)this.helper, dummyCursor);
                }
            } while (this.context.globals.Gx_eop == 1);
        }
    }

    public void commit(String dataSourceName) {
        if (Application.getConnectionManager(this.context).isConnected(this.remoteHandle, dataSourceName)) {
            do {
                this.context.globals.Gx_eop = (byte)3;
                try {
                    try {
                        GXConnection connection = this.getConnection(dataSourceName, false);
                        if (connection == null) continue;
                        connection.commit();
                    }
                    catch (RuntimeException ex) {
                        System.err.println("commit: " + ex.getMessage());
                    }
                }
                catch (SQLException e) {
                    ForEachCursor dummyCursor = new ForEachCursor("commit", "commit", false, 16, false, this.getHelper(), 1, 0, true);
                    dummyCursor.status = 999;
                    DefaultExceptionErrorHandler.handleSQLError(this.errorHandler, e, this.context, this.remoteHandle, (IDataStoreHelper)this.helper, dummyCursor);
                }
            } while (this.context.globals.Gx_eop == 1);
        }
    }

    public String userId() {
        this.context.globals.Gx_eop = (byte)3;
        try {
            return this.getConnection().getUserName();
        }
        catch (SQLException e) {
            ForEachCursor dummyCursor = new ForEachCursor("userId", "userId", false, 16, false, this.getHelper(), 1, 0, true);
            dummyCursor.status = 999;
            DefaultExceptionErrorHandler.handleSQLError(this.errorHandler, e, this.context, this.remoteHandle, (IDataStoreHelper)this.helper, dummyCursor);
            return "";
        }
    }

    public Date serverNow() {
        this.context.globals.Gx_eop = (byte)3;
        try {
            return this.getConnection().getDateTime();
        }
        catch (SQLException e) {
            ForEachCursor dummyCursor = new ForEachCursor("serverNow", "serverNow", false, 16, false, this.getHelper(), 1, 0, true);
            dummyCursor.status = 999;
            DefaultExceptionErrorHandler.handleSQLError(this.errorHandler, e, this.context, this.remoteHandle, (IDataStoreHelper)this.helper, dummyCursor);
            return CommonUtil.nullDate();
        }
    }

    public IDataStoreHelper getHelper() {
        return this.helper;
    }

    public void release() {
    }

    public static void addDataStoreProviderInfo(String key) {
        DataStoreProviderInfo dsInfo = new DataStoreProviderInfo(key);
        DataStoreProviderInfo dsInfoPrev = dataStoreProviders.putIfAbsent(key, dsInfo);
        if (dsInfoPrev == null && Application.isJMXEnabled()) {
            DataStoreProviderJMX.CreateDataStoreProviderJMX(key);
        }
    }

    public static DataStoreProviderInfo getDataStoreProviderInfo(String key) {
        return dataStoreProviders.get(key);
    }

    void beginExecute() {
        if (this.con != null) {
            this.con.setLastObjectExecuted(this.getHelper().getClass().getName());
            this.con.setFinishExecute(false);
        }
        DBConnectionManager.getInstance().getUserInformation(this.remoteHandle).setLastObjectExecuted(this.getHelper().getClass().getName());
    }

    void incSentencesCount(String key, Cursor cursor) {
        DataStoreProviderInfo dsInfo = DataStoreProvider.getDataStoreProviderInfo(key);
        dsInfo.incSentenceCount();
        SentenceInfo sInfo = cursor.dynStatement ? dsInfo.addSentenceInfo(key + "_" + cursor.mCursorId, key + "_" + cursor.mCursorId + "_" + cursor.mSQLSentence) : dsInfo.addSentenceInfo(key + "_" + cursor.mCursorId, cursor.mSQLSentence);
        sInfo.incSentenceCount();
        String sqlSnt = cursor.mSQLSentence;
        sentenceCount.incrementAndGet();
        if (cursor instanceof DirectStatement) {
            sentenceDirectSQLCount.incrementAndGet();
            dsInfo.incSentenceDirectSQLCount();
        } else if (cursor instanceof CallCursor) {
            sentenceCallCount.incrementAndGet();
            dsInfo.incSentenceCallCount();
        } else if (cursor.dynStatement || sqlSnt.toUpperCase().startsWith("SELECT")) {
            sentenceSelectCount.incrementAndGet();
            dsInfo.incSentenceSelectCount();
        } else if (sqlSnt.toUpperCase().startsWith("UPDATE")) {
            sentenceUpdateCount.incrementAndGet();
            dsInfo.incSentenceUpdateCount();
        } else if (sqlSnt.toUpperCase().startsWith("DELETE")) {
            sentenceDeleteCount.incrementAndGet();
            dsInfo.incSentenceDeleteCount();
        } else if (sqlSnt.toUpperCase().startsWith("INSERT")) {
            sentenceInsertCount.incrementAndGet();
            dsInfo.incSentenceInsertCount();
        }
    }

    protected void endExecute(String key, Cursor cursor) {
        if (this.con != null) {
            this.con.setFinishExecute(true);
        }
        DataStoreProviderInfo dsInfo = DataStoreProvider.getDataStoreProviderInfo(key);
        SentenceInfo sInfo = dsInfo.getSentenceInfo(key + "_" + cursor.mCursorId);
        sInfo.setTimeExecute(System.currentTimeMillis() - this.beginExecute.getTime());
    }

    public static long getSentenceCount() {
        return sentenceCount.get();
    }

    public static long getSentenceSelectCount() {
        return sentenceSelectCount.get();
    }

    public static long getSentenceUpdateCount() {
        return sentenceUpdateCount.get();
    }

    public static long getSentenceDeleteCount() {
        return sentenceDeleteCount.get();
    }

    public static long getSentenceInsertCount() {
        return sentenceInsertCount.get();
    }

    public static long getSentenceCallCount() {
        return sentenceCallCount.get();
    }

    public static long getSentenceDirectSQLCount() {
        return sentenceDirectSQLCount.get();
    }

    public static void dumpTxt() {
        try {
            PrintStream out = new PrintStream(new FileOutputStream("DataStoreProviders_" + CommonUtil.getYYYYMMDDHHMMSS_nosep((Date)new Date()) + ".log", true));
            out.println("DataStoreProviders Information");
            out.println("");
            out.println("Number of sentences : " + sentenceCount.get());
            out.println("Number of select sentences : " + sentenceSelectCount.get());
            out.println("Number of update sentences : " + sentenceUpdateCount.get());
            out.println("Number of delete sentences : " + sentenceDeleteCount.get());
            out.println("Number of insert sentences : " + sentenceInsertCount.get());
            out.println("Number of CALL sentences : " + sentenceCallCount.get());
            out.println("Number of direct SQL sentences : " + sentenceDirectSQLCount.get());
            out.println("");
            out.println("");
            Enumeration<DataStoreProviderInfo> en = dataStoreProviders.elements();
            while (en.hasMoreElements()) {
                DataStoreProviderInfo dsInfo = en.nextElement();
                dsInfo.dump(out);
                out.println("");
                out.println("");
            }
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void dump() {
        String fileName = "DataStoreProviders_" + CommonUtil.getYYYYMMDDHHMMSS_nosep((Date)new Date()) + ".xml";
        XMLWriter writer = new XMLWriter();
        writer.xmlStart(fileName);
        writer.writeStartElement("DataStoreProviders_Information");
        writer.writeElement("Total_SQLStatementCount", sentenceCount.get());
        writer.writeElement("Select_SQLStatementCount", sentenceSelectCount.get());
        writer.writeElement("Update_SQLStatementCount", sentenceUpdateCount.get());
        writer.writeElement("Delete_SQLStatementCount", sentenceDeleteCount.get());
        writer.writeElement("Insert_SQLStatementCount", sentenceInsertCount.get());
        writer.writeElement("StoredProcedureCount", sentenceCallCount.get());
        writer.writeElement("SQLCommandCount", sentenceDirectSQLCount.get());
        Enumeration<DataStoreProviderInfo> en = dataStoreProviders.elements();
        while (en.hasMoreElements()) {
            DataStoreProviderInfo dsInfo = en.nextElement();
            dsInfo.dump(writer);
        }
        writer.writeEndElement();
        writer.close();
    }
}

