/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db;

import com.genexus.Application;
import com.genexus.GXRuntimeException;
import com.genexus.IErrorHandler;
import com.genexus.ModelContext;
import com.genexus.common.classes.AbstractGXConnection;
import com.genexus.db.Cursor;
import com.genexus.db.DBConnectionManager;
import com.genexus.db.IDataStoreHelper;
import com.genexus.db.driver.GXDBMS;
import com.genexus.util.ReorgSubmitThreadPool;
import java.sql.SQLException;

public class DefaultExceptionErrorHandler {
    static final int FETCH = 1;
    static final int EXECUTE = 2;
    static final int CLOSE = 3;
    static final int ERROPT_IGNORE = 0;
    static final int ERROPT_RETRY = 1;
    static final int ERROPT_CANCEL = 2;
    static final int ERROPT_DEFAULT = 3;

    public static void handleSQLError(IErrorHandler errorHandler, SQLException e, ModelContext context, int remoteHandle, IDataStoreHelper helper, Cursor cursor) {
        try {
            AbstractGXConnection conn = helper.getConnectionProvider().getConnection(context, remoteHandle, helper.getDataStoreName(), true, true);
            DefaultExceptionErrorHandler.handleSQLError1(errorHandler, e, context, remoteHandle, conn, helper.getDataStoreName(), cursor);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleSQLError1(IErrorHandler errorHandler, SQLException e, ModelContext context, int remoteHandle, AbstractGXConnection conn, String datastoreName, Cursor cursor) {
        cursor.status = DefaultExceptionErrorHandler.mapErrorToStatus(DBConnectionManager.getInstance().getUserInformation((int)remoteHandle).getNamespace().getDataSource((String)datastoreName).dbms, e);
        if (cursor.status != 1) {
            ReorgSubmitThreadPool.setAnError();
        }
        if (!context.inErrorHandler) {
            if (errorHandler != null) {
                context.globals.Gx_err = (short)cursor.status;
                context.globals.Gx_dbe = e.getErrorCode();
                context.globals.Gx_dbt = e.getMessage();
                context.globals.Gx_dbsqlstate = e.getSQLState();
                context.inErrorHandler = true;
                try {
                    errorHandler.handleError();
                }
                finally {
                    context.inErrorHandler = false;
                }
            }
            if (context.globals.Gx_eop == 3) {
                DefaultExceptionErrorHandler.defaultSQLErrorHandler(context, cursor);
            }
            if (context.globals.Gx_eop == 2) {
                Application.rollback(context, remoteHandle, datastoreName, null);
                conn.setError();
                throw new GXRuntimeException((Throwable)e);
            }
        }
    }

    private static int mapErrorToStatus(GXDBMS dbms, SQLException e) {
        if (dbms.ObjectLocked(e)) {
            return 103;
        }
        if (dbms.EndOfFile(e)) {
            return 101;
        }
        if (dbms.DuplicateKeyValue(e)) {
            return 1;
        }
        if (dbms.ReferentialIntegrity(e)) {
            return 600;
        }
        if (dbms.DuplicateKeyValue(e)) {
            return 1;
        }
        if (dbms.ObjectNotFound(e)) {
            return 105;
        }
        if (dbms.getId() == 5 && dbms.DataTruncation(e)) {
            return 2;
        }
        return 999;
    }

    public static void defaultSQLErrorHandler(ModelContext context, Cursor cursor) {
        context.globals.Gx_eop = (byte)2;
        if (cursor.status == 103) {
            if ((cursor.errMask & 0x10) > 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                context.globals.Gx_eop = 1;
            } else {
                context.globals.Gx_eop = 0;
            }
        }
        if (cursor.status == 600 && (cursor.errMask & 0x20) > 0) {
            context.globals.Gx_eop = 0;
        }
        if (cursor.status == 1) {
            context.globals.Gx_eop = 0;
        }
        if (cursor.status == 2) {
            context.globals.Gx_eop = 0;
        }
    }
}

