/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db;

import com.genexus.CacheFactory;
import com.genexus.ClientContext;
import com.genexus.CommonUtil;
import com.genexus.DebugFlag;
import com.genexus.Preferences;
import com.genexus.common.classes.AbstractDataSource;
import com.genexus.common.classes.AbstractDataStoreProviderBase;
import com.genexus.db.CacheKey;
import com.genexus.db.CacheValue;
import com.genexus.db.Cursor;
import com.genexus.db.DataStoreProviderBase;
import com.genexus.db.IDataStoreHelper;
import com.genexus.db.IFieldSetter;
import com.genexus.db.IForEachCursor;
import com.genexus.db.SentenceProvider;
import com.genexus.db.driver.DataSource;
import com.genexus.db.driver.GXResultSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.UUID;

public class ForEachCursor
extends Cursor
implements IForEachCursor {
    boolean currentOf;
    boolean hold = false;
    Object[] buffers;
    private GXResultSet rslt;
    IDataStoreHelper parent;
    private boolean isCaching = false;
    private int cacheableLevel = 0;
    private boolean isForFirst = false;
    private boolean isCachingEnabled;
    private int fetchSize;
    private final Object syncResultSet = new Object();

    public ForEachCursor(String cursorId, String sqlSentence, boolean currentOf, int errMask, boolean hold, IDataStoreHelper parent, int cacheableLevel, boolean isForFirst) {
        this(cursorId, sqlSentence, currentOf, errMask, hold, parent, 0, cacheableLevel, isForFirst);
    }

    public ForEachCursor(String cursorId, String sqlSentence, boolean currentOf, int errMask, boolean hold, IDataStoreHelper parent, int fetchSize, int cacheableLevel, boolean isForFirst) {
        this(cursorId, sqlSentence, currentOf, errMask);
        this.isCachingEnabled = ClientContext.getModelContext() != null ? Preferences.getDefaultPreferences().getCACHING() || CacheFactory.getForceHighestTimetoLive() : false;
        this.hold = hold;
        this.parent = parent;
        this.dynStatement = sqlSentence.equalsIgnoreCase("scmdbuf");
        this.cacheableLevel = this.getCacheableLevel(cacheableLevel);
        this.fetchSize = fetchSize;
        this.isForFirst = isForFirst;
    }

    public ForEachCursor(String cursorId, String sqlSentence, boolean currentOf, int errMask, boolean hold, IDataStoreHelper parent) {
        this(cursorId, sqlSentence, currentOf, errMask, hold, parent, 0, 0, false);
    }

    public ForEachCursor(String cursorId, String sqlSentence, boolean currentOf, int errMask) {
        super(cursorId, sqlSentence, errMask);
        this.currentOf = currentOf;
    }

    public ForEachCursor(String cursorId, String sqlSentence, boolean currentOf) {
        this(cursorId, sqlSentence, currentOf, 0);
    }

    public ForEachCursor(String cursorId, String sqlSentence, int errMask) {
        this(cursorId, sqlSentence, false, errMask);
    }

    public void setOutputBuffers(Object[] buffers) {
        this.buffers = buffers;
    }

    protected boolean isCacheable() {
        return this.isCachingEnabled && !this.currentOf && this.cacheableLevel != 0;
    }

    protected boolean isForFirst() {
        return this.isForFirst;
    }

    protected int getCacheableLevel() {
        if (CacheFactory.getForceHighestTimetoLive()) {
            return 3;
        }
        return this.cacheableLevel;
    }

    byte[] preExecute(int cursorNum, AbstractDataStoreProviderBase absProvider, AbstractDataSource absDS, Object[] params) throws SQLException {
        DataStoreProviderBase connectionProvider = (DataStoreProviderBase)absProvider;
        DataSource ds = (DataSource)absDS;
        this.close();
        byte[] hasValues = null;
        String[] sentence = new String[]{this.mSQLSentence};
        if (this.dynStatement) {
            Object[] dynStmt = this.parent.getDynamicStatement(cursorNum, connectionProvider.context, connectionProvider.remoteHandle, connectionProvider.context.getHttpContext(), connectionProvider.getDynConstraints());
            sentence[0] = (String)dynStmt[0];
            hasValues = (byte[])dynStmt[1];
        }
        if (this.parent != null) {
            this.parent.setParametersRT(cursorNum, (IFieldSetter)new RTFieldSetter(ds, sentence), hasValues != null ? this.getParams(hasValues, params) : params);
        }
        this.isCaching = false;
        if (this.isCacheable()) {
            if (connectionProvider.cacheValue == null) {
                connectionProvider.cacheValue = new CacheValue[connectionProvider.cursors.length];
                connectionProvider.cacheIterator = new Enumeration[connectionProvider.cursors.length];
            }
            CacheKey ckey = new CacheKey(sentence[0], params);
            CacheValue cacheValue = (CacheValue)CacheFactory.getInstance().get(CacheFactory.CACHE_DB, ckey.toString(), CacheValue.class);
            Enumeration cacheIterator = null;
            if (cacheValue != null && ckey.equals(cacheValue.getKey())) {
                cacheIterator = cacheValue.getIterator();
            }
            connectionProvider.cacheIterator[cursorNum] = cacheIterator;
            if (connectionProvider.cacheIterator[cursorNum] != null) {
                if (DebugFlag.DEBUG) {
                    ds.getLog().logComment((Object)this, "Using cached data for " + sentence[0]);
                }
                this.isCaching = true;
                return hasValues;
            }
            connectionProvider.cacheValue[cursorNum] = CacheFactory.createCacheValue(sentence[0], params, this.cacheableLevel);
        }
        this.mPreparedStatement = SentenceProvider.getPreparedStatement((AbstractDataStoreProviderBase)connectionProvider, (String)this.mCursorId, (String)sentence[0], (boolean)this.currentOf);
        if (this.fetchSize != 0) {
            this.mPreparedStatement.setFetchSize(this.fetchSize);
        }
        return hasValues;
    }

    private Object[] getParams(byte[] hasValues, Object[] parms) {
        Object[] parmsNew = new Object[parms.length + hasValues.length];
        for (int i = 0; i < hasValues.length; ++i) {
            parmsNew[i] = new Byte(hasValues[i]);
        }
        System.arraycopy(parms, 0, parmsNew, hasValues.length, parms.length);
        return parmsNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postExecute(AbstractDataStoreProviderBase connectionProvider, AbstractDataSource ds) throws SQLException {
        if (this.isCaching) {
            return;
        }
        GXResultSet newSet = (GXResultSet)this.mPreparedStatement.executeQuery(this.hold);
        Object object = this.syncResultSet;
        synchronized (object) {
            this.rslt = newSet;
        }
    }

    public boolean next(AbstractDataSource ds) throws SQLException {
        return this.isCaching || this.rslt.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() throws SQLException {
        Object object = this.syncResultSet;
        synchronized (object) {
            if (this.rslt != null) {
                this.rslt.close();
                this.rslt = null;
            }
        }
    }

    public void clearBuffers() {
        for (int i = this.buffers.length - 1; i >= 0; --i) {
            if (this.buffers[i] instanceof byte[]) {
                ((byte[])this.buffers[i])[0] = 0;
                continue;
            }
            if (this.buffers[i] instanceof short[]) {
                ((short[])this.buffers[i])[0] = 0;
                continue;
            }
            if (this.buffers[i] instanceof int[]) {
                ((int[])this.buffers[i])[0] = 0;
                continue;
            }
            if (this.buffers[i] instanceof long[]) {
                ((long[])this.buffers[i])[0] = 0L;
                continue;
            }
            if (this.buffers[i] instanceof float[]) {
                ((float[])this.buffers[i])[0] = 0.0f;
                continue;
            }
            if (this.buffers[i] instanceof double[]) {
                ((double[])this.buffers[i])[0] = 0.0;
                continue;
            }
            if (this.buffers[i] instanceof String[]) {
                ((String[])this.buffers[i])[0] = "";
                continue;
            }
            if (!(this.buffers[i] instanceof java.util.Date[])) continue;
            ((java.util.Date[])this.buffers[i])[0] = CommonUtil.nullDate();
        }
    }

    public boolean hasResult() {
        return this.rslt != null;
    }

    public boolean isCurrentOf() {
        return this.currentOf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GXResultSet getResultSet() {
        GXResultSet gXResultSet = this.rslt;
        synchronized (gXResultSet) {
            return this.rslt;
        }
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public Object[] getBuffers() {
        return this.buffers;
    }

    public int getStatus() {
        return this.status;
    }

    class RTFieldSetter
    implements IFieldSetter {
        private final String[] sentence;
        private final DataSource ds;
        String[] concatOp = null;

        RTFieldSetter(DataSource ds, String[] sentence) {
            this.ds = ds;
            this.sentence = sentence;
        }

        public void setNull(int index, int sqlType) throws SQLException {
        }

        public void setBoolean(int index, boolean value) throws SQLException {
        }

        public void setByte(int index, byte value) throws SQLException {
        }

        public void setShort(int index, short value) throws SQLException {
        }

        public void setInt(int index, int value) throws SQLException {
        }

        public void setLong(int index, long value) throws SQLException {
        }

        public void setFloat(int index, float value) throws SQLException {
        }

        public void setDouble(int index, double value) throws SQLException {
        }

        public void setBigDecimal(int index, BigDecimal value, int decimals) throws SQLException {
        }

        public void setBigDecimal(int index, double value, int decimals) throws SQLException {
        }

        public void setVarchar(int index, String value) throws SQLException {
        }

        public void setVarchar(int index, String value, int length) throws SQLException {
        }

        public void setLongVarchar(int index, String value) throws SQLException {
        }

        public void setNLongVarchar(int index, String value) throws SQLException {
        }

        public void setLongVarchar(int index, String value, int maxLength) throws SQLException {
        }

        public void setString(int index, String value, int length) throws SQLException {
        }

        public void setString(int index, String value) throws SQLException {
        }

        public void setGXDbFileURI(int index, String fileName, String blobPath, int length, String tableName, String fieldName) throws SQLException {
        }

        public void setGXDbFileURI(int index, String fileName, String blobPath, int length) throws SQLException {
        }

        public void setGXDbFileURI(int index, String fileName, String blobPath, int length, String tableName, String fieldName, boolean downloadContent) throws SQLException {
        }

        public void setBytes(int index, byte[] value) throws SQLException {
        }

        public void setDateTime(int index, java.util.Date value, boolean onlyTime) throws SQLException {
        }

        public void setDateTime(int index, java.util.Date value, boolean onlyTime, boolean hasmilliseconds) throws SQLException {
        }

        public void setDateTime(int index, java.util.Date value, boolean onlyTime, boolean onlyDate, boolean hasmilliseconds) throws SQLException {
        }

        public void setDate(int index, java.util.Date value) throws SQLException {
        }

        public void setDate(int index, Date value) throws SQLException {
        }

        public void setTime(int index, Time value) throws SQLException {
        }

        public void setTimestamp(int index, Timestamp value) throws SQLException {
        }

        public void setBLOBFile(int index, String fileName) throws SQLException {
        }

        public void setBLOBFile(int index, String fileName, boolean isMultiMedia) throws SQLException {
        }

        public void setBLOBFile(int index, String fileName, boolean isMultiMedia, boolean downloadContet) throws SQLException {
        }

        public void setVarchar(int index, String value, int length, boolean allowsNull) throws SQLException {
        }

        public void setLongVarchar(int index, String value, boolean allowsNull) throws SQLException {
        }

        public void setNLongVarchar(int index, String value, boolean allowsNull) throws SQLException {
        }

        public void setLongVarchar(int index, String value, int maxLength, boolean allowsNull) throws SQLException {
        }

        public void setGUID(int index, UUID value) throws SQLException {
        }

        public void setParameterRT(String name, String value) {
            if (DebugFlag.DEBUG) {
                this.ds.getLog().log(0, "setParameterRT: " + name + " -> " + value);
            }
            boolean isLike = false;
            if (value.equals("like")) {
                isLike = true;
            } else if (!(value.equals("=") || value.equals(">") || value.equals(">=") || value.equals("<=") || value.equals("<") || value.equals("<>"))) {
                value = "=";
            }
            String[] parts = this.sentence[0].split("'");
            name = "{{" + name + "}}";
            StringBuilder nStmt = new StringBuilder();
            boolean inSQLConstant = false;
            for (int i = 0; i < parts.length; ++i) {
                if (i != 0) {
                    nStmt.append('\'');
                }
                if (!inSQLConstant) {
                    while (isLike && this.processLike(parts, i, name, value)) {
                    }
                    nStmt.append(parts[i].replace(name, value));
                } else {
                    nStmt.append(parts[i]);
                }
                inSQLConstant = !inSQLConstant;
            }
            this.sentence[0] = nStmt.toString();
        }

        private boolean processLike(String[] parts, int i, String placeholder, String op) {
            int placeholderIdx;
            if (this.concatOp == null) {
                this.concatOp = this.ds.concatOp();
            }
            if ((placeholderIdx = parts[i].indexOf(placeholder)) == -1) {
                return false;
            }
            int parenCount = 0;
            int placeholderLength = placeholder.length();
            int idx = placeholderIdx + placeholderLength;
            int j = i;
            boolean hasVariable = false;
            String currentPart = parts[j];
            while (parenCount >= 0) {
                if (idx == placeholderLength) {
                    idx = 0;
                    if ((j += 2) >= parts.length) break;
                    currentPart = parts[j];
                    continue;
                }
                switch (currentPart.charAt(idx)) {
                    case '(': {
                        ++parenCount;
                        break;
                    }
                    case ')': {
                        --parenCount;
                        break;
                    }
                    case '?': {
                        hasVariable = true;
                    }
                }
                ++idx;
            }
            if (hasVariable && j < parts.length) {
                parts[j] = String.format("%s)%s'%%'%s%s", parts[j].substring(0, --idx), this.concatOp[1], this.concatOp[2], parts[j].substring(idx));
                op = op + String.format(" %sRTRIM(", this.concatOp[0]);
            }
            parts[i] = String.format("%s%s%s", parts[i].substring(0, placeholderIdx), op, parts[i].substring(placeholderIdx + placeholderLength));
            return true;
        }
    }
}

