/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db;

import com.genexus.Application;
import com.genexus.CommonUtil;
import com.genexus.DebugFlag;
import com.genexus.ICacheService2;
import com.genexus.Preferences;
import com.genexus.db.CacheValue;
import com.genexus.db.CachedIFieldGetter;
import com.genexus.management.CacheItemJMX;
import com.genexus.management.CacheJMX;
import com.genexus.util.DoubleLinkedQueue;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class InProcessCache
implements ICacheService2 {
    protected long cacheStorageSize;
    protected long currentSize;
    protected int cacheDrops;
    protected boolean cacheEnabled;
    protected DoubleLinkedQueue lru = new DoubleLinkedQueue();
    private static final boolean DEBUG = DebugFlag.DEBUG;
    private ConcurrentHashMap<String, CacheValue> cache = new ConcurrentHashMap();
    private Object lockObject = new Object();
    private ConcurrentHashMap<String, Stats> cacheStats = new ConcurrentHashMap();

    public InProcessCache() {
        Preferences prefs = Preferences.getDefaultPreferences();
        this.cacheStorageSize = prefs.getCACHE_STORAGE_SIZE() * 1024L;
        this.cacheEnabled = prefs.getCACHING();
        if (Application.isJMXEnabled()) {
            CacheJMX.CreateCacheJMX(this);
        }
    }

    public boolean isEnabled() {
        return this.cacheEnabled;
    }

    public void setEnabled(boolean value) {
        this.cacheEnabled = value;
    }

    public ConcurrentHashMap<String, CacheValue> getCache() {
        return this.cache;
    }

    public void setCacheStorageSize(long cacheStorageSize) {
        this.cacheStorageSize = cacheStorageSize;
    }

    public long getCacheStorageSize() {
        return this.cacheStorageSize;
    }

    public long getCacheCurrentSize() {
        return this.currentSize;
    }

    public int getCacheDrops() {
        return this.cacheDrops;
    }

    public <T> T get(String cacheid, String key, Class<T> type) {
        return this.get(this.getKey(cacheid, key), type);
    }

    public <T> List<T> getAll(String cacheid, String[] keys, Class<T> type) {
        String[] prefixedKeys = this.getKey(cacheid, keys);
        ArrayList<T> values = new ArrayList<T>();
        for (String key : prefixedKeys) {
            values.add(this.get(key, type));
        }
        return values;
    }

    private <T> T get(String key, Class<T> type) {
        CacheValue value;
        if (DEBUG) {
            ++this.getStatsFor((String)key).hits;
        }
        if ((value = this.cache.get(key)) == null) {
            return null;
        }
        if (value.hasExpired()) {
            this.clearKey(key, value);
            return null;
        }
        if (this.cacheStorageSize != 0L) {
            this.lru.moveToStart(value);
        }
        value.incHits();
        if (DEBUG) {
            ++this.getStatsFor((String)key).hitsAfterFullLoaded;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        return type.cast(((CachedIFieldGetter)value.getIterator().nextElement()).getValue(0));
    }

    public void clear() {
        if (Application.isJMXEnabled()) {
            CacheJMX.DestroyCacheJMX();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearKey(String key, CacheValue value) {
        if (value != null) {
            if (DEBUG) {
                this.getStatsFor(value).removeFromStats(value);
            }
            if (this.cacheStorageSize != 0L) {
                Object object = this.lockObject;
                synchronized (object) {
                    this.lru.remove(value);
                    this.currentSize -= value.getSize();
                }
            }
            if (Application.isJMXEnabled()) {
                CacheItemJMX.DestroyCacheItemJMX(value);
            }
            this.cache.remove(key);
        }
    }

    public void clearKey(String key) {
        CacheValue value = this.cache.get(key);
        this.clearKey(key, value);
    }

    public <T> void set(String cacheid, String key, T value, int expirationSeconds) {
        this.set(this.getKey(cacheid, key), value, expirationSeconds);
    }

    public <T> void setAll(String cacheid, String[] keys, T[] values, int expirationSeconds) {
        if (keys != null && values != null && keys.length == values.length) {
            String[] prefixedKeys = this.getKey(cacheid, keys);
            int idx = 0;
            for (String key : prefixedKeys) {
                this.set(key, values[idx], expirationSeconds);
                ++idx;
            }
        }
    }

    private <T> void set(String key, T value, int expirationSeconds) {
        if (value instanceof CacheValue) {
            this.add(key, (CacheValue)value);
        } else {
            CacheValue cvalue = new CacheValue(key, null);
            cvalue.addItem(value);
            cvalue.setExpiryTime(expirationSeconds);
            this.add(key, cvalue);
        }
    }

    public <T> void set(String cacheid, String key, T value) {
        this.set(this.getKey(cacheid, key), value, 0);
    }

    private <T> void set(String key, T value) {
        this.set(key, value, 0);
    }

    private boolean containsKey(String key) {
        CacheValue value = this.cache.get(key);
        if (value != null && value.hasExpired()) {
            this.clearKey(key, value);
        }
        return this.cache.containsKey(key);
    }

    public boolean containtsKey(String cacheid, String key) {
        return this.containsKey(this.getKey(cacheid, key));
    }

    public void clear(String cacheid, String key) {
        this.cache.remove(this.getKey(cacheid, key));
    }

    public void clearCache(String cacheid) {
        this.set(cacheid, CommonUtil.now().getTime());
    }

    public void clearAllCaches() {
        this.cache.clear();
    }

    private Long getKeyPrefix(String cacheid) {
        Long prefix = this.get(cacheid, Long.class);
        if (prefix == null) {
            prefix = CommonUtil.now((boolean)false, (boolean)false).getTime();
            this.set(cacheid, Long.valueOf(prefix));
        }
        return prefix;
    }

    private String getKey(String cacheid, String key) {
        return this.formatKey(cacheid, key, this.getKeyPrefix(cacheid));
    }

    private String[] getKey(String cacheid, String[] keys) {
        Long prefix = this.getKeyPrefix(cacheid);
        String[] prefixedKeys = new String[keys.length];
        for (int idx = 0; idx < keys.length; ++idx) {
            prefixedKeys[idx] = this.formatKey(cacheid, keys[idx], prefix);
        }
        return prefixedKeys;
    }

    private String formatKey(String cacheid, String key, Long prefix) {
        return cacheid + prefix + CommonUtil.getHash((String)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(String key, CacheValue value) {
        if (Application.isJMXEnabled()) {
            CacheItemJMX.CreateCacheItemJMX(value);
        }
        value.setTimestamp();
        this.cache.put(key, value);
        Object object = this.lockObject;
        synchronized (object) {
            if (DEBUG) {
                this.getStatsFor(value).addToStats(value);
                this.getStatsFor((CacheValue)value).TTL = value.getExpiryTimeMilliseconds();
            }
            this.currentSize += value.getSize();
        }
        this.ensureCacheSize();
        if (this.cacheStorageSize != 0L) {
            this.lru.insert(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCacheSize() {
        if (this.cacheStorageSize > 0L) {
            Object object = this.lockObject;
            synchronized (object) {
                CacheValue item;
                while (this.currentSize > this.cacheStorageSize && (item = (CacheValue)this.lru.takeFromEnd()) != null) {
                    this.currentSize -= item.getSize();
                    if (Application.isJMXEnabled()) {
                        CacheItemJMX.DestroyCacheItemJMX(item);
                    }
                    this.cache.remove(item.getKey().getKey());
                    ++this.cacheDrops;
                    if (!DEBUG) continue;
                    this.getStatsFor(item).removeFromStats(item);
                }
            }
        }
    }

    public void removeExpiredEntries() {
        Enumeration<CacheValue> enum1 = this.cache.elements();
        while (enum1.hasMoreElements()) {
            CacheValue value = enum1.nextElement();
            if (!value.hasExpired()) continue;
            if (DEBUG) {
                String key = value.getKey().getKey();
                this.getStatsFor(value).removeFromStats(value);
            }
            if (this.cacheStorageSize != 0L) {
                this.lru.remove(value);
            }
            this.currentSize -= value.getSize();
            if (Application.isJMXEnabled()) {
                CacheItemJMX.DestroyCacheItemJMX(value);
            }
            this.cache.remove(value.getKey().getKey());
        }
    }

    public void setTimeToLive(int[] value) {
        for (int i = 0; i < 4; ++i) {
            Preferences.TTL[i] = value[i];
        }
    }

    public void setHitsToLive(int[] value) {
        for (int i = 0; i < 4; ++i) {
            Preferences.HTL[i] = value[i];
        }
    }

    public void addStats(String key) {
        this.getStatsFor(key);
    }

    public Stats getStatsFor(String key) {
        Stats newStats = new Stats(key);
        Stats stats = this.cacheStats.putIfAbsent(key, newStats);
        return stats != null ? stats : newStats;
    }

    public Stats getStatsFor(CacheValue value) {
        String key = value.getKey().toString();
        return this.getStatsFor(key);
    }

    public ConcurrentHashMap<String, Stats> getStats() {
        return this.cacheStats;
    }

    public String getStatsSentence(String key) {
        return this.getStatsFor((String)key).sentence;
    }

    public int getStatsHits(String key) {
        return this.getStatsFor((String)key).hits;
    }

    public int getStatsHitsCached(String key) {
        return this.getStatsFor((String)key).hitsAfterFullLoaded;
    }

    public int getStatsFullLoaded(String key) {
        return this.getStatsFor((String)key).fullLoaded;
    }

    public int getStatsCacheSize(String key) {
        return this.getStatsFor((String)key).cacheSize;
    }

    public long getStatsTTL(String key) {
        return this.getStatsFor((String)key).TTL / 60L;
    }

    class Stats {
        public String sentence;
        public int hits;
        public int hitsAfterFullLoaded;
        public int fullLoaded;
        public int cacheSize;
        public long TTL;

        public Stats(String sentence) {
            this.sentence = sentence;
            this.TTL = -1L;
        }

        public void removeFromStats(CacheValue value) {
            --this.fullLoaded;
            this.cacheSize = (int)((long)this.cacheSize - value.getSize());
        }

        public void addToStats(CacheValue value) {
            ++this.fullLoaded;
            this.cacheSize = (int)((long)this.cacheSize + value.getSize());
        }
    }
}

