/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db;

import com.genexus.Application;
import com.genexus.ApplicationContext;
import com.genexus.ClientPreferences;
import com.genexus.CommonUtil;
import com.genexus.LocalUtil;
import com.genexus.Messages;
import com.genexus.ModelContext;
import com.genexus.db.ConnectionInformation;
import com.genexus.db.DBConnectionManager;
import com.genexus.db.Namespace;
import com.genexus.db.UserInformation;
import com.genexus.db.driver.DataSource;
import com.genexus.db.driver.GXConnection;
import java.awt.Frame;
import java.sql.SQLException;
import java.util.Enumeration;

public class LocalUserInformation
extends UserInformation {
    public LocalUserInformation(Namespace namespace) {
        super(namespace);
        ClientPreferences preferences = new ClientPreferences(namespace.iniFile);
        this.setLocalUtil(preferences.getDECIMAL_POINT(), preferences.getDATE_FMT(), preferences.getTIME_FMT(), preferences.getYEAR_LIMIT(), preferences.getLANGUAGE());
    }

    public GXConnection getConnection(ModelContext context, String dataSourceName, String user, String password) throws SQLException {
        ConnectionInformation info = (ConnectionInformation)this.connections.get(dataSourceName);
        if (info == null || info.rwConnection == null) {
            info = new ConnectionInformation();
            info.user = user;
            info.password = password;
            this.connections.put(dataSourceName, info);
            info.rwConnection = new GXConnection(context, info.user, info.password, this.namespace.getDataSource(dataSourceName));
        }
        return (GXConnection)info.rwConnection;
    }

    public boolean isConnected(String dataSourceName) {
        ConnectionInformation info = (ConnectionInformation)this.connections.get(dataSourceName);
        return info != null && info.rwConnection != null;
    }

    public GXConnection getConnection(ModelContext context, String dataSourceName) throws SQLException {
        ConnectionInformation info = (ConnectionInformation)this.connections.get(dataSourceName);
        boolean isClosed = false;
        try {
            if (info != null && info.rwConnection != null && !((GXConnection)info.rwConnection).getError()) {
                isClosed = ((GXConnection)info.rwConnection).isClosed();
            }
        }
        catch (SQLException ex) {
            System.err.println("Connection closed " + ex.getMessage());
            isClosed = true;
        }
        if (info == null || info.rwConnection == null || ((GXConnection)info.rwConnection).getError() || isClosed) {
            info = new ConnectionInformation();
            this.connections.put(dataSourceName, info);
            this.createConnection(context, this.namespace.getDataSource(dataSourceName), info);
        }
        return (GXConnection)info.rwConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() throws SQLException {
        Enumeration en = this.connections.elements();
        while (en.hasMoreElements()) {
            ConnectionInformation info = (ConnectionInformation)en.nextElement();
            if (info.rwConnection == null) continue;
            try {
                info.rwConnection.close();
            }
            catch (SQLException e) {
                System.err.println("Error while closing a db connection " + e.getMessage());
            }
            finally {
                info.rwConnection = null;
            }
        }
    }

    @Override
    public void flushBuffers(Object o) throws SQLException {
        Enumeration en = this.connections.elements();
        while (en.hasMoreElements()) {
            ConnectionInformation info = (ConnectionInformation)en.nextElement();
            if (info.rwConnection == null) continue;
            try {
                info.rwConnection.flushBatchCursors(o);
            }
            catch (SQLException e) {
                System.err.println("Error while flushing cursor  " + e.getMessage());
            }
        }
    }

    @Override
    public void disconnectOnException() throws SQLException {
        this.disconnect();
    }

    private boolean setUserAndPassword(DataSource dataSource, String[] user, String[] password) {
        if (dataSource != null && dataSource.loginInServer) {
            user[0] = dataSource.defaultUser;
            password[0] = dataSource.defaultPassword;
            return true;
        }
        return false;
    }

    private void createConnection(ModelContext context, DataSource dataSource, ConnectionInformation info) throws SQLException {
        String[] user = new String[1];
        String[] password = new String[1];
        int retries = 0;
        boolean ui = ApplicationContext.getInstance().isMsgsToUI();
        while (info.rwConnection == null && retries++ < 3) {
            if (this.setUserAndPassword(dataSource, user, password)) {
                info.password = password[0];
                info.user = user[0];
                info.rwConnection = new GXConnection(context, this.handle, info.user, info.password, dataSource, info);
            } else if (ui) {
                Application.exit();
            }
            if (ui) continue;
        }
        if (ui && retries > 3) {
            CommonUtil.msg((Object)new Frame(), (String)"Can't connect to to database. Exiting ...");
            Application.exit();
        }
    }

    @Override
    public String getUser(String dataSource) {
        return ((ConnectionInformation)this.connections.get((Object)dataSource)).user;
    }

    @Override
    public String getPassword(String dataSource) {
        return ((ConnectionInformation)this.connections.get((Object)dataSource)).password;
    }

    @Override
    public LocalUtil getLocalUtil() {
        return this.localUtil;
    }

    @Override
    public Messages getMessages() {
        return this.messages;
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    public void dropAllCursors() {
        Enumeration en = this.connections.elements();
        while (en.hasMoreElements()) {
            ConnectionInformation info = (ConnectionInformation)en.nextElement();
            if (info.rwConnection != null) {
                info.rwConnection.dropAllCursors();
            }
            if (info.roConnection == null) continue;
            info.rwConnection.dropAllCursors();
        }
    }

    public void disconnectUser() {
        try {
            DBConnectionManager.getInstance().disconnect(this.getHandle());
        }
        catch (SQLException e) {
            System.out.println(e.toString());
        }
    }
}

