/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db;

import com.genexus.Application;
import com.genexus.ApplicationContext;
import com.genexus.CommonUtil;
import com.genexus.ConfigFileFinder;
import com.genexus.GXJarClassLoader;
import com.genexus.GXutil;
import com.genexus.ModelContext;
import com.genexus.Preferences;
import com.genexus.PrivateUtilities;
import com.genexus.common.classes.AbstractNamespace;
import com.genexus.db.DBConnection;
import com.genexus.db.DBConnectionManager;
import com.genexus.db.ServerConnectionManager;
import com.genexus.db.ServerUserInformation;
import com.genexus.db.UserInformation;
import com.genexus.db.driver.DataSource;
import com.genexus.db.driver.GXDBDebug;
import com.genexus.db.driver.JDBCLogConfig;
import com.genexus.management.DataSourceJMX;
import com.genexus.management.NamespaceJMX;
import com.genexus.util.IniFile;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;

public class Namespace
extends AbstractNamespace {
    public static final int GXDB_CLIENT = 0;
    public static final int GXDB_SERVER = 1;
    private static ConcurrentHashMap<String, String> namespaceListCheck = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Namespace> namespaceList = new ConcurrentHashMap();
    private GXJarClassLoader classLoader;
    private ConcurrentHashMap<String, DataSource> dataSources = new ConcurrentHashMap();
    private String name;
    public int remoteCalls;
    public int timeout;
    public String nameHost;
    public String classesArchive;
    public String autoRemote;
    public String gxdbLocation;
    public boolean autoReload;
    public int gxdbType;
    public IniFile iniFile;
    private JDBCLogConfig logConfig;
    private GXDBDebug debugLog;
    private static boolean connectStartup = false;
    static boolean initialized = false;

    public Namespace(String name, IniFile iniFile) {
        this.iniFile = iniFile;
        String mainSection = iniFile.sectionExists("Client") ? "Client" : "Server";
        Preferences preferences = new Preferences(iniFile, mainSection);
        this.timeout = preferences.getCONN_TIMEOUT();
        this.remoteCalls = preferences.getREMOTE_CALLS();
        this.nameHost = preferences.getNAME_HOST();
        this.logConfig = new JDBCLogConfig(iniFile.getProperty(name, "JDBC_LOG", ""), iniFile.getProperty(name, "JDBCLogEnabled", "0").equals("1"), iniFile.getProperty(name, "JDBCUniqueName", "0").equals("1"), iniFile.getIntegerProperty(name, "JDBCLogDetail", "0"), iniFile.getProperty(name, "JDBCLogBuffer", "0").equals("1"), iniFile.getProperty(name, "JDBCLogPath", ""), iniFile.getIntegerProperty(name, "JDBCLogLevel", "0"));
        this.logConfig.setNamespaceName(name);
        if (this.logConfig.getLevel() == 0) {
            this.debugLog = new GXDBDebug(this.logConfig);
        }
        boolean inReorg = ApplicationContext.getInstance().getReorganization();
        int i = 1;
        while (true) {
            String dataSourceName;
            try {
                dataSourceName = iniFile.getProperty(name, "DataSource" + GXutil.str(i, 5, 0).trim());
            }
            catch (InternalError e) {
                break;
            }
            if (dataSourceName == null) break;
            String section = name + "|" + dataSourceName;
            this.logConfig.setDataSourceName(dataSourceName);
            connectStartup = iniFile.getProperty(section, "CS_CONNECT", "First").equals("Startup");
            DataSource ds = new DataSource(dataSourceName.toUpperCase(), PrivateUtilities.getJDBC_DRIVER(iniFile, section), iniFile.getProperty(section, "DB_URL", ""), iniFile.getPropertyEncrypted(section, "USER_ID", ""), iniFile.getPropertyEncrypted(section, "USER_PASSWORD", ""), this.logConfig, iniFile.getProperty(section, "USE_JDBC_DATASOURCE", "0").equals("1") && !inReorg && (ApplicationContext.getInstance().isServletEngine() || ApplicationContext.getInstance().isEJBEngine() || iniFile.getProperty(section, "REMOTE_CALLS", "").toUpperCase().startsWith("HTTP")), iniFile.getProperty(section, "USE_MULTI_JDBC_DATASOURCE", "0").equals("1"), iniFile.getProperty(section, "MULTI_JDBC_DATASOURCE_PROC", ""), iniFile.getProperty(section, "JDBC_DATASOURCE", ""), iniFile.getIntegerProperty(section, "MAX_CURSOR", "100"), this.getIsolationLevel(iniFile, section), iniFile.getProperty(section, "XBASE_TINT", "1").equals("1"), iniFile.getProperty(section, "DBMS", "sqlserver"), iniFile.getProperty(section, "CS_SCHEMA", ""), iniFile.getProperty(section, "INITIALIZE_NEW", "1").equals("1"), iniFile.getProperty(section, "CS_LIBL400", "1"), iniFile.getProperty(section, "CS_DBNAME", "1"), iniFile.getIntegerProperty(section, "WAIT_RECORD", "1"), iniFile.getIntegerProperty(section, "LOCK_RETRY", "10"), iniFile.getProperty(section, "LoginInServer", "0").equals("1"), iniFile.getIntegerProperty(section, "POOLSIZE_RW", "-1"), iniFile.getProperty(section, "UnlimitedRWPool", "1").equals("1"), false, iniFile.getIntegerProperty(section, "POOLSIZE_RO", "1"), iniFile.getProperty(section, "UnlimitedROPool", "1").equals("1"), iniFile.getIntegerProperty(section, "PoolROUsers", "-1"), iniFile.getProperty(section, "POOL_STARTUP", "0").equals("1") && !inReorg, inReorg, connectStartup, iniFile.getProperty(section, "PoolRWEnabled", "1").equals("1"), iniFile.getProperty(section, "RecycleRO", "0").equals("1"), iniFile.getIntegerProperty(section, "RecycleROMin", "30"), iniFile.getProperty(section, "RecycleRW", "0").equals("1"), iniFile.getIntegerProperty(section, "RecycleRWMin", "30"), iniFile.getIntegerProperty(section, "RecycleRWType", "1"));
            section = name + "|" + dataSourceName;
            ds.setInformixDB(iniFile.getProperty(section, "INFORMIX_DB", "ANSI"));
            ds.setAS400Package(iniFile.getProperty(section, "CS_PACKAGE400", ""));
            ds.setAS400DateType(iniFile.getProperty(section, "DB2400_DATE_DATATYPE", ""));
            if (this.logConfig.getLevel() == 0) {
                ds.setLog(this.getLog());
            } else {
                ds.setLog(new GXDBDebug(this.logConfig));
            }
            ds.setNamespace(name);
            ds.initialize();
            this.dataSources.put(dataSourceName.toUpperCase(), ds);
            if (Application.isJMXEnabled()) {
                DataSourceJMX.CreateDataSourceJMX(ds);
            }
            ++i;
        }
        this.classesArchive = iniFile.getProperty(name, "Archive", "");
        this.gxdbLocation = iniFile.getProperty(name, "GXDB_LOCATION");
        this.autoRemote = iniFile.getProperty(name, "AUTO_REMOTE", "");
        this.autoReload = iniFile.getProperty(name, "AutoReload", "0").equals("1");
        this.gxdbType = (int)CommonUtil.val((String)iniFile.getProperty(name, "GXDBType", "0"));
        this.name = name;
        if (Application.isJMXEnabled()) {
            NamespaceJMX.CreateNamespaceJMX(this);
        }
    }

    private int getIsolationLevel(IniFile iniFile, String section) {
        String isolationLevel;
        switch (isolationLevel = iniFile.getProperty(section, "ISOLATION_LEVEL", "CR")) {
            case "UR": {
                return 0;
            }
            case "CR": {
                return 1;
            }
            case "RR": {
                return 2;
            }
            case "SE": {
                return 3;
            }
        }
        return 0;
    }

    public static Namespace createNamespace(ModelContext context) {
        IniFile iniFile = context.getPreferences().getIniFile();
        String name = context.getNAME_SPACE();
        Namespace ret = null;
        if (name != null) {
            String existingNamespace = namespaceListCheck.putIfAbsent(name, name);
            if (existingNamespace == null) {
                ret = new Namespace(name, iniFile);
                namespaceList.put(name, ret);
            } else {
                ret = namespaceList.get(name);
            }
        }
        return ret;
    }

    public static void endNamespace() {
        namespaceList = null;
    }

    public static void createNamespaces(IniFile iniFile) {
        if (initialized) {
            return;
        }
        initialized = true;
        String baseName = "Namespace";
        String section = iniFile.sectionExists("Client") ? "Client" : "Server";
        String name = "";
        int i = 0;
        while (name != null) {
            name = iniFile.getProperty(section, baseName + ++i);
            if (name == null) continue;
            namespaceList.put(name, new Namespace(name, iniFile));
        }
    }

    public static void createNamespaces2(IniFile iniFile) {
        String baseName = "Namespace";
        String section = iniFile.sectionExists("Client") ? "Client" : "Server";
        String name = "";
        int i = 0;
        while (name != null) {
            name = iniFile.getProperty(section, baseName + ++i);
            if (name == null) continue;
            namespaceList.put(name, new Namespace(name, iniFile));
        }
    }

    public boolean isRemoteGXDB() {
        return this.gxdbLocation == null ? false : !this.gxdbLocation.equals(ApplicationContext.getInstance().getCurrentLocation());
    }

    public boolean isClientGXDB() {
        return this.isRemoteGXDB() && this.gxdbLocation.length() != 0;
    }

    public static Namespace getNamespace(String name) {
        Namespace ns = namespaceList.get(name);
        if (ns == null) {
            Namespace.createNamespaces2(ConfigFileFinder.getConfigFile(null, "server.cfg", null));
            ns = namespaceList.get(name);
        }
        return ns;
    }

    public void reset() {
        if (this.classLoader != null) {
            this.classLoader = null;
        }
        Enumeration<UserInformation> en = DBConnectionManager.getInstance().getServerConnections();
        while (en.hasMoreElements()) {
            ServerUserInformation user = (ServerUserInformation)en.nextElement();
            if (!((Object)((Object)user.namespace)).equals((Object)this)) continue;
            ServerConnectionManager.getInstance().disconnect(user.getHandle());
        }
    }

    public synchronized GXJarClassLoader getClassLoader() {
        this.classLoader = this.classLoader == null ? new GXJarClassLoader(this.classesArchive, this.autoReload) : this.classLoader.getClassLoaderInstance();
        return this.classLoader;
    }

    public int getDataSourceCount() {
        return this.dataSources.size();
    }

    public Enumeration<String> getDataSourcesNames() {
        return this.dataSources.keys();
    }

    public Enumeration<DataSource> getDataSources() {
        return this.dataSources.elements();
    }

    public DataSource getDataSource(String name) {
        return this.dataSources.get(name.toUpperCase());
    }

    public static Enumeration getNamespaceList() {
        return namespaceList.keys();
    }

    public String getName() {
        return this.name;
    }

    public GXDBDebug getLog() {
        return this.debugLog;
    }

    public void cleanup() throws SQLException {
        Enumeration<DataSource> enDs = this.getDataSources();
        while (enDs.hasMoreElements()) {
            enDs.nextElement().cleanup();
        }
        if (this.getLog() != null) {
            this.getLog().close(0);
        }
    }

    public static boolean getConnectAtStartup() {
        return connectStartup && Preferences.getDefaultPreferences().getREMOTE_CALLS() == 0;
    }

    public static void connectAll(int remoteHandle) {
        Enumeration<Namespace> enum1 = namespaceList.elements();
        while (enum1.hasMoreElements()) {
            Namespace ns = enum1.nextElement();
            Enumeration<DataSource> enum2 = ns.dataSources.elements();
            while (enum2.hasMoreElements()) {
                DataSource ds = enum2.nextElement();
                DBConnection dbconn = new DBConnection(ds, remoteHandle);
                dbconn.connect();
                if (dbconn.getErrCode() != 3) continue;
                System.err.println(dbconn.getErrDescription());
            }
        }
    }

    public int getUserCounts() {
        int count = 0;
        String ns = this.getName();
        Enumeration<UserInformation> en = DBConnectionManager.getInstance().getServerConnections();
        while (en.hasMoreElements()) {
            ServerUserInformation userInfo = (ServerUserInformation)en.nextElement();
            if (!userInfo.getNamespace().getName().equals(ns)) continue;
            ++count;
        }
        return count;
    }
}

