/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db;

import com.genexus.db.DBConnectionManager;
import com.genexus.db.Namespace;
import com.genexus.db.ServerUserInformation;
import java.sql.SQLException;

public class ServerConnectionManager {
    private static volatile ServerConnectionManager serverConnectionManager;
    private static Object objectLock;
    private Object handleLock = new Object();

    private ServerConnectionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerConnectionManager getInstance() {
        ServerConnectionManager manager = serverConnectionManager;
        if (manager == null) {
            Object object = objectLock;
            synchronized (object) {
                if (serverConnectionManager == null) {
                    manager = serverConnectionManager = new ServerConnectionManager();
                }
            }
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNewHandle(Namespace namespace, int orb, String IP, boolean autoDisconnect) {
        Object object = this.handleLock;
        synchronized (object) {
            ServerUserInformation sui = (ServerUserInformation)DBConnectionManager.getInstance().createUserInformation(namespace);
            sui.setProtocol((byte)orb);
            sui.setIP(IP);
            sui.setAutoDisconnect(autoDisconnect);
            return sui.getHandle();
        }
    }

    public synchronized ServerUserInformation getUserInformation(int handle) {
        return (ServerUserInformation)DBConnectionManager.getInstance().getUserInformation(handle);
    }

    public synchronized void connect(int handle, String dataSource) {
        ServerUserInformation userInfo = this.getUserInformation(handle);
        if (userInfo == null) {
            System.err.println("Warning! Unknow handle requested a connect operation");
            return;
        }
    }

    public synchronized void connect(int handle, String dataSource, String user, String password) {
        ServerUserInformation userInfo = this.getUserInformation(handle);
        if (userInfo == null) {
            System.err.println("Warning! Unknow handle requested a connect operation");
            return;
        }
        userInfo.setUserAndPassword(dataSource, user, password);
    }

    public void disconnect(int handle) {
        ServerUserInformation userInfo = this.getUserInformation(handle);
        if (userInfo == null) {
            System.err.println("Warning! Unconnected handle requested a disconnect operation");
            return;
        }
        try {
            DBConnectionManager.getInstance().disconnect(handle);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public synchronized void keepAlive(int handle) {
        ServerUserInformation userInfo = this.getUserInformation(handle);
        if (userInfo == null) {
            System.err.println("Warning! Unconnected handle requested a keepAplive operation " + handle);
            return;
        }
        userInfo.setTimestamp();
    }

    static {
        objectLock = new Object();
    }
}

