/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db;

import com.genexus.Application;
import com.genexus.ApplicationContext;
import com.genexus.ModelContext;
import com.genexus.ServerPreferences;
import com.genexus.db.DBConnectionManager;
import com.genexus.db.DynamicExecute;
import com.genexus.db.Namespace;
import com.genexus.db.ServerUserInformation;
import com.genexus.db.UserInformation;
import com.genexus.db.driver.GXConnection;
import java.sql.SQLException;
import java.util.Enumeration;

final class ServerDBConnectionManager
extends DBConnectionManager {
    private static String onDisconnectProcName = "";

    ServerDBConnectionManager(ModelContext context) {
        this();
    }

    ServerDBConnectionManager() {
        if (ApplicationContext.getInstance().isApplicationServer()) {
            try {
                new IdleConnectionKiller().start();
            }
            catch (Throwable e) {
                System.out.println("Can't start idle connection killer thread");
            }
        }
    }

    @Override
    public UserInformation getNewUserInformation(Namespace namespace) {
        return new ServerUserInformation(namespace);
    }

    @Override
    public boolean isConnected(int handle, String dataSource) {
        return ((ServerUserInformation)this.getUserInformation(handle)).isConnected(dataSource);
    }

    @Override
    public GXConnection getConnection(ModelContext context, int handle, String dataSource, boolean readOnly, boolean sticky) throws SQLException {
        return ((ServerUserInformation)this.getUserInformation(handle)).getConnection(context, dataSource, readOnly, sticky);
    }

    @Override
    public void dropAllCursors(int handle) {
    }

    @Override
    public void disconnect(int handle) throws SQLException, NullPointerException {
        UserInformation ui = this.getUserInformation(handle);
        if (onDisconnectProcName != null && !ApplicationContext.getInstance().isServletEngine()) {
            try {
                if (onDisconnectProcName.equals("")) {
                    ServerPreferences pref = ServerPreferences.getInstance(Application.class);
                    onDisconnectProcName = pref.getOnDisconnectProcName();
                }
                if (ui != null && onDisconnectProcName != null) {
                    try {
                        DynamicExecute.dynamicExecute((ModelContext)new ModelContext(ServerDBConnectionManager.class), (int)handle, Application.class, (String)onDisconnectProcName, (Object[])new Object[]{new Integer(handle)});
                    }
                    catch (Throwable e) {
                        System.err.println("OnDisconnectProc -> ");
                        e.printStackTrace();
                    }
                }
            }
            catch (Throwable ex) {
                onDisconnectProcName = null;
            }
        }
        super.disconnect(handle);
    }

    class IdleConnectionKiller
    extends Thread {
        int i;
        long connectionTimeoutMiliseconds = 30000L;

        @Override
        public void run() {
            while (true) {
                try {
                    IdleConnectionKiller.sleep(this.connectionTimeoutMiliseconds);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.killConnections();
            }
        }

        private void killConnections() {
            long now = System.currentTimeMillis();
            try {
                Enumeration en = ServerDBConnectionManager.this.userConnections.elements();
                while (en.hasMoreElements()) {
                    ServerUserInformation userInfo = (ServerUserInformation)((Object)en.nextElement());
                    if (!userInfo.getAutodisconnect() || userInfo.getTimestamp() >= now - this.connectionTimeoutMiliseconds) continue;
                    try {
                        ServerDBConnectionManager.this.disconnect(userInfo.getHandle());
                    }
                    catch (Exception e) {
                        System.err.println("Error while disconnecting " + e.getMessage());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

