/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db;

import com.genexus.Application;
import com.genexus.ApplicationContext;
import com.genexus.ModelContext;
import com.genexus.common.classes.AbstractDataSource;
import com.genexus.db.ConnectionInformation;
import com.genexus.db.DBConnectionManager;
import com.genexus.db.Namespace;
import com.genexus.db.UserInformation;
import com.genexus.db.driver.DataSource;
import com.genexus.db.driver.GXConnection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;

public final class ServerUserInformation
extends UserInformation {
    private String IP = "";
    private byte protocol;
    private long connectionTime = System.currentTimeMillis();
    private static final Object lock = new Object();

    public ServerUserInformation(Namespace namespace) {
        super(namespace);
        this.setTimestamp();
        if (ApplicationContext.getInstance().getReorganization()) {
            String lang = ModelContext.getModelContext().getPreferences().getProperty("LANGUAGE", "eng");
            this.setLocalUtil('.', "", "", 40, lang);
        } else if (!ApplicationContext.getInstance().isApplicationServer() && ModelContext.getModelContext().getHttpContext() != null) {
            this.setLocalUtil(Application.getClientPreferences().getDECIMAL_POINT(), Application.getClientPreferences().getDATE_FMT(), Application.getClientPreferences().getTIME_FMT(), Application.getClientPreferences().getYEAR_LIMIT(), Application.getClientPreferences().getLANGUAGE());
        } else {
            this.setLocalUtil('.', "", "", 40, "eng");
        }
    }

    @Override
    public void disconnect() throws SQLException {
        SQLException disconnectException = null;
        Enumeration<DataSource> en = this.namespace.getDataSources();
        while (en.hasMoreElements()) {
            try {
                en.nextElement().disconnect(this.handle);
            }
            catch (SQLException e) {
                disconnectException = e;
            }
            catch (Throwable throwable) {}
        }
        if (disconnectException != null) {
            throw disconnectException;
        }
    }

    @Override
    public void flushBuffers(Object o) throws SQLException {
        Enumeration<DataSource> en = this.namespace.getDataSources();
        while (en.hasMoreElements()) {
            en.nextElement().flushBuffers(this.handle, o);
        }
    }

    public boolean isConnected(String dataSourceName) {
        ConnectionInformation info = (ConnectionInformation)this.connections.get(dataSourceName);
        return info != null && info.rwConnection != null;
    }

    @Override
    public void disconnectOnException() throws SQLException {
        Enumeration<DataSource> en = this.namespace.getDataSources();
        while (en.hasMoreElements()) {
            en.nextElement().disconnectOnException(this.handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GXConnection getConnection(ModelContext context, String dataSourceName, boolean readOnly, boolean sticky) throws SQLException {
        GXConnection con;
        DataSource dataSourceAux;
        this.setTimestamp();
        ConnectionInformation info = (ConnectionInformation)this.connections.get(dataSourceName);
        if (info == null) {
            throw new RuntimeException("Can't find connection information for datastore " + dataSourceName);
        }
        DataSource dataSource = null;
        String defaultUser = null;
        String defaultPassword = null;
        String jdbcUrl = null;
        boolean usesJdbcDataSource = false;
        Object object = lock;
        synchronized (object) {
            dataSourceAux = (DataSource)context.beforeGetConnection(this.handle, (AbstractDataSource)this.getNamespace().getDataSource(dataSourceName));
            if (dataSourceAux != null) {
                dataSource = dataSourceAux.copy();
                defaultUser = dataSource.defaultUser;
                defaultPassword = dataSource.defaultPassword;
                jdbcUrl = dataSource.jdbcUrl;
                usesJdbcDataSource = dataSource.usesJdbcDataSource();
            }
        }
        if (dataSourceAux == null) {
            con = (GXConnection)this.getNamespace().getDataSource(dataSourceName).getConnectionPool().checkOut(context, null, this.handle, this.getUser(dataSourceName), this.getPassword(dataSourceName), readOnly, sticky);
            if (con.getPreviousHandle() != this.handle) {
                context.afterGetConnection(this.handle, (AbstractDataSource)this.getNamespace().getDataSource(dataSourceName));
            }
        } else {
            con = usesJdbcDataSource ? (GXConnection)dataSource.getConnectionPool().checkOut(context, dataSource, this.handle, defaultUser, defaultPassword, readOnly, sticky) : (GXConnection)dataSource.getConnectionPool(jdbcUrl + defaultUser + defaultPassword).checkOut(context, dataSource, this.handle, defaultUser, defaultPassword, readOnly, sticky);
            if (con.getPreviousHandle() != this.handle) {
                context.afterGetConnection(this.handle, (AbstractDataSource)dataSource);
            }
        }
        this.putConnection(dataSourceName, readOnly ? (GXConnection)info.rwConnection : con, readOnly ? con : (GXConnection)info.roConnection, info.user, info.password);
        return con;
    }

    public synchronized long getConnectionTime() {
        return this.connectionTime;
    }

    public String getIP() {
        return this.IP;
    }

    public void setIP(String IP) {
        this.IP = IP;
    }

    public byte getProtocol() {
        return this.protocol;
    }

    public void setProtocol(byte protocol) {
        this.protocol = protocol;
    }

    public Date getConnectedSince() {
        return new Date(this.getConnectionTime());
    }

    public long getIdleSeconds() {
        return (System.currentTimeMillis() - this.getTimestamp()) / 1000L;
    }

    public void disconnectUser() {
        try {
            DBConnectionManager.getInstance().disconnect(this.getHandle());
        }
        catch (SQLException e) {
            System.out.println(e.toString());
        }
    }
}

