/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db;

import com.genexus.CacheFactory;
import com.genexus.ClientContext;
import com.genexus.CommonUtil;
import com.genexus.DebugFlag;
import com.genexus.Preferences;
import com.genexus.common.classes.AbstractDataSource;
import com.genexus.common.classes.AbstractDataStoreProviderBase;
import com.genexus.db.CacheKey;
import com.genexus.db.CacheValue;
import com.genexus.db.Cursor;
import com.genexus.db.DataStoreProviderBase;
import com.genexus.db.IDataStoreHelper;
import com.genexus.db.SentenceProvider;
import com.genexus.db.driver.DataSource;
import com.genexus.db.driver.GXConnection;
import com.genexus.db.driver.GXResultSet;
import com.genexus.db.service.IQuery;
import com.genexus.db.service.IServiceHelper;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;

public class ServiceCursorBase
extends Cursor {
    boolean currentOf;
    boolean hold = false;
    Object[] buffers;
    private GXResultSet rslt;
    IDataStoreHelper parent;
    private boolean isCaching = false;
    private int cacheableLevel = 0;
    private boolean isForFirst = false;
    private boolean isCachingEnabled;
    private int fetchSize;
    private final Object syncResultSet = new Object();
    public IQuery query;

    public ServiceCursorBase(String cursorId, IQuery query, boolean currentOf, int errMask, boolean hold, IDataStoreHelper parent, int cacheableLevel, boolean isForFirst) {
        this(cursorId, query, currentOf, errMask, hold, parent, 0, cacheableLevel, isForFirst);
    }

    public ServiceCursorBase(String cursorId, IQuery query, boolean currentOf, int errMask, boolean hold, IDataStoreHelper parent, int fetchSize, int cacheableLevel, boolean isForFirst) {
        this(cursorId, query, currentOf, errMask);
        this.isCachingEnabled = ClientContext.getModelContext() != null ? Preferences.getDefaultPreferences().getCACHING() || CacheFactory.getForceHighestTimetoLive() : false;
        this.hold = hold;
        this.parent = parent;
        this.cacheableLevel = this.getCacheableLevel(cacheableLevel);
        this.fetchSize = fetchSize;
        this.isForFirst = isForFirst;
        this.query = query;
    }

    public ServiceCursorBase(String cursorId, IQuery query, boolean currentOf, int errMask) {
        super(cursorId, ServiceCursorBase.queryId(cursorId, query), errMask);
        this.currentOf = currentOf;
        this.query = query;
    }

    public ServiceCursorBase(String cursorId, IQuery query, boolean currentOf) {
        this(cursorId, query, currentOf, 0);
    }

    public IDataStoreHelper getParent() {
        return this.parent;
    }

    public ServiceCursorBase(String cursorId, IQuery query, int errMask) {
        this(cursorId, query, false, errMask);
    }

    private static String queryId(String name, Object query) {
        return String.format("Service:%s_%d", name, query.hashCode());
    }

    public void setOutputBuffers(Object[] buffers) {
        this.buffers = buffers;
    }

    protected boolean isCacheable() {
        return this.isCachingEnabled && !this.currentOf && this.cacheableLevel != 0;
    }

    protected boolean isForFirst() {
        return this.isForFirst;
    }

    protected int getCacheableLevel() {
        return this.cacheableLevel;
    }

    byte[] preExecute(int cursorNum, AbstractDataStoreProviderBase abstractProvider, AbstractDataSource abstractDS, Object[] params) throws SQLException {
        DataStoreProviderBase connectionProvider = (DataStoreProviderBase)abstractProvider;
        DataSource ds = (DataSource)abstractDS;
        this.close();
        byte[] hasValues = null;
        String sentence = this.mSQLSentence;
        if (this.dynStatement) {
            Object[] dynStmt = this.parent.getDynamicStatement(cursorNum, connectionProvider.context, connectionProvider.remoteHandle, connectionProvider.context.getHttpContext(), connectionProvider.getDynConstraints());
            sentence = (String)dynStmt[0];
            hasValues = (byte[])dynStmt[1];
        }
        this.isCaching = false;
        if (this.isCacheable()) {
            if (connectionProvider.cacheValue == null) {
                connectionProvider.cacheValue = new CacheValue[connectionProvider.cursors.length];
                connectionProvider.cacheIterator = new Enumeration[connectionProvider.cursors.length];
            }
            CacheKey ckey = new CacheKey(sentence, params);
            CacheValue cacheValue = (CacheValue)CacheFactory.getInstance().get(CacheFactory.CACHE_DB, ckey.toString(), CacheValue.class);
            Enumeration cacheIterator = null;
            if (cacheValue != null && ckey.equals(cacheValue.getKey())) {
                cacheIterator = cacheValue.getIterator();
            }
            connectionProvider.cacheIterator[cursorNum] = cacheIterator;
            if (connectionProvider.cacheIterator[cursorNum] != null) {
                if (DebugFlag.DEBUG) {
                    ds.getLog().logComment((Object)this, "Using cached data for " + sentence);
                }
                this.isCaching = true;
                return hasValues;
            }
            connectionProvider.cacheValue[cursorNum] = CacheFactory.createCacheValue(sentence, params, this.cacheableLevel);
        }
        GXConnection con = (GXConnection)SentenceProvider.acquireConnection((AbstractDataStoreProviderBase)connectionProvider);
        this.mPreparedStatement = ((IServiceHelper)connectionProvider.getHelper()).getPreparedStatement(con, this.query, this, cursorNum, this.currentOf, params);
        if (this.fetchSize != 0) {
            this.mPreparedStatement.setFetchSize(this.fetchSize);
        }
        return hasValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postExecute(AbstractDataStoreProviderBase connectionProvider, AbstractDataSource ds) throws SQLException {
        switch (this.query.getQueryType()) {
            case QUERY: {
                if (this.isCaching) {
                    return;
                }
                GXResultSet newSet = (GXResultSet)this.mPreparedStatement.executeQuery(this.hold);
                Object object = this.syncResultSet;
                synchronized (object) {
                    this.rslt = newSet;
                    break;
                }
            }
            case INS: 
            case UPD: 
            case DLT: 
            case LINK: {
                this.status = this.mPreparedStatement.executeUpdate();
                break;
            }
            default: {
                throw new RuntimeException("Not implemented");
            }
        }
    }

    public boolean next(AbstractDataSource ds) throws SQLException {
        return this.isCaching || this.rslt.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() throws SQLException {
        Object object = this.syncResultSet;
        synchronized (object) {
            if (this.rslt != null) {
                this.rslt.close();
                this.rslt = null;
            }
        }
    }

    public void clearBuffers() {
        for (int i = this.buffers.length - 1; i >= 0; --i) {
            if (this.buffers[i] instanceof byte[]) {
                ((byte[])this.buffers[i])[0] = 0;
                continue;
            }
            if (this.buffers[i] instanceof short[]) {
                ((short[])this.buffers[i])[0] = 0;
                continue;
            }
            if (this.buffers[i] instanceof int[]) {
                ((int[])this.buffers[i])[0] = 0;
                continue;
            }
            if (this.buffers[i] instanceof long[]) {
                ((long[])this.buffers[i])[0] = 0L;
                continue;
            }
            if (this.buffers[i] instanceof float[]) {
                ((float[])this.buffers[i])[0] = 0.0f;
                continue;
            }
            if (this.buffers[i] instanceof double[]) {
                ((double[])this.buffers[i])[0] = 0.0;
                continue;
            }
            if (this.buffers[i] instanceof String[]) {
                ((String[])this.buffers[i])[0] = "";
                continue;
            }
            if (!(this.buffers[i] instanceof Date[])) continue;
            ((Date[])this.buffers[i])[0] = CommonUtil.nullDate();
        }
    }

    public boolean hasResult() {
        return this.rslt != null;
    }

    public boolean isCurrentOf() {
        return this.currentOf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GXResultSet getResultSet() {
        GXResultSet gXResultSet = this.rslt;
        synchronized (gXResultSet) {
            return this.rslt;
        }
    }
}

