/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db;

import com.genexus.GXSmartCacheProvider;
import com.genexus.LocalUtil;
import com.genexus.Messages;
import com.genexus.ModelContext;
import com.genexus.common.classes.AbstractGXConnection;
import com.genexus.common.classes.AbstractUserInformation;
import com.genexus.db.ConnectionInformation;
import com.genexus.db.DBConnection;
import com.genexus.db.DBConnectionManager;
import com.genexus.db.Namespace;
import com.genexus.db.driver.DataSource;
import com.genexus.db.driver.GXConnection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;

public abstract class UserInformation
extends AbstractUserInformation {
    private ConcurrentHashMap<String, Integer> orbHandles = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> properties = new ConcurrentHashMap();
    private ConcurrentHashMap<String, UserInformation> friendUserInformation;
    protected ConcurrentHashMap<String, ConnectionInformation> connections = new ConcurrentHashMap();
    private Object lockObject = new Object();
    protected Namespace namespace;
    protected LocalUtil localUtil;
    protected int handle;
    protected Messages messages;
    protected boolean autoDisconnect = true;
    protected long timestamp;
    private int remoteGXDBHandle = -1;
    protected boolean continueThread = true;
    protected boolean compressData = true;
    protected String serverUserId;
    private String lastSQL;
    private Date lastSQLDateTime;
    private boolean waiting = false;
    private Date waitingSince = null;
    private int lastConnectionUsed;
    private String lastObjectExecuted;
    GXSmartCacheProvider smartCacheProvider;

    public abstract void disconnectOnException() throws SQLException;

    public abstract void disconnect() throws SQLException;

    public abstract void flushBuffers(Object var1) throws SQLException;

    UserInformation() {
    }

    public UserInformation(Namespace namespace) {
        this.namespace = namespace;
        if (namespace == null) {
            throw new IllegalArgumentException("Null namespace");
        }
        Enumeration<DataSource> en = namespace.getDataSources();
        while (en.hasMoreElements()) {
            DataSource ds = en.nextElement();
            ConnectionInformation info = new ConnectionInformation();
            info.user = ds.defaultUser;
            info.password = ds.defaultPassword;
            this.connections.put(ds.name, info);
        }
    }

    public String getServerUserId() {
        return this.serverUserId;
    }

    public void setServerUserId(String serverUserId) {
        this.serverUserId = serverUserId;
    }

    public Enumeration<String> getProperties() {
        return this.properties.keys();
    }

    public String getProperty(String key) {
        String val = this.properties.get(key.toUpperCase());
        if (val == null) {
            return "";
        }
        return val;
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public void setHandle(int handle) {
        this.handle = handle;
    }

    public boolean getCompressData() {
        return this.compressData;
    }

    public void setCompressData(boolean compressData) {
        this.compressData = compressData;
    }

    public void setAutoDisconnect(boolean autoDisconnect) {
        this.autoDisconnect = autoDisconnect;
    }

    public boolean getAutodisconnect() {
        return this.autoDisconnect;
    }

    public void setLocalUtil(char decimalPoint, String dateFormat, String timeFormat, int firstYear2K, String language) {
        this.localUtil = LocalUtil.getLocalUtil((char)decimalPoint, (String)dateFormat, (String)timeFormat, (int)firstYear2K, (String)language);
        this.messages = this.localUtil.getMessages();
    }

    public void setUserAndPassword(String dataSourceName, String user, String password) {
        ConnectionInformation info = this.connections.putIfAbsent(dataSourceName, new ConnectionInformation(null, null, user, password));
        if (info != null) {
            info.user = user;
            info.password = password;
        }
    }

    protected void putConnection(String dataSourceName, GXConnection rwConnection, GXConnection roConnection, String user, String password) {
        this.connections.put(dataSourceName, new ConnectionInformation((AbstractGXConnection)rwConnection, (AbstractGXConnection)roConnection, user, password));
    }

    protected String getUser(String dataSource) {
        return this.connections.get((Object)dataSource).user;
    }

    protected String getPassword(String dataSource) {
        return this.connections.get((Object)dataSource).password;
    }

    public LocalUtil getLocalUtil() {
        return this.localUtil;
    }

    public Messages getMessages() {
        return this.messages;
    }

    public synchronized long getTimestamp() {
        return this.timestamp;
    }

    public synchronized void setTimestamp() {
        this.timestamp = System.currentTimeMillis();
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public int getHandle() {
        return this.handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRemoteHandle(int handle) {
        Object object = this.lockObject;
        synchronized (object) {
            Enumeration<String> en = this.orbHandles.keys();
            while (en.hasMoreElements()) {
                String location = en.nextElement();
                if (handle != this.orbHandles.get(location)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFriendUserInformation(Namespace friendNS) {
        Object object = this.lockObject;
        synchronized (object) {
            UserInformation friend;
            if (this.friendUserInformation == null) {
                this.friendUserInformation = new ConcurrentHashMap();
            }
            if ((friend = this.friendUserInformation.get(friendNS.getName())) == null) {
                friend = DBConnectionManager.getInstance().createUserInformation(friendNS);
                friend = this.friendUserInformation.putIfAbsent(friendNS.getName(), friend);
            }
            return friend.getHandle();
        }
    }

    public void setLastSQL(String sql) {
        this.lastSQL = sql;
        this.lastSQLDateTime = new Date();
    }

    public void setLastObjectExecuted(String object) {
        this.lastObjectExecuted = object;
    }

    public void setWaitingConnection(boolean waiting) {
        this.waitingSince = waiting ? new Date() : null;
        this.waiting = waiting;
    }

    public void setLastConnectionUsed(int connectionId) {
        this.lastConnectionUsed = connectionId;
    }

    public GXSmartCacheProvider getSmartCacheProvider() {
        if (this.smartCacheProvider == null) {
            this.smartCacheProvider = new GXSmartCacheProvider(this.handle);
        }
        return this.smartCacheProvider;
    }

    public String getLastSQL() {
        return this.lastSQL;
    }

    public String getLastObjectExecuted() {
        return this.lastObjectExecuted;
    }

    public Date getLastSQLDateTime() {
        return this.lastSQLDateTime;
    }

    public boolean getWaitingForConnection() {
        return this.waiting;
    }

    public Date getWaitingForConnectionSince() {
        return this.waitingSince;
    }

    public int getLastConnectionUsed() {
        return this.lastConnectionUsed;
    }

    protected void createConnectionBatch(ModelContext context, DBConnection dbc) throws SQLException {
        DataSource dataSource = dbc.dataSource;
        short showPrompt = dbc.getShowprompt();
        String user = dataSource.defaultUser;
        String password = dataSource.defaultPassword;
        ConnectionInformation info = new ConnectionInformation();
        info.user = user;
        info.password = password;
        info.rwConnection = new GXConnection(context, info.user, info.password, dataSource);
        this.connections.put(dataSource.name, info);
    }

    protected void testConnectionBatch(ModelContext context, int handle, DBConnection dbc) throws SQLException {
        DataSource dataSource = dbc.dataSource;
        String user = dataSource.defaultUser;
        String password = dataSource.defaultPassword;
        try (GXConnection con = new GXConnection(context, user, password, dataSource);){
            con.getJDBCConnection().close();
        }
    }
}

