/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db.driver;

import com.genexus.Application;
import com.genexus.CommonUtil;
import com.genexus.DebugFlag;
import com.genexus.ModelContext;
import com.genexus.PrivateUtilities;
import com.genexus.db.DBConnectionManager;
import com.genexus.db.driver.ConnectionPoolState;
import com.genexus.db.driver.DataSource;
import com.genexus.db.driver.GXConnection;
import com.genexus.db.driver.PoolDBConnectionState;
import com.genexus.management.ConnectionPoolJMX;
import com.genexus.xml.XMLWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class ConnectionPool {
    protected static final boolean DEBUG = DebugFlag.DEBUG;
    protected static final int RECYCLE_BY_CREATION = 1;
    protected static final int RECYCLE_BY_IDLE = 2;
    private final long WAIT_TIMEOUT = 30000L;
    protected DataSource dataSource;
    protected Vector<GXConnection> pool;
    protected String user;
    protected String password;
    protected int maxPoolSize;
    protected boolean unlimitedSize;
    protected String poolName;
    protected boolean recycleConnections;
    protected int recycleConnectionsType;
    protected long recycleConnectionsTime;
    private int brokenConnections;
    protected PoolDBConnectionState constate;
    private Object poolLock = new Object();
    private PrintStream out;
    int numberConnectionsCreated = 0;
    int numberConnectionsRecycled = 0;
    int numberConnectionsDeleted = 0;
    int numberRequest = 0;
    long timeFirstRequest;
    Date timeLastRequest;
    int numberUsersWaits = 0;
    int numberUsersWaiting = 0;
    Hashtable<Integer, Long> timeStartUserWait = new Hashtable();
    long maxTimeUserWait;
    float averageUserWaitingTime;
    ConnectionPoolJMX connectionPoolJMX;
    long UserMaxTimeWaitingBeforeNotif = 30000L;
    boolean enableNotifications = true;
    boolean notified = false;

    abstract GXConnection createConnection(ModelContext var1, int var2) throws SQLException;

    abstract GXConnection getSameConnection(int var1, boolean var2);

    abstract boolean isAvailable(GXConnection var1, int var2);

    abstract boolean isAvailableJMX(GXConnection var1);

    abstract boolean isReadOnly();

    abstract boolean isEnabled();

    ConnectionPool(DataSource dataSource, String user, String password) {
        this.pool = new Vector();
        this.dataSource = dataSource;
        this.user = user;
        this.password = password;
        this.constate = new PoolDBConnectionState();
        if (Application.isJMXEnabled()) {
            ConnectionPoolJMX.CreateConnectionPoolJMX(this);
        }
    }

    PoolDBConnectionState getDBConnectionState() {
        return this.constate;
    }

    void createPoolStartup() {
        if (this.dataSource.createPoolStartup && !this.unlimitedSize) {
            try {
                for (int i = 0; i < this.maxPoolSize; ++i) {
                    GXConnection con = this.createConnection(null, -1);
                    this.pool.addElement(con);
                    ++this.numberConnectionsCreated;
                }
            }
            catch (SQLException e) {
                System.err.println("Error creating " + this.poolName + " connections");
            }
        }
    }

    boolean mustRecycle(GXConnection con, boolean readOnly) {
        return this.recycleConnections && con.getPoolState().isRecyclable(readOnly) && (this.recycleConnectionsType == 1 && con.getConnectionTime() + this.recycleConnectionsTime < System.currentTimeMillis() || this.recycleConnectionsType == 2 && con.getTimeLastRequest().getTime() + this.recycleConnectionsTime < System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GXConnection getPoolConnection(int handle, boolean sticky) {
        Object object = this.poolLock;
        synchronized (object) {
            GXConnection con = this.getSameConnection(handle, sticky);
            if (con != null) {
                return con;
            }
            int idx = 0;
            while (idx < this.pool.size()) {
                con = this.pool.elementAt(idx);
                if (con.getError()) {
                    this.disconnectBrokenConnection(con);
                    continue;
                }
                if (!con.getPoolState().getInAssignment() && this.isAvailable(con, handle)) {
                    if (this.mustRecycle(con, this.isReadOnly())) {
                        if (DEBUG) {
                            this.log(con.getHandle(), "Dropping " + this.poolName + " by timeout connection " + con.hashCode());
                        }
                        this.dropUnusedConnection(con);
                        continue;
                    }
                    if (DEBUG) {
                        this.log(handle, "Reusing connection " + con.hashCode());
                    }
                    if (sticky) {
                        con.getPoolState().setInAssignment(true);
                        if (!this.constate.hasConnection(handle, con)) {
                            this.constate.addConnection(handle, con);
                        }
                        con.setHandle(handle);
                    }
                    return con;
                }
                ++idx;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection checkOut(ModelContext context, int handle, boolean sticky) throws SQLException {
        if (this.numberRequest == 0) {
            this.timeFirstRequest = System.currentTimeMillis();
        }
        ++this.numberRequest;
        this.timeLastRequest = new Date();
        boolean firstTimeWaiting = true;
        GXConnection con = null;
        while (con == null) {
            Object object = this.poolLock;
            synchronized (object) {
                con = this.getPoolConnection(handle, sticky);
                if (con == null && (this.unlimitedSize || this.pool.size() < this.maxPoolSize) && (con = this.createConnection(context, handle)) != null) {
                    this.pool.addElement(con);
                    ++this.numberConnectionsCreated;
                    if (sticky) {
                        con.getPoolState().setInAssignment(true);
                        con.setHandle(handle);
                        this.constate.addConnection(handle, con);
                    }
                }
                if (con == null) {
                    if (Application.isJMXEnabled() && this.enableNotifications) {
                        this.connectionPoolJMX.PoolIsFull();
                    }
                    DBConnectionManager.getInstance().getUserInformation(handle).setWaitingConnection(true);
                    if (DEBUG) {
                        this.log(handle, "Waiting for connection " + PrivateUtilities.getCurrentThreadId() + " unlimited " + this.unlimitedSize + " poolSize " + this.pool.size() + " maxPoolSize " + this.maxPoolSize);
                    }
                    if (firstTimeWaiting) {
                        ++this.numberUsersWaits;
                        ++this.numberUsersWaiting;
                        this.timeStartUserWait.put(new Integer(handle), new Long(System.currentTimeMillis()));
                        firstTimeWaiting = false;
                    } else if (Application.isJMXEnabled() && this.UserMaxTimeWaitingBeforeNotif < System.currentTimeMillis() - this.timeStartUserWait.get(new Integer(handle)) && this.enableNotifications) {
                        this.connectionPoolJMX.UserWaitingForLongTime();
                    }
                    this.notified = false;
                    while (!this.notified) {
                        try {
                            this.poolLock.wait(30000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (this.notified || !DEBUG) continue;
                        this.log(handle, "Still waiting for connection " + PrivateUtilities.getCurrentThreadId());
                    }
                    if (DEBUG) {
                        this.log(handle, "Stopped waiting for connection " + PrivateUtilities.getCurrentThreadId());
                    }
                }
                if (con != null) {
                    con.setHandle(handle);
                    if (DEBUG) {
                        this.log(con, handle, "Assigning connection to handle");
                    }
                }
            }
        }
        if (!firstTimeWaiting) {
            long userWait = System.currentTimeMillis() - this.timeStartUserWait.get(new Integer(handle));
            this.timeStartUserWait.remove(new Integer(handle));
            this.averageUserWaitingTime = (this.averageUserWaitingTime + (float)userWait) / (float)this.numberUsersWaits;
            if (userWait > this.maxTimeUserWait) {
                this.maxTimeUserWait = userWait;
            }
            --this.numberUsersWaiting;
        }
        DBConnectionManager.getInstance().getUserInformation(handle).setWaitingConnection(false);
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void statusChanged(ConnectionPoolState state) {
        Object object = this.poolLock;
        synchronized (object) {
            this.notified = true;
            this.poolLock.notifyAll();
        }
    }

    public Enumeration<GXConnection> getConnections() {
        return this.pool.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GXConnection getConnectionById(int id) {
        Object object = this.poolLock;
        synchronized (object) {
            for (int i = 0; i < this.pool.size(); ++i) {
                if (this.pool.elementAt(i).getId() != id) continue;
                return this.pool.elementAt(i);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropConnectionById(int id) throws SQLException {
        Object object = this.poolLock;
        synchronized (object) {
            int i = 0;
            while (i < this.pool.size()) {
                GXConnection con = this.pool.elementAt(i);
                if (con.getId() == id) {
                    this.pool.removeElementAt(i);
                    con.close();
                    ++this.numberConnectionsDeleted;
                    continue;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectBrokenConnection(GXConnection con) {
        try {
            this.log(con, 0, "Disconnecting connection with error");
            Object object = this.poolLock;
            synchronized (object) {
                this.pool.removeElement(con);
                ++this.numberConnectionsDeleted;
            }
            con.closeWithError();
        }
        catch (SQLException e) {
            System.err.println("Error closing connection " + con);
        }
        ++this.brokenConnections;
    }

    public int getBrokenConnectionCount() {
        return this.brokenConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropUnusedConnection(GXConnection con) {
        Object object = this.poolLock;
        synchronized (object) {
            this.pool.removeElement(con);
            ++this.numberConnectionsRecycled;
        }
        Thread connecionCloseThread = new Thread(new ConnecionCloseRunnable(con));
        connecionCloseThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect() throws SQLException {
        Object object = this.poolLock;
        synchronized (object) {
            for (int idx = 0; idx < this.pool.size(); ++idx) {
                this.pool.elementAt(idx).close();
            }
            this.pool = new Vector();
        }
    }

    public void disconnect(int handle) throws SQLException {
        this.constate.removeConnection(handle, !this.isEnabled());
    }

    void disconnectOnException(int handle) throws SQLException {
        this.constate.errorConnection(handle);
    }

    protected void log(int handle, String text) {
        if (DEBUG) {
            this.dataSource.getLog().logComment(1, handle, this.poolName + ": " + text);
        }
    }

    protected void log(Object source, int handle, String text) {
        if (DEBUG) {
            this.dataSource.getLog().log(1, source, handle, this.poolName + ": " + text);
        }
    }

    boolean getRecycleConnections() {
        return this.recycleConnections;
    }

    long getRecycleConnectionsTime() {
        return this.recycleConnectionsTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump() {
        try {
            if (this.out == null) {
                this.out = new PrintStream(new FileOutputStream("pool_" + CommonUtil.getYYYYMMDDHHMMSS_nosep((Date)new Date()) + ".log", true));
            }
            this.out.println("-> " + CommonUtil.getYYYYMMDDHHMMSS_nosep((Date)new Date()));
            this.out.println("Pool \t  : " + this.poolName + " " + this);
            this.out.println("DataSource: " + this.dataSource.getName() + " - user : " + this.user);
            this.out.println("Size \t  : max " + this.maxPoolSize + " current " + this.pool.size() + " unlimited " + this.unlimitedSize);
            this.out.println("Recycle   : " + this.recycleConnections + " time " + this.recycleConnectionsTime);
            Object object = this.poolLock;
            synchronized (object) {
                for (int i = 0; i < this.pool.size(); ++i) {
                    GXConnection con = this.pool.elementAt(i);
                    ConnectionPoolState state = con.getPoolState();
                    this.out.println(i + " " + con.hashCode() + " oc " + state.getOpenCursors() + " uc " + state.getUserCount() + " uncomm " + state.getUncommitedChanges() + " assign " + state.getInAssignment());
                    con.dump(this.out);
                }
            }
            this.constate.dump(this.out);
            this.out.println("<-");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void dumpJMX() {
        String fileName = "Pool_" + CommonUtil.getYYYYMMDDHHMMSS_nosep((Date)new Date()) + ".xml";
        XMLWriter writer = new XMLWriter();
        writer.xmlStart(fileName);
        writer.writeStartElement("ConnectionPool_Information");
        writer.writeElement("UnlimitedSize", new Boolean(this.getUnlimitedSize()).toString());
        writer.writeElement("Size", (long)this.getMaxPoolSize());
        writer.writeElement("ConnectionCount", (long)this.getActualPoolSize());
        writer.writeElement("FreeConnectionCount", (long)this.getFreeConnectionCount());
        writer.writeElement("CreatedConnectionCount", (long)this.getNumberConnectionsCreated());
        writer.writeElement("RecycledConnectionCount", (long)this.getNumberConnectionsRecycled());
        writer.writeElement("DroppedConnectionCount", (long)this.getNumberConnectionsDeleted());
        writer.writeElement("RequestCount", (long)this.getNumberRequest());
        writer.writeElement("AverageRequestPerSec", (double)this.getAverageNumberRequest());
        writer.writeElement("LastRequestTime", this.getTimeLastRequest().toString());
        writer.writeElement("WaitingUserCount", (long)this.getNumberUsersWaiting());
        writer.writeElement("WaitedUserCount", (long)this.getNumberUsersWaits());
        writer.writeElement("MaxUserWaitTime", this.getMaxUserWaitingTime());
        writer.writeElement("AverageUserWaitTime", (double)this.getAverageUserWaitingTime());
        for (int i = 0; i < this.pool.size(); ++i) {
            GXConnection con = this.pool.elementAt(i);
            con.dump(writer);
        }
        writer.writeEndElement();
        writer.close();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxPoolSize(int maxPoolSize) {
        if (this.unlimitedSize || maxPoolSize <= this.maxPoolSize) {
            return;
        }
        Object object = this.poolLock;
        synchronized (object) {
            this.maxPoolSize = maxPoolSize;
            this.notified = true;
            this.poolLock.notifyAll();
        }
    }

    public boolean getUnlimitedSize() {
        return this.unlimitedSize;
    }

    public int getActualPoolSize() {
        return this.pool.size();
    }

    public int getFreeConnectionCount() {
        GXConnection con = null;
        int freeConnections = 0;
        for (int idx = 0; idx < this.pool.size(); ++idx) {
            con = this.pool.elementAt(idx);
            if (!this.isAvailableJMX(con)) continue;
            ++freeConnections;
        }
        return freeConnections;
    }

    public int getNumberConnectionsCreated() {
        return this.numberConnectionsCreated;
    }

    public int getNumberConnectionsRecycled() {
        return this.numberConnectionsRecycled;
    }

    public int getNumberConnectionsDeleted() {
        return this.numberConnectionsDeleted;
    }

    public int getNumberRequest() {
        return this.numberRequest;
    }

    public float getAverageNumberRequest() {
        return (long)this.numberRequest / ((System.currentTimeMillis() - this.timeFirstRequest) / 1000L);
    }

    public Date getTimeLastRequest() {
        return this.timeLastRequest;
    }

    public int getNumberUsersWaits() {
        return this.numberUsersWaits;
    }

    public int getNumberUsersWaiting() {
        return this.numberUsersWaiting;
    }

    public long getMaxUserWaitingTime() {
        return this.maxTimeUserWait;
    }

    public float getAverageUserWaitingTime() {
        return this.averageUserWaitingTime;
    }

    public long getUserMaxTimeWaitingBeforeNotif() {
        return this.UserMaxTimeWaitingBeforeNotif;
    }

    public void setUserMaxTimeWaitingBeforeNotif(long value) {
        this.UserMaxTimeWaitingBeforeNotif = value;
    }

    public boolean getEnableNotifications() {
        return this.enableNotifications;
    }

    public void setEnableNotifications(boolean value) {
        this.enableNotifications = value;
    }

    public void dumpPoolInformation() {
        this.dumpJMX();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void PoolRecycle() {
        GXConnection con = null;
        Object object = this.poolLock;
        synchronized (object) {
            int poolSize = this.pool.size();
            int idx = 0;
            while (idx < poolSize) {
                con = this.pool.elementAt(0);
                if (con.getError()) {
                    this.disconnectBrokenConnection(con);
                    continue;
                }
                if (!con.getPoolState().getInAssignment() && this.isAvailable(con, 0)) {
                    if (DEBUG) {
                        this.log(con.getHandle(), "Dropping " + this.poolName + " by JMX Operation; connection " + con.hashCode());
                    }
                    this.dropUnusedConnection(con);
                }
                ++idx;
            }
        }
    }

    public void setConnectionPoolJMX(ConnectionPoolJMX connectionPoolJMX) {
        this.connectionPoolJMX = connectionPoolJMX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithLock(Runnable runnable) {
        Object object = this.poolLock;
        synchronized (object) {
            runnable.run();
        }
    }

    public void removeElement(GXConnection con) {
        this.pool.removeElement(con);
    }

    public class ConnecionCloseRunnable
    implements Runnable {
        private GXConnection con;

        public ConnecionCloseRunnable(GXConnection con) {
            this.con = con;
        }

        @Override
        public void run() {
            try {
                this.con.close();
            }
            catch (SQLException e) {
                System.err.println("Can't close connection " + this.con);
            }
        }
    }
}

