/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db.driver;

import com.genexus.db.driver.GXConnection;
import java.util.concurrent.atomic.AtomicInteger;

public class ConnectionPoolState {
    private GXConnection con;
    private volatile boolean inAssignment;
    private volatile boolean uncommitedChanges;
    private AtomicInteger userCount = new AtomicInteger(0);
    private Object commitedChangesLock = new Object();
    private Object inAssignmentLock = new Object();

    ConnectionPoolState(GXConnection con) {
        this.con = con;
    }

    GXConnection getConnection() {
        return this.con;
    }

    void incUserCount() {
        this.userCount.incrementAndGet();
    }

    void decUserCount() {
        this.userCount.decrementAndGet();
        this.statusChanged(true);
    }

    public int getUserCount() {
        return this.userCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setUncommitedChanges(boolean uncommitedChanges) {
        Object object = this.commitedChangesLock;
        synchronized (object) {
            this.uncommitedChanges = uncommitedChanges;
        }
        this.statusChanged(!uncommitedChanges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getUncommitedChanges() {
        Object object = this.commitedChangesLock;
        synchronized (object) {
            return this.uncommitedChanges;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInAssignment(boolean inAssignment) {
        Object object = this.inAssignmentLock;
        synchronized (object) {
            this.inAssignment = inAssignment;
        }
        if (!inAssignment) {
            this.statusChanged(!inAssignment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getInAssignment() {
        Object object = this.inAssignmentLock;
        synchronized (object) {
            return this.inAssignment;
        }
    }

    void closeCursor() {
        this.statusChanged(true);
    }

    void connectionError() {
        this.statusChanged(true);
    }

    int getOpenCursorsJMX() {
        return this.con.getOpenCursorsJMX();
    }

    int getOpenCursors() {
        return this.con.getOpenCursors();
    }

    public boolean isRWAvailableJMX() {
        return this.getOpenCursorsJMX() == 0 && !this.getUncommitedChanges();
    }

    public boolean isRWAvailable() {
        return this.getOpenCursors() == 0 && !this.getUncommitedChanges();
    }

    boolean isRecyclable(boolean readOnly) {
        return !this.getUncommitedChanges() && this.getOpenCursors() == 0 && (this.getUserCount() == 0 || !readOnly);
    }

    private void statusChanged(boolean better) {
        if (this.con.getPool() != null) {
            this.con.getPool().statusChanged(this);
        }
    }

    public String toString() {
        return "Cursors : " + this.getOpenCursors() + " | Users: " + this.userCount + " | Uncommited " + this.uncommitedChanges + " | Assignment " + this.inAssignment;
    }
}

