/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db.driver;

import com.genexus.DebugFlag;
import com.genexus.db.driver.CursorFactoryConstants;
import com.genexus.db.driver.GXConnection;
import com.genexus.db.driver.GXDBMSas400;
import com.genexus.db.driver.GXPreparedStatement;
import com.genexus.db.driver.IPreparedStatementCache;
import java.io.PrintStream;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Hashtable;

final class CursorFactory
implements IPreparedStatementCache {
    private static final boolean DEBUG = DebugFlag.DEBUG;
    String[] arrayIds;
    SQLCursorData[] data;
    long[] timeStamps;
    int maxSize;
    GXConnection jdbcConnection;
    Hashtable<PreparedStatement, SQLCursorData> preparedStatements;
    private int usedCursors;

    CursorFactory(int maxSize, GXConnection jdbcConnection) {
        if (maxSize > 2) {
            --maxSize;
        }
        this.usedCursors = 0;
        this.arrayIds = new String[maxSize];
        this.timeStamps = new long[maxSize];
        this.data = new SQLCursorData[maxSize];
        this.maxSize = maxSize;
        this.preparedStatements = new Hashtable();
        this.jdbcConnection = jdbcConnection;
    }

    @Override
    public synchronized int getUsedCursors() {
        return this.usedCursors;
    }

    @Override
    public int getUsedCursorsJMX() {
        return this.usedCursors;
    }

    private int dropOlderCursor() throws SQLException {
        long minTimeStamp = Long.MAX_VALUE;
        int index = -1;
        for (int i = this.maxSize - 1; i >= 0; --i) {
            if (this.timeStamps[i] >= minTimeStamp || this.timeStamps[i] == 0L || this.data[i].isInUse()) continue;
            minTimeStamp = this.timeStamps[i];
            index = i;
        }
        if (index == -1) {
            System.err.println("Error can't prepare more cursors \n You should increase the Maximum cursors per connection preference");
            if (DEBUG) {
                this.jdbcConnection.log(1, "Error can't prepare more cursors \n You should increase the Maximum cursors per connection preference");
            }
            throw new InternalError("Error can't prepare more cursors \n You should increase the Maximum cursors per connection preference");
        }
        this.data[index].getPreparedStatement().close();
        this.preparedStatements.remove(this.data[index].getPreparedStatement());
        if (DEBUG) {
            this.jdbcConnection.log(1, "GX: Dropping cursor " + this.arrayIds[index] + " - " + this.data[index].getSQLSentence());
        }
        this.data[index] = null;
        this.arrayIds[index] = null;
        this.timeStamps[index] = 0L;
        return index;
    }

    private PreparedStatement addElement(int handle, String cursorId, String sqlSentence, boolean currentOf, boolean callable) throws SQLException {
        int i;
        PreparedStatement statement = null;
        if (this.maxSize == 0) {
            if (callable) {
                return this.jdbcConnection.prepareCall(sqlSentence);
            }
            return this.jdbcConnection.prepareStatement(sqlSentence, handle, cursorId);
        }
        for (i = 0; i < this.maxSize && this.arrayIds[i] != null; ++i) {
        }
        if (i == this.maxSize) {
            i = this.dropOlderCursor();
        }
        statement = callable ? this.jdbcConnection.prepareCall(sqlSentence) : this.jdbcConnection.prepareStatement(sqlSentence, handle, cursorId);
        this.arrayIds[i] = cursorId;
        this.timeStamps[i] = System.currentTimeMillis();
        this.data[i] = new SQLCursorData(sqlSentence, statement);
        this.preparedStatements.put(statement, this.data[i]);
        if (DEBUG) {
            this.jdbcConnection.log(1, "GX: Preparing new cursor " + cursorId + " - " + sqlSentence);
        }
        if (currentOf && this.jdbcConnection.getDBMS() instanceof GXDBMSas400) {
            try {
                statement.setCursorName(cursorId);
            }
            catch (SQLException e) {
                this.data[i] = null;
                this.arrayIds[i] = null;
                this.timeStamps[i] = 0L;
                this.preparedStatements.remove(statement);
                throw e;
            }
        }
        ++this.usedCursors;
        ((GXPreparedStatement)statement).setHandle(handle);
        return statement;
    }

    @Override
    public CallableStatement getCallableStatement(int handle, String index, String sqlSentence) throws SQLException {
        return (CallableStatement)this.getStatement(handle, index, sqlSentence, false, true, false);
    }

    @Override
    public PreparedStatement getStatement(int handle, String index, String sqlSentence, boolean currentOf) throws SQLException {
        return this.getStatement(handle, index, sqlSentence, currentOf, false, false);
    }

    private void reprepareStatement(int handle, String index, String sqlSentence, boolean currentOf, boolean callable, int arrIdx) throws SQLException {
        this.data[arrIdx].getPreparedStatement().close();
        this.timeStamps[arrIdx] = System.currentTimeMillis();
        this.data[arrIdx] = new SQLCursorData(sqlSentence, callable ? this.jdbcConnection.prepareCall(sqlSentence) : this.jdbcConnection.prepareStatement(sqlSentence, handle, index));
        ++this.usedCursors;
        if (DEBUG) {
            this.jdbcConnection.log(1, "GX: Re preparing new cursor " + index + " - " + sqlSentence);
        }
    }

    @Override
    public synchronized PreparedStatement getStatement(int handle, String index, String sqlSentence, boolean currentOf, boolean callable, boolean batch) throws SQLException {
        int i;
        for (i = 0; !(i >= this.maxSize || this.arrayIds[i] != null && this.arrayIds[i].equals(index) && this.data[i].getSQLSentence().equals(sqlSentence) && !this.data[i].isInUse()); ++i) {
        }
        if (i == this.maxSize) {
            return this.addElement(handle, index, sqlSentence, currentOf, callable);
        }
        if (!this.data[i].getSQLSentence().equals(sqlSentence)) {
            this.reprepareStatement(handle, index, sqlSentence, currentOf, callable, i);
        }
        if (DEBUG) {
            this.jdbcConnection.log(1, "GX: Reusing cursor " + index + " - " + sqlSentence + " MaxSize " + this.maxSize);
        }
        this.timeStamps[i] = System.currentTimeMillis();
        ++this.usedCursors;
        ((GXPreparedStatement)this.data[i].getPreparedStatement()).setHandle(handle);
        return this.data[i].getPreparedStatement();
    }

    public synchronized PreparedStatement getStatement(int handle, int tableId, int operationId, String sqlSentence) throws SQLException {
        int i;
        String index = CursorFactoryConstants.calculateCursorId(tableId, operationId);
        for (i = 0; !(i >= this.maxSize || this.arrayIds[i] != null && this.arrayIds[i].equals(index) && this.data[i].getSQLSentence().equals(sqlSentence) && !this.data[i].isInUse()); ++i) {
        }
        if (i == this.maxSize) {
            return this.addElement(handle, index, sqlSentence, false, false);
        }
        this.timeStamps[i] = System.currentTimeMillis();
        if (DEBUG) {
            this.jdbcConnection.log(1, "GX: Reusing cursor TBL " + index + " - " + sqlSentence);
        }
        ++this.usedCursors;
        ((GXPreparedStatement)this.data[i].getPreparedStatement()).setHandle(handle);
        return this.data[i].getPreparedStatement();
    }

    @Override
    public synchronized void dropAllCursors() {
        for (int i = this.maxSize - 1; i >= 0; --i) {
            block4: {
                if (this.arrayIds[i] == null) continue;
                if (DEBUG) {
                    this.jdbcConnection.log(1, "GX: Drop All/Dropping cursor " + this.arrayIds[i] + " - " + this.data[i].getSQLSentence());
                }
                try {
                    this.data[i].getPreparedStatement().close();
                }
                catch (SQLException e) {
                    if (!DEBUG) break block4;
                    this.jdbcConnection.log(1, "Error dropping cursors " + this.arrayIds[i] + " - " + this.data[i].getSQLSentence());
                    this.jdbcConnection.logSQLException(-1, e);
                }
            }
            this.data[i] = null;
            this.arrayIds[i] = null;
            this.timeStamps[i] = 0L;
        }
        this.preparedStatements.clear();
        this.usedCursors = 0;
    }

    @Override
    public synchronized void freeAllCursors() {
        for (int i = this.maxSize - 1; i >= 0; --i) {
            if (this.arrayIds[i] == null || !this.data[i].isInUse()) continue;
            this.data[i].setNotInUse();
        }
        this.usedCursors = 0;
    }

    @Override
    public synchronized void dropCursor(GXPreparedStatement stmt) {
        if (stmt == null) {
            return;
        }
        this.setNotInUse(stmt);
        try {
            stmt.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.preparedStatements.remove(stmt);
    }

    @Override
    public synchronized void setNotInUse(GXPreparedStatement stmt) {
        if (stmt == null) {
            return;
        }
        if (this.maxSize == 0) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                System.err.println("can't close cursor");
            }
            return;
        }
        SQLCursorData data = this.preparedStatements.get(stmt);
        if (data != null) {
            data.setNotInUse();
            --this.usedCursors;
            if (DEBUG) {
                this.jdbcConnection.log(1, "GX: Setting cursor as unused " + data.getSQLSentence() + "/" + data.statement);
            }
        } else if (DEBUG) {
            this.jdbcConnection.log(1, "GX: Warning, trying to mark as unused an inexistent cursor");
        }
    }

    @Override
    public void dump(PrintStream out) {
        out.println("\tPreparedStatements : " + this.usedCursors + "/" + this.maxSize);
        for (int i = 0; i < this.maxSize; ++i) {
            if (this.arrayIds[i] == null) continue;
            out.println("\t\t" + i + " id: " + this.data[i].statement.hashCode() + " - gxid: " + this.arrayIds[i] + " - inuse: " + this.data[i].inUse);
        }
    }

    private class SQLCursorData {
        PreparedStatement statement;
        String sqlSentence;
        boolean inUse;

        SQLCursorData(String sqlSentence, PreparedStatement statement) {
            this.sqlSentence = sqlSentence;
            this.statement = statement;
            this.inUse = true;
        }

        String getSQLSentence() {
            return this.sqlSentence;
        }

        PreparedStatement getPreparedStatement() {
            this.inUse = true;
            return this.statement;
        }

        boolean isInUse() {
            return this.inUse;
        }

        void setNotInUse() {
            this.inUse = false;
        }
    }
}

