/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db.driver;

import com.genexus.Application;
import com.genexus.ApplicationContext;
import com.genexus.Preferences;
import com.genexus.common.classes.AbstractDataSource;
import com.genexus.db.driver.ConnectionPool;
import com.genexus.db.driver.DataSourceConnectionPool;
import com.genexus.db.driver.DirectConnectionPool;
import com.genexus.db.driver.GXConnection;
import com.genexus.db.driver.GXDBDebug;
import com.genexus.db.driver.GXDBMS;
import com.genexus.db.driver.IConnectionPool;
import com.genexus.db.driver.JDBCLogConfig;
import com.genexus.diagnostics.core.ILogger;
import com.genexus.diagnostics.core.LogManager;
import com.genexus.util.GXService;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class DataSource
extends AbstractDataSource {
    public static final ILogger logger = LogManager.getLogger(DataSource.class);
    public static String INFORMIX_DB_ANSI = "ANSI";
    public static String INFORMIX_DB_LOGGED = "Logged";
    public static String INFORMIX_DB_NOTLOGGED = "NotLogged";
    private GXDBDebug debugLog;
    public String defaultUser;
    public String defaultPassword;
    public String jdbcDriver;
    public String jdbcUrl;
    public String jdbcAS400Lib;
    public String jdbcDBName;
    public boolean jdbcLogEnabled;
    public int jdbcIsolationLevel;
    public boolean jdbcIntegrity;
    public String dbmsName;
    public String informixDB;
    public int maxCursors;
    public String schema;
    public boolean initializeNew;
    public GXDBMS dbms;
    public int rwPoolSize;
    public boolean rwPoolSizeUnlimited;
    public boolean forceAutocommit;
    public int roPoolSize;
    public boolean roPoolSizeUnlimited;
    public int roPoolUsers;
    public boolean createPoolStartup;
    public boolean connectStartup;
    public boolean roPoolEnabled;
    private boolean rwPoolEnabled;
    private boolean roPoolRecycle;
    private int roPoolRecycleMins;
    private boolean rwPoolRecycle;
    private int rwPoolRecycleMins;
    private int rwPoolRecycleType;
    public int waitRecord;
    public int lockRetryCount;
    public boolean loginInServer;
    private JDBCLogConfig jdbcLogCfg;
    private IConnectionPool connectionPool;
    private Hashtable<String, IConnectionPool> connectionPools;
    private String as400Package = "";
    private String as400DateType = "";
    public boolean useJdbcDataSource;
    private boolean useMultiJdbcDataSource;
    public String MultiJdbcDataSourceProc;
    public String jdbcDataSource;
    private String namespace;

    public DataSource(String name, String jdbcDriver, String jdbcUrl, String jdbcUser, String jdbcPassword, JDBCLogConfig jdbcLogCfg, boolean useJdbcDataSource, boolean useMultiJdbcDataSource, String MultiJdbcDataSourceProc, String jdbcDataSource, int maxCursors, int jdbcIsolationLevel, boolean jdbcIntegrity, String dbmsName, String schema, boolean initializeNew, String jdbcAS400Lib, String jdbcDBName, int waitRecord, int lockRetryCount, boolean loginInServer, int rwPoolSize, boolean rwPoolSizeUnlimited, boolean roPoolEnabled, int roPoolSize, boolean roPoolSizeUnlimited, int roPoolUsers, boolean createPoolStartup, boolean forceAutocommit, boolean connectStartup, boolean rwPoolEnabled, boolean roPoolRecycle, int roPoolRecycleMins, boolean rwPoolRecycle, int rwPoolRecycleMins, int rwPoolRecycleType) {
        this(name, jdbcDriver, jdbcUrl, jdbcUser, jdbcPassword, jdbcLogCfg, useJdbcDataSource, useMultiJdbcDataSource, MultiJdbcDataSourceProc, jdbcDataSource, maxCursors, jdbcIsolationLevel, jdbcIntegrity, dbmsName, schema, initializeNew, jdbcAS400Lib, jdbcDBName, waitRecord, lockRetryCount, loginInServer, rwPoolSize, rwPoolSizeUnlimited, roPoolEnabled, roPoolSize, roPoolSizeUnlimited, roPoolUsers, createPoolStartup, forceAutocommit, connectStartup, rwPoolEnabled, roPoolRecycle, roPoolRecycleMins, rwPoolRecycle, rwPoolRecycleMins, rwPoolRecycleType, true);
    }

    public DataSource(String name, String jdbcDriver, String jdbcUrl, String jdbcUser, String jdbcPassword, JDBCLogConfig jdbcLogCfg, boolean useJdbcDataSource, boolean useMultiJdbcDataSource, String MultiJdbcDataSourceProc, String jdbcDataSource, int maxCursors, int jdbcIsolationLevel, boolean jdbcIntegrity, String dbmsName, String schema, boolean initializeNew, String jdbcAS400Lib, String jdbcDBName, int waitRecord, int lockRetryCount, boolean loginInServer, int rwPoolSize, boolean rwPoolSizeUnlimited, boolean roPoolEnabled, int roPoolSize, boolean roPoolSizeUnlimited, int roPoolUsers, boolean createPoolStartup, boolean forceAutocommit, boolean connectStartup, boolean rwPoolEnabled, boolean roPoolRecycle, int roPoolRecycleMins, boolean rwPoolRecycle, int rwPoolRecycleMins, int rwPoolRecycleType, boolean init) {
        this.name = name;
        this.jdbcDriver = jdbcDriver;
        this.jdbcUrl = jdbcUrl;
        this.defaultUser = jdbcUser;
        this.defaultPassword = jdbcPassword;
        this.jdbcLogCfg = jdbcLogCfg;
        this.useJdbcDataSource = useJdbcDataSource;
        this.useMultiJdbcDataSource = useMultiJdbcDataSource;
        this.MultiJdbcDataSourceProc = MultiJdbcDataSourceProc;
        this.jdbcDataSource = jdbcDataSource;
        this.jdbcIsolationLevel = jdbcIsolationLevel;
        this.jdbcIntegrity = jdbcIntegrity;
        this.maxCursors = maxCursors;
        this.schema = schema;
        this.initializeNew = initializeNew;
        this.jdbcAS400Lib = jdbcAS400Lib;
        this.jdbcDBName = jdbcDBName;
        this.rwPoolSize = rwPoolSize;
        this.rwPoolEnabled = rwPoolSize == 0 ? false : rwPoolEnabled;
        this.rwPoolSizeUnlimited = this.rwPoolEnabled ? rwPoolSizeUnlimited : true;
        this.roPoolEnabled = roPoolSize == 0 ? false : roPoolEnabled;
        this.roPoolSize = roPoolSize;
        this.roPoolSizeUnlimited = roPoolEnabled ? roPoolSizeUnlimited : true;
        this.roPoolUsers = roPoolUsers;
        this.createPoolStartup = createPoolStartup;
        this.forceAutocommit = forceAutocommit;
        this.connectStartup = connectStartup;
        this.roPoolRecycle = roPoolRecycle;
        this.roPoolRecycleMins = roPoolRecycleMins;
        this.rwPoolRecycle = rwPoolRecycle;
        this.rwPoolRecycleMins = rwPoolRecycleMins;
        this.rwPoolRecycleType = rwPoolRecycleType;
        this.waitRecord = waitRecord;
        this.loginInServer = loginInServer;
        this.dbmsName = dbmsName;
        this.lockRetryCount = lockRetryCount;
        if (init) {
            this.init();
        }
    }

    private void init() {
        this.setDBMS(this.dbmsName);
        this.dbms.setDatabaseName(this.jdbcDBName);
        if (this.forceAutocommit) {
            this.dbms.setInReorg();
        }
        if (this.maxCursors <= 0) {
            throw new InternalError("The preference Maximum open cursors per connection has an invalid value (0)");
        }
        this.connectionPools = new Hashtable();
    }

    public void initialize() {
        if (this.createPoolStartup) {
            System.err.println("Started to create connection pool ...");
            this.getConnectionPool();
            System.err.println("Finished to create connection pool.");
        }
    }

    public void cleanup() throws SQLException {
        this.getConnectionPool().disconnect();
        if (this.connectionPools.size() > 0) {
            Enumeration<IConnectionPool> en = this.connectionPools.elements();
            while (en.hasMoreElements()) {
                en.nextElement().disconnect();
            }
        }
        if (this.getLog() != null) {
            if (this.jdbcLogCfg.getLevel() == 2) {
                this.getLog().close(2);
            } else {
                this.getLog().close(1);
            }
        }
    }

    void setConnectionLog(GXConnection con) {
        if (this.jdbcLogCfg.getLevel() == 2) {
            this.jdbcLogCfg.setConnectionName(Integer.toString(con.hashCode()));
            con.setLog(new GXDBDebug(this.jdbcLogCfg));
        } else {
            con.setLog(this.getLog());
        }
    }

    public int getLockRetryCount() {
        return this.dbms.getLockRetryCount(this.lockRetryCount, this.waitRecord);
    }

    public GXDBDebug getLog() {
        return this.debugLog;
    }

    public void setLog(GXDBDebug debugLog) {
        this.debugLog = debugLog;
    }

    public void setInformixDB(String informixDB) {
        this.informixDB = informixDB;
    }

    public String getInformixDB() {
        return this.informixDB;
    }

    public void setAS400Package(String as400Package) {
        this.as400Package = as400Package;
    }

    public String getAS400Package() {
        return this.as400Package;
    }

    public void setAS400DateType(String as400DateType) {
        this.as400DateType = as400DateType;
    }

    public String getAS400DateType() {
        return this.as400DateType;
    }

    private void setDBMS(String dbmsName) {
        String className = "com.genexus.db.driver.GXDBMS" + dbmsName.toLowerCase();
        try {
            this.dbms = (GXDBMS)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new InternalError("Unrecognized DBMS in configuration file : " + dbmsName + " / " + className);
        }
        GXService providerService = Application.getGXServices().get("DataAccess");
        if (providerService != null) {
            String providerClassName = providerService.getClassName();
            try {
                logger.info("Loading providerService:" + providerClassName);
                this.dbms = (GXDBMS)Class.forName(providerClassName).getConstructor(GXDBMS.class).newInstance(this.dbms);
            }
            catch (Exception ex) {
                logger.error("Couldn't create DATA_ACCESS_PROVIDER as : " + providerClassName, (Throwable)ex);
            }
        }
    }

    public synchronized IConnectionPool getConnectionPool() {
        if (this.connectionPool == null) {
            this.connectionPool = this.useGXConnectionPool() ? new DataSourceConnectionPool(this) : new DirectConnectionPool(this);
        }
        return this.connectionPool;
    }

    public IConnectionPool getConnectionPool(int handle) {
        if (this.connectionPools.size() == 0) {
            return this.getConnectionPool();
        }
        Enumeration<IConnectionPool> en = this.connectionPools.elements();
        while (en.hasMoreElements()) {
            IConnectionPool iconnPool = en.nextElement();
            Enumeration en1 = iconnPool.getRWPools();
            while (en1.hasMoreElements()) {
                String user = (String)en1.nextElement();
                ConnectionPool connPool = iconnPool.getRWConnectionPool(user);
                Enumeration<GXConnection> en2 = connPool.getConnections();
                while (en2.hasMoreElements()) {
                    if (en2.nextElement().getHandle() != handle) continue;
                    return iconnPool;
                }
            }
        }
        return this.getConnectionPool();
    }

    public void setConnectionPool(IConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    public synchronized Hashtable<String, IConnectionPool> getConnectionPools() {
        return this.connectionPools;
    }

    public void setConnectionPools(Hashtable<String, IConnectionPool> connectionPools) {
        this.connectionPools = connectionPools;
    }

    public synchronized IConnectionPool getConnectionPool(String connectionString) {
        IConnectionPool connPool = this.connectionPools.get(connectionString);
        if (connPool == null) {
            connPool = new DataSourceConnectionPool(this);
            this.connectionPools.put(connectionString, connPool);
        }
        return connPool;
    }

    public boolean usesJdbcDataSource() {
        if (ApplicationContext.getInstance().getEJB()) {
            try {
                InitialContext initCtx = new InitialContext();
                String trnType = (String)initCtx.lookup("java:comp/env/GX/TrnType");
                if (trnType.equals("CONTAINER")) {
                    return true;
                }
            }
            catch (NamingException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.useJdbcDataSource;
    }

    public boolean usesMultiJdbcDataSource() {
        return this.useMultiJdbcDataSource;
    }

    public boolean useGXConnectionPool() {
        return !this.usesJdbcDataSource() || Preferences.getDefaultPreferences().getREMOTE_CALLS() == 10;
    }

    public void disconnect(int handle) throws SQLException {
        if (this.connectionPools.size() == 0) {
            this.getConnectionPool().disconnect(handle);
        } else {
            Enumeration<IConnectionPool> en = this.connectionPools.elements();
            while (en.hasMoreElements()) {
                IConnectionPool iconnPool = en.nextElement();
                Enumeration en1 = iconnPool.getRWPools();
                while (en1.hasMoreElements()) {
                    String user = (String)en1.nextElement();
                    ConnectionPool connPool = iconnPool.getRWConnectionPool(user);
                    Enumeration<GXConnection> en2 = connPool.getConnections();
                    while (en2.hasMoreElements()) {
                        if (en2.nextElement().getHandle() != handle) continue;
                        connPool.disconnect(handle);
                        return;
                    }
                }
            }
            this.getConnectionPool().disconnect(handle);
        }
    }

    public void disconnectOnException(int handle) throws SQLException {
        if (this.connectionPools.size() == 0) {
            this.getConnectionPool().disconnectOnException(handle);
        } else {
            Enumeration<IConnectionPool> en = this.connectionPools.elements();
            while (en.hasMoreElements()) {
                ConnectionPool connPool = (ConnectionPool)((Object)en.nextElement());
                Enumeration<GXConnection> en1 = connPool.getConnections();
                while (en1.hasMoreElements()) {
                    if (en1.nextElement().getHandle() != handle) continue;
                    connPool.disconnectOnException(handle);
                    return;
                }
            }
            this.getConnectionPool().disconnectOnException(handle);
        }
    }

    public void flushBuffers(int handle, Object o) throws SQLException {
        if (this.connectionPools.size() == 0) {
            this.getConnectionPool().flushBuffers(handle, o);
        } else {
            Enumeration<IConnectionPool> en = this.connectionPools.elements();
            while (en.hasMoreElements()) {
                ConnectionPool connPool = (ConnectionPool)((Object)en.nextElement());
                Enumeration<GXConnection> en1 = connPool.getConnections();
                while (en1.hasMoreElements()) {
                    GXConnection conn = en1.nextElement();
                    if (conn.getHandle() != handle) continue;
                    conn.flushBatchCursors(o);
                }
            }
        }
    }

    public boolean getRWPoolEnabled() {
        return this.rwPoolEnabled;
    }

    public boolean getROPoolEnabled() {
        return this.roPoolEnabled;
    }

    public boolean getROPoolRecycle() {
        return this.roPoolRecycle;
    }

    public int getROPoolRecycleMins() {
        return this.roPoolRecycleMins;
    }

    public boolean getRWPoolRecycle() {
        return this.rwPoolRecycle;
    }

    public int getRWPoolRecycleMins() {
        return this.rwPoolRecycleMins;
    }

    public int getRWPoolRecycleType() {
        return this.rwPoolRecycleType;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public DataSource copy() {
        DataSource copyDataSource = new DataSource(this.name, this.jdbcDriver, this.jdbcUrl, this.defaultUser, this.defaultPassword, this.jdbcLogCfg, this.useJdbcDataSource, this.useMultiJdbcDataSource, this.MultiJdbcDataSourceProc, this.jdbcDataSource, this.maxCursors, this.jdbcIsolationLevel, this.jdbcIntegrity, this.dbmsName, this.schema, this.initializeNew, this.jdbcAS400Lib, this.jdbcDBName, this.waitRecord, this.lockRetryCount, this.loginInServer, this.rwPoolSize, this.rwPoolSizeUnlimited, this.roPoolEnabled, this.roPoolSize, this.roPoolSizeUnlimited, this.roPoolUsers, this.createPoolStartup, this.forceAutocommit, this.connectStartup, this.rwPoolEnabled, this.roPoolRecycle, this.roPoolRecycleMins, this.rwPoolRecycle, this.rwPoolRecycleMins, this.rwPoolRecycleType, false);
        copyDataSource.setLog(this.getLog());
        copyDataSource.jdbcLogEnabled = this.jdbcLogEnabled;
        copyDataSource.setInformixDB(this.getInformixDB());
        copyDataSource.dbms = this.dbms;
        copyDataSource.setAS400Package(this.getAS400Package());
        copyDataSource.setAS400DateType(this.getAS400DateType());
        copyDataSource.setNamespace(this.getNamespace());
        copyDataSource.setConnectionPool(this.getConnectionPool());
        copyDataSource.setConnectionPools(this.getConnectionPools());
        return copyDataSource;
    }

    public String[] concatOp() {
        switch (this.dbms.getId()) {
            case 3: {
                return new String[]{"", " CONCAT ", ""};
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                return new String[]{"", " || ", ""};
            }
            case 8: 
            case 11: {
                return new String[]{"", " + ", ""};
            }
        }
        return new String[]{"CONCAT(", ", ", ")"};
    }

    public void ROPoolRecycle() {
        if (this.getConnectionPool().getROConnectionPool(this.defaultUser) != null) {
            this.getConnectionPool().getROConnectionPool(this.defaultUser).PoolRecycle();
        }
    }

    public void RWPoolRecycle() {
        if (this.getConnectionPool().getRWConnectionPool(this.defaultUser) != null) {
            this.getConnectionPool().getRWConnectionPool(this.defaultUser).PoolRecycle();
        }
    }
}

