/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db.driver;

import com.genexus.ModelContext;
import com.genexus.db.driver.ConnectionPool;
import com.genexus.db.driver.DataSource;
import com.genexus.db.driver.GXConnection;
import com.genexus.db.driver.IConnectionPool;
import com.genexus.db.driver.ReadOnlyConnectionPool;
import com.genexus.db.driver.ReadWriteConnectionPool;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;

public final class DataSourceConnectionPool
implements IConnectionPool {
    private DataSource dataSource;
    private ConcurrentHashMap<String, ConnectionPool> readOnlyPools;
    private ConcurrentHashMap<String, ConnectionPool> readWritePools;
    private boolean readOnlyPoolEnabled;

    DataSourceConnectionPool(DataSource dataSource) {
        this.dataSource = dataSource;
        this.readWritePools = new ConcurrentHashMap();
        this.readOnlyPoolEnabled = dataSource.roPoolEnabled;
        this.readOnlyPools = new ConcurrentHashMap();
    }

    @Override
    public Enumeration<String> getROPools() {
        return this.readOnlyPools.keys();
    }

    @Override
    public Enumeration<String> getRWPools() {
        return this.readWritePools.keys();
    }

    @Override
    public ConnectionPool getROConnectionPool(String user) {
        return this.readOnlyPools.get(user);
    }

    @Override
    public ConnectionPool getRWConnectionPool(String user) {
        return this.readWritePools.get(user);
    }

    private ConnectionPool newConnectionPool(DataSource dataSource1, String user, String password, boolean readOnly) {
        if (dataSource1 == null) {
            dataSource1 = this.dataSource;
        }
        ConnectionPool pool = readOnly ? new ReadOnlyConnectionPool(dataSource1, user, password) : new ReadWriteConnectionPool(dataSource1, user, password);
        return pool;
    }

    @Override
    public Connection checkOut(ModelContext context, DataSource dataSource1, int handle, String user, String password, boolean readOnly, boolean sticky) throws SQLException {
        ConnectionPool previousPool;
        String key;
        ConnectionPool pool = null;
        ConcurrentHashMap<String, ConnectionPool> connectionPools = this.readOnlyPoolEnabled && readOnly ? this.readOnlyPools : this.readWritePools;
        pool = connectionPools.get(key = user + password);
        if (pool == null && (previousPool = connectionPools.putIfAbsent(key, pool = this.newConnectionPool(dataSource1, user, password, this.readOnlyPoolEnabled && readOnly))) != null) {
            pool = previousPool;
        }
        return pool.checkOut(context, handle, sticky);
    }

    @Override
    public void disconnectOnException(int handle) throws SQLException {
        Enumeration<ConnectionPool> en = this.readWritePools.elements();
        while (en.hasMoreElements()) {
            en.nextElement().disconnectOnException(handle);
        }
        en = this.readOnlyPools.elements();
        while (en.hasMoreElements()) {
            en.nextElement().disconnectOnException(handle);
        }
    }

    @Override
    public void disconnect(int handle) throws SQLException {
        SQLException disconnectException = null;
        Enumeration<ConnectionPool> en = this.readWritePools.elements();
        while (en.hasMoreElements()) {
            try {
                en.nextElement().disconnect(handle);
            }
            catch (SQLException e) {
                disconnectException = e;
            }
        }
        en = this.readOnlyPools.elements();
        while (en.hasMoreElements()) {
            try {
                en.nextElement().disconnect(handle);
            }
            catch (SQLException e) {
                disconnectException = e;
            }
        }
        if (disconnectException != null) {
            throw disconnectException;
        }
    }

    @Override
    public void disconnect() throws SQLException {
        Enumeration<ConnectionPool> en = this.readWritePools.elements();
        while (en.hasMoreElements()) {
            en.nextElement().disconnect();
        }
        en = this.readOnlyPools.elements();
        while (en.hasMoreElements()) {
            en.nextElement().disconnect();
        }
    }

    @Override
    public void flushBuffers(int handle, Object o) throws SQLException {
        GXConnection conn;
        Enumeration<GXConnection> en1;
        ConnectionPool connPool;
        Enumeration<ConnectionPool> en = this.readWritePools.elements();
        while (en.hasMoreElements()) {
            connPool = en.nextElement();
            en1 = connPool.getConnections();
            while (en1.hasMoreElements()) {
                conn = en1.nextElement();
                if (conn.getHandle() != handle) continue;
                conn.flushBatchCursors(o);
            }
        }
        en = this.readOnlyPools.elements();
        while (en.hasMoreElements()) {
            connPool = en.nextElement();
            en1 = connPool.getConnections();
            while (en1.hasMoreElements()) {
                conn = en1.nextElement();
                if (conn.getHandle() != handle) continue;
                conn.flushBatchCursors(o);
            }
        }
    }

    @Override
    public void runWithLock(Runnable runnable) {
        Enumeration<ConnectionPool> en = this.readWritePools.elements();
        while (en.hasMoreElements()) {
            en.nextElement().runWithLock(runnable);
        }
        en = this.readOnlyPools.elements();
        while (en.hasMoreElements()) {
            en.nextElement().runWithLock(runnable);
        }
    }

    @Override
    public void removeElement(GXConnection con) {
        Enumeration<ConnectionPool> en = this.readWritePools.elements();
        while (en.hasMoreElements()) {
            en.nextElement().removeElement(con);
        }
        en = this.readOnlyPools.elements();
        while (en.hasMoreElements()) {
            en.nextElement().removeElement(con);
        }
    }
}

