/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db.driver;

import com.genexus.DebugFlag;
import com.genexus.db.driver.GXConnection;
import com.genexus.db.driver.GXDBMSas400;
import com.genexus.db.driver.GXPreparedStatement;
import com.genexus.db.driver.IPreparedStatementCache;
import java.io.PrintStream;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;

public class DirectPreparedStatement
implements IPreparedStatementCache {
    private static final boolean DEBUG = DebugFlag.DEBUG;
    private GXConnection jdbcConnection;
    private Vector<GXPreparedStatement> activeStatements;

    DirectPreparedStatement(GXConnection jdbcConnection) {
        this.jdbcConnection = jdbcConnection;
        this.activeStatements = new Vector();
    }

    @Override
    public CallableStatement getCallableStatement(int handle, String index, String sqlSentence) throws SQLException {
        return (CallableStatement)this.getStatement(handle, index, sqlSentence, false, true, false);
    }

    @Override
    public int getUsedCursors() {
        return 0;
    }

    @Override
    public int getUsedCursorsJMX() {
        return 0;
    }

    @Override
    public PreparedStatement getStatement(int handle, String index, String sqlSentence, boolean currentOf) throws SQLException {
        return this.getStatement(handle, index, sqlSentence, currentOf, false, false);
    }

    private GXPreparedStatement createStatement(int handle, String cursorId, String sqlSentence, boolean currentOf, boolean callable) throws SQLException {
        GXPreparedStatement stmt = (GXPreparedStatement)(callable ? this.jdbcConnection.prepareCall(sqlSentence) : this.jdbcConnection.prepareStatement(sqlSentence, handle, cursorId));
        if (currentOf && this.jdbcConnection.getDBMS() instanceof GXDBMSas400) {
            stmt.setCursorName(cursorId);
        }
        this.activeStatements.addElement(stmt);
        return stmt;
    }

    @Override
    public synchronized PreparedStatement getStatement(int handle, String index, String sqlSentence, boolean currentOf, boolean callable, boolean batch) throws SQLException {
        return this.createStatement(handle, index, sqlSentence, currentOf, callable);
    }

    @Override
    public synchronized void dropAllCursors() {
        Enumeration<GXPreparedStatement> enum1 = this.activeStatements.elements();
        while (enum1.hasMoreElements()) {
            GXPreparedStatement stmt = enum1.nextElement();
            if (DEBUG) {
                this.jdbcConnection.log(1, "GX: Drop All/Dropping cursor - " + stmt.getSqlStatement());
            }
            try {
                stmt.close();
            }
            catch (SQLException e) {
                System.err.println("can't close cursor");
            }
        }
        this.activeStatements.removeAllElements();
    }

    @Override
    public synchronized void freeAllCursors() {
    }

    @Override
    public synchronized void dropCursor(GXPreparedStatement stmt) {
        if (stmt == null) {
            return;
        }
        this.setNotInUse(stmt);
    }

    @Override
    public synchronized void setNotInUse(GXPreparedStatement stmt) {
        if (stmt == null) {
            return;
        }
        if (stmt.isBatch() || stmt.getSkipSetBlobs()) {
            return;
        }
        this.activeStatements.removeElement(stmt);
        if (DEBUG) {
            this.jdbcConnection.log(1, "GX: Marking cursor as unused [" + this.activeStatements.size() + "] - " + stmt.getSqlStatement());
        }
        try {
            stmt.close();
        }
        catch (SQLException e) {
            System.err.println("can't close cursor");
        }
    }

    @Override
    public void dump(PrintStream out) {
    }
}

