/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db.driver;

import com.genexus.DebugFlag;
import com.genexus.db.driver.GXConnection;
import com.genexus.db.driver.GXPreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import org.apache.commons.collections4.map.LinkedMap;

public class FreeStatementList {
    private LinkedMap<String, StatementList> freeCache;
    private GXConnection jdbcConnection;
    private int statementCount;
    private Object objectLock = new Object();
    private static final boolean DEBUG = DebugFlag.DEBUG;

    FreeStatementList(int maxSize, GXConnection jdbcConnection) {
        this.freeCache = new LinkedMap(maxSize);
        this.jdbcConnection = jdbcConnection;
        this.statementCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int size() {
        Object object = this.objectLock;
        synchronized (object) {
            return this.statementCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(GXPreparedStatement stmt) {
        String sqlStatement = stmt.getCacheId(this.jdbcConnection);
        Object object = this.objectLock;
        synchronized (object) {
            StatementList sl = (StatementList)this.freeCache.get((Object)sqlStatement);
            boolean firstsql = false;
            if (sl == null) {
                firstsql = true;
                sl = new StatementList();
                this.freeCache.put((Object)sqlStatement, (Object)sl);
            }
            if (!stmt.isBatch() || firstsql) {
                sl.push(stmt);
                ++this.statementCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(GXPreparedStatement stmt) {
        String sqlStatement = stmt.getCacheId(this.jdbcConnection);
        Object object = this.objectLock;
        synchronized (object) {
            StatementList sl = (StatementList)this.freeCache.get((Object)sqlStatement);
            if (sl != null) {
                this.statementCount -= sl.size();
                this.freeCache.remove((Object)sqlStatement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeOlder() {
        StatementList statementList = null;
        Object object = this.objectLock;
        synchronized (object) {
            statementList = (StatementList)this.freeCache.get(this.freeCache.firstKey());
            if (((GXPreparedStatement)statementList.firstElement()).isBatch() && ((GXPreparedStatement)statementList.firstElement()).getRecordCount() > 0) {
                if (this.freeCache.size() == 1) {
                    return false;
                }
                statementList = (StatementList)this.freeCache.get(this.freeCache.get(1));
            }
            this.freeCache.remove((Object)((GXPreparedStatement)statementList.peek()).getCacheId(this.jdbcConnection));
            this.statementCount -= statementList.size();
        }
        statementList.popAndCloseStatements();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GXPreparedStatement popSentence(StatementList sl) {
        Object object = this.objectLock;
        synchronized (object) {
            GXPreparedStatement stmt = (GXPreparedStatement)sl.pop();
            --this.statementCount;
            if (sl.size() == 0) {
                this.freeCache.remove((Object)stmt.getCacheId(this.jdbcConnection));
            }
            return stmt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GXPreparedStatement get(String sqlSentence) {
        Object object = this.objectLock;
        synchronized (object) {
            StatementList sl = (StatementList)this.freeCache.get((Object)sqlSentence);
            return sl == null ? null : this.popSentence(sl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeAll() throws SQLException {
        ArrayList<StatementList> lists = new ArrayList<StatementList>();
        Iterator iterator = this.objectLock;
        synchronized (iterator) {
            Iterator i = this.freeCache.values().iterator();
            while (i.hasNext()) {
                lists.add((StatementList)i.next());
            }
            this.freeCache.clear();
            this.statementCount = 0;
        }
        for (StatementList list : lists) {
            list.popAndCloseStatements();
        }
    }

    class StatementList
    extends Stack<GXPreparedStatement> {
        StatementList() {
        }

        void popAndCloseStatements() {
            while (!this.isEmpty()) {
                GXPreparedStatement stmt = (GXPreparedStatement)this.pop();
                try {
                    stmt.close();
                    if (!DEBUG) continue;
                    FreeStatementList.this.jdbcConnection.log(1, "GX: Dropping older cursor free " + stmt.getSqlStatement());
                }
                catch (SQLException e) {
                    if (!DEBUG) continue;
                    FreeStatementList.this.jdbcConnection.log(1, "GX: Cannot close cursor " + stmt.getSqlStatement());
                }
            }
        }
    }
}

