/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db.driver;

import com.genexus.CommonUtil;
import com.genexus.DebugFlag;
import com.genexus.GXDbFile;
import com.genexus.db.IFieldGetter;
import com.genexus.db.IGXCallableStatement;
import com.genexus.db.driver.GXConnection;
import com.genexus.db.driver.GXPreparedStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.UUID;

public final class GXCallableStatement
extends GXPreparedStatement
implements CallableStatement,
IFieldGetter,
IGXCallableStatement {
    private static final boolean DEBUG = DebugFlag.DEBUG;
    private CallableStatement stmt;
    private GXConnection con;

    public GXCallableStatement(CallableStatement stmt, GXConnection con, int handle, String sqlSentence) {
        super(stmt, con, handle, sqlSentence, "");
        this.stmt = stmt;
        this.con = con;
    }

    @Override
    public boolean execute() throws SQLException {
        boolean ret;
        this.con.incNumberRequest();
        this.con.setSentenceLastRequest(this.getSqlStatement());
        if (!this.con.isReadOnly()) {
            this.con.setUncommitedChanges();
        }
        if (DEBUG) {
            this.log(2, "Executing callable statement");
            try {
                ret = this.con.getDBMS().execute(this.stmt);
                this.log(2, "succesfully executed");
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            ret = this.con.getDBMS().execute(this.stmt);
        }
        return ret;
    }

    public void setNotInUse() {
        this.con.setNotInUse(this);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        if ((this.con.getDBMS().getId() == 6 || this.con.getDBMS().getId() == 12) && sqlType == -7) {
            sqlType = 252;
        }
        if (DEBUG) {
            this.log(0, "registerOutParameter - index : " + parameterIndex + " sqlType " + sqlType);
            try {
                this.stmt.registerOutParameter(parameterIndex, sqlType);
                this.log(0, "parameter Registered");
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.registerOutParameter(parameterIndex, sqlType);
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        if (DEBUG) {
            this.log(0, "registerOutParameter - index : " + parameterIndex + " sqlType " + sqlType + " scale " + scale);
            try {
                this.stmt.registerOutParameter(parameterIndex, sqlType, scale);
                this.log(0, "parameter Registered");
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.registerOutParameter(parameterIndex, sqlType, scale);
        }
    }

    public String getLongVarchar(int columnIndex) throws SQLException {
        String value;
        if (DEBUG) {
            this.log(0, "getLongVarchar - index : " + columnIndex);
            try {
                value = this.stmt.getString(columnIndex);
                if (this.stmt.wasNull() || value == null) {
                    value = "";
                }
                this.log(0, "getLongVarchar - real length: " + value.length());
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            value = this.stmt.getString(columnIndex);
            if (this.stmt.wasNull() || value == null) {
                value = "";
            }
        }
        return value;
    }

    public String getVarchar(int columnIndex) throws SQLException {
        String value;
        if (DEBUG) {
            this.log(0, "getVarchar - index : " + columnIndex);
            try {
                value = this.stmt.getString(columnIndex);
                if (this.stmt.wasNull()) {
                    value = "";
                }
                this.log(0, "getString - value : " + value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            value = this.stmt.getString(columnIndex);
            if (this.stmt.wasNull()) {
                value = "";
            }
        }
        return value;
    }

    public String getBLOBFile(int columnIndex, String extension, String name) throws SQLException {
        return "";
    }

    public String getBLOBFile(int columnIndex, String extension) throws SQLException {
        return "";
    }

    public String getBLOBFile(int columnIndex) throws SQLException {
        return this.getBLOBFile(columnIndex, "tmp");
    }

    public String getMultimediaFile(int columnIndex, String name) throws SQLException {
        return "";
    }

    public String getMultimediaUri(int columnIndex) throws SQLException {
        return this.getMultimediaUri(columnIndex, true);
    }

    public String getMultimediaUri(int columnIndex, boolean absPath) throws SQLException {
        return GXDbFile.resolveUri(this.getVarchar(columnIndex), absPath);
    }

    public String getString(int columnIndex, int length) throws SQLException {
        String value;
        if (DEBUG) {
            this.log(0, "getString - index : " + columnIndex + " length : " + length);
            try {
                value = this.stmt.getString(columnIndex);
                if (this.stmt.wasNull()) {
                    value = CommonUtil.replicate((String)" ", (int)length);
                }
                this.log(0, "getString - value : " + value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            value = this.stmt.getString(columnIndex);
            if (this.stmt.wasNull()) {
                value = CommonUtil.replicate((String)" ", (int)length);
            }
        }
        return value;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        byte value;
        if (DEBUG) {
            this.log(0, "getByte - index : " + columnIndex);
            try {
                value = this.stmt.getByte(columnIndex);
                if (this.stmt.wasNull()) {
                    value = 0;
                }
                this.log(0, "getByte - value : " + value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            value = this.stmt.getByte(columnIndex);
            if (this.stmt.wasNull()) {
                value = 0;
            }
        }
        return value;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        short value;
        if (DEBUG) {
            this.log(0, "getShort - index : " + columnIndex);
            try {
                value = this.stmt.getShort(columnIndex);
                if (this.stmt.wasNull()) {
                    value = 0;
                }
                this.log(0, "getShort - value : " + value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            value = this.stmt.getShort(columnIndex);
            if (this.stmt.wasNull()) {
                value = 0;
            }
        }
        return value;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        int value;
        if (DEBUG) {
            this.log(0, "getInt - index : " + columnIndex);
            try {
                value = this.stmt.getInt(columnIndex);
                if (this.stmt.wasNull()) {
                    value = 0;
                }
                this.log(0, "getInt - value : " + value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            value = this.stmt.getInt(columnIndex);
            if (this.stmt.wasNull()) {
                value = 0;
            }
        }
        return value;
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        long value;
        if (DEBUG) {
            this.log(0, "getLong - index : " + columnIndex);
            try {
                value = this.stmt.getLong(columnIndex);
                if (this.stmt.wasNull()) {
                    value = 0L;
                }
                this.log(0, "getLong - value : " + value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            value = this.stmt.getLong(columnIndex);
            if (this.stmt.wasNull()) {
                value = 0L;
            }
        }
        return value;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        float value;
        if (DEBUG) {
            this.log(0, "getFloat - index : " + columnIndex);
            try {
                value = this.stmt.getFloat(columnIndex);
                if (this.stmt.wasNull()) {
                    value = 0.0f;
                }
                this.log(0, "getFloat - value : " + value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            value = this.stmt.getFloat(columnIndex);
            if (this.stmt.wasNull()) {
                value = 0.0f;
            }
        }
        return value;
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        double value;
        if (DEBUG) {
            this.log(0, "getDouble - index : " + columnIndex);
            try {
                value = this.stmt.getDouble(columnIndex);
                if (this.stmt.wasNull()) {
                    value = 0.0;
                }
                this.log(0, "getDouble - value : " + value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            value = this.stmt.getDouble(columnIndex);
            if (this.stmt.wasNull()) {
                value = 0.0;
            }
        }
        return value;
    }

    public java.util.Date getGXDateTime(int columnIndex) throws SQLException {
        return this.getGXDateTime(columnIndex, false);
    }

    public java.util.Date getGXDateTime(int columnIndex, boolean hasMilliSeconds) throws SQLException {
        java.util.Date value = null;
        if (DEBUG) {
            this.log(0, "getGXDateTime - index : " + columnIndex);
            try {
                value = this.stmt.getTimestamp(columnIndex);
                if (this.stmt.wasNull() || this.con.isNullDate(value)) {
                    value = CommonUtil.nullDate();
                }
                this.log(0, "getGXDateTime - value2 : " + value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            value = this.stmt.getTimestamp(columnIndex);
            if (this.stmt.wasNull() || this.con.isNullDate(value)) {
                value = CommonUtil.nullDate();
            }
        }
        return value;
    }

    public java.util.Date getGXDate(int columnIndex) throws SQLException {
        java.util.Date value = null;
        if (DEBUG) {
            this.log(0, "getGXDate - index : " + columnIndex);
            try {
                if (this.con.getDBMS().useCharInDate()) {
                    String valueString = this.getString(columnIndex);
                    this.log(0, "getGXDate - stringRead : " + valueString);
                    if (this.stmt.wasNull()) {
                        return CommonUtil.nullDate();
                    }
                    if (valueString.length() > 8) {
                        if (valueString.equals("00000000000000")) {
                            value = CommonUtil.nullDate();
                        } else {
                            StringBuffer newValueString = new StringBuffer();
                            block8: for (int i = 0; i < valueString.length(); ++i) {
                                switch (valueString.charAt(i)) {
                                    case ' ': 
                                    case '-': 
                                    case ':': {
                                        continue block8;
                                    }
                                    default: {
                                        newValueString.append(valueString.charAt(i));
                                    }
                                }
                            }
                            valueString = newValueString.toString();
                            value = CommonUtil.ymdhmsToT_noYL((int)((int)CommonUtil.val((String)valueString.substring(0, 4))), (int)((int)CommonUtil.val((String)valueString.substring(4, 6))), (int)((int)CommonUtil.val((String)valueString.substring(6, 8))), (int)((int)CommonUtil.val((String)valueString.substring(8, 10))), (int)((int)CommonUtil.val((String)valueString.substring(10, 12))), (int)((int)CommonUtil.val((String)valueString.substring(12, 14))));
                        }
                    } else {
                        value = valueString.equals("00000000") ? CommonUtil.nullDate() : CommonUtil.ymdhmsToT_noYL((int)((int)CommonUtil.val((String)valueString.substring(0, 4))), (int)((int)CommonUtil.val((String)valueString.substring(4, 6))), (int)((int)CommonUtil.val((String)valueString.substring(6, 8))), (int)0, (int)0, (int)0);
                    }
                    this.log(0, "getGXDate as Char - value1 : " + value + " string " + valueString);
                }
                value = this.stmt.getTimestamp(columnIndex);
                this.log(0, "getGXDate - value1 : " + value);
                value = this.stmt.wasNull() || this.con.isNullDate(value) ? CommonUtil.nullDate() : CommonUtil.resetTime((java.util.Date)value);
                this.log(0, "getGXDate - value2 : " + value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else if (this.con.getDBMS().useCharInDate()) {
            String valueString = this.getString(columnIndex);
            if (this.stmt.wasNull()) {
                return CommonUtil.nullDate();
            }
            if (valueString.length() > 8) {
                if (valueString.equals("00000000000000")) {
                    value = CommonUtil.nullDate();
                } else {
                    StringBuffer newValueString = new StringBuffer();
                    block9: for (int i = 0; i < valueString.length(); ++i) {
                        switch (valueString.charAt(i)) {
                            case ' ': 
                            case '-': 
                            case ':': {
                                continue block9;
                            }
                            default: {
                                newValueString.append(valueString.charAt(i));
                            }
                        }
                    }
                    valueString = newValueString.toString();
                    value = CommonUtil.ymdhmsToT_noYL((int)((int)CommonUtil.val((String)valueString.substring(0, 4))), (int)((int)CommonUtil.val((String)valueString.substring(4, 6))), (int)((int)CommonUtil.val((String)valueString.substring(6, 8))), (int)((int)CommonUtil.val((String)valueString.substring(8, 10))), (int)((int)CommonUtil.val((String)valueString.substring(10, 12))), (int)((int)CommonUtil.val((String)valueString.substring(12, 14))));
                }
            } else {
                value = valueString.equals("00000000") ? CommonUtil.nullDate() : CommonUtil.ymdhmsToT_noYL((int)((int)CommonUtil.val((String)valueString.substring(0, 4))), (int)((int)CommonUtil.val((String)valueString.substring(4, 6))), (int)((int)CommonUtil.val((String)valueString.substring(6, 8))), (int)0, (int)0, (int)0);
            }
        } else {
            value = this.stmt.getTimestamp(columnIndex);
            value = this.stmt.wasNull() || ((java.util.Date)value).equals(this.con.getNullDate()) ? CommonUtil.nullDate() : CommonUtil.resetTime((java.util.Date)value);
        }
        return value;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        BigDecimal value;
        if (DEBUG) {
            this.log(0, "getBigDecimal - index : " + columnIndex);
            try {
                value = this.stmt.getBigDecimal(columnIndex);
                if (this.stmt.wasNull() || value == null) {
                    value = BigDecimal.ZERO;
                }
                this.log(0, "getBigDecimal - value : " + value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            value = this.stmt.getBigDecimal(columnIndex);
            if (this.stmt.wasNull() || value == null) {
                value = BigDecimal.ZERO;
            }
        }
        return value;
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal value;
        if (DEBUG) {
            this.log(0, "getBigDecimal - index : " + columnIndex);
            try {
                value = this.stmt.getBigDecimal(columnIndex, scale);
                if (this.stmt.wasNull() || value == null) {
                    value = BigDecimal.ZERO;
                }
                this.log(0, "getBigDecimal - value : " + value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            value = this.stmt.getBigDecimal(columnIndex, scale);
            if (this.stmt.wasNull() || value == null) {
                value = BigDecimal.ZERO;
            }
        }
        return value;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getString");
        }
        return this.stmt.getString(columnIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getBoolean");
        }
        return this.stmt.getBoolean(columnIndex);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getBytes");
        }
        return this.stmt.getBytes(columnIndex);
    }

    public UUID getGUID(int columnIndex) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getGUID");
        }
        return UUID.fromString("00000000-0000-0000-0000-000000000000");
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getDate");
        }
        return this.stmt.getDate(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getTime");
        }
        return this.stmt.getTime(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getTimestamp");
        }
        return this.stmt.getTimestamp(columnIndex);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getObject");
        }
        return this.stmt.getObject(columnIndex);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.stmt.wasNull();
    }

    public void resetWasNullHits() {
    }

    private void log(int level, String text) {
        if (DEBUG) {
            this.con.log(level, this, text);
        }
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        return this.stmt.getObject(i, map);
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        return this.stmt.getBlob(i);
    }

    @Override
    public Array getArray(int i) throws SQLException {
        return this.stmt.getArray(i);
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        return this.stmt.getClob(i);
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        return this.stmt.getRef(i);
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        return this.stmt.getDate(parameterIndex, cal);
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        return this.stmt.getTime(parameterIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        return this.stmt.getTimestamp(parameterIndex, cal);
    }

    @Override
    public void registerOutParameter(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.stmt.registerOutParameter(paramIndex, sqlType, typeName);
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        this.stmt.setURL(parameterName, val);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.stmt.setNull(parameterName, sqlType);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.stmt.setNull(parameterName, sqlType, typeName);
    }

    @Override
    public void setBoolean(String a, boolean b) throws SQLException {
        this.stmt.setBoolean(a, b);
    }

    @Override
    public void setByte(String a, byte b) throws SQLException {
        this.stmt.setByte(a, b);
    }

    @Override
    public void setInt(String a, int b) throws SQLException {
        this.stmt.setInt(a, b);
    }

    @Override
    public void setShort(String a, short b) throws SQLException {
        this.stmt.setShort(a, b);
    }

    @Override
    public void setLong(String a, long b) throws SQLException {
        this.stmt.setLong(a, b);
    }

    @Override
    public void setFloat(String a, float b) throws SQLException {
        this.stmt.setFloat(a, b);
    }

    @Override
    public void setDouble(String a, double b) throws SQLException {
        this.stmt.setDouble(a, b);
    }

    @Override
    public void setBigDecimal(String a, BigDecimal b) throws SQLException {
        this.stmt.setBigDecimal(a, b);
    }

    @Override
    public void setBytes(String a, byte[] b) throws SQLException {
        this.stmt.setBytes(a, b);
    }

    @Override
    public void setString(String a, String b) throws SQLException {
        this.stmt.setString(a, b);
    }

    @Override
    public void setDate(String a, Date b) throws SQLException {
        this.stmt.setDate(a, b);
    }

    @Override
    public void setDate(String a, Date b, Calendar c) throws SQLException {
        this.stmt.setDate(a, b, c);
    }

    @Override
    public void setTime(String a, Time b) throws SQLException {
        this.stmt.setTime(a, b);
    }

    @Override
    public void setTime(String a, Time b, Calendar c) throws SQLException {
        this.stmt.setTime(a, b, c);
    }

    @Override
    public void setTimestamp(String a, Timestamp b) throws SQLException {
        this.stmt.setTimestamp(a, b);
    }

    @Override
    public void setTimestamp(String a, Timestamp b, Calendar c) throws SQLException {
        this.stmt.setTimestamp(a, b, c);
    }

    @Override
    public void setAsciiStream(String a, InputStream b, int c) throws SQLException {
        this.stmt.setAsciiStream(a, b, c);
    }

    @Override
    public void setBinaryStream(String a, InputStream b, int c) throws SQLException {
        this.stmt.setBinaryStream(a, b, c);
    }

    @Override
    public void setCharacterStream(String a, Reader b, int c) throws SQLException {
        this.stmt.setCharacterStream(a, b, c);
    }

    @Override
    public void setObject(String a, Object b, int c, int d) throws SQLException {
        this.stmt.setObject(a, b, c, d);
    }

    @Override
    public void setObject(String a, Object b, int c) throws SQLException {
        this.stmt.setObject(a, b, c);
    }

    @Override
    public void setObject(String a, Object b) throws SQLException {
        this.stmt.setObject(a, b);
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        return this.stmt.getArray(parameterName);
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        return this.stmt.getBigDecimal(parameterName);
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        return this.stmt.getBlob(parameterName);
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        return this.stmt.getBoolean(parameterName);
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        return this.stmt.getByte(parameterName);
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        return this.stmt.getBytes(parameterName);
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        return this.stmt.getClob(parameterName);
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        return this.stmt.getDate(parameterName);
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        return this.stmt.getDate(parameterName, cal);
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        return this.stmt.getDouble(parameterName);
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        return this.stmt.getFloat(parameterName);
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        return this.stmt.getInt(parameterName);
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        return this.stmt.getLong(parameterName);
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        return this.stmt.getObject(parameterName);
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        return this.stmt.getObject(parameterName, map);
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        return this.stmt.getRef(parameterName);
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        return this.stmt.getShort(parameterName);
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        return this.stmt.getString(parameterName);
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        return this.stmt.getTime(parameterName);
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        return this.stmt.getTime(parameterName, cal);
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        return this.stmt.getTimestamp(parameterName);
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return this.stmt.getTimestamp(parameterName, cal);
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        return this.stmt.getURL(parameterIndex);
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        return this.stmt.getURL(parameterName);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.stmt.registerOutParameter(parameterName, sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.stmt.registerOutParameter(parameterName, sqlType, scale);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.stmt.registerOutParameter(parameterName, sqlType, typeName);
    }

    @Override
    public Reader getCharacterStream(int arg0) throws SQLException {
        return this.stmt.getCharacterStream(arg0);
    }

    @Override
    public Reader getCharacterStream(String arg0) throws SQLException {
        return this.stmt.getCharacterStream(arg0);
    }

    @Override
    public Reader getNCharacterStream(int arg0) throws SQLException {
        return this.stmt.getNCharacterStream(arg0);
    }

    @Override
    public Reader getNCharacterStream(String arg0) throws SQLException {
        return this.stmt.getNCharacterStream(arg0);
    }

    @Override
    public NClob getNClob(int arg0) throws SQLException {
        return this.stmt.getNClob(arg0);
    }

    @Override
    public NClob getNClob(String arg0) throws SQLException {
        return this.stmt.getNClob(arg0);
    }

    @Override
    public String getNString(int arg0) throws SQLException {
        return this.stmt.getNString(arg0);
    }

    @Override
    public String getNString(String arg0) throws SQLException {
        return this.stmt.getNString(arg0);
    }

    @Override
    public RowId getRowId(int arg0) throws SQLException {
        return this.stmt.getRowId(arg0);
    }

    @Override
    public RowId getRowId(String arg0) throws SQLException {
        return this.stmt.getRowId(arg0);
    }

    @Override
    public SQLXML getSQLXML(int arg0) throws SQLException {
        return this.stmt.getSQLXML(arg0);
    }

    @Override
    public SQLXML getSQLXML(String arg0) throws SQLException {
        return this.stmt.getSQLXML(arg0);
    }

    @Override
    public void setAsciiStream(String arg0, InputStream arg1) throws SQLException {
        this.stmt.setAsciiStream(arg0, arg1);
    }

    @Override
    public void setAsciiStream(String arg0, InputStream arg1, long arg2) throws SQLException {
        this.stmt.setAsciiStream(arg0, arg1, arg2);
    }

    @Override
    public void setBinaryStream(String arg0, InputStream arg1) throws SQLException {
        this.stmt.setBinaryStream(arg0, arg1);
    }

    @Override
    public void setBinaryStream(String arg0, InputStream arg1, long arg2) throws SQLException {
        this.stmt.setBinaryStream(arg0, arg1, arg2);
    }

    @Override
    public void setBlob(String arg0, Blob arg1) throws SQLException {
        this.stmt.setBlob(arg0, arg1);
    }

    @Override
    public void setBlob(String arg0, InputStream arg1) throws SQLException {
        this.stmt.setBlob(arg0, arg1);
    }

    @Override
    public void setBlob(String arg0, InputStream arg1, long arg2) throws SQLException {
        this.stmt.setBlob(arg0, arg1, arg2);
    }

    @Override
    public void setCharacterStream(String arg0, Reader arg1) throws SQLException {
        this.stmt.setCharacterStream(arg0, arg1);
    }

    @Override
    public void setCharacterStream(String arg0, Reader arg1, long arg2) throws SQLException {
        this.stmt.setCharacterStream(arg0, arg1, arg2);
    }

    @Override
    public void setClob(String arg0, Clob arg1) throws SQLException {
        this.stmt.setClob(arg0, arg1);
    }

    @Override
    public void setClob(String arg0, Reader arg1) throws SQLException {
        this.stmt.setClob(arg0, arg1);
    }

    @Override
    public void setClob(String arg0, Reader arg1, long arg2) throws SQLException {
        this.stmt.setClob(arg0, arg1, arg2);
    }

    @Override
    public void setNCharacterStream(String arg0, Reader arg1) throws SQLException {
        this.stmt.setNCharacterStream(arg0, arg1);
    }

    @Override
    public void setNCharacterStream(String arg0, Reader arg1, long arg2) throws SQLException {
        this.stmt.setNCharacterStream(arg0, arg1, arg2);
    }

    @Override
    public void setNClob(String arg0, NClob arg1) throws SQLException {
        this.stmt.setNClob(arg0, arg1);
    }

    @Override
    public void setNClob(String arg0, Reader arg1) throws SQLException {
        this.stmt.setNClob(arg0, arg1);
    }

    @Override
    public void setNClob(String arg0, Reader arg1, long arg2) throws SQLException {
        this.stmt.setNClob(arg0, arg1, arg2);
    }

    @Override
    public void setNString(String arg0, String arg1) throws SQLException {
        this.stmt.setNString(arg0, arg1);
    }

    @Override
    public void setRowId(String arg0, RowId arg1) throws SQLException {
        this.stmt.setRowId(arg0, arg1);
    }

    @Override
    public void setSQLXML(String arg0, SQLXML arg1) throws SQLException {
        this.stmt.setSQLXML(arg0, arg1);
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        return null;
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        return null;
    }
}

