/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db.driver;

import com.genexus.Application;
import com.genexus.ApplicationContext;
import com.genexus.CommonUtil;
import com.genexus.DebugFlag;
import com.genexus.GXJTA;
import com.genexus.ModelContext;
import com.genexus.PrivateUtilities;
import com.genexus.common.classes.AbstractDataSource;
import com.genexus.common.classes.AbstractGXConnection;
import com.genexus.common.classes.IGXPreparedStatement;
import com.genexus.db.BatchUpdateCursor;
import com.genexus.db.ConnectionInformation;
import com.genexus.db.Cursor;
import com.genexus.db.DBConnectionManager;
import com.genexus.db.driver.ConnectionPool;
import com.genexus.db.driver.ConnectionPoolState;
import com.genexus.db.driver.CursorFactory;
import com.genexus.db.driver.DataSource;
import com.genexus.db.driver.DirectPreparedStatement;
import com.genexus.db.driver.GXCallableStatement;
import com.genexus.db.driver.GXDBDebug;
import com.genexus.db.driver.GXDBMS;
import com.genexus.db.driver.GXDBMSas400;
import com.genexus.db.driver.GXDBMSinformix;
import com.genexus.db.driver.GXDBMSmysql;
import com.genexus.db.driver.GXDBMSoracle7;
import com.genexus.db.driver.GXPreparedStatement;
import com.genexus.db.driver.GXResultSet;
import com.genexus.db.driver.GXStatement;
import com.genexus.db.driver.IPreparedStatementCache;
import com.genexus.db.driver.JDBCLogConfig;
import com.genexus.db.driver.PreparedStatementCache;
import com.genexus.diagnostics.core.ILogger;
import com.genexus.diagnostics.core.LogManager;
import com.genexus.management.ConnectionJMX;
import com.genexus.platform.NativeFunctions;
import com.genexus.xml.XMLWriter;
import java.awt.Frame;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public final class GXConnection
extends AbstractGXConnection
implements Connection {
    public static final ILogger logger = LogManager.getLogger(GXConnection.class);
    private static final boolean DEBUG = DebugFlag.DEBUG;
    private String SunJdbcOdbcDriver;
    private String MSJdbcOdbcDriver;
    private ConnectionPool pool;
    private Connection con;
    private int handle;
    private int previousHandle;
    private int thread;
    private Date nullDate;
    private String connectedUser;
    private DataSource dataSource;
    private IPreparedStatementCache preparedStatementPool;
    private Vector<Cursor> batchUpdateStmts;
    private ConnectionPoolState state;
    private GXDBDebug log;
    private long connectedTime;
    private boolean error;
    private ModelContext context;
    private boolean doCommit;
    protected boolean bridge;
    protected String _dbURL;
    protected String _user;
    protected String _password;
    protected String _jdbcDriver;
    protected Properties prop;
    protected SQLException sqlE;
    private long assignTime;
    private boolean locked;
    private long timeLock;
    int numberRequest;
    Date timeLastRequest;
    String sentenceLastRequest;
    String lastObjectExecuted;
    boolean finishExecute;
    String externalConnectionManager;
    private static final ConcurrentHashMap<String, javax.sql.DataSource> JDBCDataSourceMappings = new ConcurrentHashMap();
    boolean setPreviousHandle;
    private Object lockObject;
    private boolean useOldDateTimeFuntion;
    String dbmsId;

    public GXConnection(DataSource dataSource, Connection con) {
        this.SunJdbcOdbcDriver = "sun.jdbc.odbc.JdbcOdbcDriver";
        this.MSJdbcOdbcDriver = "com.ms.jdbc.odbc.JdbcOdbcDriver";
        this.handle = -1;
        this.previousHandle = -1;
        this.batchUpdateStmts = new Vector();
        this.locked = false;
        this.timeLock = 0L;
        this.numberRequest = 0;
        this.finishExecute = true;
        this.externalConnectionManager = "com.genexus.util.ExternalConnectionManager";
        this.setPreviousHandle = false;
        this.lockObject = new Object();
        this.useOldDateTimeFuntion = true;
        this.con = con;
        this.dataSource = dataSource;
        this.nullDate = dataSource.dbms.nullDate();
    }

    public GXConnection(ModelContext context, String user, String password, DataSource dataSource) throws SQLException {
        this(context, -1, user, password, dataSource);
    }

    GXConnection(ModelContext context, ConnectionPool pool, int handle, String user, String password, DataSource dataSource) throws SQLException {
        this(context, handle, user, password, dataSource);
        this.pool = pool;
    }

    GXConnection(ModelContext context, int handle, String user, String password, DataSource dataSource) throws SQLException {
        this(context, handle, user, password, dataSource, null);
    }

    public GXConnection(ModelContext context, int handle, String user, String password, DataSource dataSource, ConnectionInformation info) throws SQLException {
        String DBMSId;
        block36: {
            this.SunJdbcOdbcDriver = "sun.jdbc.odbc.JdbcOdbcDriver";
            this.MSJdbcOdbcDriver = "com.ms.jdbc.odbc.JdbcOdbcDriver";
            this.handle = -1;
            this.previousHandle = -1;
            this.batchUpdateStmts = new Vector();
            this.locked = false;
            this.timeLock = 0L;
            this.numberRequest = 0;
            this.finishExecute = true;
            this.externalConnectionManager = "com.genexus.util.ExternalConnectionManager";
            this.setPreviousHandle = false;
            this.lockObject = new Object();
            this.useOldDateTimeFuntion = true;
            this.thread = Thread.currentThread().hashCode();
            this.handle = handle;
            this.dataSource = dataSource;
            this.context = context;
            if (System.getProperty("gx.jdbclog") != null) {
                try (FileOutputStream fis2 = new FileOutputStream("_gx_jdbc_driver_log.log");){
                    DriverManager.setLogWriter(new PrintWriter(fis2));
                }
                catch (IOException fis2) {
                    // empty catch block
                }
            }
            this.nullDate = dataSource.dbms.nullDate();
            dataSource.setConnectionLog(this);
            if (context != null) {
                DataSource dataSource1;
                if (context.getPreferences().getProperty("CompatibleEmptyStringAsNull", "0").equals("1")) {
                    GXPreparedStatement.addSpaceToEmptyVarChar = false;
                }
                if (context.getPreferences().getProperty("BlankStringAsEmpty", "0").equals("1")) {
                    GXResultSet.blankStringAsEmpty = true;
                }
                if (context.getPreferences().getProperty("AvoidDataTruncationError", "0").equals("1")) {
                    GXPreparedStatement.avoidDataTruncationError = true;
                }
                if (context.getPreferences().getProperty("LongVarCharAsOracleLong", "0").equals("1")) {
                    GXResultSet.longVarCharAsOracleLong = true;
                    GXPreparedStatement.longVarCharAsOracleLong = true;
                }
                if (context.getPreferences().getProperty("DontGetConId", "0").equals("1")) {
                    this.dbmsId = "";
                }
                if (!ApplicationContext.getInstance().getPoolConnections() && (dataSource1 = (DataSource)context.beforeGetConnection(handle, (AbstractDataSource)dataSource)) != null) {
                    dataSource = dataSource1;
                    user = dataSource.defaultUser;
                    password = dataSource.defaultPassword;
                }
            }
            if (dataSource.usesJdbcDataSource()) {
                this.connect(null, dataSource.jdbcDataSource, user, "<JDBC DataSource defined>");
            } else {
                this.connect(dataSource.jdbcDriver, dataSource.jdbcUrl, user, password);
            }
            if (DEBUG && this.isLogEnabled()) {
                String version;
                this.getLog().logWarnings(this.con.getWarnings());
                DatabaseMetaData dma = this.con.getMetaData();
                try {
                    version = dma.getDatabaseProductVersion();
                }
                catch (SQLException e) {
                    version = "";
                }
                this.log(2, "Connected to     : " + dma.getURL());
                this.log(2, "                   " + dataSource.jdbcUrl);
                this.log(2, "Connection class : " + this.con.getClass().getName());
                this.log(2, "Database         : " + dma.getDatabaseProductName() + " version " + version);
                this.log(2, "Driver           : " + dma.getDriverName());
                this.log(2, "Version          : " + dma.getDriverVersion());
                this.log(2, "GX DBMS          : " + dataSource.dbms);
                this.log(2, "DataStore        : " + dataSource.name);
            }
            this.doCommit = true;
            if (context != null && context.getSessionContext() != null) {
                try {
                    InitialContext initCtx = new InitialContext();
                    String trnType = (String)initCtx.lookup("java:comp/env/GX/TrnType");
                    if (trnType.equals("CONTAINER")) {
                        this.doCommit = false;
                    }
                }
                catch (NamingException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
            if (!ApplicationContext.getInstance().getReorganization() || this.getDBMS().getId() != 4 || !dataSource.jdbcDBName.equals("")) {
                if (ApplicationContext.getInstance().getReorganization()) {
                    this.setAutoCommit(dataSource.dbms.getSupportsAutocommit());
                } else if (!(!this.doCommit || dataSource.usesJdbcDataSource() && GXJTA.isJTATX(handle, context))) {
                    this.setAutoCommit(!dataSource.jdbcIntegrity);
                }
            }
            try {
                if (this.con.getTransactionIsolation() != this.GXToJDBCIsolationLevel(dataSource.jdbcIsolationLevel)) {
                    this.setTransactionIsolation(this.GXToJDBCIsolationLevel(dataSource.jdbcIsolationLevel));
                }
            }
            catch (SQLException sqlException) {
                String errMessage = "Error setting transaction isolation to " + this.GXToJDBCIsolationLevel(dataSource.jdbcIsolationLevel);
                logger.warn(errMessage, (Throwable)sqlException);
                this.log(2, errMessage);
                if (!this.isLogEnabled()) break block36;
                this.logSQLException(handle, sqlException);
            }
        }
        this.connectedUser = user;
        this.connectedTime = System.currentTimeMillis();
        this.state = new ConnectionPoolState(this);
        dataSource.dbms.onConnection(this);
        if (Application.isJMXEnabled() && context != null) {
            ConnectionJMX.CreateConnectionJMX(this);
        }
        if (!ApplicationContext.getInstance().getReorganization() && context != null && !ApplicationContext.getInstance().getPoolConnections()) {
            if (info != null) {
                info.rwConnection = this;
            }
            context.afterGetConnection(handle, (AbstractDataSource)dataSource);
        }
        if (DEBUG && this.isLogEnabled() && !(DBMSId = this.getDBMSId()).equals("")) {
            this.log(2, "Physical Id      : " + DBMSId);
        }
    }

    public Connection getJDBCConnection() {
        return this.con;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public ModelContext getContext() {
        return this.context;
    }

    public long getConnectionTime() {
        return this.connectedTime;
    }

    public void setError() {
        this.error = true;
        this.state.connectionError();
    }

    public boolean getError() {
        return this.error;
    }

    private int GXToJDBCIsolationLevel(int gxIL) {
        if (!(this.dataSource.dbms instanceof GXDBMSinformix) || !this.dataSource.getInformixDB().equals(DataSource.INFORMIX_DB_NOTLOGGED)) {
            switch (gxIL) {
                case 1: {
                    return 2;
                }
                case 0: {
                    return 1;
                }
                case 2: {
                    return 4;
                }
                case 3: {
                    return 8;
                }
            }
            System.err.println("Invalid isolation level " + gxIL);
            return 0;
        }
        return 0;
    }

    public int getId() {
        return this.hashCode();
    }

    private void connect(String jdbcDriver, String dbURL, String user, String password) throws SQLException {
        block10: {
            if (this.dataSource != null) {
                this.dataSource.dbms.setDataSource(this.dataSource);
            }
            try {
                if (jdbcDriver == null) {
                    this.connectJDBCDataSource(dbURL);
                    this.preparedStatementPool = new DirectPreparedStatement(this);
                } else {
                    this.connectJDBCDriver(jdbcDriver, dbURL, user, password);
                    if (this.dataSource != null) {
                        this.preparedStatementPool = System.getProperty("gx.useoldcache") == null ? new PreparedStatementCache(this.dataSource.maxCursors, this) : new CursorFactory(this.dataSource.maxCursors, this);
                    }
                }
            }
            catch (SQLException sqlException) {
                if (this.dataSource.dbms.ignoreConnectionError(sqlException)) break block10;
                if (Application.getShowConnectError()) {
                    logger.fatal("Error connecting to database at " + new Date(), (Throwable)sqlException);
                    System.err.println("Error connecting to database at " + new Date());
                    System.err.println("Driver  : " + jdbcDriver);
                    System.err.println("URL     : " + dbURL);
                    System.err.println("User    : " + user);
                    System.err.println("Error   : " + sqlException.getMessage());
                    System.err.println("Connection : " + this.con);
                    try {
                        System.err.println("Java classpath    : " + System.getProperty("java.class.path"));
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
                if (DEBUG && this.isLogEnabled()) {
                    this.logSQLException(this.handle, sqlException);
                }
                throw sqlException;
            }
        }
    }

    private void connectJDBCDriver(String jdbcDriver, String dbURL, String user, String password) throws SQLException {
        this._jdbcDriver = jdbcDriver;
        this._dbURL = dbURL;
        this._user = user;
        this._password = password;
        this.prop = new Properties();
        if (jdbcDriver.equals("")) {
            jdbcDriver = this.SunJdbcOdbcDriver;
        }
        if (DEBUG && this.isLogEnabled()) {
            this.log(2, "Trying to connect to : Driver  : " + jdbcDriver);
            this.log(2, "                       URL     : " + dbURL);
            this.log(2, "                       User    : " + user);
        }
        boolean bl = this.bridge = jdbcDriver.equals(this.SunJdbcOdbcDriver) || jdbcDriver.equals(this.MSJdbcOdbcDriver);
        if (this.bridge) {
            if (PrivateUtilities.isClassPresent(this.MSJdbcOdbcDriver)) {
                this.registerDriver(this.MSJdbcOdbcDriver);
            } else if (PrivateUtilities.isClassPresent(this.SunJdbcOdbcDriver)) {
                this.registerDriver(this.SunJdbcOdbcDriver);
            }
        } else {
            this.registerDriver(jdbcDriver);
        }
        this.prop.put("user", user);
        this.prop.put("password", password);
        if (this.dataSource != null) {
            this.dataSource.dbms.setConnectionProperties(this.prop);
        }
        if (this.dataSource != null && this.dataSource.dbms instanceof GXDBMSas400 && ApplicationContext.getInstance().getReorganization()) {
            this._dbURL = this._dbURL + "/" + this.dataSource.jdbcDBName;
        }
        NativeFunctions.getInstance().executeWithPermissions(new Runnable(){

            @Override
            public void run() {
                if (PrivateUtilities.isClassPresent(GXConnection.this.externalConnectionManager)) {
                    if (DEBUG && GXConnection.this.isLogEnabled()) {
                        GXConnection.this.log(2, "Trying to connect using external connection manager to : Driver  : " + GXConnection.this._jdbcDriver);
                    }
                    try {
                        Class<?> c = Class.forName(GXConnection.this.externalConnectionManager);
                        Method m = c.getMethod("getConnection", String.class, String.class, String.class, String.class, Properties.class);
                        GXConnection.this.con = (Connection)m.invoke(null, GXConnection.this._jdbcDriver, GXConnection.this._dbURL, GXConnection.this._user, GXConnection.this._password, GXConnection.this.prop);
                    }
                    catch (Exception e) {
                        logger.fatal("Could not connect to JDBCDriver", (Throwable)e);
                    }
                } else {
                    try {
                        if (DriverManager.getLoginTimeout() < 0) {
                            DriverManager.setLoginTimeout(0);
                        }
                        if (GXConnection.this.bridge) {
                            GXConnection.this.con = DriverManager.getConnection(GXConnection.this._dbURL, GXConnection.this._user, GXConnection.this._password);
                        } else {
                            GXConnection.this.con = DriverManager.getConnection(GXConnection.this._dbURL, GXConnection.this.prop);
                        }
                    }
                    catch (SQLException e) {
                        GXConnection.this.sqlE = e;
                    }
                }
            }
        }, 6);
        if (this.sqlE != null) {
            throw this.sqlE;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof GXConnection && this.con != null && o != null) {
            return this.con.equals(((GXConnection)o).con);
        }
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    /*
     * Unable to fully structure code
     */
    private void connectJDBCDataSource(String dataSourceName) throws SQLException {
        if (GXConnection.DEBUG && this.isLogEnabled()) {
            this.log(2, "Trying to connect to : DataSource : " + dataSourceName);
        }
        try {
            if (this.context.getSessionContext() != null) {
                try {
                    initCtx = new InitialContext();
                    trnType = (String)initCtx.lookup("java:comp/env/GX/TrnType");
                    if (trnType.equals("CONTAINER")) ** GOTO lbl15
                    GXJTA.initTX(this.getLog(), this.dataSource.jdbcIntegrity);
                }
                catch (NamingException e) {
                    throw new RuntimeException(e.getMessage());
                }
            } else if (this.dataSource.usesJdbcDataSource() && GXJTA.isJTATX(this.handle, this.context)) {
                GXJTA.initTX(this.getLog(), this.dataSource.jdbcIntegrity);
            }
lbl15:
            // 5 sources

            ds = GXConnection.JDBCDataSourceMappings.get(dataSourceName);
            if (ds != null) {
                try {
                    if (!this.setDataSourceOracleFixedString(ds)) {
                        this.con = ds.getConnection();
                    }
                    return;
                }
                catch (SQLException sqle) {
                    this.log(2, "Looking up datasource: " + dataSourceName);
                    GXConnection.JDBCDataSourceMappings.remove(dataSourceName);
                }
            }
            ic = new InitialContext();
            ds = (javax.sql.DataSource)ic.lookup(dataSourceName);
            GXConnection.JDBCDataSourceMappings.put(dataSourceName, ds);
            if (!this.setDataSourceOracleFixedString(ds)) {
                this.con = ds.getConnection();
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private boolean setDataSourceOracleFixedString(javax.sql.DataSource ds) throws SQLException {
        block6: {
            if (this.dataSource.dbms instanceof GXDBMSoracle7) {
                try {
                    Class<?> oracleDataStourceClass = Class.forName("oracle.jdbc.pool.OracleDataSource");
                    if (ds.isWrapperFor(oracleDataStourceClass)) {
                        Object oracle_datasource = ds.unwrap(oracleDataStourceClass);
                        Properties dataSourceProps = new Properties();
                        this.dataSource.dbms.setConnectionProperties(dataSourceProps);
                        Method setConnectionPropertiesMth = oracle_datasource.getClass().getMethod("setConnectionProperties", Properties.class);
                        setConnectionPropertiesMth.invoke(oracle_datasource, dataSourceProps);
                        javax.sql.DataSource dataSource = (javax.sql.DataSource)oracle_datasource;
                        this.con = dataSource.getConnection();
                        return true;
                    }
                }
                catch (ClassNotFoundException cex) {
                    if (this.isLogEnabled()) {
                        this.log(this.handle, "setDataSourceOracleFixedString class oracle.jdbc.pool.OracleDataSource does not exist on classpath");
                    }
                }
                catch (Exception ex) {
                    this.log(2, "Error setting oracle FixedString");
                    if (!this.isLogEnabled()) break block6;
                    this.logSQLException(this.handle, ex);
                }
            }
        }
        return false;
    }

    public GXConnection() {
        this.SunJdbcOdbcDriver = "sun.jdbc.odbc.JdbcOdbcDriver";
        this.MSJdbcOdbcDriver = "com.ms.jdbc.odbc.JdbcOdbcDriver";
        this.handle = -1;
        this.previousHandle = -1;
        this.batchUpdateStmts = new Vector();
        this.locked = false;
        this.timeLock = 0L;
        this.numberRequest = 0;
        this.finishExecute = true;
        this.externalConnectionManager = "com.genexus.util.ExternalConnectionManager";
        this.setPreviousHandle = false;
        this.lockObject = new Object();
        this.useOldDateTimeFuntion = true;
    }

    public static void check(String jdbcDriver, String jdbcURL, String jdbcUser, String jdbcPassword, String DBMS) {
        try (GXConnection c = new GXConnection();){
            JDBCLogConfig jdbcLogConfig = new JDBCLogConfig("check", false, false, 0, false, "", 0);
            c.setLog(new GXDBDebug(jdbcLogConfig));
            c.dataSource = new DataSource("check", jdbcDriver, jdbcURL, jdbcUser, jdbcPassword, jdbcLogConfig, false, false, "", "", 1, 0, false, DBMS, "", false, "", "", 0, 0, false, 0, false, false, 0, false, 0, false, false, false, false, false, 0, false, 0, 1);
            c.connect(jdbcDriver.trim(), jdbcURL.trim(), jdbcUser.trim(), jdbcPassword.trim());
            c.con.close();
            Enumeration<Driver> en = DriverManager.getDrivers();
            while (en.hasMoreElements()) {
                DriverManager.deregisterDriver(en.nextElement());
            }
            c.close();
            CommonUtil.msg((Object)new Frame(), (String)"Sucessfully connected!");
        }
        catch (SQLException e) {
            CommonUtil.msg((Object)new Frame(), (String)("Connection failed! " + e.getMessage()));
        }
    }

    GXDBMS getDBMS() {
        return this.dataSource.dbms;
    }

    public long getAssignTime() {
        return this.assignTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setHandle(int handle) {
        Object object = this.lockObject;
        synchronized (object) {
            if (this.setPreviousHandle) {
                this.previousHandle = this.handle;
                this.setPreviousHandle = false;
            }
            this.handle = handle;
            this.thread = Thread.currentThread().hashCode();
            this.assignTime = System.currentTimeMillis();
            DBConnectionManager.getInstance().getUserInformation(handle).setLastConnectionUsed(this.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHandle() {
        Object object = this.lockObject;
        synchronized (object) {
            return this.handle;
        }
    }

    public int getPreviousHandle() {
        this.setPreviousHandle = true;
        return this.previousHandle;
    }

    public int getThread() {
        return this.thread;
    }

    final Date getNullDate() {
        return this.dataSource.dbms.nullDate();
    }

    void setPool(ConnectionPool pool) {
        this.pool = pool;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
        this.timeLock = System.currentTimeMillis();
    }

    public boolean getLocked() {
        return this.locked && this.timeLock != 0L && this.timeLock < System.currentTimeMillis() - 30000L;
    }

    @Override
    public Statement createStatement(int a, int b) throws SQLException {
        return this.createStatement(this.handle);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(this.handle);
    }

    public Statement createStatement(int handle) throws SQLException {
        if (DEBUG) {
            this.log(2, "createStatement");
            try {
                GXStatement stmt = new GXStatement(this.con.createStatement(), this, handle);
                try {
                    if (this.getDBMS().getSupportsQueryTimeout()) {
                        stmt.setQueryTimeout(0);
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return stmt;
            }
            catch (SQLException sqlException) {
                if (this.isLogEnabled()) {
                    this.logSQLException(handle, sqlException);
                }
                throw sqlException;
            }
        }
        GXStatement stmt = new GXStatement(this.con.createStatement(), this, handle);
        try {
            if (this.getDBMS().getSupportsQueryTimeout()) {
                stmt.setQueryTimeout(0);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return stmt;
    }

    public synchronized void rePrepareStatement(Cursor cursor) throws SQLException {
        try {
            this.log(2, "re preparing statement " + cursor.getSQLSentence());
            this.preparedStatementPool.dropCursor((GXPreparedStatement)cursor.getStatement());
            GXPreparedStatement stmt = (GXPreparedStatement)this.getStatement(cursor.getCursorId(), cursor.getSQLSentence(), cursor.isCurrentOf(), this.handle);
            this.preparedStatementPool.setNotInUse(stmt);
        }
        finally {
            this.state.setInAssignment(false);
        }
    }

    public synchronized PreparedStatement getStatement(String index, String sqlSentence, boolean currentOf, int handle) throws SQLException {
        return this.getStatement(index, sqlSentence, currentOf, handle, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PreparedStatement getStatement(String index, String sqlSentence, boolean currentOf, int handle, boolean batch) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = this.preparedStatementPool.getStatement(handle, index, sqlSentence, currentOf, false, batch);
        }
        finally {
            this.state.setInAssignment(false);
        }
        return stmt;
    }

    public PreparedStatement getStatement(String index, String sqlSentence, boolean currentOf) throws SQLException {
        return this.getStatement(index, sqlSentence, currentOf, this.handle, false);
    }

    public PreparedStatement getStatement(String index, String sqlSentence, boolean currentOf, boolean batch) throws SQLException {
        return this.getStatement(index, sqlSentence, currentOf, this.handle, batch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CallableStatement getCallableStatement(String index, String sqlSentence, int handle) throws SQLException {
        CallableStatement stmt;
        if (DEBUG) {
            this.log(2, "getCallableStatement " + sqlSentence);
            try {
                stmt = this.preparedStatementPool.getCallableStatement(handle, index, sqlSentence);
            }
            catch (SQLException sqlException) {
                if (this.isLogEnabled()) {
                    this.logSQLException(handle, sqlException);
                }
                throw sqlException;
            }
            finally {
                this.state.setInAssignment(false);
            }
        }
        try {
            stmt = this.preparedStatementPool.getCallableStatement(handle, index, sqlSentence);
        }
        finally {
            this.state.setInAssignment(false);
        }
        return stmt;
    }

    public synchronized CallableStatement getCallableStatement(String index, String sqlSentence) throws SQLException {
        return this.getCallableStatement(index, sqlSentence, this.handle);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int a, int b) throws SQLException {
        return this.prepareStatement(sql, this.handle, "", false);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, this.handle, "", false);
    }

    public PreparedStatement prepareStatement(String sql, int handle, String cursorId) throws SQLException {
        return this.prepareStatement(sql, handle, cursorId, false);
    }

    public PreparedStatement prepareStatement(String sql, int handle, String cursorId, boolean currentOf) throws SQLException {
        if (DEBUG) {
            this.log(2, "prepareStatement - sql = " + sql);
            try {
                GXPreparedStatement stmt = new GXPreparedStatement(this.con.prepareStatement(sql), this, handle, sql, cursorId, currentOf);
                this.log(2, "prepareStatement - id  = " + GXDBDebug.getJDBCObjectId(stmt));
                return stmt;
            }
            catch (SQLException sqlException) {
                if (this.isLogEnabled()) {
                    this.logSQLException(handle, sqlException);
                }
                throw sqlException;
            }
        }
        return new GXPreparedStatement(this.con.prepareStatement(sql), this, handle, sql, cursorId, currentOf);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (DEBUG) {
            this.log(2, "setAutoCommit - autoCommit = " + autoCommit);
            try {
                this.con.setAutoCommit(autoCommit);
            }
            catch (SQLException sqlException) {
                if (this.isLogEnabled()) {
                    this.logSQLException(this.handle, sqlException);
                }
                throw sqlException;
            }
        } else {
            this.con.setAutoCommit(autoCommit);
        }
    }

    public boolean getUseOldDateTimeFuntion() {
        return this.useOldDateTimeFuntion;
    }

    public void setDontUseNewDateTimeFunction() {
        this.useOldDateTimeFuntion = false;
    }

    public Date getDateTime() throws SQLException {
        return this.dataSource.dbms.serverDateTime(this);
    }

    public String getDBMSVersion() throws SQLException {
        return this.dataSource.dbms.serverVersion(this);
    }

    public String getDatabaseName() {
        return this.dataSource.dbms.getDatabaseName();
    }

    public String getUserName() throws SQLException {
        int i;
        String userName;
        if (DEBUG) {
            this.log(0, "getUserName");
            try {
                userName = this.getMetaData().getUserName();
            }
            catch (SQLException sqlException) {
                if (this.isLogEnabled()) {
                    this.logSQLException(this.handle, sqlException);
                }
                throw sqlException;
            }
            this.log(0, "getUserName returned " + userName);
        } else {
            userName = this.getMetaData().getUserName();
        }
        if (userName == null) {
            userName = this.connectedUser;
            if (DEBUG) {
                this.log(2, "getUserName - using connected user");
            }
        }
        if (this.getDBMS().getId() == 5 && (i = userName.indexOf("@")) != -1) {
            userName = userName.substring(0, i);
        }
        return userName;
    }

    private void rollback_impl() throws SQLException {
        if (this.dataSource.usesJdbcDataSource() && GXJTA.isJTATX(this.handle, this.context)) {
            GXJTA.rollback();
        } else {
            this.dataSource.dbms.rollback(this.con);
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.batchUpdateStmts.clear();
        if (DEBUG) {
            this.log(2, "rollback");
            try {
                this.rollback_impl();
            }
            catch (SQLException sqlException) {
                if (this.isLogEnabled()) {
                    this.logSQLException(this.handle, sqlException);
                }
                throw sqlException;
            }
        } else {
            this.rollback_impl();
        }
        this.setCommitedChanges();
        this.state.setInAssignment(false);
    }

    private void commit_impl() throws SQLException {
        if (this.dataSource.usesJdbcDataSource() && GXJTA.isJTATX(this.handle, this.context)) {
            GXJTA.commit();
        } else {
            this.dataSource.dbms.commit(this.con);
        }
    }

    public void flushBatchCursors(Object o) throws SQLException {
        Vector<BatchUpdateCursor> toRemove = new Vector<BatchUpdateCursor>();
        this.log(2, "Scanning " + this.batchUpdateStmts.size() + " batch Stmts with pending updates");
        for (int i = 0; i < this.batchUpdateStmts.size(); ++i) {
            BatchUpdateCursor cursor = (BatchUpdateCursor)this.batchUpdateStmts.get(i);
            if (!cursor.isValidOwner(o)) continue;
            if (cursor.pendingRecords()) {
                cursor.beforeCommitEvent();
            }
            toRemove.add(cursor);
        }
        if (toRemove.size() > 0) {
            this.batchUpdateStmts.removeAll(toRemove);
        }
    }

    public void flushAllBatchCursors() throws SQLException {
        this.log(2, "Scanning " + this.batchUpdateStmts.size() + " batch Stmts with pending updates");
        for (int i = 0; i < this.batchUpdateStmts.size(); ++i) {
            BatchUpdateCursor cursor = (BatchUpdateCursor)this.batchUpdateStmts.get(i);
            if (!cursor.pendingRecords()) continue;
            cursor.beforeCommitEvent();
        }
        this.batchUpdateStmts.clear();
    }

    @Override
    public void commit() throws SQLException {
        this.flushAllBatchCursors();
        if (DEBUG) {
            this.log(2, "commit");
            try {
                this.commit_impl();
            }
            catch (SQLException sqlException) {
                if (this.isLogEnabled()) {
                    this.logSQLException(this.handle, sqlException);
                }
                throw sqlException;
            }
        } else {
            this.commit_impl();
        }
        this.setCommitedChanges();
        this.state.setInAssignment(false);
    }

    private void close_impl() throws SQLException {
        if (this.dataSource.usesJdbcDataSource() && GXJTA.isJTATX(this.handle, this.context)) {
            this.dropAllCursors();
            GXJTA.cleanTX(this.dataSource.jdbcIntegrity);
            this.con.close();
        } else {
            try {
                this.dropAllCursors();
                if (!(this.dataSource.dbms instanceof GXDBMSinformix && this.dataSource.getInformixDB().equals(DataSource.INFORMIX_DB_NOTLOGGED) || !this.getUncommitedChanges() && !(this.dataSource.dbms instanceof GXDBMSmysql))) {
                    this.rollback();
                }
                this.con.setAutoCommit(true);
            }
            finally {
                this.con.close();
            }
        }
    }

    @Override
    public void close() throws SQLException {
        if (DEBUG) {
            this.log(2, "close");
            try {
                if (Application.isJMXEnabled()) {
                    ConnectionJMX.DestroyConnectionJMX(this);
                }
                this.close_impl();
            }
            catch (SQLException sqlException) {
                if (this.isLogEnabled()) {
                    this.logSQLException(this.handle, sqlException);
                }
                throw sqlException;
            }
            this.flushLog();
            this.getLog().close(2);
        } else {
            if (Application.isJMXEnabled()) {
                ConnectionJMX.DestroyConnectionJMX(this);
            }
            this.close_impl();
        }
        this.handle = -1;
    }

    public void closeWithError() throws SQLException {
        if (DEBUG) {
            this.log(2, "Closing broken connection");
            try {
                if (Application.isJMXEnabled()) {
                    ConnectionJMX.DestroyConnectionJMX(this);
                }
                this.con.close();
            }
            catch (SQLException sqlException) {
                if (this.isLogEnabled()) {
                    this.logSQLException(this.handle, sqlException);
                }
                throw sqlException;
            }
            this.flushLog();
        } else {
            if (Application.isJMXEnabled()) {
                ConnectionJMX.DestroyConnectionJMX(this);
            }
            this.con.close();
        }
        this.handle = -1;
    }

    public void dropAllCursors() {
        this.preparedStatementPool.dropAllCursors();
        this.state.closeCursor();
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (DEBUG) {
            this.log(0, "isClosed");
            try {
                return this.con.isClosed();
            }
            catch (SQLException sqlException) {
                if (this.isLogEnabled()) {
                    this.logSQLException(this.handle, sqlException);
                }
                throw sqlException;
            }
        }
        return this.con.isClosed();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (DEBUG) {
            this.log(2, "setReadOnly - readOnly = " + readOnly);
            try {
                this.con.setReadOnly(readOnly);
            }
            catch (SQLException sqlException) {
                if (this.isLogEnabled()) {
                    this.logSQLException(this.handle, sqlException);
                }
                throw sqlException;
            }
        } else {
            this.con.setReadOnly(readOnly);
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        if (DEBUG) {
            this.log(2, "setTransactionIsolation - level " + level);
            try {
                this.con.setTransactionIsolation(level);
            }
            catch (SQLException sqlException) {
                if (this.isLogEnabled()) {
                    this.logSQLException(this.handle, sqlException);
                }
                throw sqlException;
            }
        } else {
            this.con.setTransactionIsolation(level);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.con.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.con.clearWarnings();
    }

    private boolean registerDriver(String className) {
        boolean lreturn = false;
        try {
            Class.forName(className);
            lreturn = true;
        }
        catch (ClassNotFoundException e) {
            this.log(2, "registerDriver/ClassNotFoundException : " + className);
        }
        return lreturn;
    }

    private boolean deregisterDriver(String className) {
        boolean lreturn = false;
        try {
            DriverManager.deregisterDriver((Driver)Class.forName(className).newInstance());
            lreturn = true;
        }
        catch (IllegalAccessException e) {
            System.err.println("registerDriver/IllegalAccessException : " + className);
        }
        catch (InstantiationException e) {
            System.err.println("registerDriver/InstantiationException : " + className);
        }
        catch (ClassNotFoundException e) {
            System.err.println("registerDriver/ClassNotFoundException : " + className);
        }
        catch (SQLException es) {
            System.err.println("registerDriver/SQLException : " + es.getMessage() + " - SQLState " + es.getSQLState() + " - Error " + es.getErrorCode());
        }
        return lreturn;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.con.nativeSQL(sql);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.con.getTransactionIsolation();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.con.isReadOnly();
    }

    @Override
    public CallableStatement prepareCall(String sql, int a, int b) throws SQLException {
        return this.prepareCall(sql);
    }

    public GXCallableStatement prepareCall(String sql, int handle) throws SQLException {
        return new GXCallableStatement(this.con.prepareCall(sql), this, handle, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, this.handle);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.con.getMetaData();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.con.getAutoCommit();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.con.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.con.getCatalog();
    }

    public ConnectionPoolState getPoolState() {
        return this.state;
    }

    ConnectionPool getPool() {
        return this.pool;
    }

    public boolean getUncommitedChanges() {
        return this.state.getUncommitedChanges();
    }

    void setCommitedChanges() {
        this.state.setUncommitedChanges(false);
    }

    public void setUncommitedChanges() {
        this.state.setUncommitedChanges(true);
    }

    void setNotInUse(GXPreparedStatement stmt) {
        this.preparedStatementPool.setNotInUse(stmt);
        this.state.closeCursor();
    }

    public void dropCursor(IGXPreparedStatement stmt) {
        try {
            this.preparedStatementPool.dropCursor((GXPreparedStatement)stmt);
            this.state.closeCursor();
        }
        finally {
            this.state.setInAssignment(false);
        }
    }

    public int getOpenCursors() {
        return this.preparedStatementPool.getUsedCursors();
    }

    boolean isNullCleanDate(Date date) {
        return date.equals(this.nullDate);
    }

    boolean isNullDate(Date date) {
        return CommonUtil.resetTime((Date)date).equals(this.nullDate);
    }

    boolean isNullDateTime(Date date) {
        return date.equals(this.nullDate);
    }

    public IPreparedStatementCache getPreparedStatementPool() {
        return this.preparedStatementPool;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() {
        return null;
    }

    public void setTypeMap(Map map) {
    }

    void dump(PrintStream out) {
        this.preparedStatementPool.dump(out);
    }

    void dump(XMLWriter writer) {
        writer.writeStartElement("Connection_Information");
        writer.writeAttribute("Id", (long)this.getId());
        writer.writeElement("PhysicalId", this.getDBMSId());
        writer.writeElement("CreateTime", this.getTimeCreated().toString());
        writer.writeElement("LastAssignedTime", this.getTimeAssigned().toString());
        writer.writeElement("LastUserAssigned", (long)this.getLastUserAssigned());
        writer.writeElement("LastUserAssignedName", this.getUserId());
        writer.writeElement("Error", new Boolean(this.getError()).toString());
        writer.writeElement("Available", new Boolean(!this.getInAssigment() && this.getOpenCursorsJMX() == 0 && !this.getUncommitedChanges()).toString());
        writer.writeElement("OpenCursorCount", (long)this.getOpenCursorsJMX());
        writer.writeElement("UncommitedChanges", new Boolean(this.getUncommitedChanges()).toString());
        writer.writeElement("RequestCount", (long)this.getNumberRequest());
        writer.writeStartElement("LastSQLStatement");
        writer.writeCData(this.getSentenceLastRequest());
        writer.writeEndElement();
        writer.writeElement("LastSQLStatementTime", this.getTimeLastRequest().toString());
        writer.writeElement("LastSQLStatementEnded", new Boolean(this.getFinishExecute()).toString());
        writer.writeElement("LastObject", this.getLastObjectExecuted());
        writer.writeEndElement();
    }

    private String getUserId() {
        try {
            return DBConnectionManager.getInstance().getUserName(this.context, this.getLastUserAssigned(), "DEFAULT");
        }
        catch (SQLException ex) {
            return "";
        }
    }

    public GXDBDebug getLog() {
        return this.log;
    }

    void setLog(GXDBDebug log) {
        this.log = log;
    }

    void log(int level, String text) {
        if (DEBUG) {
            this.getLog().log(level, this, this.handle, text);
        }
    }

    void log(int level, Object obj, String text) {
        if (DEBUG) {
            this.getLog().log(level, obj, this.handle, text);
        }
    }

    void flushLog() {
        if (DEBUG) {
            this.getLog().flushLog();
        }
    }

    boolean isLogEnabled() {
        if (DEBUG && this.getLog() != null) {
            return this.getLog().isLogEnabled();
        }
        return false;
    }

    void logSQLException(int handle, Exception e) {
        if (DEBUG) {
            this.getLog().logException(handle, e, this);
        }
    }

    @Override
    public void setHoldability(int x) throws SQLException {
        this.con.setHoldability(x);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.con.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.con.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String x) throws SQLException {
        return this.con.setSavepoint(x);
    }

    @Override
    public void rollback(Savepoint x) throws SQLException {
        this.con.rollback(x);
    }

    @Override
    public void releaseSavepoint(Savepoint x) throws SQLException {
        this.con.releaseSavepoint(x);
    }

    @Override
    public Statement createStatement(int a, int b, int c) throws SQLException {
        return this.con.createStatement(a, b, c);
    }

    @Override
    public PreparedStatement prepareStatement(String s, int a, int b, int c) throws SQLException {
        return this.con.prepareStatement(s, a, b, c);
    }

    @Override
    public CallableStatement prepareCall(String s, int a, int b, int c) throws SQLException {
        return this.con.prepareCall(s, a, b, c);
    }

    @Override
    public PreparedStatement prepareStatement(String s, int[] c) throws SQLException {
        return this.con.prepareStatement(s, c);
    }

    @Override
    public PreparedStatement prepareStatement(String s, String[] c) throws SQLException {
        return this.con.prepareStatement(s, c);
    }

    @Override
    public PreparedStatement prepareStatement(String s, int i) throws SQLException {
        return this.con.prepareStatement(s, i);
    }

    public void incNumberRequest() {
        ++this.numberRequest;
        this.timeLastRequest = new Date();
    }

    public void setSentenceLastRequest(String sentenceLastRequest) {
        this.sentenceLastRequest = sentenceLastRequest;
    }

    public void setLastObjectExecuted(String object) {
        this.lastObjectExecuted = object;
    }

    public void setFinishExecute(boolean finishExecute) {
        this.finishExecute = finishExecute;
    }

    public String getDBMSId() {
        if (this.dbmsId == null) {
            this.dbmsId = this.dataSource.dbms.connectionPhysicalId(this);
        }
        return this.dbmsId;
    }

    public Date getTimeCreated() {
        return new Date(this.connectedTime);
    }

    public Date getTimeAssigned() {
        return new Date(this.assignTime);
    }

    public int getLastUserAssigned() {
        return this.handle;
    }

    public boolean getInAssigment() {
        return this.getPoolState().getInAssignment();
    }

    public int getNumberRequest() {
        return this.numberRequest;
    }

    public Date getTimeLastRequest() {
        return this.timeLastRequest;
    }

    public int getOpenCursorsJMX() {
        return this.preparedStatementPool.getUsedCursorsJMX();
    }

    public String getSentenceLastRequest() {
        return this.sentenceLastRequest;
    }

    public String getLastObjectExecuted() {
        return this.lastObjectExecuted;
    }

    public boolean getFinishExecute() {
        return this.finishExecute;
    }

    public void disconnect() {
        try {
            this.getPool().dropConnectionById(this.getId());
        }
        catch (SQLException e) {
            logger.error("Failed to drop Connection ", (Throwable)e);
        }
    }

    public void dump() {
        String fileName = "Connection_" + this.getId() + "_" + CommonUtil.getYYYYMMDDHHMMSS_nosep((Date)new Date()) + ".xml";
        XMLWriter writer = new XMLWriter();
        writer.xmlStart(fileName);
        this.dump(writer);
        writer.close();
    }

    public void addBatchUpdate(Cursor cursor) {
        if (!this.batchUpdateStmts.contains(cursor)) {
            this.batchUpdateStmts.add(cursor);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        return null;
    }

    @Override
    public Clob createClob() throws SQLException {
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return null;
    }

    @Override
    public Struct createStruct(String arg0, Object[] arg1) throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return null;
    }

    @Override
    public String getClientInfo(String arg0) throws SQLException {
        return null;
    }

    @Override
    public boolean isValid(int arg0) throws SQLException {
        return false;
    }

    @Override
    public void setClientInfo(Properties arg0) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(String arg0, String arg1) throws SQLClientInfoException {
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }
}

