/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db.driver;

import com.genexus.ApplicationContext;
import com.genexus.CommonUtil;
import com.genexus.DebugFlag;
import com.genexus.GXutil;
import com.genexus.ICleanedup;
import com.genexus.Version;
import com.genexus.db.driver.JDBCLogConfig;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Date;
import java.util.GregorianCalendar;

public final class GXDBDebug
implements ICleanedup {
    private static final boolean DEBUG = DebugFlag.DEBUG;
    public static final byte LOG_MAX = 0;
    public static final byte LOG_MED = 1;
    public static final byte LOG_MIN = 2;
    public static final int POOL_ACTIVITY = 1;
    private PrintWriter log;
    private int logLineCount = 0;
    private GregorianCalendar cal = new GregorianCalendar();
    private String fileName = "";
    boolean logEnabled = false;
    JDBCLogConfig cfg;

    public GXDBDebug(JDBCLogConfig cfg) {
        this.cfg = cfg;
        this.logLineCount = 0;
        if (DEBUG) {
            this.logEnabled = cfg.enabled;
            if (ApplicationContext.getInstance().isGXUtility()) {
                this.logEnabled = false;
            }
            if (this.logEnabled) {
                this.fileName = cfg.getFileName();
                try {
                    this.log = this.createWriter(this.fileName);
                }
                catch (IOException e) {
                    try {
                        String fileNameWithoutExtension = this.fileName;
                        String fileExtension = "";
                        int tempIndex = this.fileName.lastIndexOf(46);
                        if (tempIndex != -1) {
                            fileNameWithoutExtension = this.fileName.substring(0, tempIndex);
                            fileExtension = this.fileName.substring(tempIndex);
                        }
                        this.fileName = fileNameWithoutExtension + "_" + CommonUtil.getYYYYMMDDHHMMSSmmm_nosep((Date)new Date()) + fileExtension;
                        this.log = this.createWriter(this.fileName);
                    }
                    catch (IOException ioe) {
                        this.logEnabled = false;
                    }
                }
                if (this.logEnabled) {
                    this.log.println("Java vendor       : " + System.getProperty("java.vendor"));
                    this.log.println("Java version      : " + System.getProperty("java.version"));
                    this.log.println("Generator version : " + Version.getFullVersion());
                    this.log.println("Java classpath    : " + System.getProperty("java.class.path"));
                    this.log.println("Operating System  : " + System.getProperty("os.name") + " " + System.getProperty("os.version") + "/" + System.getProperty("os.arch"));
                    this.log.println("Current DateTime  : " + new Date());
                    this.log.println("");
                    this.flushLog();
                }
            }
        }
    }

    private PrintWriter createWriter(String filename) throws IOException {
        Writer baseWriter = new FileWriter(this.fileName);
        if (this.cfg.buffered) {
            baseWriter = new BufferedWriter(baseWriter);
        }
        return new PrintWriter(baseWriter);
    }

    public void closeLog() {
        if (this.logEnabled && this.log != null) {
            this.log.close();
            this.logEnabled = false;
        }
    }

    public void cleanup() {
        this.closeLog();
    }

    public void flushLog() {
        if (this.logEnabled && this.log != null) {
            this.log.flush();
        }
    }

    public void logException(int handle, Exception e, Object object) {
        if (e instanceof SQLException) {
            this.logSQLException(handle, (SQLException)e, object);
        }
    }

    public void logSQLException(int handle, SQLException e, Object obj) {
        if (!this.logEnabled) {
            return;
        }
        e.printStackTrace(this.log);
        while (e != null) {
            this.log(handle, "Exception: SQLState: " + e.getSQLState() + " ErrorCode: " + e.getErrorCode() + " in " + obj.hashCode());
            this.log(handle, "           Message : " + e.getMessage());
            this.log(handle, "           Message : " + e.getMessage());
            e = e.getNextException();
        }
        if (!this.cfg.buffered) {
            this.flushLog();
        }
    }

    void logWarnings(SQLWarning warn) throws SQLException {
        if (warn != null && this.logEnabled && this.log != null) {
            while (warn != null) {
                this.log.println("Warning: SQLState: " + warn.getSQLState() + " ErrorCode: " + warn.getErrorCode());
                this.log.println("         Message : " + warn.getMessage());
                warn = warn.getNextWarning();
            }
        }
        if (!this.cfg.buffered) {
            this.flushLog();
        }
    }

    public void logComment(int level, Object source, int handle, String text) {
        if (level >= this.cfg.detail) {
            this.logComment(source, handle, text);
        }
    }

    public final void logComment(int level, int handle, String text) {
        this.logComment(handle, text);
    }

    public final void logComment(int handle, String text) {
        if (this.logEnabled) {
            this.log(handle, "# " + text);
        }
    }

    public final void logComment(Object source, String text) {
        this.logComment(source, 0, text);
    }

    public final void logComment(Object source, int handle, String text) {
        if (this.logEnabled) {
            this.log(source, handle, "# " + text);
        }
    }

    final void log(int level, Object source, int handle, String text) {
        if (level >= this.cfg.detail) {
            this.log(source, handle, text);
        }
    }

    final void log(Object source, int handle, String text) {
        if (this.logEnabled) {
            String name = source.getClass().getName();
            this.log(handle, name.substring(name.lastIndexOf(46, name.length()) + 1) + "/" + source.hashCode() + ": " + text);
        }
    }

    public final void log(int handle, String text) {
        if (this.logEnabled && this.log != null) {
            this.cal.setTime(new Date(System.currentTimeMillis()));
            String time = GXDBDebug.padstr(this.cal.get(11), 2) + ":" + GXDBDebug.padstr(this.cal.get(12), 2) + ":" + GXDBDebug.padstr(this.cal.get(13), 2) + "." + GXDBDebug.padstr(this.cal.get(14), 3);
            this.log.println(GXutil.str(this.logLineCount++, 8, 0) + "(" + handle + ")(" + time + ")" + text);
            if (!this.cfg.buffered) {
                this.flushLog();
            }
        }
    }

    static int getJDBCObjectId(Object conString) {
        return conString.hashCode();
    }

    private static String padstr(int number, int length) {
        return CommonUtil.padl((String)CommonUtil.ltrim((String)GXutil.str(number, length, 0)), (int)length, (String)"0");
    }

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    public void close(int level) {
        if (this.logEnabled && level == this.cfg.level && this.log != null) {
            System.err.println("Closing " + this.fileName + "...");
            this.log.close();
        }
    }

    protected void finalize() {
        this.closeLog();
    }
}

