/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db.driver;

import com.genexus.ApplicationContext;
import com.genexus.CommonUtil;
import com.genexus.db.driver.DataSource;
import com.genexus.db.driver.GXCallableStatement;
import com.genexus.db.driver.GXConnection;
import com.genexus.db.driver.GXDBMS;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Properties;

public class GXDBMSas400
implements GXDBMS {
    private boolean useCharInDate = true;
    private DataSource dataSource;
    private static String ibmDrivers = "com.ibm.";
    private boolean inReorg = false;
    private String dbName = "";
    private static boolean serverTimeProcedureCreated = false;

    @Override
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.useCharInDate = !dataSource.getAS400DateType().equalsIgnoreCase("Date");
    }

    @Override
    public boolean isAlive(GXConnection con) {
        try {
            this.serverDateTime(con);
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    @Override
    public ResultSet executeQuery(PreparedStatement stmt, boolean hold) throws SQLException {
        return stmt.executeQuery();
    }

    @Override
    public int executeUpdate(PreparedStatement stmt) throws SQLException {
        return stmt.executeUpdate();
    }

    @Override
    public boolean execute(PreparedStatement stmt) throws SQLException {
        return stmt.execute();
    }

    @Override
    public int[] executeBatch(Statement stmt) throws SQLException {
        return stmt.executeBatch();
    }

    @Override
    public boolean DataTruncation(SQLException e) {
        return e.getErrorCode() == 516;
    }

    @Override
    public boolean ReferentialIntegrity(SQLException e) {
        return false;
    }

    @Override
    public boolean EndOfFile(SQLException e) {
        return e.getErrorCode() == 100;
    }

    @Override
    public boolean DuplicateKeyValue(SQLException e) {
        return e.getErrorCode() == -803;
    }

    @Override
    public boolean ObjectLocked(SQLException e) {
        return e.getErrorCode() == -913;
    }

    @Override
    public boolean ObjectNotFound(SQLException e) {
        return e.getErrorCode() == -204 || this.MaskedDatabaseAlreadyExists(e) || e.getErrorCode() == -913 || e.getErrorCode() == 7905;
    }

    @Override
    public Date nullDate() {
        return CommonUtil.ymdhmsToT_noYL((int)1, (int)1, (int)1, (int)0, (int)0, (int)0);
    }

    public boolean MaskedFileNotFound(SQLException e) {
        return e.getErrorCode() == -204;
    }

    public boolean MaskedDatabaseAlreadyExists(SQLException e) {
        return e.getErrorCode() == -601;
    }

    @Override
    public boolean useDateTimeInDate() {
        return false;
    }

    @Override
    public boolean useCharInDate() {
        return this.useCharInDate;
    }

    @Override
    public void setDatabaseName(String dbName) {
        this.dbName = dbName;
    }

    @Override
    public String getDatabaseName() {
        return this.dbName;
    }

    @Override
    public void setInReorg() {
        this.inReorg = true;
    }

    @Override
    public void setConnectionProperties(Properties props) {
        if (this.dataSource.jdbcDriver.startsWith(ibmDrivers)) {
            if (this.dataSource.jdbcUrl.indexOf("date format") == -1) {
                props.put("date format", "iso");
            }
            props.put("naming", "system");
            props.put("extended dynamic", "true");
            props.put("package", this.dataSource.getAS400Package());
            if (ApplicationContext.getInstance().getReorganization()) {
                props.put("libraries", "*LIBL " + this.dataSource.jdbcAS400Lib);
            } else if (this.dataSource.jdbcAS400Lib.indexOf(this.dbName) >= 0) {
                props.put("libraries", "*LIBL " + this.dataSource.jdbcAS400Lib);
            } else {
                props.put("libraries", this.dbName + " *LIBL " + this.dataSource.jdbcAS400Lib);
            }
        }
    }

    @Override
    public void onConnection(GXConnection con) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date serverDateTime(GXConnection con) throws SQLException {
        boolean uncommitedChanges = con.getUncommitedChanges();
        try {
            if (!serverTimeProcedureCreated) {
                Statement stmt = con.createStatement();
                try {
                    stmt.executeUpdate("CREATE PROCEDURE QWCCVTDT (IN CHAR(10), IN CHAR(17), IN CHAR(10), INOUT CHAR(17), INOUT CHARACTER(1)) (EXTERNAL NAME QSYS/QWCCVTDT GENERAL)");
                }
                catch (SQLException sQLException) {
                }
                finally {
                    serverTimeProcedureCreated = true;
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
            CallableStatement cstmt = con.getCallableStatement("_serverDT", "CALL QWCCVTDT (?,?,?,?,?)");
            cstmt.registerOutParameter(4, 1);
            cstmt.registerOutParameter(5, 1);
            cstmt.setString(1, "*CURRENT");
            cstmt.setString(2, " ");
            cstmt.setString(3, "*YYMD");
            cstmt.setString(4, "");
            cstmt.setString(5, "");
            cstmt.execute();
            if (!uncommitedChanges) {
                con.setCommitedChanges();
            }
            String result = cstmt.getString(4);
            ((GXCallableStatement)cstmt).setNotInUse();
            return CommonUtil.ymdhmsToT_noYL((String)result);
        }
        catch (SQLException e) {
            con.setError();
            throw e;
        }
    }

    @Override
    public String serverVersion(GXConnection con) throws SQLException {
        return "";
    }

    @Override
    public String connectionPhysicalId(GXConnection con) {
        try {
            Class<?> c = Class.forName("com.ibm.as400.access.AS400JDBCConnection");
            Method m = c.getMethod("getServerJobIdentifier", null);
            return (String)m.invoke((Object)con.getJDBCConnection(), (Object[])null);
        }
        catch (Exception e) {
            System.out.println(e);
            return "";
        }
    }

    @Override
    public boolean getSupportsAutocommit() {
        return true;
    }

    @Override
    public void commit(Connection con) throws SQLException {
        con.commit();
    }

    @Override
    public void rollback(Connection con) throws SQLException {
        con.rollback();
    }

    @Override
    public boolean useReadOnlyConnections() {
        return false;
    }

    @Override
    public boolean ignoreConnectionError(SQLException e) {
        return false;
    }

    @Override
    public boolean rePrepareStatement(SQLException e) {
        return false;
    }

    @Override
    public boolean getSupportsQueryTimeout() {
        return true;
    }

    @Override
    public boolean useStreamsInNullLongVarchar() {
        return false;
    }

    @Override
    public boolean useStreamsInLongVarchar() {
        return false;
    }

    @Override
    public int getId() {
        return 1;
    }

    @Override
    public int getLockRetryCount(int lockRetryCount, int waitRecord) {
        return lockRetryCount;
    }

    @Override
    public boolean connectionClosed(SQLException e) {
        return e.getSQLState() == "08S01";
    }
}

