/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db.driver;

import com.genexus.CommonUtil;
import com.genexus.db.driver.DataSource;
import com.genexus.db.driver.GXConnection;
import com.genexus.db.driver.GXDBMS;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;

public class GXDBMScloudscape
implements GXDBMS {
    private static final boolean DEBUG = false;
    private boolean logged = true;
    private boolean notlogged = true;
    private DataSource dataSource;

    @Override
    public ResultSet executeQuery(PreparedStatement stmt, boolean hold) throws SQLException {
        return stmt.executeQuery();
    }

    @Override
    public int executeUpdate(PreparedStatement stmt) throws SQLException {
        return stmt.executeUpdate();
    }

    @Override
    public boolean execute(PreparedStatement stmt) throws SQLException {
        return stmt.execute();
    }

    @Override
    public int[] executeBatch(Statement stmt) throws SQLException {
        return stmt.executeBatch();
    }

    @Override
    public boolean isAlive(GXConnection con) {
        try {
            this.serverDateTime(con);
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    @Override
    public void setInReorg() {
    }

    @Override
    public boolean DataTruncation(SQLException e) {
        return false;
    }

    @Override
    public boolean useReadOnlyConnections() {
        return true;
    }

    @Override
    public void setDataSource(DataSource datasource) {
        this.dataSource = datasource;
        this.logged = datasource.getInformixDB().equals(DataSource.INFORMIX_DB_LOGGED);
    }

    @Override
    public boolean DuplicateKeyValue(SQLException e) {
        return e.getSQLState().equals("23500");
    }

    @Override
    public boolean ObjectNotFound(SQLException e) {
        return e.getSQLState().equals("42X05") || e.getSQLState().equals("42X65") || e.getSQLState().equals("42Y55");
    }

    @Override
    public boolean useDateTimeInDate() {
        return false;
    }

    @Override
    public boolean useCharInDate() {
        return false;
    }

    @Override
    public void onConnection(GXConnection gxconnection) throws SQLException {
        if (this.dataSource.getInformixDB().equals(DataSource.INFORMIX_DB_LOGGED)) {
            Statement statement = gxconnection.createStatement();
            statement.executeUpdate("BEGIN WORK");
            statement.close();
            gxconnection.setCommitedChanges();
        }
    }

    @Override
    public void setDatabaseName(String s) {
    }

    @Override
    public String getDatabaseName() {
        return "";
    }

    @Override
    public void rollback(Connection connection) throws SQLException {
        connection.rollback();
        if (this.logged) {
            Statement statement = connection.createStatement();
            statement.executeUpdate("BEGIN WORK");
            statement.close();
            ((GXConnection)connection).setCommitedChanges();
        }
    }

    @Override
    public boolean ObjectLocked(SQLException e) {
        return e.getErrorCode() == -243 || e.getErrorCode() == -244 || e.getErrorCode() == -245;
    }

    @Override
    public boolean ignoreConnectionError(SQLException e) {
        return false;
    }

    @Override
    public boolean ReferentialIntegrity(SQLException e) {
        return false;
    }

    @Override
    public boolean EndOfFile(SQLException e) {
        return e.getErrorCode() == 100;
    }

    @Override
    public void setConnectionProperties(Properties properties) {
    }

    @Override
    public boolean getSupportsAutocommit() {
        return !this.dataSource.getInformixDB().equals(DataSource.INFORMIX_DB_ANSI);
    }

    @Override
    public Date nullDate() {
        return CommonUtil.ymdhmsToT_noYL((int)1000, (int)1, (int)1, (int)0, (int)0, (int)0);
    }

    @Override
    public void commit(Connection connection) throws SQLException {
        connection.commit();
        if (this.logged) {
            Statement statement = connection.createStatement();
            statement.executeUpdate("BEGIN WORK");
            statement.close();
            ((GXConnection)connection).setCommitedChanges();
        }
    }

    @Override
    public Date serverDateTime(GXConnection gxconnection) throws SQLException {
        ResultSet resultset = gxconnection.getStatement("_ServerDT_", "SELECT CURRENT YEAR TO SECOND FROM informix.SYSTABLES WHERE tabname = 'systables'", false).executeQuery();
        resultset.next();
        Timestamp timestamp = resultset.getTimestamp(1);
        resultset.close();
        return timestamp;
    }

    @Override
    public String serverVersion(GXConnection con) throws SQLException {
        return "";
    }

    @Override
    public String connectionPhysicalId(GXConnection con) {
        return "";
    }

    @Override
    public boolean rePrepareStatement(SQLException e) {
        return false;
    }

    @Override
    public boolean getSupportsQueryTimeout() {
        return false;
    }

    @Override
    public boolean useStreamsInNullLongVarchar() {
        return false;
    }

    @Override
    public boolean useStreamsInLongVarchar() {
        return false;
    }

    @Override
    public int getId() {
        return 2;
    }

    @Override
    public int getLockRetryCount(int lockRetryCount, int waitRecord) {
        return lockRetryCount;
    }

    @Override
    public boolean connectionClosed(SQLException e) {
        return false;
    }
}

