/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db.driver;

import com.genexus.CommonUtil;
import com.genexus.DebugFlag;
import com.genexus.db.driver.DataSource;
import com.genexus.db.driver.GXConnection;
import com.genexus.db.driver.GXDBMS;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;

public class GXDBMSinformix
implements GXDBMS {
    private static final boolean DEBUG = DebugFlag.DEBUG;
    private boolean logged = true;
    private boolean notlogged = true;
    private DataSource dataSource;

    @Override
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.logged = dataSource.getInformixDB().equals(DataSource.INFORMIX_DB_LOGGED);
    }

    @Override
    public boolean isAlive(GXConnection con) {
        try {
            this.serverDateTime(con);
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    @Override
    public ResultSet executeQuery(PreparedStatement stmt, boolean hold) throws SQLException {
        try {
            Method m = Class.forName("com.informix.jdbc.IfxPreparedStatement").getMethod("executeQuery", Boolean.TYPE);
            return (ResultSet)m.invoke((Object)stmt, hold);
        }
        catch (Throwable e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            return stmt.executeQuery();
        }
    }

    @Override
    public int executeUpdate(PreparedStatement stmt) throws SQLException {
        return stmt.executeUpdate();
    }

    @Override
    public boolean execute(PreparedStatement stmt) throws SQLException {
        return stmt.execute();
    }

    @Override
    public int[] executeBatch(Statement stmt) throws SQLException {
        return stmt.executeBatch();
    }

    @Override
    public boolean DataTruncation(SQLException e) {
        return false;
    }

    @Override
    public boolean useReadOnlyConnections() {
        return true;
    }

    @Override
    public boolean EndOfFile(SQLException e) {
        return e.getErrorCode() == 100;
    }

    @Override
    public boolean ReferentialIntegrity(SQLException e) {
        return false;
    }

    @Override
    public boolean DuplicateKeyValue(SQLException e) {
        return e.getErrorCode() == -239 || e.getErrorCode() == -268 || e.getErrorCode() == -346 && e.getNextException() != null && e.getNextException().getErrorCode() == -100;
    }

    @Override
    public boolean ObjectLocked(SQLException e) {
        return e.getErrorCode() == -243 || e.getErrorCode() == -244 || e.getErrorCode() == -245;
    }

    @Override
    public boolean ObjectNotFound(SQLException e) {
        return e.getErrorCode() == -206 || e.getErrorCode() == -319 || e.getErrorCode() == -623;
    }

    @Override
    public Date nullDate() {
        return CommonUtil.ymdhmsToT_noYL((int)1, (int)1, (int)1, (int)0, (int)0, (int)0);
    }

    @Override
    public boolean useDateTimeInDate() {
        return false;
    }

    @Override
    public boolean useCharInDate() {
        return false;
    }

    @Override
    public void setConnectionProperties(Properties props) {
    }

    @Override
    public void commit(Connection con) throws SQLException {
        con.commit();
        if (this.logged) {
            if (DEBUG) {
                this.dataSource.getLog().log(0, "BEGIN WORK");
            }
            Statement s1 = con.createStatement();
            s1.executeUpdate("BEGIN WORK");
            s1.close();
        }
    }

    @Override
    public void rollback(Connection con) throws SQLException {
        con.rollback();
        if (this.logged) {
            if (DEBUG) {
                this.dataSource.getLog().log(0, "BEGIN WORK");
            }
            Statement s1 = con.createStatement();
            s1.executeUpdate("BEGIN WORK");
            s1.close();
        }
    }

    @Override
    public void onConnection(GXConnection con) throws SQLException {
        Statement s1;
        if (this.dataSource.getInformixDB().equals(DataSource.INFORMIX_DB_LOGGED)) {
            s1 = con.createStatement();
            s1.executeUpdate("BEGIN WORK");
            s1.close();
        }
        if (this.dataSource.waitRecord > 0) {
            s1 = con.createStatement();
            s1.executeUpdate("SET LOCK MODE TO WAIT " + this.dataSource.waitRecord);
            s1.close();
            con.setCommitedChanges();
        } else {
            s1 = con.createStatement();
            s1.executeUpdate("SET LOCK MODE TO WAIT");
            s1.close();
            con.setCommitedChanges();
        }
    }

    @Override
    public Date serverDateTime(GXConnection con) throws SQLException {
        ResultSet rslt = con.getStatement("_ServerDT_", "SELECT CURRENT YEAR TO FRACTION(3) FROM informix.SYSTABLES WHERE tabname = 'systables'", false).executeQuery();
        rslt.next();
        Timestamp value = rslt.getTimestamp(1);
        rslt.close();
        return value;
    }

    @Override
    public String serverVersion(GXConnection con) throws SQLException {
        return "";
    }

    @Override
    public String connectionPhysicalId(GXConnection con) {
        return "";
    }

    @Override
    public boolean getSupportsAutocommit() {
        return !this.dataSource.getInformixDB().equals(DataSource.INFORMIX_DB_ANSI);
    }

    @Override
    public void setDatabaseName(String dbName) {
    }

    @Override
    public String getDatabaseName() {
        return "";
    }

    @Override
    public void setInReorg() {
    }

    @Override
    public boolean ignoreConnectionError(SQLException e) {
        return false;
    }

    @Override
    public boolean rePrepareStatement(SQLException e) {
        return false;
    }

    @Override
    public boolean getSupportsQueryTimeout() {
        return false;
    }

    @Override
    public boolean useStreamsInNullLongVarchar() {
        return true;
    }

    @Override
    public boolean useStreamsInLongVarchar() {
        return true;
    }

    @Override
    public int getId() {
        return 4;
    }

    @Override
    public int getLockRetryCount(int lockRetryCount, int waitRecord) {
        return lockRetryCount;
    }

    @Override
    public boolean connectionClosed(SQLException e) {
        return e.getErrorCode() == -79716;
    }
}

