/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db.driver;

import com.genexus.ApplicationContext;
import com.genexus.CommonUtil;
import com.genexus.db.driver.DataSource;
import com.genexus.db.driver.GXConnection;
import com.genexus.db.driver.GXDBMS;
import com.genexus.db.service.ServiceError;
import com.genexus.db.service.ServiceException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Properties;

public class GXDBMSservice
implements GXDBMS {
    public static final String DATASOURCE_NAME = "servicedatasource";
    private DataSource dataSource;

    @Override
    public void setDatabaseName(String dbName) {
    }

    @Override
    public String getDatabaseName() {
        return "";
    }

    @Override
    public ResultSet executeQuery(PreparedStatement stmt, boolean hold) throws SQLException {
        try {
            return stmt.executeQuery();
        }
        catch (ServiceException e) {
            throw new SQLException(e.getMessage(), e.getSQLState(), e.getVendorCode(), e);
        }
    }

    @Override
    public int executeUpdate(PreparedStatement stmt) throws SQLException {
        return stmt.executeUpdate();
    }

    @Override
    public boolean execute(PreparedStatement stmt) throws SQLException {
        return stmt.execute();
    }

    @Override
    public int[] executeBatch(Statement stmt) throws SQLException {
        return stmt.executeBatch();
    }

    @Override
    public void setInReorg() {
    }

    @Override
    public boolean isAlive(GXConnection con) {
        try {
            return !con.isClosed();
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public boolean DataTruncation(SQLException e) {
        return e.getErrorCode() == ServiceError.DATA_TRUNCATION.getCode();
    }

    @Override
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public boolean useReadOnlyConnections() {
        return true;
    }

    @Override
    public boolean EndOfFile(SQLException e) {
        return e.getErrorCode() == ServiceError.END_OF_FILE.getCode();
    }

    @Override
    public boolean ReferentialIntegrity(SQLException e) {
        return e.getErrorCode() == ServiceError.REFERENTIAL_INTEGRITY.getCode();
    }

    @Override
    public boolean DuplicateKeyValue(SQLException e) {
        return e.getErrorCode() == ServiceError.DUPLICATE_KEY.getCode();
    }

    @Override
    public boolean ObjectLocked(SQLException e) {
        return e.getErrorCode() == ServiceError.OBJECT_LOCKED.getCode();
    }

    @Override
    public boolean ObjectNotFound(SQLException e) {
        return e.getErrorCode() == ServiceError.OBJECT_NOT_FOUND.getCode();
    }

    @Override
    public Date nullDate() {
        return CommonUtil.ymdhmsToT_noYL((int)1, (int)1, (int)1, (int)0, (int)0, (int)0);
    }

    @Override
    public boolean useDateTimeInDate() {
        return false;
    }

    @Override
    public boolean useCharInDate() {
        return false;
    }

    @Override
    public void setConnectionProperties(Properties props) {
        props.setProperty(DATASOURCE_NAME, this.dataSource.getName());
    }

    @Override
    public void onConnection(GXConnection con) throws SQLException {
    }

    @Override
    public Date serverDateTime(GXConnection con) throws SQLException {
        return CommonUtil.now();
    }

    @Override
    public String serverVersion(GXConnection con) throws SQLException {
        return con.getClientInfo("SERVER_VERSION");
    }

    @Override
    public String connectionPhysicalId(GXConnection con) {
        return "";
    }

    @Override
    public boolean getSupportsAutocommit() {
        return true;
    }

    @Override
    public void commit(Connection con) throws SQLException {
        if (!ApplicationContext.getInstance().getReorganization()) {
            con.commit();
        }
    }

    @Override
    public void rollback(Connection con) throws SQLException {
        if (!ApplicationContext.getInstance().getReorganization()) {
            con.rollback();
        }
    }

    @Override
    public boolean ignoreConnectionError(SQLException e) {
        return false;
    }

    @Override
    public boolean rePrepareStatement(SQLException e) {
        return false;
    }

    @Override
    public boolean getSupportsQueryTimeout() {
        return false;
    }

    @Override
    public boolean useStreamsInNullLongVarchar() {
        return false;
    }

    @Override
    public boolean useStreamsInLongVarchar() {
        return false;
    }

    @Override
    public int getId() {
        return 11;
    }

    @Override
    public int getLockRetryCount(int lockRetryCount, int waitRecord) {
        return lockRetryCount;
    }

    @Override
    public boolean connectionClosed(SQLException e) {
        return e.getErrorCode() == ServiceError.CONNECTION_CLOSED.getCode();
    }
}

