/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db.driver;

import com.genexus.CommonUtil;
import com.genexus.db.driver.DataSource;
import com.genexus.db.driver.GXConnection;
import com.genexus.db.driver.GXDBMS;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;

public class GXDBMSsqlserver
implements GXDBMS {
    private DataSource dataSource;
    public boolean allowsCommitWithAutocommit = true;

    @Override
    public ResultSet executeQuery(PreparedStatement stmt, boolean hold) throws SQLException {
        return stmt.executeQuery();
    }

    @Override
    public int executeUpdate(PreparedStatement stmt) throws SQLException {
        return stmt.executeUpdate();
    }

    @Override
    public boolean execute(PreparedStatement stmt) throws SQLException {
        return stmt.execute();
    }

    @Override
    public int[] executeBatch(Statement stmt) throws SQLException {
        return stmt.executeBatch();
    }

    @Override
    public void setDatabaseName(String dbName) {
    }

    @Override
    public String getDatabaseName() {
        return "";
    }

    @Override
    public void setInReorg() {
    }

    @Override
    public boolean isAlive(GXConnection con) {
        try {
            this.serverDateTime(con);
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean DataTruncation(SQLException e) {
        return false;
    }

    @Override
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public boolean useReadOnlyConnections() {
        return true;
    }

    @Override
    public boolean EndOfFile(SQLException e) {
        return e.getErrorCode() == 100;
    }

    @Override
    public boolean ReferentialIntegrity(SQLException e) {
        return e.getErrorCode() == 547;
    }

    @Override
    public boolean DuplicateKeyValue(SQLException e) {
        return e.getErrorCode() == 2627 || e.getErrorCode() == 2601;
    }

    @Override
    public boolean ObjectLocked(SQLException e) {
        return e.getErrorCode() == 1000 || e.getErrorCode() == 1222 || e.getErrorCode() == 903;
    }

    @Override
    public boolean ObjectNotFound(SQLException e) {
        return e.getErrorCode() == 3704 || e.getErrorCode() == 3703 || e.getErrorCode() == 3701 || e.getErrorCode() == 4902 || e.getErrorCode() == 3728 || e.getErrorCode() == 3727 || e.getErrorCode() == 1801 || e.getErrorCode() == 15032;
    }

    @Override
    public Date nullDate() {
        return CommonUtil.ymdhmsToT_noYL((int)1753, (int)1, (int)1, (int)0, (int)0, (int)0);
    }

    @Override
    public boolean useDateTimeInDate() {
        return this.dataSource.jdbcDriver.startsWith("com.microsoft.jdbc.sqlserver") || this.dataSource.jdbcDriver.startsWith("com.ddtek.jdbc.sqlserver.SQLServerDriver");
    }

    @Override
    public boolean useCharInDate() {
        return false;
    }

    @Override
    public void setConnectionProperties(Properties props) {
    }

    @Override
    public void onConnection(GXConnection con) throws SQLException {
        if (this.dataSource.waitRecord > 0) {
            Statement s1 = con.createStatement();
            s1.executeUpdate("SET LOCK_TIMEOUT " + this.dataSource.waitRecord * 1000);
            s1.close();
            con.setCommitedChanges();
        }
        if (con.getDataSource().jdbcDriver.startsWith("net.sourceforge.jtds.") || con.getDataSource().jdbcDriver.startsWith("com.microsoft.sqlserver.jdbc.SQLServerDriver")) {
            this.allowsCommitWithAutocommit = false;
        }
    }

    @Override
    public Date serverDateTime(GXConnection con) throws SQLException {
        ResultSet rslt = con.getStatement("_ServerDT_", "SELECT GETDATE()", false).executeQuery();
        rslt.next();
        Timestamp value = rslt.getTimestamp(1);
        rslt.close();
        return value;
    }

    @Override
    public String serverVersion(GXConnection con) throws SQLException {
        ResultSet rslt = con.getStatement("_ServerVERSION_", "SELECT CAST(SERVERPROPERTY('ResourceVersion') AS VARCHAR(20)), CAST(SERVERPROPERTY('productversion') AS VARCHAR(20))", false).executeQuery();
        rslt.next();
        String value = rslt.getString(1);
        if (rslt.wasNull()) {
            value = rslt.getString(2);
        }
        rslt.close();
        return value.replaceAll("10.", "9.");
    }

    @Override
    public String connectionPhysicalId(GXConnection con) {
        try {
            ResultSet rslt = con.getStatement("_ConnectionID_", "SELECT @@spid", false).executeQuery();
            rslt.next();
            String value = rslt.getString(1);
            rslt.close();
            return value;
        }
        catch (SQLException e) {
            return "";
        }
    }

    @Override
    public boolean getSupportsAutocommit() {
        return true;
    }

    @Override
    public void commit(Connection con) throws SQLException {
        if (this.allowsCommitWithAutocommit || !con.getAutoCommit()) {
            con.commit();
        }
    }

    @Override
    public void rollback(Connection con) throws SQLException {
        if (this.allowsCommitWithAutocommit || !con.getAutoCommit()) {
            con.rollback();
        }
    }

    @Override
    public boolean ignoreConnectionError(SQLException e) {
        return false;
    }

    @Override
    public boolean rePrepareStatement(SQLException e) {
        return false;
    }

    @Override
    public boolean getSupportsQueryTimeout() {
        return true;
    }

    @Override
    public boolean useStreamsInNullLongVarchar() {
        return false;
    }

    @Override
    public boolean useStreamsInLongVarchar() {
        return false;
    }

    @Override
    public int getId() {
        return 8;
    }

    @Override
    public int getLockRetryCount(int lockRetryCount, int waitRecord) {
        return lockRetryCount;
    }

    @Override
    public boolean connectionClosed(SQLException e) {
        return e.getSQLState() == "08S01";
    }
}

