/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db.driver;

import com.genexus.Application;
import com.genexus.CommonUtil;
import com.genexus.DebugFlag;
import com.genexus.DecimalUtil;
import com.genexus.GXDbFile;
import com.genexus.GXutil;
import com.genexus.LocalUtil;
import com.genexus.ModelContext;
import com.genexus.Preferences;
import com.genexus.PrivateUtilities;
import com.genexus.common.classes.IGXPreparedStatement;
import com.genexus.common.interfaces.SpecificImplementation;
import com.genexus.db.IFieldSetter;
import com.genexus.db.driver.ExternalProvider;
import com.genexus.db.driver.ExternalProviderCommon;
import com.genexus.db.driver.GXCallableStatement;
import com.genexus.db.driver.GXConnection;
import com.genexus.db.driver.GXDBDebug;
import com.genexus.db.driver.GXDBMSas400;
import com.genexus.db.driver.GXDBMSdameng;
import com.genexus.db.driver.GXDBMSoracle7;
import com.genexus.db.driver.GXResultSet;
import com.genexus.db.driver.GXStatement;
import com.genexus.db.driver.ResourceAccessControlList;
import com.genexus.internet.HttpContext;
import com.genexus.util.GXFile;
import com.genexus.webpanels.HttpContextWeb;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.UUID;
import java.util.Vector;

public class GXPreparedStatement
extends GXStatement
implements PreparedStatement,
IFieldSetter,
IGXPreparedStatement {
    private static final boolean DEBUG = DebugFlag.DEBUG;
    public static final int PLSQL_BOOLEAN = 252;
    public static boolean longVarCharAsOracleLong = false;
    public static LocalUtil localUtil = new LocalUtil('.', "MDY", "24", 40, "eng");
    private PreparedStatement stmt;
    private String sqlSentence;
    private String cursorId;
    private boolean currentOf;
    private long creationTime;
    private Vector<InputStream> streamsToClose;
    private int recordCount;
    private int batchSize;
    private Object[] batchRecords;
    private Object onCommitInstance;
    private String onCommitMethod;
    private boolean batchStmt;
    boolean fieldAcceptsNull = true;
    public static boolean addSpaceToEmptyVarChar = true;
    public static boolean avoidDataTruncationError = false;
    protected boolean skipSetBlobs = false;
    protected String[] blobFiles;
    private boolean isUpdateBlobStmt = false;

    public GXPreparedStatement(PreparedStatement stmt, GXConnection con, int handle, String sqlSentence, String cursorId) {
        this(stmt, con, handle, sqlSentence, cursorId, false);
    }

    public GXPreparedStatement(PreparedStatement stmt, GXConnection con, int handle, String sqlSentence, String cursorId, boolean currentOf) {
        super(stmt, con, handle);
        this.stmt = stmt;
        this.con = con;
        this.sqlSentence = sqlSentence;
        this.cursorId = cursorId;
        this.currentOf = currentOf;
        this.creationTime = System.currentTimeMillis();
        this.streamsToClose = new Vector();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getSqlStatement() {
        return this.sqlSentence;
    }

    public String getCursorId() {
        return this.cursorId;
    }

    public boolean getCurrentOf() {
        return this.currentOf;
    }

    public String getCacheId(GXConnection conn) {
        if (this.isBatch() || this.getCurrentOf() && conn.getDBMS() instanceof GXDBMSas400) {
            return this.getCursorId();
        }
        return this.getSqlStatement();
    }

    public int getHandle() {
        return this.handle;
    }

    public void setHandle(int handle) {
        this.handle = handle;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery(false);
    }

    public ResultSet executeQuery(boolean hold) throws SQLException {
        this.con.incNumberRequest();
        this.con.setSentenceLastRequest(this.getSqlStatement());
        GXResultSet result = null;
        try {
            if (this.con.getDBMS().getSupportsQueryTimeout() && this.stmt.getQueryTimeout() > 0) {
                this.setQueryTimeout(0);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (DEBUG) {
            try {
                if (this.con.getDBMS().getSupportsQueryTimeout()) {
                    this.log(0, "executeQuery start timeout " + this.stmt.getQueryTimeout());
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                result = new GXResultSet(this.con.getDBMS().executeQuery(this.stmt, hold), this, this.con, this.handle);
                this.log(2, "executeQuery - id = " + this + " - " + GXDBDebug.getJDBCObjectId(result));
                GXResultSet gXResultSet = result;
                return gXResultSet;
            }
            catch (SQLException sqlException) {
                if (!this.con.getDBMS().ObjectLocked(sqlException)) {
                    this.notInUse();
                }
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
            finally {
                this.closeOpenedStreams();
            }
        }
        try {
            result = new GXResultSet(this.con.getDBMS().executeQuery(this.stmt, hold), this, this.con, this.handle);
        }
        catch (SQLException sqlException) {
            if (!this.con.getDBMS().ObjectLocked(sqlException)) {
                this.notInUse();
            }
            throw sqlException;
        }
        finally {
            this.closeOpenedStreams();
        }
        this.creationTime = System.currentTimeMillis();
        return result;
    }

    @Override
    public boolean execute() throws SQLException {
        this.con.incNumberRequest();
        this.con.setSentenceLastRequest(this.getSqlStatement());
        if (DEBUG) {
            this.log(0, "Warning: execute");
            try {
                boolean ret;
                boolean bl = ret = this.con.getDBMS().execute(this.stmt);
                return bl;
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
            finally {
                this.closeOpenedStreams();
            }
        }
        try {
            boolean ret;
            boolean sqlException = ret = this.con.getDBMS().execute(this.stmt);
            return sqlException;
        }
        catch (SQLException sqlException) {
            throw sqlException;
        }
        finally {
            this.closeOpenedStreams();
        }
    }

    private void closeOpenedStreams() {
        Enumeration<InputStream> e = this.streamsToClose.elements();
        while (e.hasMoreElements()) {
            try {
                e.nextElement().close();
            }
            catch (IOException ioex) {
                if (!DEBUG) continue;
                System.err.println("Error closing stream: " + ioex.getMessage());
            }
        }
        this.streamsToClose.removeAllElements();
    }

    private void log(int level, String text) {
        if (DEBUG) {
            this.con.log(level, this, text);
        }
    }

    public void notInUse() {
        this.con.setNotInUse(this);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.con.incNumberRequest();
        this.con.setSentenceLastRequest(this.getSqlStatement());
        int[] ret = null;
        SQLException sqlException = null;
        this.con.setUncommitedChanges();
        try {
            if (DEBUG) {
                this.log(2, "executeBatch");
                ret = super.executeBatch();
            } else {
                ret = super.executeBatch();
            }
        }
        catch (SQLException e) {
            if (DEBUG && this.con.isLogEnabled()) {
                this.con.logSQLException(this.con.getHandle(), e);
            }
            sqlException = e;
        }
        this.closeOpenedStreams();
        this.con.setNotInUse(this);
        if (sqlException != null) {
            throw sqlException;
        }
        return ret;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.con.incNumberRequest();
        this.con.setSentenceLastRequest(this.getSqlStatement());
        int ret = 0;
        SQLException sqlException = null;
        this.con.setUncommitedChanges();
        try {
            if (DEBUG) {
                this.log(2, "executeUpdate");
                ret = this.con.getDBMS().executeUpdate(this.stmt);
            } else {
                ret = this.con.getDBMS().executeUpdate(this.stmt);
            }
        }
        catch (SQLException e) {
            if (DEBUG && this.con.isLogEnabled()) {
                this.con.logSQLException(this.con.getHandle(), e);
            }
            sqlException = e;
        }
        this.closeOpenedStreams();
        this.con.setNotInUse(this);
        if (sqlException != null) {
            throw sqlException;
        }
        return ret;
    }

    @Override
    public void setNull(int index, int sqlType) throws SQLException {
        if (DEBUG) {
            this.log(0, "setNull - index : " + index + " sqlType : " + sqlType);
            try {
                this.stmt.setNull(index, sqlType);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.setNull(index, sqlType);
        }
    }

    @Override
    public void setBoolean(int index, boolean value) throws SQLException {
        if (DEBUG) {
            this.log(0, "setBoolean - index : " + index + " value : " + value);
            try {
                if (this instanceof GXCallableStatement && !this.isUpdateBlobStmt && (this.con.getDBMS().getId() == 6 || this.con.getDBMS().getId() == 12)) {
                    this.stmt.setObject(index, (Object)value, 252);
                }
                this.stmt.setBoolean(index, value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else if (this instanceof GXCallableStatement && !this.isUpdateBlobStmt && (this.con.getDBMS().getId() == 6 || this.con.getDBMS().getId() == 12)) {
            this.stmt.setObject(index, (Object)value, 252);
        } else {
            this.stmt.setBoolean(index, value);
        }
    }

    @Override
    public void setByte(int index, byte value) throws SQLException {
        if (DEBUG) {
            this.log(0, "setByte - index : " + index + " value : " + value);
            try {
                this.stmt.setByte(index, value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.setByte(index, value);
        }
    }

    @Override
    public void setShort(int index, short value) throws SQLException {
        if (DEBUG) {
            this.log(0, "setShort - index : " + index + " value : " + value);
            try {
                this.stmt.setShort(index, value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.setShort(index, value);
        }
    }

    @Override
    public void setInt(int index, int value) throws SQLException {
        if (DEBUG) {
            this.log(0, "setInt - index : " + index + " value : " + value);
            try {
                this.stmt.setInt(index, value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.setInt(index, value);
        }
    }

    @Override
    public void setLong(int index, long value) throws SQLException {
        if (DEBUG) {
            this.log(0, "setLong - index : " + index + " value : " + value);
            try {
                this.stmt.setLong(index, value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.setLong(index, value);
        }
    }

    @Override
    public void setFloat(int index, float value) throws SQLException {
        if (DEBUG) {
            this.log(0, "setFloat - index : " + index + " value : " + value);
            try {
                this.stmt.setFloat(index, value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.setFloat(index, value);
        }
    }

    @Override
    public void setDouble(int index, double value) throws SQLException {
        if (DEBUG) {
            this.log(0, "setDouble - index : " + index + " value : " + value);
            try {
                this.stmt.setDouble(index, value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.setDouble(index, value);
        }
    }

    public void setBigDecimal(int index, double value, int decimals) throws SQLException {
        BigDecimal decimalValue = DecimalUtil.unexponentString((String)Double.toString(value)).setScale(decimals, 4);
        if (DEBUG) {
            this.log(0, "setBigDecimal (double) - index : " + index + " value : " + value + " decimal : " + decimalValue);
            try {
                this.stmt.setBigDecimal(index, decimalValue);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.setBigDecimal(index, decimalValue);
        }
    }

    public void setBigDecimal(int index, BigDecimal value, int scale) throws SQLException {
        this.setBigDecimal(index, value.setScale(scale, 4));
    }

    @Override
    public void setBigDecimal(int index, BigDecimal value) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: setBigDecimal - index : " + index + " value : " + value);
            try {
                this.stmt.setBigDecimal(index, value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.setBigDecimal(index, value);
        }
    }

    public void setVarchar(int index, String value, int length, boolean acceptsNull) throws SQLException {
        this.fieldAcceptsNull = acceptsNull;
        this.setVarchar(index, value, length);
        this.fieldAcceptsNull = false;
    }

    public void setVarchar(int index, String value) throws SQLException {
        this.setVarchar(index, value, value.length());
    }

    public void setVarchar(int index, String value, int length) throws SQLException {
        String realValue = this.con.getDBMS().getId() == 6 || this.con.getDBMS().getId() == 12 ? CommonUtil.rtrim((String)value) : value;
        if (!(!(realValue = CommonUtil.left((String)realValue, (int)length)).equals("") || !addSpaceToEmptyVarChar && this.fieldAcceptsNull || this.con.getDBMS().getId() != 6 && this.con.getDBMS().getId() != 12)) {
            realValue = " ";
        }
        if (DEBUG) {
            this.log(0, "setVarchar - index : " + index + " length " + realValue.length());
            try {
                this.stmt.setString(index, realValue);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.setString(index, realValue);
        }
    }

    public void setLongVarchar(int index, String value, int maxLength) throws SQLException {
        if (value.length() > maxLength && this.con.getDBMS().getId() == 1) {
            this.setLongVarchar(index, value.substring(0, maxLength));
        } else {
            this.setLongVarchar(index, value);
        }
    }

    public void setLongVarchar(int index, String value, int maxLength, boolean acceptsNull) throws SQLException {
        this.fieldAcceptsNull = acceptsNull;
        this.setLongVarchar(index, value, maxLength);
        this.fieldAcceptsNull = false;
    }

    public void setLongVarchar(int index, String value, boolean acceptsNull) throws SQLException {
        this.fieldAcceptsNull = acceptsNull;
        this.setLongVarchar(index, value);
        this.fieldAcceptsNull = false;
    }

    public void setNLongVarchar(int index, String value, boolean acceptsNull) throws SQLException {
        this.fieldAcceptsNull = acceptsNull;
        this.setLongVarchar2(index, value, true);
        this.fieldAcceptsNull = false;
    }

    public void setNLongVarchar(int index, String value) throws SQLException {
        this.setLongVarchar2(index, value, true);
    }

    public void setLongVarchar(int index, String value) throws SQLException {
        this.setLongVarchar2(index, value, false);
    }

    private void setLongVarchar2(int index, String value, boolean nls) throws SQLException {
        block24: {
            String realValue;
            String string = realValue = this.con.getDBMS().getId() == 6 || this.con.getDBMS().getId() == 12 ? CommonUtil.rtrim((String)value) : value;
            if (!(!realValue.equals("") || !addSpaceToEmptyVarChar && this.fieldAcceptsNull || this.con.getDBMS().getId() != 6 && this.con.getDBMS().getId() != 12)) {
                realValue = " ";
            }
            int realLength = realValue.length();
            if (DEBUG) {
                this.log(0, "setLongVarcharString - index : " + index + " length " + realLength);
                try {
                    if (realLength > 0 && this.con.getDBMS().useStreamsInLongVarchar() || realLength == 0 && this.con.getDBMS().useStreamsInNullLongVarchar()) {
                        if (this.con.getDBMS().getId() == 6 || this.con.getDBMS().getId() == 12) {
                            try {
                                if (!nls && !longVarCharAsOracleLong) {
                                    try {
                                        this.setOracleClob(index, realValue);
                                    }
                                    catch (Exception exc) {
                                        this.setUnicodeStream(index, realValue);
                                    }
                                }
                                if (nls) {
                                    this.oracleSetFormOfUse(index);
                                }
                                this.setUnicodeStream(index, realValue);
                            }
                            catch (UnsupportedEncodingException e) {
                                this.stmt.setAsciiStream(index, (InputStream)new ByteArrayInputStream(realValue.getBytes()), realLength);
                            }
                        }
                        this.stmt.setAsciiStream(index, (InputStream)new ByteArrayInputStream(realValue.getBytes()), realLength);
                    }
                    this.setStringRealLength(index, realValue, realLength);
                }
                catch (SQLException sqlException) {
                    if (this.con.isLogEnabled()) {
                        this.con.logSQLException(this.con.getHandle(), sqlException);
                    }
                    throw sqlException;
                }
            } else if (realLength > 0 && this.con.getDBMS().useStreamsInLongVarchar() || realLength == 0 && this.con.getDBMS().useStreamsInNullLongVarchar()) {
                if (this.con.getDBMS().getId() == 6) {
                    try {
                        if (!nls && !longVarCharAsOracleLong) {
                            try {
                                this.setOracleClob(index, realValue);
                            }
                            catch (Exception exc) {
                                this.setUnicodeStream(index, realValue);
                            }
                            break block24;
                        }
                        if (nls) {
                            this.oracleSetFormOfUse(index);
                        }
                        this.setUnicodeStream(index, realValue);
                    }
                    catch (UnsupportedEncodingException e) {
                        this.stmt.setAsciiStream(index, (InputStream)new ByteArrayInputStream(realValue.getBytes()), realLength);
                    }
                } else {
                    this.stmt.setAsciiStream(index, (InputStream)new ByteArrayInputStream(realValue.getBytes()), realLength);
                }
            } else {
                this.setStringRealLength(index, realValue, realLength);
            }
        }
    }

    public void oracleSetFormOfUse(int index) {
        try {
            Method setFormOfUseMth = this.stmt.getClass().getMethod("setFormOfUse", Integer.TYPE, Short.TYPE);
            if (setFormOfUseMth != null && setFormOfUseMth.isAccessible()) {
                setFormOfUseMth.invoke((Object)this.stmt, new Integer(index), Class.forName("oracle.jdbc.OraclePreparedStatement").getField("FORM_NCHAR").get(null));
            }
        }
        catch (Exception ex1) {
            System.out.println(ex1.getMessage());
        }
    }

    private void setUnicodeStream(int index, String value) throws SQLException, UnsupportedEncodingException {
        byte[] unicodeBytes = value.getBytes("UnicodeBigUnmarked");
        this.stmt.setCharacterStream(index, (Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(unicodeBytes), "UnicodeBigUnmarked"), unicodeBytes.length);
    }

    private void setOracleClob(int index, String value) throws SQLException {
        Clob tempClob = this.con.getJDBCConnection().createClob();
        tempClob.setString(1L, value);
        this.stmt.setClob(index, tempClob);
    }

    public void setParameterRT(String name, String value) {
    }

    public void setStringRealLength(int index, String value, int length) throws SQLException {
        if (DEBUG) {
            this.log(0, "setString - index : " + index + " value : " + value + " length " + length);
            try {
                this.stmt.setString(index, CommonUtil.padr((String)value, (int)length, (String)" "));
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.setString(index, CommonUtil.padr((String)value, (int)length, (String)" "));
        }
    }

    public void setString(int index, String value, int length) throws SQLException {
        if (avoidDataTruncationError) {
            value = CommonUtil.padr((String)value, (int)length, (String)" ");
        } else if (this.con.getDBMS().getId() == 10) {
            value = CommonUtil.left((String)value, (int)length);
        }
        if (value.equals("") && (this.con.getDBMS().getId() == 6 || this.con.getDBMS().getId() == 12)) {
            value = " ";
        }
        if (DEBUG) {
            this.log(0, "setString - index : " + index + " value : " + value);
            try {
                if (this.con.getDBMS().getId() == 6 || this.con.getDBMS().getId() == 12) {
                    this.stmt.setObject(index, value);
                }
                this.stmt.setString(index, value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else if (this.con.getDBMS().getId() == 6 || this.con.getDBMS().getId() == 12) {
            this.stmt.setObject(index, value);
        } else {
            this.stmt.setString(index, value);
        }
    }

    @Override
    public void setString(int index, String value) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: setString: " + value);
        }
        this.stmt.setString(index, value);
    }

    public void setGXDbFileURI(int index, String fileName, String blobPath, int length) throws SQLException {
        this.setGXDbFileURI(index, fileName, blobPath, length, null, null);
    }

    public void setGXDbFileURI(int index, String fileName, String blobPath, int length, String tableName, String fieldName, boolean downloadContent) throws SQLException {
        this.setGXDbFileURI(index, fileName, blobPath, length, tableName, fieldName);
    }

    public void setGXDbFileURI(int index, String fileName, String blobPath, int length, String tableName, String fieldName) throws SQLException {
        String fileUri;
        block22: {
            boolean attInExternalStorage;
            ExternalProvider storageProvider = Application.getExternalProvider();
            fileName = fileName.trim();
            blobPath = blobPath.trim();
            String uploadNameValue = SpecificImplementation.GXutil.getUploadNameValue(blobPath);
            if (blobPath == null || blobPath.trim().length() == 0) {
                this.setVarchar(index, ExternalProviderCommon.getProviderObjectAbsoluteUriSafe((ExternalProvider)storageProvider, (String)fileName), length, false);
                return;
            }
            fileUri = "";
            String multimediaTemporalPath = Preferences.getDefaultPreferences().getMultimediaPath();
            if (!(fileName.length() <= 0 || blobPath.startsWith(multimediaTemporalPath) && GXutil.isAbsoluteURL(fileName))) {
                fileUri = GXDbFile.generateUri(fileName, GXDbFile.hasToken(fileName) == false, true);
            } else if (blobPath.trim().length() > 0) {
                blobPath = GXutil.cutUploadPrefix(blobPath);
                File file = new File(blobPath);
                fileUri = GXDbFile.generateUri(uploadNameValue.isEmpty() ? file.getName() : uploadNameValue, GXDbFile.hasToken(blobPath) == false, true);
            }
            boolean externalStorageEnabled = storageProvider != null;
            boolean bl = attInExternalStorage = externalStorageEnabled && tableName != null && fieldName != null;
            if (!attInExternalStorage) {
                this.setVarchar(index, fileUri, length, false);
                return;
            }
            String storageObjectName = ExternalProviderCommon.getProviderObjectName((ExternalProvider)storageProvider, (String)blobPath);
            boolean resourceAlreadyOnStorage = storageObjectName != null;
            ResourceAccessControlList defaultAcl = ResourceAccessControlList.Default;
            String storageTargetObjectName = blobPath;
            boolean isPrivateTempUpload = storageTargetObjectName.startsWith(Application.getClientPreferences().getTMPMEDIA_DIR());
            String folder = Application.getGXServices().get("Storage").getProperties().get("FOLDER_NAME");
            if (!resourceAlreadyOnStorage && (fileName.equals(blobPath) || GXutil.isAbsoluteURL(fileName))) {
                try (InputStream is = new URL(fileName).openStream();){
                    int idx = storageTargetObjectName.lastIndexOf("/");
                    if (idx != -1 && idx < storageTargetObjectName.length() - 1) {
                        storageTargetObjectName = storageTargetObjectName.substring(idx + 1);
                    }
                    storageTargetObjectName = PrivateUtilities.getTempFileName("", CommonUtil.getFileName((String)storageTargetObjectName), CommonUtil.getFileType((String)storageTargetObjectName), true);
                    storageTargetObjectName = folder + "/" + tableName + "/" + fieldName + "/" + storageTargetObjectName;
                    fileUri = Application.getExternalProvider().upload(storageTargetObjectName, is, defaultAcl);
                    break block22;
                }
                catch (IOException e) {
                    throw new SQLException("An error occurred while downloading data from url: " + fileName + e.getMessage());
                }
            }
            if (resourceAlreadyOnStorage && !isPrivateTempUpload) {
                fileUri = storageObjectName;
            } else {
                GXFile gxFile = new GXFile(storageTargetObjectName, ResourceAccessControlList.Private);
                if (gxFile.exists()) {
                    fileName = uploadNameValue.isEmpty() ? gxFile.getName() : uploadNameValue;
                    int idx = fileName.lastIndexOf("/");
                    if (idx != -1 && idx < fileName.length() - 1) {
                        fileName = fileName.substring(idx + 1);
                    }
                    fileName = PrivateUtilities.getTempFileName("", CommonUtil.getFileName((String)fileName), CommonUtil.getFileType((String)fileName), true);
                    fileUri = storageProvider.copy(gxFile.getAbsoluteName(), fileName, tableName, fieldName, defaultAcl);
                } else {
                    HttpContext webContext;
                    int idx = blobPath.lastIndexOf("/");
                    if (idx != -1 && idx < blobPath.length() - 1) {
                        fileName = blobPath.substring(idx + 1);
                    }
                    fileName = PrivateUtilities.getTempFileName("", CommonUtil.getFileName((String)fileName), CommonUtil.getFileType((String)fileName), true);
                    fileName = folder + "/" + tableName + "/" + fieldName + "/" + fileName;
                    if (this.con.getContext() != null && (webContext = (HttpContext)this.con.getContext().getHttpContext()) != null && webContext instanceof HttpContextWeb && (blobPath.startsWith(webContext.getContextPath()) || blobPath.startsWith(webContext.getDefaultPath()))) {
                        blobPath = ((HttpContextWeb)webContext).getRealPath(blobPath);
                    }
                    fileUri = storageProvider.upload(blobPath, fileName, defaultAcl);
                }
            }
        }
        this.setVarchar(index, fileUri, length, false);
    }

    @Override
    public void setBytes(int index, byte[] value) throws SQLException {
        if (DEBUG) {
            this.log(0, "setBytes - index : " + index + " value : " + Arrays.toString(value));
            try {
                this.stmt.setBytes(index, value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.setBytes(index, value);
        }
    }

    public void setGUID(int index, UUID value) throws SQLException {
        if (DEBUG) {
            this.log(0, "setGUID - index : " + index + " value : " + value.toString());
            try {
                this.stmt.setString(index, value.toString());
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.setString(index, value.toString());
        }
    }

    public void setDateTime(int index, java.util.Date value, boolean onlyTime) throws SQLException {
        this.setDateTime(index, value, onlyTime, false);
    }

    public void setDateTime(int index, java.util.Date value, boolean onlyTime, boolean onlyDate, boolean hasmilliseconds) throws SQLException {
        this.setDateTime(index, value, onlyTime, hasmilliseconds);
    }

    public void setDateTime(int index, java.util.Date value, boolean onlyTime, boolean hasmilliseconds) throws SQLException {
        if (onlyTime && !value.equals(CommonUtil.nullDate())) {
            Calendar valueCalendar = GregorianCalendar.getInstance();
            valueCalendar.setTime(value);
            java.util.Date newValue = this.con.getNullDate();
            Calendar newCalendar = GregorianCalendar.getInstance();
            newCalendar.setTime(newValue);
            newCalendar.set(11, valueCalendar.get(11));
            newCalendar.set(12, valueCalendar.get(12));
            newCalendar.set(13, valueCalendar.get(13));
            value = hasmilliseconds ? CommonUtil.dtaddms((java.util.Date)newCalendar.getTime(), (double)((double)CommonUtil.millisecond((java.util.Date)value) / 1000.0)) : newCalendar.getTime();
        }
        if (!onlyTime && ModelContext.getModelContext() != null) {
            value = ModelContext.getModelContext().local2DBserver(value);
        }
        if (DEBUG) {
            this.log(0, "setDateTime - index : " + index + " value : " + value + " isnull " + value.equals(CommonUtil.nullDate()));
        }
        try {
            if (DEBUG) {
                this.log(0, "setDateTime - index : " + index + " time : " + new Timestamp(value.equals(CommonUtil.nullDate()) ? this.con.getNullDate().getTime() : value.getTime()));
            }
            if (this.con.getDBMS().getId() == 7 && this.saveNullDate(value)) {
                this.stmt.setDate(index, new Date(this.con.getNullDate().getTime()));
            } else if (hasmilliseconds) {
                if (this.con.getDBMS().getId() == 8 || this.con.getDBMS().getId() == 5) {
                    this.stmt.setString(index, new Timestamp(this.saveNullDate(value) ? this.con.getNullDate().getTime() : value.getTime()).toString());
                } else {
                    this.stmt.setTimestamp(index, new Timestamp(this.saveNullDate(value) ? this.con.getNullDate().getTime() : value.getTime()));
                }
            } else {
                this.stmt.setTimestamp(index, new Timestamp(this.saveNullDate(value) ? this.con.getNullDate().getTime() : CommonUtil.resetMillis((java.util.Date)value).getTime()));
            }
        }
        catch (SQLException sqlException) {
            if (this.con.isLogEnabled()) {
                this.con.logSQLException(this.con.getHandle(), sqlException);
            }
            throw sqlException;
        }
    }

    private boolean saveNullDate(java.util.Date value) {
        return value.equals(CommonUtil.nullDate()) || value.before(this.con.getNullDate());
    }

    public void setDate(int index, java.util.Date value) throws SQLException {
        if (DEBUG) {
            this.log(0, "setDate - index : " + index + " value : " + value + " time " + value.getTime());
        }
        if (this.con.getDBMS().useDateTimeInDate()) {
            this.setDateTime(index, value, false);
        } else if (this.con.getDBMS().useCharInDate()) {
            if (value.equals(CommonUtil.nullDate())) {
                this.setString(index, "00000000");
            } else {
                this.setString(index, CommonUtil.getYYYYMMDD((java.util.Date)value));
            }
        } else {
            Date sDate = new Date(this.con.getNullDate().getTime());
            if (!this.saveNullDate(value)) {
                Calendar valueCalendar = GregorianCalendar.getInstance();
                valueCalendar.setTime(value);
                GregorianCalendar sGregorianCalendar = new GregorianCalendar();
                sGregorianCalendar.set(valueCalendar.get(1), valueCalendar.get(2), valueCalendar.get(5), 0, 0, 0);
                sDate = new Date(sGregorianCalendar.getTime().getTime());
            }
            this.setDate(index, sDate);
        }
    }

    @Override
    public void setDate(int index, Date value) throws SQLException {
        if (DEBUG) {
            this.log(0, "setDateSQL - index : " + index + " value : " + value);
            try {
                if (this.con.getDBMS().useDateTimeInDate()) {
                    this.setDateTime(index, value, false);
                }
                this.stmt.setDate(index, value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else if (this.con.getDBMS().useDateTimeInDate()) {
            this.setDateTime(index, value, false);
        } else {
            this.stmt.setDate(index, value);
        }
    }

    @Override
    public void setTime(int index, Time value) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: setTime - index : " + index + " value : " + value);
            try {
                this.stmt.setTime(index, value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.setTime(index, value);
        }
    }

    @Override
    public void setTimestamp(int index, Timestamp value) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: setTimestamp - index : " + index + " value : " + value);
            try {
                this.stmt.setTimestamp(index, value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.setTimestamp(index, value);
        }
    }

    @Override
    public void setAsciiStream(int index, InputStream value, int length) throws SQLException {
        if (DEBUG) {
            this.log(0, "setAsciiStream - index : " + index + " length : " + length);
            try {
                this.stmt.setAsciiStream(index, value, length);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.setAsciiStream(index, value, length);
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int index, InputStream value, int length) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: setUnicodeStream - index : " + index + " length : " + length);
            try {
                this.stmt.setUnicodeStream(index, value, length);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.setUnicodeStream(index, value, length);
        }
    }

    public void skipSetBlobs(boolean skipSetBlobs) {
        this.skipSetBlobs = skipSetBlobs;
        this.isUpdateBlobStmt = true;
    }

    public boolean getSkipSetBlobs() {
        return this.skipSetBlobs;
    }

    public String[] getBlobFiles() {
        return this.blobFiles;
    }

    public void setBLOBFile(Blob blob, String fileName) throws SQLException {
        block11: {
            if (!(fileName == null || fileName.trim().equals("") || fileName.toLowerCase().trim().endsWith("about:blank") || this.con.getDBMS().getId() != 6 && this.con.getDBMS().getId() != 12)) {
                try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(fileName));){
                    File file = new File(fileName);
                    if (this.con.getDBMS().getId() == 6) {
                        ((GXDBMSoracle7)this.con.getDBMS()).setBlobData(blob, inputStream, (int)file.length());
                    } else {
                        ((GXDBMSdameng)this.con.getDBMS()).setBlobData(blob, inputStream, (int)file.length());
                    }
                    inputStream.close();
                }
                catch (Exception e) {
                    if (e instanceof IOException) {
                        throw new SQLException("Can't find BLOB file " + fileName);
                    }
                    if (!DEBUG || !this.con.isLogEnabled()) break block11;
                    this.con.logSQLException(this.con.getHandle(), e);
                }
            }
        }
    }

    public void setBLOBFile(int index, String fileName) throws SQLException {
        this.setBLOBFile(index, fileName, false);
    }

    public void setBLOBFile(int index, String fileName, boolean isMultiMedia, boolean downloadContent) throws SQLException {
        this.setBLOBFile(index, fileName, isMultiMedia);
    }

    public void setBLOBFile(int index, String fileName, boolean isMultiMedia) throws SQLException {
        if (isMultiMedia && Application.getGXServices().get("Storage") != null) {
            fileName = "";
        }
        if (fileName != null && !fileName.trim().equals("") && !fileName.toLowerCase().trim().endsWith("about:blank") && Application.getGXServices().get("Storage") == null) {
            HttpContext webContext;
            fileName = GXutil.cutUploadPrefix(fileName);
            try {
                if (fileName.toLowerCase().startsWith("http://") || fileName.toLowerCase().startsWith("https://")) {
                    int queryIndex = fileName.lastIndexOf(63);
                    if (queryIndex > -1) {
                        fileName = fileName.substring(0, queryIndex + 1) + PrivateUtilities.encodeURL(fileName.substring(queryIndex + 1));
                    }
                    URL fileURL = new URL(fileName);
                    String blobPath = Preferences.getDefaultPreferences().getBLOB_PATH();
                    fileName = PrivateUtilities.getTempFileName(blobPath, CommonUtil.getFileName((String)fileName), CommonUtil.getFileType((String)fileName), true);
                    PrivateUtilities.InputStreamToFile(fileURL.openStream(), fileName);
                }
            }
            catch (MalformedURLException e) {
                throw new SQLException("Malformed URL " + fileName);
            }
            catch (IOException e) {
                throw new SQLException("An error occurred while downloading data from url: " + fileName + e.getMessage());
            }
            if (this.con.getContext() != null && (webContext = (HttpContext)this.con.getContext().getHttpContext()) != null) {
                if (webContext instanceof HttpContextWeb) {
                    fileName = ((HttpContextWeb)webContext).getRealPath(fileName);
                } else if (!webContext.getDefaultPath().isEmpty() && !new File(fileName).isAbsolute()) {
                    if (fileName.startsWith(webContext.getContextPath())) {
                        fileName = fileName.substring(webContext.getContextPath().length() + 1);
                    }
                    fileName = webContext.getDefaultPath() + File.separator + fileName;
                }
            }
        }
        if (this.skipSetBlobs) {
            if (this.blobFiles == null) {
                this.blobFiles = new String[index];
            } else if (this.blobFiles.length < index) {
                String[] temp = this.blobFiles;
                this.blobFiles = new String[index];
                System.arraycopy(temp, 0, this.blobFiles, 0, temp.length);
            }
            this.blobFiles[index - 1] = fileName;
        } else if (fileName != null && !fileName.trim().equals("") && !fileName.toLowerCase().trim().endsWith("about:blank")) {
            if (Application.getExternalProvider() == null) {
                try {
                    File file = new File(fileName);
                    BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
                    this.setBinaryStream(index, (InputStream)inputStream, (int)file.length());
                }
                catch (IOException e) {
                    throw new SQLException("The filename does not exists in url " + fileName);
                }
            } else {
                GXFile gxFile = new GXFile(fileName, ResourceAccessControlList.Private);
                if (gxFile.exists()) {
                    InputStream is = gxFile.getStream();
                    this.setBinaryStream(index, is, (int)gxFile.getLength());
                } else {
                    try {
                        File localFile = new File(fileName);
                        BufferedInputStream localInputStream = new BufferedInputStream(new FileInputStream(localFile));
                        this.setBinaryStream(index, (InputStream)localInputStream, (int)localFile.length());
                    }
                    catch (IOException e) {
                        throw new SQLException("The filename does not exists in url " + fileName);
                    }
                }
            }
        } else if (this.con.getDBMS().getId() == 6) {
            BufferedInputStream inputStream = new BufferedInputStream(new ByteArrayInputStream(new byte[]{0}));
            this.setBinaryStream(index, (InputStream)inputStream, 1);
        } else {
            BufferedInputStream inputStream = new BufferedInputStream(new ByteArrayInputStream(new byte[0]));
            this.setBinaryStream(index, (InputStream)inputStream, 0);
        }
    }

    @Override
    public void setBinaryStream(int index, InputStream value, int length) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: setBinaryStream - index : " + index + " length : " + length);
            try {
                this.stmt.setBinaryStream(index, value, length);
                this.streamsToClose.addElement(value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.setBinaryStream(index, value, length);
            this.streamsToClose.addElement(value);
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: clearParameters");
            try {
                this.stmt.clearParameters();
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.clearParameters();
        }
    }

    @Override
    public void setObject(int index, Object value, int targetSqlType, int scale) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: setObject - index : " + index + " value : " + value + " targetSqlType : " + targetSqlType + " scale: " + scale);
            try {
                this.stmt.setObject(index, value, targetSqlType, scale);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.setObject(index, value, targetSqlType, scale);
        }
    }

    @Override
    public void setObject(int index, Object value, int targetSqlType) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: setObject - index : " + index + " value : " + value + " targetSqlType : " + targetSqlType);
            try {
                this.stmt.setObject(index, value, targetSqlType);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.setObject(index, value, targetSqlType);
        }
    }

    @Override
    public void setObject(int index, Object value) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: setObject - index : " + index + " value : " + value);
            try {
                this.stmt.setObject(index, value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.setObject(index, value);
        }
    }

    public void addBatch(Object[] recordBlock) throws SQLException {
        this.addBatch();
        this.batchRecords[this.recordCount] = recordBlock;
        ++this.recordCount;
    }

    @Override
    public void addBatch() throws SQLException {
        this.stmt.addBatch();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.stmt.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        this.stmt.setRef(i, x);
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        this.stmt.setBlob(i, x);
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        this.stmt.setClob(i, x);
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        this.stmt.setArray(i, x);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.stmt.getMetaData();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.stmt.setDate(parameterIndex, x, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.stmt.setTime(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.stmt.setTimestamp(parameterIndex, x, cal);
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.stmt.setNull(paramIndex, sqlType, typeName);
    }

    @Override
    public void setURL(int i, URL x) throws SQLException {
        this.stmt.setURL(i, x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.stmt.getParameterMetaData();
    }

    public void resetRecordCount() {
        this.recordCount = 0;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    @Override
    public void close() throws SQLException {
        super.close();
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int size) {
        this.batchRecords = new Object[size];
        this.batchSize = size;
        this.batchStmt = true;
        this.resetRecordCount();
    }

    public Object[] getBatchRecords() {
        return this.batchRecords;
    }

    public Object getOnCommitInstance() {
        return this.onCommitInstance;
    }

    public String getOnCommitMethod() {
        return this.onCommitMethod;
    }

    public void setOnCommitInstance(Object value) {
        this.onCommitInstance = value;
    }

    public void setOnCommitMethod(String mth) {
        this.onCommitMethod = mth;
    }

    public boolean isBatch() {
        return this.batchStmt;
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1) throws SQLException {
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1, long arg2) throws SQLException {
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1) throws SQLException {
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1, long arg2) throws SQLException {
    }

    @Override
    public void setBlob(int arg0, InputStream arg1) throws SQLException {
    }

    @Override
    public void setBlob(int arg0, InputStream arg1, long arg2) throws SQLException {
    }

    @Override
    public void setCharacterStream(int arg0, Reader arg1) throws SQLException {
    }

    @Override
    public void setCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
    }

    @Override
    public void setClob(int arg0, Reader arg1) throws SQLException {
    }

    @Override
    public void setClob(int arg0, Reader arg1, long arg2) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int arg0, Reader arg1) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
    }

    @Override
    public void setNClob(int arg0, NClob arg1) throws SQLException {
    }

    @Override
    public void setNClob(int arg0, Reader arg1) throws SQLException {
    }

    @Override
    public void setNClob(int arg0, Reader arg1, long arg2) throws SQLException {
    }

    @Override
    public void setNString(int arg0, String arg1) throws SQLException {
    }

    @Override
    public void setRowId(int arg0, RowId arg1) throws SQLException {
    }

    @Override
    public void setSQLXML(int arg0, SQLXML arg1) throws SQLException {
    }
}

