/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db.driver;

import com.genexus.Application;
import com.genexus.CommonUtil;
import com.genexus.DebugFlag;
import com.genexus.GXDbFile;
import com.genexus.GXutil;
import com.genexus.ModelContext;
import com.genexus.Preferences;
import com.genexus.PrivateUtilities;
import com.genexus.db.IFieldGetter;
import com.genexus.db.IGXResultSet;
import com.genexus.db.driver.ConnectionPool;
import com.genexus.db.driver.ExternalProvider;
import com.genexus.db.driver.ExternalProviderCommon;
import com.genexus.db.driver.GXConnection;
import com.genexus.db.driver.GXDBMSdameng;
import com.genexus.db.driver.GXDBMSoracle7;
import com.genexus.db.driver.GXPreparedStatement;
import com.genexus.db.driver.ResourceAccessControlList;
import com.genexus.internet.HttpContext;
import com.genexus.util.GXFile;
import com.genexus.webpanels.BlobsCleaner;
import com.genexus.webpanels.HttpContextWeb;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public final class GXResultSet
implements ResultSet,
IFieldGetter,
IGXResultSet {
    private static final boolean DEBUG = DebugFlag.DEBUG;
    public static boolean longVarCharAsOracleLong = false;
    public static boolean blankStringAsEmpty = false;
    private ResultSet result;
    private Statement stmt;
    GXConnection con;
    private AtomicBoolean closed = new AtomicBoolean(false);
    private int handle;
    private ConnectionPool pool;
    private long resultRegBytes;
    private static String lastBlobsDir = "";

    public GXResultSet(ResultSet result, Statement stmt, GXConnection con, int handle) {
        this.result = result;
        this.stmt = stmt;
        this.con = con;
        this.handle = handle;
        this.pool = con.getPool();
        if (this.pool != null) {
            this.pool.getDBConnectionState().addResultSet(handle, con, this);
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (DEBUG) {
            this.log(0, "wasNull : " + this.result.wasNull());
            return this.result.wasNull();
        }
        return this.result.wasNull();
    }

    public void resetWasNullHits() {
    }

    @Override
    public boolean next() throws SQLException {
        this.resultRegBytes = 0L;
        if (DEBUG) {
            this.log(0, "next");
            try {
                return this.result.next();
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.handle, sqlException);
                }
                throw sqlException;
            }
        }
        return this.result.next();
    }

    @Override
    public void close() throws SQLException {
        SQLException disconnectException = null;
        if (this.isClosed()) {
            return;
        }
        this.closed.set(true);
        if (DEBUG) {
            this.log(0, "close");
        }
        if (this.pool != null) {
            this.pool.getDBConnectionState().removeResultSet(this.handle, this.con, this);
        }
        try {
            this.con.setNotInUse((GXPreparedStatement)this.stmt);
        }
        catch (Throwable e) {
            System.err.println("e " + e.getMessage());
        }
        try {
            this.result.close();
        }
        catch (SQLException sqlException) {
            disconnectException = sqlException;
        }
        this.result = null;
        if (disconnectException != null) {
            throw disconnectException;
        }
    }

    public GXConnection getConnection() {
        return this.con;
    }

    public long getResultRegBytes() {
        return this.resultRegBytes;
    }

    public String getLongVarchar(int columnIndex) throws SQLException {
        String value;
        if (DEBUG) {
            this.log(0, "getLongVarchar - index : " + columnIndex);
            try {
                if (this.con.getDBMS() instanceof GXDBMSoracle7 && !longVarCharAsOracleLong) {
                    try {
                        value = this.getClobString(this.getClob(columnIndex));
                    }
                    catch (SQLException exc) {
                        value = this.result.getString(columnIndex);
                    }
                } else {
                    value = this.result.getString(columnIndex);
                }
                if (this.result.wasNull() || value == null) {
                    value = "";
                }
                this.log(0, "getLongVarchar - real length: " + value.length() + " V " + value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.handle, sqlException);
                }
                throw sqlException;
            }
        } else {
            if (this.con.getDBMS() instanceof GXDBMSoracle7 && !longVarCharAsOracleLong) {
                try {
                    value = this.getClobString(this.getClob(columnIndex));
                }
                catch (SQLException exc) {
                    value = this.result.getString(columnIndex);
                }
            } else {
                value = this.result.getString(columnIndex);
            }
            if (this.result.wasNull() || value == null) {
                value = "";
            }
        }
        this.resultRegBytes += (long)value.length();
        return value;
    }

    private String getClobString(Clob clob) throws SQLException {
        if (clob == null) {
            return "";
        }
        char[] cbuf = new char[(int)clob.length()];
        try (Reader reader = clob.getCharacterStream();){
            reader.read(cbuf);
        }
        catch (IOException ioException) {
            System.err.println("Error reading CLOB column");
        }
        return new String(cbuf);
    }

    public String getVarchar(int columnIndex) throws SQLException {
        String value;
        if (DEBUG) {
            this.log(0, "getVarchar - index : " + columnIndex);
            try {
                value = this.result.getString(columnIndex);
                if (this.result.wasNull()) {
                    value = "";
                }
                this.log(0, "getString - value : " + value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.handle, sqlException);
                }
                throw sqlException;
            }
        } else {
            value = this.result.getString(columnIndex);
            if (this.result.wasNull()) {
                value = "";
            }
        }
        this.resultRegBytes += (long)value.length();
        if (this.con.getDBMS() instanceof GXDBMSoracle7 && blankStringAsEmpty && GXPreparedStatement.addSpaceToEmptyVarChar && value.equals(" ")) {
            value = "";
        }
        return value;
    }

    public String getString(int columnIndex, int length) throws SQLException {
        String value;
        switch (this.con.getDBMS().getId()) {
            case 10: 
            case 11: {
                return this.getVarchar(columnIndex);
            }
        }
        if (DEBUG) {
            this.log(0, "getString - index : " + columnIndex + " length : " + length);
            try {
                value = this.result.getString(columnIndex);
                value = this.result.wasNull() || value == null ? "" : String.format(String.format("%%-%ds", length), value);
                this.log(0, "getString - value : " + value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.handle, sqlException);
                }
                throw sqlException;
            }
        } else {
            value = this.result.getString(columnIndex);
            value = this.result.wasNull() || value == null ? "" : String.format(String.format("%%-%ds", length), value);
        }
        this.resultRegBytes += (long)value.length();
        return value;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        byte value;
        if (DEBUG) {
            this.log(0, "getByte - index : " + columnIndex);
            try {
                value = (byte)this.result.getInt(columnIndex);
                if (this.result.wasNull()) {
                    value = 0;
                }
                this.log(0, "getByte - value : " + value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.handle, sqlException);
                }
                throw sqlException;
            }
        } else {
            value = (byte)this.result.getInt(columnIndex);
            if (this.result.wasNull()) {
                value = 0;
            }
        }
        ++this.resultRegBytes;
        return value;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        short value;
        if (DEBUG) {
            this.log(0, "getShort - index : " + columnIndex);
            try {
                value = this.result.getShort(columnIndex);
                if (this.result.wasNull()) {
                    value = 0;
                }
                this.log(0, "getShort - value : " + value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.handle, sqlException);
                }
                throw sqlException;
            }
        } else {
            value = this.result.getShort(columnIndex);
            if (this.result.wasNull()) {
                value = 0;
            }
        }
        this.resultRegBytes += 2L;
        return value;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        int value;
        if (DEBUG) {
            this.log(0, "getInt - index : " + columnIndex);
            try {
                value = this.result.getInt(columnIndex);
                if (this.result.wasNull()) {
                    value = 0;
                }
                this.log(0, "getInt - value : " + value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.handle, sqlException);
                }
                throw sqlException;
            }
        } else {
            value = this.result.getInt(columnIndex);
            if (this.result.wasNull()) {
                value = 0;
            }
        }
        this.resultRegBytes += 4L;
        return value;
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        long value;
        if (DEBUG) {
            this.log(0, "getLong - index : " + columnIndex);
            try {
                value = this.result.getLong(columnIndex);
                if (this.result.wasNull()) {
                    value = 0L;
                }
                this.log(0, "getLong - value : " + value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.handle, sqlException);
                }
                throw sqlException;
            }
        } else {
            value = this.result.getLong(columnIndex);
            if (this.result.wasNull()) {
                value = 0L;
            }
        }
        this.resultRegBytes += 8L;
        return value;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        float value;
        if (DEBUG) {
            this.log(0, "getFloat - index : " + columnIndex);
            try {
                value = this.result.getFloat(columnIndex);
                if (this.result.wasNull()) {
                    value = 0.0f;
                }
                this.log(0, "getFloat - value : " + value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.handle, sqlException);
                }
                throw sqlException;
            }
        } else {
            value = this.result.getFloat(columnIndex);
            if (this.result.wasNull()) {
                value = 0.0f;
            }
        }
        this.resultRegBytes += 4L;
        return value;
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        double value;
        if (DEBUG) {
            this.log(0, "getDouble - index : " + columnIndex);
            try {
                value = this.result.getDouble(columnIndex);
                if (this.result.wasNull()) {
                    value = 0.0;
                }
                this.log(0, "getDouble - value : " + value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.handle, sqlException);
                }
                throw sqlException;
            }
        } else {
            value = this.result.getDouble(columnIndex);
            if (this.result.wasNull()) {
                value = 0.0;
            }
        }
        this.resultRegBytes += 8L;
        return value;
    }

    public java.util.Date getGXDateTime(int columnIndex) throws SQLException {
        return this.getGXDateTime(columnIndex, false);
    }

    public java.util.Date getGXDateTime(int columnIndex, boolean hasMilliSeconds) throws SQLException {
        java.util.Date value = null;
        if (DEBUG) {
            this.log(0, "getGXDateTime - index : " + columnIndex);
            try {
                value = this.result.getTimestamp(columnIndex);
                if (this.result.wasNull() || this.con.isNullDateTime(value)) {
                    value = CommonUtil.nullDate();
                } else if (this.con.isNullDate(value)) {
                    value = CommonUtil.resetDate((java.util.Date)value);
                } else {
                    if (!hasMilliSeconds) {
                        value = CommonUtil.resetMillis((java.util.Date)new java.util.Date(value.getTime()));
                    }
                    if (ModelContext.getModelContext() != null) {
                        value = ModelContext.getModelContext().DBserver2local(value);
                    }
                }
                this.log(0, "getGXDateTime - value2 : " + value);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.handle, sqlException);
                }
                throw sqlException;
            }
        } else {
            value = this.result.getTimestamp(columnIndex);
            if (this.result.wasNull() || this.con.isNullDateTime(value)) {
                value = CommonUtil.nullDate();
            } else if (this.con.isNullDate(value)) {
                value = CommonUtil.resetDate((java.util.Date)value);
            } else {
                if (!hasMilliSeconds) {
                    value = CommonUtil.resetMillis((java.util.Date)new java.util.Date(value.getTime()));
                }
                if (ModelContext.getModelContext() != null) {
                    value = ModelContext.getModelContext().DBserver2local(value);
                }
            }
        }
        this.resultRegBytes += 8L;
        return value;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public java.util.Date getGXDate(int columnIndex) throws SQLException {
        void var2_29;
        this.resultRegBytes += 8L;
        Object var2_2 = null;
        boolean retryReadDate = false;
        if (DEBUG) {
            this.log(0, "getGXDate - index : " + columnIndex);
            try {
                void var2_15;
                if (this.con.getDBMS().useCharInDate()) {
                    try {
                        void var2_7;
                        String valueString = this.getString(columnIndex);
                        this.log(0, "getGXDate - stringRead : " + valueString);
                        if (this.result.wasNull()) {
                            return CommonUtil.nullDate();
                        }
                        if (valueString.length() > 8) {
                            if (valueString.equals("00000000000000")) {
                                java.util.Date date = CommonUtil.nullDate();
                            } else {
                                StringBuffer newValueString = new StringBuffer();
                                block12: for (int i = 0; i < valueString.length(); ++i) {
                                    switch (valueString.charAt(i)) {
                                        case ' ': 
                                        case '-': 
                                        case ':': {
                                            continue block12;
                                        }
                                        default: {
                                            newValueString.append(valueString.charAt(i));
                                        }
                                    }
                                }
                                valueString = newValueString.toString();
                                java.util.Date date = CommonUtil.ymdhmsToT_noYL((int)((int)CommonUtil.val((String)valueString.substring(0, 4))), (int)((int)CommonUtil.val((String)valueString.substring(4, 6))), (int)((int)CommonUtil.val((String)valueString.substring(6, 8))), (int)((int)CommonUtil.val((String)valueString.substring(8, 10))), (int)((int)CommonUtil.val((String)valueString.substring(10, 12))), (int)((int)CommonUtil.val((String)valueString.substring(12, 14))));
                            }
                        } else if (valueString.equals("00000000")) {
                            java.util.Date date = CommonUtil.nullDate();
                        } else {
                            java.util.Date date = CommonUtil.ymdhmsToT_noYL((int)((int)CommonUtil.val((String)valueString.substring(0, 4))), (int)((int)CommonUtil.val((String)valueString.substring(4, 6))), (int)((int)CommonUtil.val((String)valueString.substring(6, 8))), (int)0, (int)0, (int)0);
                        }
                        this.log(0, "getGXDate as Char - value1 : " + var2_7 + " string " + valueString);
                    }
                    catch (Exception e) {
                        retryReadDate = true;
                    }
                }
                if (this.con.getDBMS().useCharInDate() && !retryReadDate) return var2_29;
                if (this.con.getDBMS().useDateTimeInDate()) {
                    Timestamp timestamp = this.result.getTimestamp(columnIndex);
                    this.log(0, "getGXDate/DateTime - value1 : " + timestamp);
                } else {
                    Date date = this.result.getDate(columnIndex);
                    this.log(0, "getGXDate/Date - value1 : " + date);
                }
                if (this.result.wasNull()) {
                    java.util.Date date = CommonUtil.nullDate();
                } else {
                    void var2_11;
                    java.util.Date date = CommonUtil.resetTime((java.util.Date)var2_11);
                    if (this.con.isNullCleanDate(date)) {
                        java.util.Date date2 = CommonUtil.nullDate();
                    }
                }
                this.log(0, "getGXDate - value2 : " + var2_15);
                return var2_29;
            }
            catch (SQLException sqlException) {
                if (!this.con.isLogEnabled()) throw sqlException;
                this.con.logSQLException(this.handle, sqlException);
                throw sqlException;
            }
        }
        if (this.con.getDBMS().useCharInDate()) {
            try {
                String valueString = this.getString(columnIndex);
                if (this.result.wasNull()) {
                    return CommonUtil.nullDate();
                }
                if (valueString.length() > 8) {
                    if (valueString.equals("00000000000000")) {
                        java.util.Date date = CommonUtil.nullDate();
                    } else {
                        StringBuffer newValueString = new StringBuffer();
                        block13: for (int i = 0; i < valueString.length(); ++i) {
                            switch (valueString.charAt(i)) {
                                case ' ': 
                                case '-': 
                                case ':': {
                                    continue block13;
                                }
                                default: {
                                    newValueString.append(valueString.charAt(i));
                                }
                            }
                        }
                        valueString = newValueString.toString();
                        java.util.Date date = CommonUtil.ymdhmsToT_noYL((int)((int)CommonUtil.val((String)valueString.substring(0, 4))), (int)((int)CommonUtil.val((String)valueString.substring(4, 6))), (int)((int)CommonUtil.val((String)valueString.substring(6, 8))), (int)((int)CommonUtil.val((String)valueString.substring(8, 10))), (int)((int)CommonUtil.val((String)valueString.substring(10, 12))), (int)((int)CommonUtil.val((String)valueString.substring(12, 14))));
                    }
                } else if (valueString.equals("00000000")) {
                    java.util.Date date = CommonUtil.nullDate();
                } else {
                    java.util.Date date = CommonUtil.ymdhmsToT_noYL((int)((int)CommonUtil.val((String)valueString.substring(0, 4))), (int)((int)CommonUtil.val((String)valueString.substring(4, 6))), (int)((int)CommonUtil.val((String)valueString.substring(6, 8))), (int)0, (int)0, (int)0);
                }
            }
            catch (Exception e) {
                retryReadDate = true;
            }
        }
        if (this.con.getDBMS().useCharInDate() && !retryReadDate) return var2_29;
        if (this.con.getDBMS().useDateTimeInDate()) {
            Timestamp timestamp = this.result.getTimestamp(columnIndex);
        } else {
            Date date = this.result.getDate(columnIndex);
        }
        if (this.result.wasNull()) {
            java.util.Date date = CommonUtil.nullDate();
            return var2_29;
        } else {
            void var2_25;
            java.util.Date date = CommonUtil.resetTime((java.util.Date)var2_25);
            if (!this.con.isNullCleanDate(date)) return var2_29;
            java.util.Date date3 = CommonUtil.nullDate();
        }
        return var2_29;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getString");
        }
        return this.result.getString(columnIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getBoolean");
        }
        return this.result.getBoolean(columnIndex);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        if (GXResultSet.DEBUG) {
            this.log(0, "getBigDecimal - index : " + columnIndex);
            try {
                try {
                    ret = this.result.getBigDecimal(columnIndex);
                    if (ret == null) ** GOTO lbl27
                    ret = ret.setScale(scale, 4);
                }
                catch (AbstractMethodError e) {
                    ret = this.result.getBigDecimal(columnIndex, scale);
                }
            }
            catch (ArithmeticException aException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.handle, aException);
                }
                throw aException;
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.handle, sqlException);
                }
                throw sqlException;
            }
        } else {
            try {
                ret = this.result.getBigDecimal(columnIndex);
                if (ret != null) {
                    ret = ret.setScale(scale, 4);
                }
            }
            catch (AbstractMethodError e) {
                ret = this.result.getBigDecimal(columnIndex, scale);
            }
        }
lbl27:
        // 5 sources

        if (ret == null) {
            return new BigDecimal(0);
        }
        return ret;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getBytes");
        }
        return this.result.getBytes(columnIndex);
    }

    public UUID getGUID(int columnIndex) throws SQLException {
        UUID value;
        String valueString = this.con.getDBMS().getId() == 10 ? this.getVarchar(columnIndex) : this.result.getString(columnIndex);
        if (DEBUG) {
            this.log(0, "getGUID - index : " + columnIndex);
            try {
                value = valueString == null || this.result.wasNull() ? UUID.fromString("00000000-0000-0000-0000-000000000000") : UUID.fromString(valueString);
                this.log(0, "getGUID - value : " + value.toString());
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.handle, sqlException);
                }
                throw sqlException;
            }
        } else {
            value = valueString == null || this.result.wasNull() ? UUID.fromString("00000000-0000-0000-0000-000000000000") : UUID.fromString(valueString);
        }
        return value;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getDate");
        }
        return this.result.getDate(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getTime");
        }
        return this.result.getTime(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getTimestamp");
        }
        return this.result.getTimestamp(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getAsciiStream");
        }
        return this.result.getAsciiStream(columnIndex);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getUnicodeStream");
        }
        return this.result.getUnicodeStream(columnIndex);
    }

    public String getBLOBFile(int columnIndex) throws SQLException {
        return this.getBLOBFile(columnIndex, "tmp");
    }

    public String getBLOBFile(int columnIndex, String extension) throws SQLException {
        return this.getBLOBFile(columnIndex, extension, "");
    }

    public String getBLOBFile(int columnIndex, String extension, String name) throws SQLException {
        String fileName = this.getBlobFileName(name, extension);
        return this.getBLOBFile(columnIndex, extension, name, fileName, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getBLOBFile(int columnIndex, String extension, String name, String fileName, boolean temporary) throws SQLException {
        try (InputStream source = this.getBinaryStream(columnIndex);){
            File path;
            byte[] xbuffer = new byte[1];
            int firstByte = 0;
            int secondByte = 0;
            if (source != null) {
                firstByte = source.read(xbuffer);
                if (this.con.getDBMS() instanceof GXDBMSoracle7 || this.con.getDBMS() instanceof GXDBMSdameng) {
                    secondByte = source.read();
                }
            }
            boolean isEmptyBuffer = false;
            if (source != null && source.available() == 0 && firstByte != -1 && xbuffer[0] == 0) {
                isEmptyBuffer = true;
            }
            if (this.result.wasNull() || source == null || firstByte == -1 || (this.con.getDBMS() instanceof GXDBMSoracle7 || this.con.getDBMS() instanceof GXDBMSdameng) && secondByte == -1 || isEmptyBuffer) {
                if (source != null) {
                    source.close();
                }
                String string = "";
                return string;
            }
            if (Application.getGXServices().get("Storage") == null && !(path = new File(fileName).getParentFile()).exists()) {
                path.mkdirs();
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            BufferedOutputStream destination = new BufferedOutputStream(os);
            byte[] buffer = new byte[4096];
            ((OutputStream)destination).write(xbuffer, 0, 1);
            if (this.con.getDBMS() instanceof GXDBMSoracle7 || this.con.getDBMS() instanceof GXDBMSdameng) {
                ((OutputStream)destination).write(secondByte);
            }
            while (true) {
                int bytes_read;
                if ((bytes_read = source.read(buffer)) == -1) {
                    source.close();
                    ((OutputStream)destination).close();
                    ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
                    GXFile gxFile = new GXFile(fileName, ResourceAccessControlList.Private);
                    gxFile.create(is);
                    fileName = gxFile.getFilePath();
                    if (!temporary) return fileName;
                    BlobsCleaner.getInstance().addBlobFile(fileName);
                    return fileName;
                }
                ((OutputStream)destination).write(buffer, 0, bytes_read);
            }
        }
        catch (IOException e) {
            throw new SQLException("Can't read BLOB field into " + fileName);
        }
    }

    public String getMultimediaFile(int columnIndex, String gxdbFileUri) throws SQLException {
        String fileName;
        if (!GXDbFile.isFileExternal(gxdbFileUri) && (fileName = GXDbFile.getFileNameFromUri(gxdbFileUri)).trim().length() != 0) {
            String filePath = "";
            if (Application.getExternalProvider() == null) {
                String multimediaDir = Preferences.getDefaultPreferences().getMultimediaPath();
                filePath = GXutil.getNonTraversalPath(multimediaDir, fileName);
            } else {
                filePath = Preferences.getDefaultPreferences().getProperty("CS_BLOB_PATH", "").trim() + "/" + GXDbFile.getMultimediaDirectory() + "/" + fileName;
            }
            GXFile file = new GXFile(filePath);
            if (file.exists()) {
                return file.getAbsolutePath();
            }
            return this.getBLOBFile(columnIndex, CommonUtil.getFileType((String)gxdbFileUri), CommonUtil.getFileName((String)gxdbFileUri), filePath, false);
        }
        return "";
    }

    public String getMultimediaUri(int columnIndex) throws SQLException {
        return this.getMultimediaUri(columnIndex, true);
    }

    public String getMultimediaUri(int columnIndex, boolean absPath) throws SQLException {
        String providerObjectName;
        ExternalProvider provider = Application.getExternalProvider();
        String colValue = this.getVarchar(columnIndex);
        if (provider != null && colValue.length() > 0 && GXutil.isAbsoluteURL(colValue) && (providerObjectName = ExternalProviderCommon.getProviderObjectName((ExternalProvider)provider, (String)colValue)) != null) {
            return new GXFile(providerObjectName).getAbsolutePath();
        }
        return GXDbFile.resolveUri(colValue, absPath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getBlobFileName(String name, String extension) {
        String blobPath = Preferences.getDefaultPreferences().getBLOB_PATH();
        String fileName = PrivateUtilities.getTempFileName(blobPath, name, extension, true);
        if (Application.getExternalProvider() != null) return fileName.replace(File.separator, "/");
        File file = new File(fileName);
        if (file.isAbsolute()) return fileName;
        if (!lastBlobsDir.equals("")) {
            return lastBlobsDir + fileName;
        }
        if (this.con.getContext() == null) return fileName;
        HttpContext webContext = (HttpContext)this.con.getContext().getHttpContext();
        if (webContext == null) return fileName;
        if (!(webContext instanceof HttpContextWeb)) return fileName;
        try {
            String origFileName = fileName;
            fileName = ((HttpContextWeb)webContext).getRealPath(fileName);
            lastBlobsDir = fileName.substring(0, fileName.indexOf(origFileName));
            return fileName;
        }
        catch (NullPointerException e) {
            if (lastBlobsDir.equals("")) return fileName;
            return lastBlobsDir + fileName;
        }
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getBinaryStream");
        }
        return this.result.getBinaryStream(columnIndex);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getObject");
        }
        return this.result.getObject(columnIndex);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getString/2");
        }
        return this.result.getString(columnName);
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getBoolean/2");
        }
        return this.result.getBoolean(columnName);
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getByte/2");
        }
        return this.result.getByte(columnName);
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getShort/2");
        }
        return this.result.getShort(columnName);
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getInt/2");
        }
        return this.result.getInt(columnName);
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getLong/2");
        }
        return this.result.getLong(columnName);
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getFloat/2");
        }
        return this.result.getFloat(columnName);
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getDouble/2");
        }
        return this.result.getDouble(columnName);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getBigDecimal/2");
        }
        return this.result.getBigDecimal(columnName, scale);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getBytes/2");
        }
        return this.result.getBytes(columnName);
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getDate/2");
        }
        return this.result.getDate(columnName);
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getTimestamp");
        }
        return this.result.getTimestamp(columnName);
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getTime/2");
        }
        return this.result.getTime(columnName);
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getAsciiStream/2");
        }
        return this.result.getAsciiStream(columnName);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getUnicodeStream/2");
        }
        return this.result.getUnicodeStream(columnName);
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getBinaryStream/2");
        }
        return this.result.getBinaryStream(columnName);
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getObject/2");
        }
        return this.result.getObject(columnName);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getWarnings");
        }
        return this.result.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: clearWarnings");
        }
        this.result.clearWarnings();
    }

    @Override
    public String getCursorName() throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getCursorName");
        }
        return this.result.getCursorName();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: getMetaData");
        }
        return this.result.getMetaData();
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        if (DEBUG) {
            this.log(0, "Warning: findColumn");
        }
        return this.result.findColumn(columnName);
    }

    private void log(int level, String text) {
        if (DEBUG) {
            this.con.log(level, this, text);
        }
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.result.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.result.getCharacterStream(columnName);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.result.getBigDecimal(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.result.getBigDecimal(columnName);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.result.isBeforeFirst();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.result.isFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.result.isAfterLast();
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.result.isLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.result.beforeFirst();
    }

    @Override
    public void afterLast() throws SQLException {
        this.result.afterLast();
    }

    @Override
    public boolean first() throws SQLException {
        return this.result.first();
    }

    @Override
    public boolean last() throws SQLException {
        return this.result.last();
    }

    @Override
    public boolean previous() throws SQLException {
        return this.result.previous();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        return this.result.relative(rows);
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        return this.result.absolute(row);
    }

    @Override
    public int getRow() throws SQLException {
        return this.result.getRow();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.result.setFetchSize(rows);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.result.getFetchDirection();
    }

    @Override
    public int getType() throws SQLException {
        return this.result.getType();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.result.setFetchDirection(direction);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.result.getFetchSize();
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.result.getConcurrency();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.result.updateShort(columnIndex, x);
    }

    @Override
    public void updateShort(String columnIndex, short x) throws SQLException {
        this.result.updateShort(columnIndex, x);
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this.result.rowInserted();
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.result.updateByte(columnIndex, x);
    }

    @Override
    public void updateByte(String columnIndex, byte x) throws SQLException {
        this.result.updateByte(columnIndex, x);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.result.rowDeleted();
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.result.updateNull(columnIndex);
    }

    @Override
    public void updateNull(String columnIndex) throws SQLException {
        this.result.updateNull(columnIndex);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.result.updateBoolean(columnIndex, x);
    }

    @Override
    public void updateBoolean(String columnIndex, boolean x) throws SQLException {
        this.result.updateBoolean(columnIndex, x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.result.updateBytes(columnIndex, x);
    }

    @Override
    public void updateBytes(String columnIndex, byte[] x) throws SQLException {
        this.result.updateBytes(columnIndex, x);
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this.result.rowUpdated();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.result.updateInt(columnIndex, x);
    }

    @Override
    public void updateInt(String columnIndex, int x) throws SQLException {
        this.result.updateInt(columnIndex, x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.result.updateFloat(columnIndex, x);
    }

    @Override
    public void updateFloat(String columnIndex, float x) throws SQLException {
        this.result.updateFloat(columnIndex, x);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.result.updateDate(columnIndex, x);
    }

    @Override
    public void updateDate(String columnIndex, Date x) throws SQLException {
        this.result.updateDate(columnIndex, x);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.result.updateDouble(columnIndex, x);
    }

    @Override
    public void updateDouble(String columnIndex, double x) throws SQLException {
        this.result.updateDouble(columnIndex, x);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.result.updateBigDecimal(columnIndex, x);
    }

    @Override
    public void updateBigDecimal(String columnIndex, BigDecimal x) throws SQLException {
        this.result.updateBigDecimal(columnIndex, x);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.result.updateString(columnIndex, x);
    }

    @Override
    public void updateString(String columnIndex, String x) throws SQLException {
        this.result.updateString(columnIndex, x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.result.updateLong(columnIndex, x);
    }

    @Override
    public void updateLong(String columnIndex, long x) throws SQLException {
        this.result.updateLong(columnIndex, x);
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        this.result.updateTime(columnName, x);
    }

    @Override
    public void updateTime(int columnName, Time x) throws SQLException {
        this.result.updateTime(columnName, x);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.result.updateTimestamp(columnName, x);
    }

    @Override
    public void updateTimestamp(int columnName, Timestamp x) throws SQLException {
        this.result.updateTimestamp(columnName, x);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.result.updateAsciiStream(columnName, x, length);
    }

    @Override
    public void updateAsciiStream(int columnName, InputStream x, int length) throws SQLException {
        this.result.updateAsciiStream(columnName, x, length);
    }

    @Override
    public void updateBinaryStream(int columnName, InputStream x, int length) throws SQLException {
        this.result.updateBinaryStream(columnName, x, length);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.result.updateBinaryStream(columnName, x, length);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.result.updateCharacterStream(columnName, reader, length);
    }

    @Override
    public void updateCharacterStream(int columnName, Reader reader, int length) throws SQLException {
        this.result.updateCharacterStream(columnName, reader, length);
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.result.updateObject(columnName, x, scale);
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        this.result.updateObject(columnName, x);
    }

    @Override
    public void updateObject(int columnName, Object x, int scale) throws SQLException {
        this.result.updateObject(columnName, x, scale);
    }

    @Override
    public void updateObject(int columnName, Object x) throws SQLException {
        this.result.updateObject(columnName, x);
    }

    @Override
    public void insertRow() throws SQLException {
        this.result.insertRow();
    }

    @Override
    public void updateRow() throws SQLException {
        this.result.updateRow();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.result.deleteRow();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.result.refreshRow();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.result.cancelRowUpdates();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.result.moveToInsertRow();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.result.moveToCurrentRow();
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.result.getStatement();
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        return this.result.getObject(i, map);
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        return this.result.getRef(i);
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        return this.result.getBlob(i);
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        return this.result.getClob(i);
    }

    @Override
    public Array getArray(int i) throws SQLException {
        return this.result.getArray(i);
    }

    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        return this.result.getObject(colName, map);
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        return this.result.getRef(colName);
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        return this.result.getBlob(colName);
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        return this.result.getClob(colName);
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        return this.result.getArray(colName);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.result.getDate(columnIndex, cal);
    }

    @Override
    public Date getDate(String columnIndex, Calendar cal) throws SQLException {
        return this.result.getDate(columnIndex, cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.result.getTime(columnIndex, cal);
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.result.getTime(columnName, cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.result.getTimestamp(columnIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(String columnIndex, Calendar cal) throws SQLException {
        return this.result.getTimestamp(columnIndex, cal);
    }

    @Override
    public URL getURL(int c) throws SQLException {
        return this.result.getURL(c);
    }

    @Override
    public URL getURL(String c) throws SQLException {
        return this.result.getURL(c);
    }

    @Override
    public void updateRef(int c, Ref x) throws SQLException {
        this.result.updateRef(c, x);
    }

    @Override
    public void updateRef(String c, Ref x) throws SQLException {
        this.result.updateRef(c, x);
    }

    @Override
    public void updateBlob(int c, Blob x) throws SQLException {
        this.result.updateBlob(c, x);
    }

    @Override
    public void updateBlob(String c, Blob x) throws SQLException {
        this.result.updateBlob(c, x);
    }

    @Override
    public void updateClob(int c, Clob x) throws SQLException {
        this.result.updateClob(c, x);
    }

    @Override
    public void updateClob(String c, Clob x) throws SQLException {
        this.result.updateClob(c, x);
    }

    @Override
    public void updateArray(int c, Array x) throws SQLException {
        this.result.updateArray(c, x);
    }

    @Override
    public void updateArray(String c, Array x) throws SQLException {
        this.result.updateArray(c, x);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public Reader getNCharacterStream(int arg0) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(String arg0) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(int arg0) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(String arg0) throws SQLException {
        return null;
    }

    @Override
    public String getNString(int arg0) throws SQLException {
        return null;
    }

    @Override
    public String getNString(String arg0) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(int arg0) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(String arg0) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(int arg0) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(String arg0) throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed.get();
    }

    @Override
    public void updateAsciiStream(int arg0, InputStream arg1) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String arg0, InputStream arg1) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int arg0, InputStream arg1, long arg2) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String arg0, InputStream arg1, long arg2) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int arg0, InputStream arg1) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String arg0, InputStream arg1) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int arg0, InputStream arg1, long arg2) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String arg0, InputStream arg1, long arg2) throws SQLException {
    }

    @Override
    public void updateBlob(int arg0, InputStream arg1) throws SQLException {
    }

    @Override
    public void updateBlob(String arg0, InputStream arg1) throws SQLException {
    }

    @Override
    public void updateBlob(int arg0, InputStream arg1, long arg2) throws SQLException {
    }

    @Override
    public void updateBlob(String arg0, InputStream arg1, long arg2) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int arg0, Reader arg1) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String arg0, Reader arg1) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String arg0, Reader arg1, long arg2) throws SQLException {
    }

    @Override
    public void updateClob(int arg0, Reader arg1) throws SQLException {
    }

    @Override
    public void updateClob(String arg0, Reader arg1) throws SQLException {
    }

    @Override
    public void updateClob(int arg0, Reader arg1, long arg2) throws SQLException {
    }

    @Override
    public void updateClob(String arg0, Reader arg1, long arg2) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int arg0, Reader arg1) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String arg0, Reader arg1) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String arg0, Reader arg1, long arg2) throws SQLException {
    }

    @Override
    public void updateNClob(int arg0, NClob arg1) throws SQLException {
    }

    @Override
    public void updateNClob(String arg0, NClob arg1) throws SQLException {
    }

    @Override
    public void updateNClob(int arg0, Reader arg1) throws SQLException {
    }

    @Override
    public void updateNClob(String arg0, Reader arg1) throws SQLException {
    }

    @Override
    public void updateNClob(int arg0, Reader arg1, long arg2) throws SQLException {
    }

    @Override
    public void updateNClob(String arg0, Reader arg1, long arg2) throws SQLException {
    }

    @Override
    public void updateNString(int arg0, String arg1) throws SQLException {
    }

    @Override
    public void updateNString(String arg0, String arg1) throws SQLException {
    }

    @Override
    public void updateRowId(int arg0, RowId arg1) throws SQLException {
    }

    @Override
    public void updateRowId(String arg0, RowId arg1) throws SQLException {
    }

    @Override
    public void updateSQLXML(int arg0, SQLXML arg1) throws SQLException {
    }

    @Override
    public void updateSQLXML(String arg0, SQLXML arg1) throws SQLException {
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return null;
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return null;
    }
}

