/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db.driver;

import com.genexus.DebugFlag;
import com.genexus.ModelContext;
import com.genexus.db.driver.GXConnection;
import com.genexus.db.driver.GXResultSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class GXStatement
implements Statement {
    private static final boolean DEBUG = DebugFlag.DEBUG;
    private Statement stmt;
    protected GXConnection con;
    protected int handle;

    GXStatement(Statement stmt, GXConnection con, int handle) {
        this.stmt = stmt;
        this.con = con;
        this.handle = handle;
    }

    @Override
    public synchronized ResultSet executeQuery(String sql) throws SQLException {
        this.con.incNumberRequest();
        this.con.setSentenceLastRequest(sql);
        GXResultSet result = null;
        if (DEBUG) {
            this.log("executeQuery - sql: " + sql);
            try {
                result = new GXResultSet(this.stmt.executeQuery(sql), this, this.con, this.handle);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            result = new GXResultSet(this.stmt.executeQuery(sql), this, this.con, this.handle);
        }
        return result;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.con.incNumberRequest();
        this.con.setSentenceLastRequest(sql);
        int ret = 0;
        SQLException sqlException = null;
        this.con.setUncommitedChanges();
        try {
            if (DEBUG) {
                this.log("executeUpdate - sql: " + sql);
                ret = this.stmt.executeUpdate(sql);
            } else {
                ret = this.stmt.executeUpdate(sql);
            }
        }
        catch (SQLException e) {
            if (DEBUG && this.con.isLogEnabled()) {
                this.con.logSQLException(this.con.getHandle(), e);
            }
            sqlException = e;
        }
        if (sqlException != null) {
            throw sqlException;
        }
        return ret;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.con.incNumberRequest();
        this.con.setSentenceLastRequest(sql);
        if (DEBUG) {
            this.log("execute - sql: " + sql);
            try {
                boolean ret = this.stmt.execute(sql);
                return ret;
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        }
        boolean ret = this.stmt.execute(sql);
        return ret;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (DEBUG) {
            this.log("close stmt");
            try {
                this.stmt.close();
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.close();
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (DEBUG) {
            this.log("getWarnings");
            try {
                return this.stmt.getWarnings();
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        }
        return this.stmt.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (DEBUG) {
            this.log("Warning: clearWarnings");
            try {
                this.stmt.clearWarnings();
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.clearWarnings();
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (DEBUG) {
            this.log("Warning: getResultSet");
            try {
                return new GXResultSet(this.stmt.getResultSet(), this, this.con, this.handle);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        }
        return new GXResultSet(this.stmt.getResultSet(), this, this.con, this.handle);
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        if (DEBUG) {
            this.log("Warning: getMaxFieldSize");
            try {
                return this.stmt.getMaxFieldSize();
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        }
        return this.stmt.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        if (DEBUG) {
            this.log("Warning: setMaxFieldSize - max: " + max);
            try {
                this.stmt.setMaxFieldSize(max);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.setMaxFieldSize(max);
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        if (DEBUG) {
            this.log("Warning: getMaxRows");
            try {
                return this.stmt.getMaxRows();
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        }
        return this.stmt.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (DEBUG) {
            this.log("Warning: setMaxRows - max:" + max);
            try {
                this.stmt.setMaxRows(max);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.setMaxRows(max);
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        if (DEBUG) {
            this.log("Warning: setEscapeProcessing - enable: " + enable);
            try {
                this.stmt.setEscapeProcessing(enable);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.setEscapeProcessing(enable);
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        if (DEBUG) {
            this.log("Warning: getQueryTimeout");
            try {
                return this.stmt.getQueryTimeout();
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        }
        return this.stmt.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (DEBUG) {
            this.log("Warning: setQueryTimeout - seconds:" + seconds);
            try {
                this.stmt.setQueryTimeout(seconds);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.setQueryTimeout(seconds);
        }
    }

    @Override
    public void cancel() throws SQLException {
        if (DEBUG) {
            this.log("Warning: cancel");
            try {
                this.stmt.cancel();
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.cancel();
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        if (DEBUG) {
            this.log("Warning: setCursorName - name:" + name);
            try {
                this.stmt.setCursorName(name);
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        } else {
            this.stmt.setCursorName(name);
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (DEBUG) {
            this.log("Warning: getUpdateCount");
            try {
                return this.stmt.getUpdateCount();
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        }
        return this.stmt.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (DEBUG) {
            this.log("Warning: getMoreResults");
            try {
                return this.stmt.getMoreResults();
            }
            catch (SQLException sqlException) {
                if (this.con.isLogEnabled()) {
                    this.con.logSQLException(this.con.getHandle(), sqlException);
                }
                throw sqlException;
            }
        }
        return this.stmt.getMoreResults();
    }

    private void log(String text) {
        if (DEBUG) {
            this.con.log(2, text);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.con.getDBMS().executeBatch(this.stmt);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.con;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.stmt.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.stmt.clearBatch();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.stmt.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.stmt.getResultSetType();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        try {
            if (ModelContext.getModelContext() != null && ModelContext.getModelContext().getPreferences().getProperty("DontSetFetchSize", "0").equals("0")) {
                this.stmt.setFetchSize(rows);
            }
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.stmt.getFetchSize();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.stmt.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.stmt.getFetchDirection();
    }

    @Override
    public boolean getMoreResults(int x) throws SQLException {
        return this.stmt.getMoreResults(x);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.stmt.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.stmt.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] c) throws SQLException {
        return this.stmt.executeUpdate(sql, c);
    }

    @Override
    public int executeUpdate(String sql, String[] c) throws SQLException {
        return this.stmt.executeUpdate(sql, c);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.stmt.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] c) throws SQLException {
        return this.stmt.execute(sql, c);
    }

    @Override
    public boolean execute(String sql, String[] c) throws SQLException {
        return this.stmt.execute(sql, c);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.stmt.getResultSetHoldability();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean arg0) throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }
}

