/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db.driver;

import com.genexus.db.DBConnectionManager;
import com.genexus.db.driver.DataSource;
import com.genexus.db.driver.GXConnection;
import com.genexus.db.driver.GXDBMSmysql;
import com.genexus.db.driver.GXDBMSpostgresql;
import com.genexus.db.driver.GXResultSet;
import com.genexus.db.driver.IConnectionPool;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;

class PoolDBConnectionState {
    private ConcurrentHashMap<Integer, ConcurrentHashMap<GXConnection, ConcurrentHashMap<GXResultSet, String>>> handles;
    private Dictionary mainConnections;
    private Object syncObject = new Object();

    PoolDBConnectionState() {
        this.handles = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Enumeration<GXConnection> getConnections(int handle) {
        Object object = this.syncObject;
        synchronized (object) {
            ConcurrentHashMap<GXConnection, ConcurrentHashMap<GXResultSet, String>> connections = this.handles.get(new Integer(handle));
            if (connections == null) {
                return null;
            }
            return connections.keys();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasConnection(int handle, GXConnection con) {
        boolean ret;
        Object object = this.syncObject;
        synchronized (object) {
            ConcurrentHashMap<GXConnection, ConcurrentHashMap<GXResultSet, String>> connections = this.handles.get(new Integer(handle));
            if (connections == null) {
                return false;
            }
            ret = connections.get(con) != null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConnection(int handle, GXConnection con) {
        Object object = this.syncObject;
        synchronized (object) {
            ConcurrentHashMap<GXConnection, ConcurrentHashMap<GXResultSet, String>> connections = this.handles.get(new Integer(handle));
            if (connections == null) {
                ConcurrentHashMap connections1 = new ConcurrentHashMap();
                connections1.putIfAbsent(con, new ConcurrentHashMap());
                this.handles.putIfAbsent(new Integer(handle), connections1);
            } else {
                connections.put(con, new ConcurrentHashMap());
            }
            con.getPoolState().incUserCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConnection(int handle, GXConnection con) throws SQLException {
        Object object = this.syncObject;
        synchronized (object) {
            ConcurrentHashMap<GXConnection, ConcurrentHashMap<GXResultSet, String>> connections = this.handles.get(new Integer(handle));
            if (connections != null) {
                this.removeConnections(connections, con, con.getHandle() == handle);
                if (connections.size() == 0) {
                    this.handles.remove(new Integer(handle));
                }
            }
        }
        con.getPoolState().decUserCount();
    }

    private void removeDataSourceConnection(int handle, IConnectionPool pool, boolean closeConnections) {
        ConcurrentHashMap<GXConnection, ConcurrentHashMap<GXResultSet, String>> conns = this.handles.get(new Integer(handle));
        GXConnection con = null;
        GXConnection newCon = null;
        if (conns != null) {
            Enumeration<GXConnection> en = conns.keys();
            while (en.hasMoreElements()) {
                block11: {
                    con = en.nextElement();
                    try {
                        newCon = (GXConnection)con.getPool().checkOut(con.getContext(), handle, true);
                        if (newCon.getId() == con.getId()) {
                            boolean mustDecUserCount = false;
                            try {
                                mustDecUserCount = conns.get(con).isEmpty();
                                if (!this.removeConnections(conns, newCon, true)) {
                                    con.getPoolState().decUserCount();
                                }
                                break block11;
                            }
                            catch (SQLException e) {
                                if (mustDecUserCount) {
                                    con.getPoolState().decUserCount();
                                }
                                break block11;
                            }
                        }
                        newCon.getPoolState().setInAssignment(false);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if (!closeConnections) continue;
                try {
                    pool.removeElement(con);
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        this.handles.remove(new Integer(handle));
    }

    public void removeConnection(int handle, boolean closeConnections) throws SQLException {
        DataSource ds;
        Enumeration<DataSource> dss = DBConnectionManager.getInstance().getUserInformation(handle).getNamespace().getDataSources();
        while ((ds = dss.nextElement()) != null) {
            IConnectionPool pool = ds.getConnectionPool(handle);
            this.removeDataSourceConnection(handle, pool, closeConnections);
        }
    }

    private boolean removeConnections(ConcurrentHashMap<GXConnection, ConcurrentHashMap<GXResultSet, String>> connections, GXConnection con, boolean rollback) throws SQLException {
        SQLException disconnectException = null;
        boolean ret = false;
        ConcurrentHashMap<GXResultSet, String> resultSets = connections.get(con);
        Enumeration<GXResultSet> en = resultSets.keys();
        while (en.hasMoreElements()) {
            try {
                en.nextElement().close();
            }
            catch (SQLException e) {
                disconnectException = e;
            }
            ret = true;
        }
        if ((con.getPoolState().getUncommitedChanges() || rollback && (con.getDataSource().dbms instanceof GXDBMSmysql || con.getDataSource().dbms instanceof GXDBMSpostgresql)) && (rollback || !con.getDataSource().jdbcIntegrity)) {
            try {
                con.rollback();
            }
            catch (SQLException e) {
                disconnectException = e;
            }
        } else {
            con.getPoolState().setInAssignment(false);
        }
        if (disconnectException != null) {
            throw disconnectException;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeResultSet(int handle, GXConnection con, GXResultSet rslt) {
        boolean removeUser = false;
        Object object = this.syncObject;
        synchronized (object) {
            ConcurrentHashMap<GXResultSet, String> resultSets;
            ConcurrentHashMap<GXConnection, ConcurrentHashMap<GXResultSet, String>> connections = this.handles.get(new Integer(handle));
            if (connections != null && (resultSets = connections.get(con)) != null) {
                resultSets.remove(rslt);
                if (resultSets.size() == 0 && !con.getPoolState().getUncommitedChanges() && con.getPool().isEnabled()) {
                    if (con.getDBMS().getId() != 7 && con.getDBMS().getId() != 5) {
                        connections.remove(con);
                        if (connections.size() == 0) {
                            this.handles.remove(new Integer(handle));
                        }
                    }
                    removeUser = true;
                }
            }
        }
        if (removeUser) {
            con.getPoolState().decUserCount();
        }
    }

    void errorConnection(int handle) {
        ConcurrentHashMap<GXConnection, ConcurrentHashMap<GXResultSet, String>> connections = this.handles.get(new Integer(handle));
        if (connections != null) {
            Enumeration<GXConnection> en = connections.keys();
            while (en.hasMoreElements()) {
                GXConnection con = en.nextElement();
                if (con.getHandle() != handle) continue;
                con.setError();
                try {
                    this.removeConnections(connections, con, con.getHandle() == handle);
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addResultSet(int handle, GXConnection con, GXResultSet rslt) {
        Object object = this.syncObject;
        synchronized (object) {
            ConcurrentHashMap<GXResultSet, String> resultSets;
            ConcurrentHashMap<GXConnection, ConcurrentHashMap<GXResultSet, String>> connections = this.handles.get(new Integer(handle));
            if (connections != null && (resultSets = connections.get(con)) != null) {
                resultSets.put(rslt, "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(PrintStream out) {
        Object object = this.syncObject;
        synchronized (object) {
            Enumeration<Integer> en = this.handles.keys();
            while (en.hasMoreElements()) {
                Integer handle = en.nextElement();
                out.println("Handle " + handle);
                Enumeration<GXConnection> en1 = this.handles.get(handle).keys();
                while (en1.hasMoreElements()) {
                    GXConnection connection = en1.nextElement();
                    out.println("\tConnection " + connection.hashCode());
                    out.println("\t\tState: " + connection.getPoolState());
                    Enumeration<GXResultSet> en2 = this.handles.get(handle).get(connection).keys();
                    while (en2.hasMoreElements()) {
                        out.println("\t\tResultset " + en2.nextElement());
                    }
                }
            }
        }
    }
}

