/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db.driver;

import com.genexus.DebugFlag;
import com.genexus.db.DBConnectionManager;
import com.genexus.db.driver.FreeStatementList;
import com.genexus.db.driver.GXConnection;
import com.genexus.db.driver.GXDBMSas400;
import com.genexus.db.driver.GXPreparedStatement;
import com.genexus.db.driver.IPreparedStatementCache;
import java.io.PrintStream;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;

public class PreparedStatementCache
implements IPreparedStatementCache {
    private static final boolean DEBUG = DebugFlag.DEBUG;
    private ConcurrentHashMap<GXPreparedStatement, Boolean> usedCache;
    public FreeStatementList freeStatementList;
    private Object objectLock = new Object();
    private GXConnection jdbcConnection;
    private int maxSize;
    private boolean unlimitedSize;

    PreparedStatementCache(int maxSize, GXConnection jdbcConnection) {
        this.freeStatementList = new FreeStatementList(maxSize, jdbcConnection);
        this.usedCache = new ConcurrentHashMap(maxSize);
        this.jdbcConnection = jdbcConnection;
        this.maxSize = maxSize;
        boolean bl = this.unlimitedSize = maxSize == -1;
        if (DEBUG) {
            jdbcConnection.log(1, "Creating Java 2 statement cache: Maximum size " + maxSize);
        }
    }

    @Override
    public CallableStatement getCallableStatement(int handle, String index, String sqlSentence) throws SQLException {
        return (CallableStatement)this.getStatement(handle, index, sqlSentence, false, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUsedCursors() {
        Object object = this.objectLock;
        synchronized (object) {
            return this.usedCache.size();
        }
    }

    @Override
    public int getUsedCursorsJMX() {
        return this.getUsedCursors();
    }

    @Override
    public PreparedStatement getStatement(int handle, String index, String sqlSentence, boolean currentOf) throws SQLException {
        return this.getStatement(handle, index, sqlSentence, currentOf, false, false);
    }

    private GXPreparedStatement createStatement(int handle, String cursorId, String sqlSentence, boolean currentOf, boolean callable) throws SQLException {
        GXPreparedStatement stmt = (GXPreparedStatement)(callable ? this.jdbcConnection.prepareCall(sqlSentence) : this.jdbcConnection.prepareStatement(sqlSentence, handle, cursorId, currentOf));
        if (currentOf && this.jdbcConnection.getDBMS() instanceof GXDBMSas400) {
            stmt.setCursorName(cursorId);
        }
        if (DEBUG) {
            this.jdbcConnection.log(1, "Preparing new cursor " + cursorId + " free " + this.freeStatementList.size() + " used " + this.usedCache.size() + " - " + sqlSentence);
        }
        return stmt;
    }

    @Override
    public synchronized PreparedStatement getStatement(int handle, String index, String sqlSentence, boolean currentOf, boolean callable, boolean batch) throws SQLException {
        if (handle != -1 && !index.equals("_ConnectionID_")) {
            DBConnectionManager.getInstance().getUserInformation(handle).setLastSQL(index + " " + sqlSentence);
        }
        GXPreparedStatement out = null;
        out = batch || currentOf && this.jdbcConnection.getDBMS() instanceof GXDBMSas400 ? this.freeStatementList.get(index) : this.freeStatementList.get(sqlSentence);
        if (out == null) {
            if (!this.unlimitedSize && this.freeStatementList.size() + this.usedCache.size() >= this.maxSize) {
                if (this.freeStatementList.size() == 0) {
                    ++this.maxSize;
                    if (DEBUG) {
                        this.jdbcConnection.log(1, "Expanding prepared statement pool to " + this.maxSize);
                    }
                } else if (!this.freeStatementList.removeOlder()) {
                    ++this.maxSize;
                }
            }
            out = this.createStatement(handle, index, sqlSentence, currentOf, callable);
        } else if (DEBUG) {
            this.jdbcConnection.log(1, "Reusing cursor " + index + " free " + this.freeStatementList.size() + " used " + this.usedCache.size() + " - " + sqlSentence);
        }
        this.usedCache.put(out, true);
        out.setHandle(handle);
        return out;
    }

    @Override
    public synchronized void dropAllCursors() {
        block4: {
            if (DEBUG) {
                this.jdbcConnection.log(1, "Dropping all cursors. Used :" + this.usedCache.size() + " free " + this.freeStatementList.size());
            }
            try {
                for (GXPreparedStatement stmt : this.usedCache.keySet()) {
                    stmt.close();
                    if (!DEBUG) continue;
                    this.jdbcConnection.log(1, "Dropping used cursor " + stmt.getSqlStatement());
                }
                this.freeStatementList.closeAll();
            }
            catch (SQLException e) {
                if (!DEBUG) break block4;
                this.jdbcConnection.log(1, "Can't drop cursors");
                this.jdbcConnection.logSQLException(-1, e);
            }
        }
        this.usedCache.clear();
    }

    @Override
    public synchronized void freeAllCursors() {
        for (GXPreparedStatement stmt : this.usedCache.keySet()) {
            this.setNotInUse(stmt);
        }
        this.usedCache.clear();
    }

    @Override
    public synchronized void dropCursor(GXPreparedStatement stmt) {
        if (stmt == null) {
            return;
        }
        try {
            stmt.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.usedCache.remove(stmt);
        this.freeStatementList.remove(stmt);
    }

    @Override
    public synchronized void setNotInUse(GXPreparedStatement stmt) {
        if (stmt != null) {
            try {
                this.usedCache.remove(stmt);
                this.freeStatementList.add(stmt);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public synchronized void dump(PrintStream out) {
        out.println("Used statements");
        for (GXPreparedStatement stmt : this.usedCache.keySet()) {
            out.println(stmt.getCreationTime() + " : " + stmt.getSqlStatement());
        }
    }
}

