/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db.driver;

import com.genexus.ModelContext;
import com.genexus.db.driver.ConnectionPool;
import com.genexus.db.driver.ConnectionPoolState;
import com.genexus.db.driver.DataSource;
import com.genexus.db.driver.GXConnection;
import java.sql.SQLException;

final class ReadOnlyConnectionPool
extends ConnectionPool {
    int maxUsers;

    ReadOnlyConnectionPool(DataSource dataSource, String user, String password) {
        super(dataSource, user, password);
        this.maxPoolSize = dataSource.roPoolSize;
        this.unlimitedSize = dataSource.roPoolSizeUnlimited;
        this.maxUsers = dataSource.roPoolUsers;
        this.recycleConnections = dataSource.getROPoolRecycle();
        this.recycleConnectionsTime = (long)dataSource.getROPoolRecycleMins() * 60L * 1000L;
        if (DEBUG) {
            this.log(0, "Creating read-only pool size: " + this.maxPoolSize + " unlimited: " + this.unlimitedSize + " max users: " + this.maxUsers + " recycle " + this.recycleConnections + " recycle time " + this.recycleConnectionsTime + " max cursors : " + dataSource.maxCursors);
        }
        this.poolName = "R/O Pool";
        this.createPoolStartup();
    }

    boolean useSameConnectionForSameHandle() {
        return false;
    }

    @Override
    boolean isAvailableJMX(GXConnection con) {
        ConnectionPoolState state = con.getPoolState();
        if (state.getOpenCursorsJMX() >= this.dataSource.maxCursors) {
            return false;
        }
        return this.maxUsers == -1 || state.getUserCount() < this.maxUsers;
    }

    @Override
    boolean isAvailable(GXConnection con, int handle) {
        ConnectionPoolState state = con.getPoolState();
        if (state.getOpenCursors() >= this.dataSource.maxCursors) {
            return false;
        }
        return this.maxUsers == -1 || state.getUserCount() < this.maxUsers || this.constate.hasConnection(handle, con);
    }

    @Override
    GXConnection createConnection(ModelContext context, int handle) throws SQLException {
        GXConnection con;
        block3: {
            con = new GXConnection(context, this, handle, this.user, this.password, this.dataSource);
            if (con.getDBMS().useReadOnlyConnections()) {
                try {
                    con.setReadOnly(true);
                }
                catch (SQLException e) {
                    if (!DEBUG) break block3;
                    this.dataSource.getLog().logComment(handle, "The driver doesn't support Read Only connection - using Read/Write connection");
                }
            }
        }
        return con;
    }

    @Override
    GXConnection getSameConnection(int handle, boolean sticky) {
        return null;
    }

    @Override
    boolean isReadOnly() {
        return true;
    }

    @Override
    boolean isEnabled() {
        return this.dataSource.getROPoolEnabled();
    }
}

