/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db.driver;

import com.genexus.ApplicationContext;
import com.genexus.ModelContext;
import com.genexus.db.driver.ConnectionPool;
import com.genexus.db.driver.DataSource;
import com.genexus.db.driver.GXConnection;
import com.genexus.db.driver.GXDBMSinformix;
import java.sql.SQLException;
import java.util.Enumeration;

final class ReadWriteConnectionPool
extends ConnectionPool {
    ReadWriteConnectionPool(DataSource dataSource, String user, String password) {
        super(dataSource, user, password);
        this.maxPoolSize = dataSource.rwPoolSize;
        this.unlimitedSize = dataSource.rwPoolSizeUnlimited;
        this.recycleConnections = dataSource.getRWPoolRecycle();
        this.recycleConnectionsType = dataSource.getRWPoolRecycleType();
        String recycleConnectionsTypeDesc = "by creation time";
        this.recycleConnectionsTime = (long)dataSource.getRWPoolRecycleMins() * 60000L;
        if (DEBUG) {
            if (this.recycleConnectionsType == 2) {
                recycleConnectionsTypeDesc = "by idle time";
            }
            this.log(0, "Creating pool size: " + this.maxPoolSize + ", unlimited: " + this.unlimitedSize + ", recycle " + this.recycleConnections + ", recycle type " + recycleConnectionsTypeDesc + ", recycle time " + this.recycleConnectionsTime);
        }
        this.poolName = "Pool";
        this.createPoolStartup();
    }

    boolean useSameConnectionForSameHandle() {
        return true;
    }

    @Override
    boolean isAvailableJMX(GXConnection con) {
        return con.getPoolState().isRWAvailableJMX();
    }

    @Override
    boolean isAvailable(GXConnection con, int handle) {
        if (ApplicationContext.getInstance().getReorganization()) {
            return Thread.currentThread().hashCode() == con.getThread() || con.getPoolState().isRWAvailable();
        }
        return con.getHandle() == handle || con.getPoolState().isRWAvailable();
    }

    @Override
    GXConnection createConnection(ModelContext context, int handle) throws SQLException {
        return new GXConnection(context, this, handle, this.user, this.password, this.dataSource);
    }

    @Override
    GXConnection getSameConnection(int handle, boolean sticky) {
        Enumeration<GXConnection> en = this.constate.getConnections(handle);
        if (en != null) {
            while (en.hasMoreElements()) {
                GXConnection con = en.nextElement();
                if (ApplicationContext.getInstance().getReorganization() && !(this.dataSource.dbms instanceof GXDBMSinformix) && Thread.currentThread().hashCode() != con.getThread() || con.getHandle() != handle) continue;
                if (DEBUG) {
                    this.log(handle, "Reusing pre-assigned connection " + con.hashCode());
                }
                if (sticky) {
                    con.getPoolState().setInAssignment(true);
                }
                return con;
            }
        }
        return null;
    }

    @Override
    boolean isReadOnly() {
        return false;
    }

    @Override
    boolean isEnabled() {
        return this.dataSource.getRWPoolEnabled();
    }
}

