/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.db.service;

import com.genexus.db.service.GXType;
import com.genexus.db.service.IODataMap;
import com.genexus.db.service.IQuery;
import com.genexus.db.service.QueryType;
import com.genexus.db.service.ServiceDataStoreHelper;
import com.genexus.db.service.VarValue;
import com.genexus.util.NameValuePair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class Query
implements IQuery {
    protected static final String[] EMPTY_ARR_STRING = new String[0];
    final ServiceDataStoreHelper dataStoreHelper;
    public String tableName;
    public String[] projection = EMPTY_ARR_STRING;
    public String[] orderBys = EMPTY_ARR_STRING;
    public String[] filters = EMPTY_ARR_STRING;
    private final ArrayList<NameValuePair> mAssignAtts = new ArrayList();
    public IODataMap[] selectList = new IODataMap[0];
    private final HashMap<String, VarValue> mVarValues = new HashMap();
    protected final HashMap<Integer, GXType> parmTypes = new HashMap();
    protected QueryType queryType = QueryType.QUERY;

    public Query(ServiceDataStoreHelper dataStoreHelper) {
        this.dataStoreHelper = dataStoreHelper;
    }

    public Iterator<NameValuePair> getAssignAtts() {
        return this.mAssignAtts.iterator();
    }

    public HashMap<String, VarValue> getVars() {
        return this.mVarValues;
    }

    public VarValue getParm(String parmName) {
        return this.mVarValues.get(parmName);
    }

    public Query For(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public Query select(String[] columns) {
        this.projection = columns;
        return this;
    }

    public Query orderBy(String[] orders) {
        this.orderBys = orders;
        return this;
    }

    public Query orderBy(String order) {
        return this.orderBy(new String[]{order});
    }

    public Query filter(String[] filters) {
        this.filters = filters;
        return this;
    }

    public Query set(String name, String value) {
        this.mAssignAtts.add(new NameValuePair(name, value));
        return this;
    }

    public Query setMaps(IODataMap[] selectList) {
        this.selectList = selectList;
        return this;
    }

    @Override
    public QueryType getQueryType() {
        return this.queryType;
    }

    public Query setType(QueryType queryType) {
        this.queryType = queryType;
        return this;
    }

    public Query addConst(GXType gxType, Object parm) {
        String parmName = String.format(":const%d", this.mVarValues.size() + 1);
        this.mVarValues.put(parmName, new VarValue(parmName, gxType, parm));
        return this;
    }

    public Query setParmType(int parmId, GXType gxType) {
        this.parmTypes.put(parmId, gxType);
        return this;
    }

    public <T extends Query> T as(Class<T> reference) {
        return (T)((Query)reference.cast(this));
    }

    public void initializeParms(Object[] parms) {
        for (int idx : this.parmTypes.keySet()) {
            String parmName = String.format(":parm%d", idx);
            this.mVarValues.put(parmName, new VarValue(parmName, this.parmTypes.get(idx), parms[idx]));
        }
    }
}

