/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.filters;

import com.genexus.servlet.Filter;
import com.genexus.servlet.IFilterChain;
import com.genexus.servlet.IServletRequest;
import com.genexus.servlet.IServletResponse;
import com.genexus.servlet.ServletException;
import com.genexus.servlet.http.IHttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import json.org.json.JSONObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class APIObjectFilter
extends Filter {
    private ArrayList<String> appPath = new ArrayList();
    public static final Logger logger = LogManager.getLogger(APIObjectFilter.class);

    public void doFilter(IServletRequest request, IServletResponse response, IFilterChain chain) throws Exception {
        if (request.isHttpServletRequest() && response.isHttpServletResponse()) {
            IHttpServletRequest httpRequest = request.getHttpServletRequest();
            String path = httpRequest.getRequestURI().substring(httpRequest.getContextPath().length()).substring(1);
            String urlString = path.toLowerCase();
            boolean isPath = false;
            for (String appBasePath : this.appPath) {
                if (!urlString.startsWith(appBasePath)) continue;
                isPath = true;
                break;
            }
            if (isPath) {
                String fwdURI = "/rest/" + path;
                httpRequest.getRequestDispatcher(fwdURI).forward(request, response);
            } else {
                chain.doFilter(request, response);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void init(Map<String, String> headers, String path, String sessionCookieName) throws ServletException {
        try {
            String paramValue = headers.get("BasePath");
            if (paramValue != null && !paramValue.isEmpty()) {
                Path privateFolder;
                if (paramValue.equals("*") && path != null && !path.isEmpty() && !Files.exists(privateFolder = Paths.get(paramValue = path + "private", new String[0]), new LinkOption[0])) {
                    paramValue = path + "WEB-INF" + File.separator + "private";
                }
                logger.info("API metadata path: " + paramValue);
                Stream<Path> walk = Files.walk(Paths.get(paramValue + File.separator, new String[0]), new FileVisitOption[0]);
                List result = walk.map(x -> x.toString()).filter(f -> f.endsWith(".grp.json")).collect(Collectors.toList());
                for (String temp : result) {
                    try {
                        String read = String.join((CharSequence)"", Files.readAllLines(Paths.get(temp, new String[0])));
                        JSONObject jo = new JSONObject(read);
                        String apipath = jo.getString("BasePath");
                        this.appPath.add(apipath.toLowerCase());
                    }
                    catch (IOException e) {
                        logger.error("Exception in API Filter: ", (Throwable)e);
                    }
                }
            } else {
                logger.info("API base path invalid.");
            }
        }
        catch (Exception e) {
            logger.error("Exception in API Filter: ", (Throwable)e);
        }
    }

    public void destroy() {
    }
}

