/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.filters;

import com.genexus.servlet.Filter;
import com.genexus.servlet.IFilterChain;
import com.genexus.servlet.IServletRequest;
import com.genexus.servlet.IServletResponse;
import com.genexus.servlet.ServletException;
import com.genexus.servlet.http.HttpServletRequestWrapper;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class SecuredRemoteAddressFilter
extends Filter {
    protected static final String SECURED_REMOTE_ADDRESSES_PARAMETER = "securedRemoteAddresses";
    private static final Pattern commaSeparatedValuesPattern = Pattern.compile("\\s*,\\s*");
    private Pattern[] securedRemoteAddresses = new Pattern[]{Pattern.compile("10\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}"), Pattern.compile("192\\.168\\.\\d{1,3}\\.\\d{1,3}"), Pattern.compile("172\\.(?:1[6-9]|2\\d|3[0-1]).\\d{1,3}.\\d{1,3}"), Pattern.compile("169\\.254\\.\\d{1,3}\\.\\d{1,3}"), Pattern.compile("127\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}")};

    protected static Pattern[] commaDelimitedListToPatternArray(String commaDelimitedPatterns) {
        String[] patterns = SecuredRemoteAddressFilter.commaDelimitedListToStringArray(commaDelimitedPatterns);
        ArrayList<Pattern> patternsList = new ArrayList<Pattern>();
        for (String pattern : patterns) {
            try {
                patternsList.add(Pattern.compile(pattern));
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException("Illegal pattern syntax '" + pattern + "'", e);
            }
        }
        return patternsList.toArray(new Pattern[0]);
    }

    protected static String[] commaDelimitedListToStringArray(String commaDelimitedStrings) {
        return commaDelimitedStrings == null || commaDelimitedStrings.length() == 0 ? new String[]{} : commaSeparatedValuesPattern.split(commaDelimitedStrings);
    }

    protected static boolean matchesOne(String str, Pattern ... patterns) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(str).matches()) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
    }

    public void doFilter(IServletRequest request, IServletResponse response, IFilterChain chain) throws Exception {
        IServletRequest xRequest;
        if (request.isHttpServletRequest() && response.isHttpServletResponse()) {
            if (!request.isSecure() && SecuredRemoteAddressFilter.matchesOne(request.getRemoteAddr(), this.securedRemoteAddresses)) {
                HttpServletRequestWrapper reqw = new HttpServletRequestWrapper(request.getHttpServletRequest()){

                    public boolean isSecure() {
                        return true;
                    }
                };
                xRequest = reqw.getServletRequest();
            } else {
                xRequest = request;
            }
        } else {
            xRequest = request;
        }
        chain.doFilter(xRequest, response);
    }

    public void init(Map<String, String> headers, String path, String sessionCookieName) throws ServletException {
        String comaDelimitedSecuredRemoteAddresses = headers.get(SECURED_REMOTE_ADDRESSES_PARAMETER);
        if (comaDelimitedSecuredRemoteAddresses != null) {
            this.setSecuredRemoteAdresses(comaDelimitedSecuredRemoteAddresses);
        }
    }

    public void setSecuredRemoteAdresses(String comaDelimitedSecuredRemoteAddresses) {
        this.securedRemoteAddresses = SecuredRemoteAddressFilter.commaDelimitedListToPatternArray(comaDelimitedSecuredRemoteAddresses);
    }
}

