/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.filters;

import com.genexus.filters.SecureCookieHttpServletResponseWrapper;
import com.genexus.servlet.Filter;
import com.genexus.servlet.IFilterChain;
import com.genexus.servlet.IServletRequest;
import com.genexus.servlet.IServletResponse;
import com.genexus.servlet.ServletException;
import com.genexus.servlet.http.ICookie;
import com.genexus.servlet.http.IHttpServletRequest;
import com.genexus.servlet.http.IHttpServletResponse;
import com.genexus.servlet.http.IHttpServletResponseWrapper;
import java.util.Arrays;
import java.util.Map;

public class SessionFilter
extends Filter {
    String JSESSIONID = "JSESSIONID";

    public void init(Map<String, String> headers, String path, String sessionCookieName) throws ServletException {
        if (sessionCookieName != null && !sessionCookieName.equals("")) {
            this.JSESSIONID = sessionCookieName;
        }
    }

    public void doFilter(IServletRequest request, IServletResponse response, IFilterChain chain) throws Exception {
        IHttpServletRequest req = request.getHttpServletRequest();
        IHttpServletResponse res = response.getHttpServletResponse();
        ICookie session = null;
        ICookie[] allCookies = req.getCookies();
        if (allCookies != null) {
            session = Arrays.stream(allCookies).filter(x -> x.getName().equals(this.JSESSIONID)).findFirst().orElse(null);
        }
        if (session != null && req.isSecure() && !session.getSecure()) {
            chain.doFilter(request, (IHttpServletResponseWrapper)new SecureCookieHttpServletResponseWrapper(res, this.JSESSIONID));
        } else {
            chain.doFilter(req, res);
        }
    }

    public void destroy() {
    }
}

