/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.filters;

import com.genexus.servlet.Filter;
import com.genexus.servlet.IFilterChain;
import com.genexus.servlet.IServletRequest;
import com.genexus.servlet.IServletResponse;
import com.genexus.servlet.ServletException;
import com.genexus.servlet.http.HttpServletRequestWrapper;
import com.genexus.servlet.http.IHttpServletRequest;
import com.genexus.servlet.http.IHttpServletRequestWrapper;
import com.genexus.servlet.http.IHttpServletResponse;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class XForwardedFilter
extends Filter {
    private static final Pattern commaSeparatedValuesPattern = Pattern.compile("\\s*,\\s*");
    protected static final String HTTP_SERVER_PORT_PARAMETER = "httpServerPort";
    protected static final String HTTPS_SERVER_PORT_PARAMETER = "httpsServerPort";
    protected static final String INTERNAL_PROXIES_PARAMETER = "allowedInternalProxies";
    protected static final String PROTOCOL_HEADER_PARAMETER = "protocolHeader";
    protected static final String PROTOCOL_HEADER_SSL_VALUE_PARAMETER = "protocolHeaderSslValue";
    protected static final String PROXIES_HEADER_PARAMETER = "proxiesHeader";
    protected static final String REMOTE_IP_HEADER_PARAMETER = "remoteIPHeader";
    protected static final String TRUSTED_PROXIES_PARAMETER = "trustedProxies";
    private int httpServerPort = 80;
    private int httpsServerPort = 443;
    private Pattern[] allowedInternalProxies = new Pattern[]{Pattern.compile("10\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}"), Pattern.compile("192\\.168\\.\\d{1,3}\\.\\d{1,3}"), Pattern.compile("172\\.(?:1[6-9]|2\\d|3[0-1]).\\d{1,3}.\\d{1,3}"), Pattern.compile("169\\.254\\.\\d{1,3}\\.\\d{1,3}"), Pattern.compile("127\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}")};
    private String protocolHeader = null;
    private String protocolHeaderSslValue = "https";
    private String proxiesHeader = "X-Forwarded-By";
    private String remoteIPHeader = "X-Forwarded-For";
    private Pattern[] trustedProxies = new Pattern[0];

    protected static Pattern[] commaDelimitedListToPatternArray(String commaDelimitedPatterns) {
        String[] patterns = XForwardedFilter.commaDelimitedListToStringArray(commaDelimitedPatterns);
        ArrayList<Pattern> patternsList = new ArrayList<Pattern>();
        for (String pattern : patterns) {
            try {
                patternsList.add(Pattern.compile(pattern));
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException("Illegal pattern syntax '" + pattern + "'", e);
            }
        }
        return patternsList.toArray(new Pattern[0]);
    }

    protected static String[] commaDelimitedListToStringArray(String commaDelimitedStrings) {
        return commaDelimitedStrings == null || commaDelimitedStrings.length() == 0 ? new String[]{} : commaSeparatedValuesPattern.split(commaDelimitedStrings);
    }

    protected static String listToCommaDelimitedString(List<String> stringList) {
        if (stringList == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        Iterator<String> it = stringList.iterator();
        while (it.hasNext()) {
            String element = it.next();
            if (element == null) continue;
            result.append((Object)element);
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    protected static boolean matchesOne(String str, Pattern ... patterns) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(str).matches()) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
    }

    public void doFilter(IHttpServletRequest request, IHttpServletResponse response, IFilterChain chain) throws Exception {
        if (XForwardedFilter.matchesOne(request.getRemoteAddr(), this.allowedInternalProxies)) {
            String protocolHeaderValue;
            int idx;
            String remoteIp = null;
            LinkedList<String> proxiesHeaderValue = new LinkedList<String>();
            String[] remoteIPHeaderValue = XForwardedFilter.commaDelimitedListToStringArray(request.getHeader(this.remoteIPHeader));
            for (idx = remoteIPHeaderValue.length - 1; idx >= 0; --idx) {
                String currentRemoteIp;
                remoteIp = currentRemoteIp = remoteIPHeaderValue[idx];
                if (XForwardedFilter.matchesOne(currentRemoteIp, this.allowedInternalProxies)) continue;
                if (XForwardedFilter.matchesOne(currentRemoteIp, this.trustedProxies)) {
                    proxiesHeaderValue.addFirst(currentRemoteIp);
                    continue;
                }
                --idx;
                break;
            }
            LinkedList<String> newRemoteIpHeaderValue = new LinkedList<String>();
            while (idx >= 0) {
                String currentRemoteIp = remoteIPHeaderValue[idx];
                newRemoteIpHeaderValue.addFirst(currentRemoteIp);
                --idx;
            }
            XForwardedRequest xRequest = new XForwardedRequest(request);
            if (remoteIp != null) {
                xRequest.setRemoteAddr(remoteIp);
                xRequest.setRemoteHost(remoteIp);
                if (proxiesHeaderValue.size() == 0) {
                    xRequest.removeHeader(this.proxiesHeader);
                } else {
                    String commaDelimitedListOfProxies = XForwardedFilter.listToCommaDelimitedString(proxiesHeaderValue);
                    xRequest.setHeader(this.proxiesHeader, commaDelimitedListOfProxies);
                }
                if (newRemoteIpHeaderValue.size() == 0) {
                    xRequest.removeHeader(this.remoteIPHeader);
                } else {
                    String commaDelimitedRemoteIpHeaderValue = XForwardedFilter.listToCommaDelimitedString(newRemoteIpHeaderValue);
                    xRequest.setHeader(this.remoteIPHeader, commaDelimitedRemoteIpHeaderValue);
                }
            }
            if (this.protocolHeader != null && (protocolHeaderValue = request.getHeader(this.protocolHeader)) != null) {
                if (this.protocolHeaderSslValue.equalsIgnoreCase(protocolHeaderValue)) {
                    xRequest.setSecure(true);
                    xRequest.setScheme("https");
                    xRequest.setServerPort(this.httpsServerPort);
                } else {
                    xRequest.setSecure(false);
                    xRequest.setScheme("http");
                    xRequest.setServerPort(this.httpServerPort);
                }
            }
            chain.doFilter((IHttpServletRequestWrapper)xRequest, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void doFilter(IServletRequest request, IServletResponse response, IFilterChain chain) throws Exception {
        if (request.isHttpServletRequest() && response.isHttpServletResponse()) {
            this.doFilter(request, response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    public int getHttpsServerPort() {
        return this.httpsServerPort;
    }

    public Pattern[] getInternalProxies() {
        return this.allowedInternalProxies;
    }

    public String getProtocolHeader() {
        return this.protocolHeader;
    }

    public String getProtocolHeaderSslValue() {
        return this.protocolHeaderSslValue;
    }

    public String getProxiesHeader() {
        return this.proxiesHeader;
    }

    public String getRemoteIPHeader() {
        return this.remoteIPHeader;
    }

    public Pattern[] getTrustedProxies() {
        return this.trustedProxies;
    }

    public void init(Map<String, String> headers, String path, String sessionCookieName) throws ServletException {
        if (headers.get(INTERNAL_PROXIES_PARAMETER) != null) {
            this.setAllowedInternalProxies(headers.get(INTERNAL_PROXIES_PARAMETER));
        }
        if (headers.get(PROTOCOL_HEADER_PARAMETER) != null) {
            this.setProtocolHeader(headers.get(PROTOCOL_HEADER_PARAMETER));
        }
        if (headers.get(PROTOCOL_HEADER_SSL_VALUE_PARAMETER) != null) {
            this.setProtocolHeaderSslValue(headers.get(PROTOCOL_HEADER_SSL_VALUE_PARAMETER));
        }
        if (headers.get(PROXIES_HEADER_PARAMETER) != null) {
            this.setProxiesHeader(headers.get(PROXIES_HEADER_PARAMETER));
        }
        if (headers.get(REMOTE_IP_HEADER_PARAMETER) != null) {
            this.setRemoteIPHeader(headers.get(REMOTE_IP_HEADER_PARAMETER));
        }
        if (headers.get(TRUSTED_PROXIES_PARAMETER) != null) {
            this.setTrustedProxies(headers.get(TRUSTED_PROXIES_PARAMETER));
        }
        if (headers.get(HTTP_SERVER_PORT_PARAMETER) != null) {
            try {
                this.setHttpServerPort(Integer.parseInt(headers.get(HTTP_SERVER_PORT_PARAMETER)));
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Illegal httpServerPort : " + e.getMessage());
            }
        }
        if (headers.get(HTTPS_SERVER_PORT_PARAMETER) != null) {
            try {
                this.setHttpsServerPort(Integer.parseInt(headers.get(HTTPS_SERVER_PORT_PARAMETER)));
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Illegal httpsServerPort : " + e.getMessage());
            }
        }
    }

    public void setAllowedInternalProxies(String allowedInternalProxies) {
        this.allowedInternalProxies = XForwardedFilter.commaDelimitedListToPatternArray(allowedInternalProxies);
    }

    public void setHttpServerPort(int httpServerPort) {
        this.httpServerPort = httpServerPort;
    }

    public void setHttpsServerPort(int httpsServerPort) {
        this.httpsServerPort = httpsServerPort;
    }

    public void setProtocolHeader(String protocolHeader) {
        this.protocolHeader = protocolHeader;
    }

    public void setProtocolHeaderSslValue(String protocolHeaderSslValue) {
        this.protocolHeaderSslValue = protocolHeaderSslValue;
    }

    public void setProxiesHeader(String proxiesHeader) {
        this.proxiesHeader = proxiesHeader;
    }

    public void setRemoteIPHeader(String remoteIPHeader) {
        this.remoteIPHeader = remoteIPHeader;
    }

    public void setTrustedProxies(String trustedProxies) {
        this.trustedProxies = XForwardedFilter.commaDelimitedListToPatternArray(trustedProxies);
    }

    public static class XForwardedRequest
    extends HttpServletRequestWrapper {
        static final ThreadLocal<SimpleDateFormat[]> threadLocalDateFormats = new ThreadLocal<SimpleDateFormat[]>(){

            @Override
            protected SimpleDateFormat[] initialValue() {
                return new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
            }
        };
        protected Map<String, List<String>> headers;
        protected String remoteAddr;
        protected String remoteHost;
        protected String scheme;
        protected boolean secure;
        protected int serverPort;

        public XForwardedRequest(IHttpServletRequest request) {
            super(request);
            this.remoteAddr = request.getRemoteAddr();
            this.remoteHost = request.getRemoteHost();
            this.scheme = request.getScheme();
            this.secure = request.isSecure();
            this.serverPort = request.getServerPort();
            this.headers = new HashMap<String, List<String>>();
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String header = (String)headerNames.nextElement();
                this.headers.put(header, Collections.list(request.getHeaders(header)));
            }
        }

        public long getDateHeader(String name) {
            String value = this.getHeader(name);
            if (value == null) {
                return -1L;
            }
            DateFormat[] dateFormats = threadLocalDateFormats.get();
            Date date = null;
            for (int i = 0; i < dateFormats.length && date == null; ++i) {
                DateFormat dateFormat = dateFormats[i];
                try {
                    date = dateFormat.parse(value);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (date == null) {
                throw new IllegalArgumentException(value);
            }
            return date.getTime();
        }

        public String getHeader(String name) {
            Map.Entry<String, List<String>> header = this.getHeaderEntry(name);
            if (header == null || header.getValue() == null || header.getValue().isEmpty()) {
                return null;
            }
            return header.getValue().get(0);
        }

        protected Map.Entry<String, List<String>> getHeaderEntry(String name) {
            for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(name)) continue;
                return entry;
            }
            return null;
        }

        public Enumeration<String> getHeaderNames() {
            return Collections.enumeration(this.headers.keySet());
        }

        public Enumeration<String> getHeaders(String name) {
            Map.Entry<String, List<String>> header = this.getHeaderEntry(name);
            if (header == null || header.getValue() == null) {
                return Collections.enumeration(Collections.emptyList());
            }
            return Collections.enumeration((Collection)header.getValue());
        }

        public int getIntHeader(String name) {
            String value = this.getHeader(name);
            if (value == null) {
                return -1;
            }
            return Integer.parseInt(value);
        }

        public String getRemoteAddr() {
            return this.remoteAddr;
        }

        public String getRemoteHost() {
            return this.remoteHost;
        }

        public String getScheme() {
            return this.scheme;
        }

        public int getServerPort() {
            return this.serverPort;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public void removeHeader(String name) {
            Map.Entry<String, List<String>> header = this.getHeaderEntry(name);
            if (header != null) {
                this.headers.remove(header.getKey());
            }
        }

        public void setHeader(String name, String value) {
            List<String> values = Arrays.asList(value);
            Map.Entry<String, List<String>> header = this.getHeaderEntry(name);
            if (header == null) {
                this.headers.put(name, values);
            } else {
                header.setValue(values);
            }
        }

        public void setRemoteAddr(String remoteAddr) {
            this.remoteAddr = remoteAddr;
        }

        public void setRemoteHost(String remoteHost) {
            this.remoteHost = remoteHost;
        }

        public void setScheme(String scheme) {
            this.scheme = scheme;
        }

        public void setSecure(boolean secure) {
            this.secure = secure;
        }

        public void setServerPort(int serverPort) {
            this.serverPort = serverPort;
        }
    }
}

